/*
 * Decompiled with CFR 0.152.
 */
package com.sas.console.visuals;

import com.sas.console.models.HelpKeyListener;
import com.sas.console.models.RefreshKeyListener;
import com.sas.console.plugins.ElementInterface;
import com.sas.console.plugins.TableModelInterface;
import com.sas.console.utils.MnemonicModel;
import com.sas.console.visuals.ConsoleAction;
import com.sas.console.visuals.ConsoleDNDTable;
import com.sas.console.visuals.ConsoleTree;
import com.sas.console.visuals.ConsoleViewInterface;
import com.sas.console.visuals.DeleteAction;
import com.sas.console.visuals.MainConsole;
import com.sas.console.visuals.PropertyAction;
import com.sas.console.visuals.SubmenuAction;
import com.sas.console.visuals.ToolTipStrippingJPopupMenu;
import com.sas.visuals.Resources;
import com.sas.workspace.WAdminResource;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.basic.BasicTableUI;
import javax.swing.table.TableCellEditor;

public class ConsoleTable
extends ConsoleDNDTable {
    private static final long serialVersionUID = 9200000001L;
    protected JPopupMenu m_popMenu;
    protected ConsoleTree m_treeView;
    protected int[] m_selectedIndices;
    protected boolean doneWithSelection = false;
    protected int m_numSelected = 0;
    protected MainConsole m_console;
    protected ConsoleViewInterface m_view;
    protected static WAdminResource bundle = new WAdminResource(ConsoleTable.class);

    public ConsoleTable(TableModelInterface tableModel, ConsoleViewInterface view) {
        this.setModel(tableModel);
        this.m_popMenu = new ToolTipStrippingJPopupMenu();
        this.m_view = view;
        this.m_console = (MainConsole)this.m_view.getConsole();
        this._setFocusListener();
        this.setUI(new ConsoleTableUI());
        this.addMouseListener(new TableMouseListener(this));
        this.addKeyListener(new TableKeyListener(this));
        this.addKeyListener(new HelpKeyListener(this.m_view.getConsole()));
        this.addKeyListener(new RefreshKeyListener(this.m_console));
    }

    public void dispose() {
        TableModelInterface model = (TableModelInterface)this.getModel();
        model.removeTableModelListener(this);
    }

    protected void _setFocusListener() {
        FocusAdapter focusListener = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent event) {
                ConsoleTable.this.repaint();
                int viewType = ConsoleTable.this.m_view.getType();
                if (viewType == 1 || viewType == 0) {
                    ConsoleTree tree = (ConsoleTree)ConsoleTable.this.m_view.getComponent();
                    tree.repaint();
                }
                ConsoleTable.this.m_console.setViewLastSelected(viewType);
                ConsoleTable.this.m_console.setTreeLastSelected(false);
                int selectedIndex = ConsoleTable.this.getSelectionModel().getLeadSelectionIndex();
                if (selectedIndex < 0 && ConsoleTable.this.getModel().getRowCount() > 0) {
                    selectedIndex = 0;
                    ConsoleTable.this.getSelectionModel().setSelectionInterval(0, 0);
                }
                TableModelInterface model = (TableModelInterface)ConsoleTable.this.getModel();
                ConsoleTable.this.m_console.updateToolBar(model.getToolBarActions(ConsoleTable.this.getSelectionModel()));
                ConsoleTable.this.m_console.updateMenuBar(false);
            }

            @Override
            public void focusLost(FocusEvent event) {
                ConsoleTable.this.repaint();
            }
        };
        this.addFocusListener(focusListener);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (this.m_console == null) {
            super.valueChanged(e);
            return;
        }
        int status = this.m_console.getServerStatus();
        this.m_console.checkIServerStatus();
        if (status != this.m_console.getServerStatus()) {
            return;
        }
        if (this.getSelectedRow() >= 0) {
            this.m_console.updateMenuBar(false);
            TableModelInterface model = (TableModelInterface)this.getModel();
            this.m_console.updateToolBar(model.getToolBarActions(this.getSelectionModel()));
        }
        super.valueChanged(e);
    }

    public void showTablePopupMenu(MouseEvent event) {
        this.m_popMenu = new ToolTipStrippingJPopupMenu();
        ImageIcon blankIcon = Resources.getImageIcon((String)bundle.getString("Common.BlankIcon.image"), (int)16);
        TableModelInterface model = (TableModelInterface)this.getModel();
        Vector<Action> actionsList = new Vector<Action>(0);
        List modelActions = ((TableModelInterface)this.getModel()).getContextMenuActions(this.getSelectionModel());
        if (modelActions != null) {
            actionsList.addAll(modelActions);
        }
        Action[] extendedActions = this.m_console.getExtendedContextMenuActions(model, this.getSelectionModel());
        for (int index = 0; extendedActions != null && index < extendedActions.length; ++index) {
            actionsList.add(extendedActions[index]);
        }
        for (int i = 0; i < actionsList.size(); ++i) {
            Action action = (Action)actionsList.get(i);
            if (action instanceof SubmenuAction) {
                SubmenuAction submenuAction = (SubmenuAction)action;
                JMenu submenu = SubmenuAction.generateSubmenu(submenuAction);
                this.m_popMenu.add(submenu);
                continue;
            }
            if (action == null) {
                this.m_popMenu.addSeparator();
                continue;
            }
            if (action.getValue("SmallIcon") == null) {
                action.putValue("SmallIcon", blankIcon);
            }
            ConsoleAction consoleAction = new ConsoleAction(action);
            this.m_popMenu.add(MnemonicModel.getMenuItemWithMnemonic(consoleAction));
        }
        if (!this.getSelectionModel().isSelectionEmpty() && this.displaysProperties((ElementInterface)((TableModelInterface)this.getModel()).getObjectAt(this.getSelectedRow()))) {
            PropertyAction propertiesAction = new PropertyAction((TableModelInterface)this.getModel(), this.getSelectionModel());
            ConsoleAction consolePropertiesAction = new ConsoleAction(propertiesAction);
            this.m_popMenu.add(MnemonicModel.getMenuItemWithMnemonic(consolePropertiesAction));
        }
        if (this.m_popMenu.getSubElements().length != 0) {
            JComponent source = (JComponent)event.getSource();
            if (source instanceof JViewport) {
                source = this;
            }
            source.add(this.m_popMenu);
            this.m_popMenu.show(source, event.getX(), event.getY());
        }
    }

    protected boolean displaysProperties(ElementInterface node) {
        boolean ret = true;
        try {
            Method callback = node.getClass().getMethod("displaysSASMCProperties", null);
            Boolean result = (Boolean)callback.invoke((Object)node, (Object[])null);
            ret = result;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return ret;
    }

    class ConsoleTableUI
    extends BasicTableUI {
        @Override
        protected MouseInputListener createMouseInputListener() {
            return new ConsoleTableMouseInputHandler();
        }

        public class ConsoleTableMouseInputHandler
        extends BasicTableUI.MouseInputHandler {
            public ConsoleTableMouseInputHandler() {
                super(ConsoleTableUI.this);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (ConsoleTableUI.this.table.getSelectedRowCount() > 1) {
                    if (e.isControlDown() || e.isShiftDown()) {
                        super.mousePressed(e);
                    }
                    return;
                }
                super.mousePressed(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (ConsoleTableUI.this.table.getSelectedRowCount() <= 1 || e.isShiftDown() || e.isControlDown() || e.isPopupTrigger()) {
                    super.mouseReleased(e);
                } else {
                    Point p = e.getPoint();
                    int row = ConsoleTableUI.this.table.rowAtPoint(p);
                    int column = ConsoleTableUI.this.table.columnAtPoint(p);
                    if (column == -1 || row == -1) {
                        return;
                    }
                    ConsoleTableUI.this.table.requestFocus();
                    TableCellEditor editor = ConsoleTableUI.this.table.getCellEditor();
                    if (editor == null || editor.shouldSelectCell(e)) {
                        this.setValueIsAdjusting(true);
                        ConsoleTableUI.this.table.changeSelection(row, column, e.isControlDown(), e.isShiftDown());
                    }
                }
            }

            private void setValueIsAdjusting(boolean flag) {
                ConsoleTableUI.this.table.getSelectionModel().setValueIsAdjusting(flag);
                ConsoleTableUI.this.table.getColumnModel().getSelectionModel().setValueIsAdjusting(flag);
            }
        }
    }

    protected class TableMouseListener
    extends MouseAdapter {
        ConsoleTable m_table;

        public TableMouseListener(ConsoleTable t) {
            this.m_table = t;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                TableModelInterface tableModel = (TableModelInterface)this.m_table.getModel();
                AbstractAction defaultAction = tableModel.getDefaultContextMenuAction(this.m_table.getSelectionModel());
                if (defaultAction != null) {
                    ConsoleAction consoleAction = new ConsoleAction(defaultAction);
                    consoleAction.actionPerformed(new ActionEvent(e.getSource(), e.getID(), null));
                } else {
                    defaultAction = new PropertyAction(tableModel, ConsoleTable.this.getSelectionModel());
                    defaultAction.actionPerformed(null);
                }
            }
        }
    }

    protected class TableKeyListener
    extends KeyAdapter {
        ConsoleTable m_table;

        public TableKeyListener(ConsoleTable table) {
            this.m_table = table;
        }

        @Override
        public void keyPressed(KeyEvent e) {
            ListSelectionModel selectionModel = this.m_table.getSelectionModel();
            switch (e.getKeyCode()) {
                case 9: {
                    int index = 0;
                    if (e.isShiftDown()) {
                        index = selectionModel.getLeadSelectionIndex();
                    } else {
                        index = selectionModel.getLeadSelectionIndex() + 1;
                        int row = ConsoleTable.this.getRowCount() - 1;
                        if (selectionModel.isSelectionEmpty() || index > row) {
                            index = 0;
                        }
                    }
                    this.m_table.changeSelection(index, 0, false, false);
                    break;
                }
                case 36: {
                    selectionModel.setAnchorSelectionIndex(0);
                    break;
                }
                case 35: {
                    selectionModel.setAnchorSelectionIndex(this.m_table.getRowCount() - 1);
                    break;
                }
                case 10: {
                    if (!e.isAltDown()) break;
                    PropertyAction propertyAction = new PropertyAction((TableModelInterface)this.m_table.getModel(), this.m_table.getSelectionModel());
                    propertyAction.actionPerformed(null);
                    break;
                }
                case 127: {
                    DeleteAction deleteAction = new DeleteAction(ConsoleTable.this.m_console);
                    deleteAction.actionPerformed(null);
                    break;
                }
                case 525: {
                    MouseEvent event = new MouseEvent(ConsoleTable.this, 0, 0L, 0, 50, 50, 1, true);
                    ConsoleTable.this.showTablePopupMenu(event);
                    e.consume();
                    break;
                }
                case 121: {
                    if (!e.isShiftDown()) break;
                    MouseEvent event2 = new MouseEvent(ConsoleTable.this, 0, 0L, 0, 50, 50, 1, true);
                    ConsoleTable.this.showTablePopupMenu(event2);
                    e.consume();
                    break;
                }
            }
        }
    }
}

