/*
 * Decompiled with CFR 0.152.
 */
package com.sas.console.visuals;

import com.sas.console.plugins.NodeInterface;
import com.sas.console.plugins.PluginNavigationInterface;
import com.sas.console.plugins.Root.CategoryNode;
import com.sas.console.plugins.Root.RootNode;
import com.sas.console.visuals.ConsoleTree;
import com.sas.workspace.DNDObject;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.tree.TreePath;

public class ConsoleDNDTree
extends ConsoleTree
implements DragGestureListener,
DragSourceListener,
DropTargetListener {
    private static final long serialVersionUID = 9200000001L;
    protected NodeInterface m_DNDtreeCurrentNode;
    protected DragSource m_dragSource = new DragSource();
    protected DropTarget m_dropTarget;

    public ConsoleDNDTree() {
        this.m_dragSource.createDefaultDragGestureRecognizer(this, 3, this);
        this.m_dropTarget = new DropTarget(this, this);
        this.m_dropTarget.setActive(true);
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dsde) {
    }

    @Override
    public void dragEnter(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragExit(DragSourceEvent dse) {
    }

    @Override
    public void dragOver(DragSourceDragEvent dsde) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dge) {
        MouseEvent dragEvent = null;
        Point lastPoint = null;
        Point origin = dge.getDragOrigin();
        Iterator<InputEvent> events = dge.iterator();
        while (events.hasNext()) {
            InputEvent dragObj = events.next();
            if (dragObj == null) continue;
            dragEvent = (MouseEvent)dragObj;
        }
        lastPoint = dragEvent.getPoint();
        if (lastPoint.distance(origin.getX(), origin.getY()) >= 5.0) {
            this.m_DNDtreeCurrentNode = (NodeInterface)this.getLastSelectedPathComponent();
            if (this.m_DNDtreeCurrentNode instanceof RootNode || this.m_DNDtreeCurrentNode instanceof CategoryNode) {
                DNDObject dragNode = new DNDObject((Object)this.m_DNDtreeCurrentNode);
                this.m_dragSource.startDrag(dge, DragSource.DefaultCopyNoDrop, (Transferable)dragNode, this);
            } else {
                DNDObject dragNode = new DNDObject((Object)this.m_DNDtreeCurrentNode);
                this.m_dragSource.startDrag(dge, DragSource.DefaultCopyDrop, (Transferable)dragNode, this);
            }
        }
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        try {
            Transferable transfer = dtde.getTransferable();
            Point dropLocation = dtde.getLocation();
            TreePath dropPath = this.getPathForLocation(dropLocation.x, dropLocation.y);
            if (dropPath != null) {
                NodeInterface dropNode = (NodeInterface)dropPath.getLastPathComponent();
                PluginNavigationInterface plugin = dropNode.getPlugin();
                if (plugin.supportsDropOperations()) {
                    try {
                        dtde.acceptDrop(3);
                        Vector dropItems = (Vector)transfer.getTransferData(DNDObject.dndObjectDataFlavor);
                        dropNode.drop(dropItems);
                    }
                    catch (IOException ioe) {
                        JOptionPane.showMessageDialog(this, ioe.getMessage());
                    }
                } else {
                    dtde.rejectDrop();
                }
            }
        }
        catch (UnsupportedFlavorException ufe) {
            JOptionPane.showMessageDialog(this, ufe.getMessage());
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        dtde.acceptDrag(3);
        Point location = dtde.getLocation();
        TreePath path = this.getPathForLocation(location.x, location.y);
        if (path != null) {
            NodeInterface node = (NodeInterface)this.getPathForLocation(location.x, location.y).getLastPathComponent();
            PluginNavigationInterface plugin = node.getPlugin();
            if (!plugin.supportsDropOperations()) {
                dtde.rejectDrag();
            } else {
                this.setSelectionPath(path);
            }
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
    }
}

