/*
 * Decompiled with CFR 0.152.
 */
package com.sas.console.utils;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;

public abstract class WindowUtil {
    public static final void busyOn(Component awtComponent) {
        WindowUtil.getParentFrame(awtComponent).setCursor(Cursor.getPredefinedCursor(3));
    }

    public static final void busyOff(Component awtComponent) {
        WindowUtil.getParentFrame(awtComponent).setCursor(Cursor.getPredefinedCursor(0));
    }

    public static final void busyOn(JComponent c) {
        c.getTopLevelAncestor().setCursor(Cursor.getPredefinedCursor(3));
    }

    public static final void busyOff(JComponent c) {
        c.getTopLevelAncestor().setCursor(Cursor.getPredefinedCursor(0));
    }

    public static final void busyOn(JDialog c) {
        c.setCursor(Cursor.getPredefinedCursor(3));
    }

    public static final void busyOff(JDialog c) {
        c.setCursor(Cursor.getPredefinedCursor(0));
    }

    public static final void busyOn(Frame c) {
        c.setCursor(Cursor.getPredefinedCursor(3));
    }

    public static final void busyOff(Frame c) {
        c.setCursor(Cursor.getPredefinedCursor(0));
    }

    public static final void sleep(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            return;
        }
    }

    public static final void drawFocusRect(Graphics g, int x, int y, int width, int height) {
        WindowUtil.drawFocusRect(g, x, y, width, height, true);
    }

    public static final void drawFocusRect(Graphics g, int x, int y, int width, int height, boolean useXOR) {
        int i;
        g.setColor(Color.black);
        if (useXOR) {
            g.setXORMode(Color.white);
        }
        for (i = 0; i < width; i += 2) {
            g.drawLine(x + i, y, x + i, y);
            g.drawLine(x + i, y + height - 1, x + i, y + height - 1);
        }
        for (i = 0; i < height; i += 2) {
            g.drawLine(x, y + i, x, y + i);
            g.drawLine(x + width - 1, y + i, x + width - 1, y + i);
        }
        if (useXOR) {
            g.setPaintMode();
        }
    }

    public static void center(Window window) {
        Dimension size = window.getSize();
        Dimension screenSize = window.getToolkit().getScreenSize();
        window.setLocation(screenSize.width / 2 - size.width / 2, screenSize.height / 2 - size.height / 2);
    }

    public static void centerOver(Window window, Component component) {
        int amountOver;
        Point location = component.getLocationOnScreen();
        Dimension componentSize = component.getSize();
        location.x += componentSize.width / 2;
        location.y += componentSize.height / 2;
        Dimension size = window.getSize();
        int x = location.x - size.width / 2;
        int y = location.y - size.height / 2;
        Dimension screenSize = window.getToolkit().getScreenSize();
        if (x + size.width > screenSize.width && (amountOver = x + size.width - screenSize.width) > 0 && x - amountOver > 0) {
            x -= amountOver;
        }
        if (y + size.height > screenSize.height && (amountOver = y + size.height - screenSize.height) > 0 && y - amountOver > 0) {
            y -= amountOver;
        }
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        window.setLocation(x, y);
    }

    public static void centerOverWindow(Window window, Component component) {
        while (component != null && !(component instanceof Window)) {
            component = component.getParent();
        }
        if (component != null) {
            WindowUtil.centerOver(window, component);
        }
    }

    public static Frame getParentFrame(Component comp) {
        Frame parentFrame = null;
        Component parent = comp;
        while (parent != null) {
            if (parent instanceof Frame) {
                parentFrame = (Frame)parent;
                parent = null;
                continue;
            }
            parent = parent.getParent();
        }
        return parentFrame;
    }

    public static Window getParentWindow(Component comp) {
        Window parentWindow = null;
        Component parent = comp;
        while (parent != null) {
            if (parent instanceof Window) {
                parentWindow = (Window)parent;
                parent = null;
                continue;
            }
            parent = parent.getParent();
        }
        return parentWindow;
    }

    public static Dimension getBestWindowSize(Dimension x) {
        Toolkit tkt = Toolkit.getDefaultToolkit();
        Dimension realSize = tkt.getScreenSize();
        Dimension retDim = new Dimension(x);
        if (x.height > realSize.height || x.width > realSize.width) {
            retDim.height = realSize.height;
            retDim.width = realSize.width;
        }
        return retDim;
    }

    public static void setDeepEnabled(Component comp, boolean state) {
        comp.setEnabled(state);
        if (comp instanceof Container) {
            Container container = (Container)comp;
            Component[] compArray = container.getComponents();
            for (int index = 0; index < compArray.length; ++index) {
                WindowUtil.setDeepEnabled(compArray[index], state);
            }
        }
    }

    public static void fixupDialogIcons(ImageIcon icon) {
        JDialog parentLess = new JDialog();
        Frame sharedHiddenParentFrame = (Frame)parentLess.getParent();
        sharedHiddenParentFrame.setIconImage(icon.getImage());
    }

    public static void ShowComponentInDialog(Component view, String strTitle) {
        if (view instanceof Dialog) {
            Dialog dialog = (Dialog)view;
            WindowUtil.center(dialog);
            dialog.setVisible(true);
        } else if (view instanceof JDialog) {
            JDialog dialog = (JDialog)view;
            WindowUtil.center(dialog);
            dialog.setVisible(true);
        } else {
            JDialog dialog = new JDialog();
            dialog.getContentPane().add(view);
            dialog.setModal(true);
            dialog.setTitle(strTitle);
            dialog.pack();
            WindowUtil.center(dialog);
            dialog.setVisible(true);
        }
    }
}

