/*
 * Decompiled with CFR 0.152.
 */
package com.sas.console.utils;

import com.sas.metadata.remote.DatabaseSchema;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.SASLibrary;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.text.CollationKey;
import java.text.Collator;
import java.util.List;
import java.util.Locale;
import java.util.Vector;

public class SortUtil {
    public static List sortAccending(List contentList) {
        CollationKey[] keys = SortUtil.convertToCollatorKeys(contentList);
        if (keys == null) {
            return null;
        }
        for (int i = 0; i < keys.length; ++i) {
            for (int j = i + 1; j < keys.length; ++j) {
                if (keys[i].compareTo(keys[j]) <= 0) continue;
                CollationKey temp = keys[i];
                keys[i] = keys[j];
                keys[j] = temp;
            }
        }
        return SortUtil.getSortedList(contentList, keys);
    }

    protected static List getSortedList(List contentList, CollationKey[] keys) {
        Vector<Object> sortedList = new Vector<Object>(1);
        for (int i = 0; i < keys.length; ++i) {
            String name = keys[i].getSourceString();
            Object contentItem = null;
            for (int j = 0; j < contentList.size(); ++j) {
                Object currentItem = contentList.get(j);
                if (currentItem instanceof PhysicalTable) {
                    try {
                        if (!((PhysicalTable)currentItem).getName().equalsIgnoreCase(name)) continue;
                        contentItem = currentItem;
                        contentList.remove(contentItem);
                        break;
                    }
                    catch (RemoteException ex) {
                        Workspace.handleRemoteException((RemoteException)ex);
                        continue;
                    }
                }
                if (currentItem instanceof SASLibrary) {
                    try {
                        if (!((SASLibrary)currentItem).getName().equalsIgnoreCase(name)) continue;
                        contentItem = currentItem;
                        contentList.remove(contentItem);
                        break;
                    }
                    catch (RemoteException ex) {
                        Workspace.handleRemoteException((RemoteException)ex);
                        continue;
                    }
                }
                if (!(currentItem instanceof DatabaseSchema)) continue;
                try {
                    if (!((DatabaseSchema)currentItem).getName().equalsIgnoreCase(name)) continue;
                    contentItem = currentItem;
                    contentList.remove(contentItem);
                    break;
                }
                catch (RemoteException ex) {
                    Workspace.handleRemoteException((RemoteException)ex);
                }
            }
            if (contentItem == null) continue;
            sortedList.add(i, contentItem);
        }
        return sortedList;
    }

    protected static CollationKey[] convertToCollatorKeys(List contentList) {
        try {
            Collator collator = Collator.getInstance(Locale.getDefault());
            collator.setStrength(2);
            CollationKey[] keys = new CollationKey[contentList.size()];
            boolean itemNotRecognized = false;
            for (int i = 0; i < contentList.size(); ++i) {
                Object contentItem = contentList.get(i);
                if (contentItem instanceof PhysicalTable) {
                    keys[i] = collator.getCollationKey(((PhysicalTable)contentItem).getName());
                    continue;
                }
                if (contentItem instanceof SASLibrary) {
                    keys[i] = collator.getCollationKey(((SASLibrary)contentItem).getName());
                    continue;
                }
                if (contentItem instanceof DatabaseSchema) {
                    keys[i] = collator.getCollationKey(((DatabaseSchema)contentItem).getName());
                    continue;
                }
                itemNotRecognized = true;
            }
            if (itemNotRecognized) {
                return null;
            }
            return keys;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return null;
        }
    }
}

