/*
 * Decompiled with CFR 0.152.
 */
package com.sas.console.utils;

import com.sas.console.visuals.MainConsole;
import com.sas.metadata.remote.Connection;
import com.sas.metadata.remote.DatabaseSchema;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.ServerComponent;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.mgmt.RepositoryUtil;
import com.sas.workspace.mgmt.visuals.PrototypeUtil;
import com.sas.workspace.mgmt.visuals.VersionUtil;
import java.awt.Component;
import java.awt.Window;
import java.rmi.RemoteException;

public class PropertyActionUtil {
    protected static WAdminResource bundle = new WAdminResource(PropertyActionUtil.class);
    protected static WAdminResource consoleBundle = new WAdminResource(MainConsole.class);

    public static boolean showProperties(Root root) {
        boolean bShowProperties = true;
        if (root != null) {
            if (!PropertyActionUtil.verifyObjectExists(root)) {
                return false;
            }
            if (root instanceof ServerComponent || root instanceof Connection || root instanceof SASLibrary || root instanceof DatabaseSchema) {
                try {
                    if (!PrototypeUtil.isPrototypeCompatible((Root)root, (Component)Workspace.getWorkspace())) {
                        VersionUtil.displayPropertiesMessage((Window)Workspace.getWorkspace(), (String)consoleBundle.getString("MainConsole.Title.txt"));
                        bShowProperties = false;
                    }
                }
                catch (MdException exc) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                    bShowProperties = false;
                }
                catch (RemoteException re) {
                    Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
                    bShowProperties = false;
                }
            }
        }
        return bShowProperties;
    }

    public static boolean verifyObjectExists(Root root) {
        try {
            if (root == null) {
                return false;
            }
            String repoID = "A0000001." + root.getRepositoryID();
            String type = root.getCMetadataType();
            String id = root.getFQID();
            String select = "<XMLSELECT search=\"@Id='" + id + "'\"/>";
            if (Workspace.getMdFactory().getOMIUtil().doesObjectExist(repoID, type, select) == 0) {
                String repoName = RepositoryUtil.getNameForReposId((MdFactory)Workspace.getMdFactory(), (String)repoID);
                String msg = bundle.formatString("PropertyActionUtil.ObjectDoesNotExist.Error.txt", (Object)id, (Object)repoName);
                MessageUtil.displayMessage((String)msg, (int)0);
                Workspace.getDefaultLogger().error((Object)msg);
                return false;
            }
            return true;
        }
        catch (RemoteException rex) {
            String msg = rex.getLocalizedMessage();
            MessageUtil.displayMessage((String)msg, (int)0);
            Workspace.getDefaultLogger().error((Object)msg);
            return false;
        }
        catch (MdException mdex) {
            MessageUtil.displayMetadataExceptionMessage((MdException)mdex, (String)"Reading");
            Workspace.getDefaultLogger().error((Object)mdex.getLocalizedMessage());
            return false;
        }
        catch (Exception ex) {
            String msg = ex.getLocalizedMessage();
            MessageUtil.displayMessage((String)msg, (int)0);
            Workspace.getDefaultLogger().error((Object)msg);
            return false;
        }
    }
}

