/*
 * Decompiled with CFR 0.152.
 */
package com.sas.console.utils;

import com.sas.console.utils.MethodCall;
import com.sas.workspace.WAdminResource;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Vector;

public class BackgroundThread
extends Thread {
    protected Vector m_methodCalls;
    protected Object m_object;
    protected int m_pause;
    private static WAdminResource bundle = WAdminResource.getBundle(BackgroundThread.class);

    public BackgroundThread(Object object) {
        this.m_object = object;
        this.m_methodCalls = new Vector();
        this.m_pause = 100;
    }

    public void addMethodCall(String strMethodName) {
        MethodCall methodCall = new MethodCall(strMethodName);
        this.addMethodCall(methodCall);
    }

    public void addMethodCall(MethodCall methodCall) {
        this.m_methodCalls.addElement(methodCall);
    }

    public void setPause(int pause) {
        this.m_pause = pause;
    }

    @Override
    public void run() {
        this.setPriority(1);
        for (int index = 0; index < this.m_methodCalls.size(); ++index) {
            try {
                Method method;
                BackgroundThread.sleep(this.m_pause);
                MethodCall methodCall = (MethodCall)this.m_methodCalls.elementAt(index);
                String strMethodName = methodCall.getMethodName();
                Object[] parameterArray = methodCall.getParameterArray();
                if (parameterArray == null) {
                    method = this.m_object.getClass().getMethod(strMethodName, null);
                } else {
                    Class[] typeArray = new Class[parameterArray.length];
                    for (int paramIndex = 0; paramIndex < parameterArray.length; ++paramIndex) {
                        typeArray[paramIndex] = parameterArray[paramIndex].getClass();
                    }
                    method = this.m_object.getClass().getMethod(strMethodName, typeArray);
                }
                method.invoke(this.m_object, parameterArray);
                continue;
            }
            catch (NoSuchMethodException e) {
                System.out.println(bundle.formatString("BackgroundThread.message.MethodNotFound.fmt.txt", this.m_methodCalls.elementAt(index)));
                continue;
            }
            catch (IllegalAccessException e) {
                System.out.println(bundle.formatString("BackgroundThread.message.AccessDenied.fmt.txt", this.m_methodCalls.elementAt(index)));
                continue;
            }
            catch (InvocationTargetException e) {
                System.out.println(bundle.formatString("BackgroundThread.message.BadExecute.fmt.txt", this.m_methodCalls.elementAt(index)));
                continue;
            }
            catch (InterruptedException e) {
                break;
            }
        }
    }
}

