/*
 * Decompiled with CFR 0.152.
 */
package com.sas.console.searchview;

import com.sas.console.ConsoleChangeEvent;
import com.sas.console.ConsoleChangeListener;
import com.sas.console.ConsoleInterface;
import com.sas.console.folderview.visuals.FolderViewUtil;
import com.sas.console.folderview.visuals.TableAbstractColumn;
import com.sas.console.folderview.visuals.TableView;
import com.sas.console.plugins.CustomTableInterface;
import com.sas.console.plugins.CustomTablePane;
import com.sas.console.searchview.ResultsTableItem;
import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.remote.MdFactoryEvent;
import com.sas.metadata.remote.MdFactoryListener;
import com.sas.services.ServiceException;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.publicobject.PublicObjectInterface;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.Workspace;
import java.awt.Component;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Vector;

public class ResultsTable
extends TableView
implements ConsoleChangeListener,
MdFactoryListener {
    protected ConsoleInterface m_console;
    protected LinkedHashMap _resultsMap = new LinkedHashMap();
    boolean _resultsChanged = false;

    public ResultsTable(ConsoleInterface console, TableAbstractColumn[] columnModels, int visibleColumns, Vector itemList, String settingsPrefix) {
        super(null, columnModels, visibleColumns, itemList, settingsPrefix);
        this.registerMetadataListener();
        this.m_console = console;
        this.m_console.addConsoleListener(this);
    }

    public void registerMetadataListener() {
        Factory logicalObjectFactory = Factory.getInstance();
        try {
            TypeInterface[] typesArray = logicalObjectFactory.getTypesSupported();
            String[] typeNamesArray = new String[typesArray.length];
            for (int i = 0; i < typesArray.length; ++i) {
                typeNamesArray[i] = typesArray[i].getMetadataType();
            }
            Workspace.getMdFactory().addMdFactoryListener((MdFactoryListener)this, typeNamesArray);
        }
        catch (RemoteException re) {
            re.printStackTrace();
        }
        catch (LogicalTypeException re) {
            re.printStackTrace();
        }
    }

    public void unregisterMetadataListener() {
        try {
            Workspace.getMdFactory().removeMdFactoryListener((MdFactoryListener)this);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void MdObjectsCreated(MdFactoryEvent e) throws RemoteException {
    }

    public void MdObjectsDeleted(MdFactoryEvent e) throws RemoteException {
        String[] deleteList = e.getObjectIDs();
        for (int i = 0; i < deleteList.length; ++i) {
            String deletedId = deleteList[i];
            this.deleteItemInVisual(deletedId);
        }
        this._resultsChanged = true;
    }

    public void MdObjectsModified(MdFactoryEvent e) throws RemoteException {
        String[] modifyList = e.getObjectIDs();
        for (int i = 0; i < modifyList.length; ++i) {
            String modId = modifyList[i];
            this.updateItemInVisual(modId);
        }
    }

    protected void updateItemInVisual(String fqid) {
        ResultsTableItem changedItem = this.findItemInTable(fqid);
        if (changedItem == null) {
            return;
        }
        try {
            MetadataInterface refreshedObject = FolderViewUtil.getServerInterface().fetch(changedItem.getPublicObjectInterface().getIdentifier() + "/" + changedItem.getPublicObjectInterface().getTypeDescriptor().getMetadataType(), true);
            changedItem.setPublicObjectInterface((PublicObjectInterface)refreshedObject);
            CustomTablePane customTable = (CustomTablePane)this.getComponent();
            customTable.refreshRow(this._itemList.indexOf(changedItem));
        }
        catch (ServiceException e) {
            MessageUtil.displayServiceExceptionMessage((ServiceException)e);
            e.printStackTrace();
        }
        catch (RemoteException e) {
            MessageUtil.displayRemoteExceptionMessage((RemoteException)e);
        }
    }

    protected ResultsTableItem findItemInTable(String fqid) {
        for (int i = 0; i < this._itemList.size(); ++i) {
            ResultsTableItem item = (ResultsTableItem)this._itemList.get(i);
            try {
                if (!item.getPublicObjectInterface().getIdentifier().equalsIgnoreCase(fqid)) continue;
                return item;
            }
            catch (ServiceException e) {
                continue;
            }
            catch (RemoteException e) {
                // empty catch block
            }
        }
        return null;
    }

    protected void createItemMap(Vector itemList) {
        for (int i = 0; i < this._itemList.size(); ++i) {
            ResultsTableItem item = (ResultsTableItem)this._itemList.get(i);
            this._resultsMap.put(item.getPublicObjectInterface(), i);
        }
    }

    protected int findObjectIndexInTable(PublicObjectInterface po) {
        Integer indValue;
        int index = -1;
        if (this._resultsMap.isEmpty() || this._resultsChanged) {
            if (this._resultsChanged) {
                this._resultsMap.clear();
            }
            this.createItemMap(this._itemList);
            this._resultsChanged = false;
        }
        if ((indValue = (Integer)this._resultsMap.get(po)) != null) {
            index = indValue;
        }
        return index;
    }

    @Override
    public List getContextMenuActions() {
        if (this._itemList.size() > 0) {
            return this._customTable.getContextMenuActions();
        }
        return new ArrayList();
    }

    public Vector getTableItemsList() {
        return this._itemList;
    }

    protected void deleteItemInVisual(String fqid) {
        ResultsTableItem resultItem = this.findItemInTable(fqid);
        int indexOfItemBeforeDelete = this._itemList.indexOf(resultItem);
        if (indexOfItemBeforeDelete > -1) {
            this._itemList.remove(resultItem);
            this._resultsMap.remove(resultItem.getPublicObjectInterface());
            CustomTablePane customTable = (CustomTablePane)this.getComponent();
            ResultsTableItem tableItem = resultItem;
            try {
                String type = tableItem.getPublicObjectInterface().getTypeDescriptor().getType();
                int deleteRow = customTable.getRow(resultItem.getName(), type);
                customTable.deleteRow(customTable.convertRowIndexToModel(deleteRow));
            }
            catch (ServiceException e) {
                e.printStackTrace();
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void consoleChange(ConsoleChangeEvent event) {
        int eventType = event.getEventType();
        switch (eventType) {
            case 8: 
            case 13: {
                Component table = this.getComponent();
                if (this.getComponent() == null) break;
                ((CustomTableInterface)((Object)table)).saveSettings();
                table = null;
                break;
            }
            case 12: {
                this.unregisterMetadataListener();
                this.m_console.removeConsoleListener(this);
            }
        }
    }
}

