/*
 * Decompiled with CFR 0.152.
 */
package com.sas.console.searchview;

import com.sas.console.folderview.visuals.TableAbstractColumn;
import com.sas.console.plugins.CustomTableInterface;
import com.sas.console.searchview.RB;
import com.sas.console.searchview.ResultsTable;
import com.sas.console.searchview.TableColumnLocation;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.OMIServer;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.metadata.VirtualFolderManager;
import com.sas.services.information.publicobject.PublicObjectInterface;
import com.sas.services.information.sasfolders.SASFoldersUtil;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import javax.swing.SwingUtilities;

public class LocationColumnThread
extends Thread {
    TableColumnLocation _column;
    ServerInterface _server;
    ResultsTable _searchTable;
    TableAbstractColumn[] _columnModels;
    List<PublicObjectInterface> _resultsList;
    HashMap reposMap;
    CustomTableInterface customTable;
    boolean isActive = false;

    public LocationColumnThread(TableColumnLocation locColumn, ServerInterface server, ResultsTable searchTable, List<PublicObjectInterface> searchResultsList, TableAbstractColumn[] colModel) {
        this.setName("LOCATION THREAD");
        this._column = locColumn;
        this._server = server;
        this._searchTable = searchTable;
        this._columnModels = colModel;
        this._resultsList = searchResultsList;
        this.reposMap = new HashMap();
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void stopThread() {
        this.isActive = false;
    }

    @Override
    public void run() {
        this.isActive = true;
        this.customTable = (CustomTableInterface)((Object)this._searchTable.getComponent());
        String objectType = "";
        String objectId = "";
        int index = 0;
        try {
            this.buildRepositoryMap();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (PublicObjectInterface po : this._resultsList) {
            try {
                objectType = po.getTypeDescriptor().getTypeName();
                objectId = po.getIdentifier();
                int objIndex = this._searchTable.findObjectIndexInTable(po);
                if (objIndex == -1) continue;
                if (SASFoldersUtil.isContainedByFolder((PublicObjectInterface)po)) {
                    PathUrl path = po.getPathUrl();
                    if (path != null) {
                        PathUrl parentPathUrl = this.getParentPathUrl(path);
                        String displayPath = parentPathUrl.getDisplayPath();
                        this._column.setLocationValue(objIndex, displayPath);
                        final int currIndex = objIndex;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                LocationColumnThread.this.customTable.refreshRow(currIndex);
                            }
                        });
                    }
                } else if (SASFoldersUtil.isContainedByVirtualFolder((String)po.getTypeDescriptor().getTypeName(), (ServerInterface)this._server)) {
                    OMIRepositoryInterface repos = this.getVirtualObjectRepository(objectId);
                    String displayPath = VirtualFolderManager.getDefaultPath((String)po.getTypeDescriptor().getTypeName(), (OMIRepositoryInterface)repos);
                    this._column.setLocationValue(objIndex, displayPath);
                    final int currIndex = objIndex;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            LocationColumnThread.this.customTable.refreshRow(currIndex);
                        }
                    });
                }
            }
            catch (Exception e) {
                try {
                    String message = MessageFormat.format(RB.getStringResource("LocationColumnThread.RetrieveLocation.Error.txt"), objectType, po.getName(), e.getMessage());
                    System.err.println(message);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            ++index;
            if (this.isActive) continue;
            break;
        }
        this.isActive = false;
    }

    private OMIRepositoryInterface getVirtualObjectRepository(String objectID) {
        OMIRepositoryInterface repos = null;
        String shortReposID = objectID.substring(0, 8);
        if (this.reposMap.containsKey(shortReposID)) {
            repos = (OMIRepositoryInterface)this.reposMap.get(shortReposID);
        }
        return repos;
    }

    private void buildRepositoryMap() throws ServiceException, RemoteException {
        OMIServer server = Workspace.getWorkspace().getMetadataServer();
        List reposList = server.getRepositories(true);
        for (RepositoryInterface rs : reposList) {
            if (!(rs instanceof OMIRepositoryInterface)) continue;
            String id = ((OMIRepositoryInterface)rs).getDefaultRepositoryId();
            String shortReposId = id.substring(9);
            this.reposMap.put(shortReposId, (OMIRepositoryInterface)rs);
        }
    }

    public PathUrl getParentPathUrl(PathUrl objPathUrl) {
        if (objPathUrl.getName() == null) {
            return new PathUrl(objPathUrl.getRepository(), null, null, "/", "Folder");
        }
        return new PathUrl(objPathUrl.getRepository(), objPathUrl.getRootTree(), objPathUrl.getPath(), null, "Folder");
    }
}

