/*
 * Decompiled with CFR 0.152.
 */
package com.sas.console.plugins.Root;

import com.sas.console.plugins.PluginInterface;
import com.sas.console.visuals.ConsoleViewInterface;
import com.sas.console.visuals.MainConsole;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.iom.SASIOMDefs.VariableArray2dOfStringHolder;
import com.sas.meta.SASOMI.ISecurity_1_1;
import com.sas.meta.SASOMI.ISecurity_1_1Helper;
import com.sas.metadata.remote.ApplicationAction;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.FastMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Tree;
import com.sas.workspace.ILogger;
import com.sas.workspace.IdentityUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.omg.CORBA.Object;
import org.omg.CORBA.StringHolder;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PluginSecurityManager {
    private static final String VERSION_ATTRIBUTE = "SoftwareVersion";
    private static final String CURRENT_VERSION = "9.4";
    private static String softwareComponentName = "Management Console";
    private String m_strFoundationReposID = null;
    protected static WAdminResource bundle = new WAdminResource(PluginSecurityManager.class);

    private static void debug(String msg) {
        String loggerContext = Workspace.getMainLoggingContext() + ".pluginmgr";
        ILogger logger = Workspace.getLogger((String)loggerContext);
        if (logger != null && logger.isDebugEnabled()) {
            Workspace.getLogger((String)loggerContext).debug((java.lang.Object)("PluginSecurityManager: " + msg));
        }
    }

    public boolean deleteApplicationAction(Class pluginClass, String pluginName) {
        try {
            MdObjectStore objectStore = Workspace.getWorkspace().getMdObjectFactory().createObjectStore();
            Tree pluginTree = this.getSASMCPluginTree((MdStore)objectStore);
            if (pluginTree == null) {
                Workspace.getDefaultLogger().error((java.lang.Object)bundle.getString("PluginSecurityManager.BadSoftwareComponentMetadata.txt"));
                return false;
            }
            AssociationList members = pluginTree.getMembers();
            for (int i = 0; i < members.size(); ++i) {
                if (!(members.get(i) instanceof ApplicationAction) || !((ApplicationAction)members.get(i)).getActionIdentifier().equals(pluginClass.getName())) continue;
                Workspace.getMdFactory().deleteMetadataObject((CMetadata)((ApplicationAction)members.get(i)));
            }
            objectStore.dispose();
        }
        catch (Exception e) {
            Workspace.getDefaultLogger().error((java.lang.Object)"", (Throwable)e);
            return false;
        }
        return true;
    }

    public boolean createApplicationAction(Class pluginClass, String pluginName) {
        try {
            MdObjectStore objectStore = Workspace.getWorkspace().getMdObjectFactory().createObjectStore();
            ApplicationAction newAction = (ApplicationAction)Workspace.getWorkspace().getMdObjectFactory().createComplexMetadataObject(objectStore, (MdStore)null, pluginName, "ApplicationAction", this.getFoundationReposContext(), (String)null);
            newAction.setActionIdentifier(pluginClass.getName());
            Tree pluginTree = this.getSASMCPluginTree((MdStore)objectStore);
            if (pluginTree == null) {
                Workspace.getDefaultLogger().error((java.lang.Object)bundle.getString("PluginSecurityManager.BadSoftwareComponentMetadata.txt"));
                return false;
            }
            pluginTree.getMembers().add((java.lang.Object)newAction);
            newAction.updateMetadataAll();
            objectStore.dispose();
        }
        catch (Exception e) {
            Workspace.getDefaultLogger().error((java.lang.Object)"", (Throwable)e);
        }
        return true;
    }

    private String getFoundationReposContext() {
        try {
            String foundationReposID = this.getFoundationRepositoryID();
            return foundationReposID.substring(9);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private Tree getSASMCPluginTree(MdStore objectStore) throws MdException, RemoteException {
        String sOptions = "<XMLSELECT Search=\"Tree[@TreeType='ApplicationActions'][Properties/Property[@PropertyName='CategoryName' and @DefaultValue='mgmtconsole_Plugins']][ParentTree/Tree[@TreeType='ApplicationActions']/SoftwareComponents/SoftwareComponent[@ClassIdentifier='mgmtcondata' AND @Name ? '" + softwareComponentName + "']]\"/>";
        int fOptions = 392;
        List list = Workspace.getWorkspace().getMdObjectFactory().getOMIUtil().getMetadataObjectsSubset(objectStore, "A0000001." + this.getFoundationReposContext(), "Tree", fOptions, sOptions);
        if (list.size() > 0) {
            return (Tree)list.get(0);
        }
        return null;
    }

    public String getSoftwareComponentID(Class pluginClass) {
        String componentID = null;
        if (Workspace.getWorkspace() == null || ((MainConsole)Workspace.getWorkspace()).getOMIConnection() == null) {
            return null;
        }
        try {
            String foundationReposID = this.getFoundationRepositoryID();
            if (foundationReposID == null) {
                return null;
            }
            String sOptions = "<XMLSELECT Search=\"@ActionIdentifier='" + pluginClass.getName() + "'\"/>";
            int fOptions = 392;
            List list = Workspace.getWorkspace().getMdObjectFactory().getOMIUtil().getMetadataObjectsNoCache("ApplicationAction", foundationReposID, sOptions, fOptions);
            if (list.size() > 0) {
                Map action = (Map)list.get(0);
                componentID = (String)action.get("Id");
            }
        }
        catch (Exception e) {
            Workspace.getDefaultLogger().error((java.lang.Object)"", (Throwable)e);
        }
        return componentID;
    }

    public boolean shouldPluginLoad(PluginInterface plugin) {
        if (Workspace.getWorkspace() == null || ((MainConsole)Workspace.getWorkspace()).getOMIConnection() == null) {
            if (plugin.needsConnection() && Workspace.getWorkspace() == null) {
                PluginSecurityManager.debug(bundle.formatString("PluginSecurityManager.LoadMsg1.txt", (java.lang.Object)plugin.getName()));
            }
            if (plugin.needsConnection() && ((MainConsole)Workspace.getWorkspace()).getOMIConnection() == null) {
                PluginSecurityManager.debug(bundle.formatString("PluginSecurityManager.LoadMsg1.txt", (java.lang.Object)plugin.getName()));
            }
            return !plugin.needsConnection();
        }
        if (((MainConsole)Workspace.getWorkspace()).getDefaultRepository() == null) {
            if (plugin.needsConnection() && !plugin.getClass().getName().equals("com.sas.console.plugins.metadataManager.Plugin")) {
                PluginSecurityManager.debug(bundle.formatString("PluginSecurityManager.LoadMsg1.txt", (java.lang.Object)plugin.getName()));
            }
            return !plugin.needsConnection() || plugin.getClass().getName().equals("com.sas.console.plugins.metadataManager.Plugin");
        }
        try {
            String foundationReposID = this.getFoundationRepositoryID();
            if (foundationReposID == null) {
                if (plugin.needsConnection()) {
                    PluginSecurityManager.debug(bundle.formatString("PluginSecurityManager.LoadMsg2.txt", (java.lang.Object)plugin.getName()));
                }
                return !plugin.needsConnection();
            }
            FastMetadata softwareComponent = PluginSecurityManager.getSoftwareComponent(foundationReposID);
            if (softwareComponent != null) {
                String softwareComponentID = (String)softwareComponent.get((java.lang.Object)"Id");
                ISecurity_1_1 m_iSec = ISecurity_1_1Helper.narrow((Object)Workspace.getWorkspace().getCMRHandle());
                String[][] sOptions2 = new String[][]{{"ALLATTRS", ""}};
                VariableArray2dOfStringHolder m_outputArray = new VariableArray2dOfStringHolder();
                m_iSec.GetApplicationActionsAuthorizations("", softwareComponentID, sOptions2, m_outputArray);
                for (int i = 0; i < m_outputArray.value.length; ++i) {
                    if (!m_outputArray.value[i][0].equals(plugin.getClass().getName())) continue;
                    if (m_outputArray.value[i][2].equals("Y")) {
                        return true;
                    }
                    PluginSecurityManager.debug(bundle.formatString("PluginSecurityManager.LoadMsg3.txt", (java.lang.Object)plugin.getName()));
                    return false;
                }
                if (!IdentityUtil.checkSpecialAuthorization((int)1)) {
                    boolean result;
                    boolean bl = result = !this.requiresRegistration(m_outputArray);
                    if (!result) {
                        PluginSecurityManager.debug(bundle.formatString("PluginSecurityManager.LoadMsg4.txt", (java.lang.Object)plugin.getName()));
                    }
                    return result;
                }
                return true;
            }
            if (IdentityUtil.checkSpecialAuthorization((int)1)) {
                return true;
            }
            StringHolder identityString = new StringHolder();
            ISecurity_1_1 securityConn = ((MainConsole)plugin.getConsole()).getMetaWorkspace().MakeISecurityConnection(plugin.getConsole().getOMIConnection());
            securityConn.GetIdentity("", identityString);
            String urn = identityString.value;
            if (urn.indexOf("UNKNOWN") >= 0) {
                PluginSecurityManager.debug(bundle.formatString("PluginSecurityManager.LoadMsg5.txt", (java.lang.Object)plugin.getName()));
                return false;
            }
            return true;
        }
        catch (Exception e) {
            Workspace.getDefaultLogger().error((java.lang.Object)"", (Throwable)e);
            try {
                if (IdentityUtil.checkSpecialAuthorization((int)1)) {
                    return true;
                }
            }
            catch (Throwable t) {
                Workspace.getDefaultLogger().error((java.lang.Object)"Basic functionality failing...", t);
            }
            return false;
        }
    }

    public boolean shouldViewLoad(ConsoleViewInterface view) {
        if (Workspace.getWorkspace() == null || ((MainConsole)Workspace.getWorkspace()).getOMIConnection() == null) {
            PluginSecurityManager.debug(bundle.formatString("PluginSecurityManager.LoadMsg1.txt", (java.lang.Object)view.getName()));
            return false;
        }
        if (((MainConsole)Workspace.getWorkspace()).getDefaultRepository() == null) {
            PluginSecurityManager.debug(bundle.formatString("PluginSecurityManager.LoadMsg1.txt", (java.lang.Object)view.getName()));
            return false;
        }
        try {
            String foundationReposID = this.getFoundationRepositoryID();
            if (foundationReposID == null) {
                PluginSecurityManager.debug(bundle.formatString("PluginSecurityManager.LoadMsg2.txt", (java.lang.Object)view.getName()));
                return false;
            }
            FastMetadata softwareComponent = PluginSecurityManager.getSoftwareComponent(foundationReposID);
            if (softwareComponent != null) {
                String softwareComponentID = (String)softwareComponent.get((java.lang.Object)"Id");
                ISecurity_1_1 m_iSec = ISecurity_1_1Helper.narrow((Object)Workspace.getWorkspace().getCMRHandle());
                String[][] sOptions2 = new String[][]{{"ALLATTRS", ""}};
                VariableArray2dOfStringHolder m_outputArray = new VariableArray2dOfStringHolder();
                m_iSec.GetApplicationActionsAuthorizations("", softwareComponentID, sOptions2, m_outputArray);
                for (int i = 0; i < m_outputArray.value.length; ++i) {
                    if (!m_outputArray.value[i][0].equals(view.getClass().getName())) continue;
                    if (m_outputArray.value[i][2].equals("Y")) {
                        return true;
                    }
                    PluginSecurityManager.debug(bundle.formatString("PluginSecurityManager.LoadMsg3.txt", (java.lang.Object)view.getName()));
                    return false;
                }
                if (!IdentityUtil.checkSpecialAuthorization((int)1)) {
                    boolean result;
                    boolean bl = result = !this.requiresRegistration(m_outputArray);
                    if (!result) {
                        PluginSecurityManager.debug(bundle.formatString("PluginSecurityManager.LoadMsg4.txt", (java.lang.Object)view.getName()));
                    }
                    return result;
                }
                return true;
            }
            if (IdentityUtil.checkSpecialAuthorization((int)1)) {
                return true;
            }
            StringHolder identityString = new StringHolder();
            ISecurity_1_1 securityConn = ((MainConsole)view.getConsole()).getMetaWorkspace().MakeISecurityConnection(view.getConsole().getOMIConnection());
            securityConn.GetIdentity("", identityString);
            String urn = identityString.value;
            if (urn.indexOf("UNKNOWN") >= 0) {
                PluginSecurityManager.debug(bundle.formatString("PluginSecurityManager.LoadMsg5.txt", (java.lang.Object)view.getName()));
                return false;
            }
            return true;
        }
        catch (Exception e) {
            Workspace.getDefaultLogger().error((java.lang.Object)"", (Throwable)e);
            return false;
        }
    }

    private static FastMetadata getSoftwareComponent(String foundationReposID) throws MdException, RemoteException {
        String sOptions = "<XMLSELECT Search=\"SoftwareComponent[@ClassIdentifier='mgmtcondata' AND @Name ? '" + softwareComponentName + "']\"/>";
        int fOptions = 392;
        FastMetadata softwareComponent = null;
        List<FastMetadata> results = Workspace.getWorkspace().getMdObjectFactory().getOMIUtil().getFastMetadataObjects("SoftwareComponent", foundationReposID, sOptions, fOptions);
        if (results != null && !results.isEmpty()) {
            if (results.size() == 1) {
                softwareComponent = (FastMetadata)results.get(0);
                PluginSecurityManager.debug("Found a single software component with version " + softwareComponent.getAttribute(VERSION_ATTRIBUTE));
            } else {
                PluginSecurityManager.debug("Found multiple software component instances.  Scanning for proper version.");
                results = PluginSecurityManager.sortResults(results);
                softwareComponent = PluginSecurityManager.getSoftwareComponentByVersion(CURRENT_VERSION, results);
                PluginSecurityManager.debug("Using software component with version " + softwareComponent.getAttribute(VERSION_ATTRIBUTE));
            }
        }
        if (softwareComponent == null) {
            PluginSecurityManager.debug("No valid software components were found.");
        }
        return softwareComponent;
    }

    private static FastMetadata getSoftwareComponentByVersion(String currentVersion, List<FastMetadata> softwareComponents) {
        for (FastMetadata sc : softwareComponents) {
            String version = sc.getAttribute(VERSION_ATTRIBUTE);
            if (!currentVersion.equalsIgnoreCase(version)) continue;
            return sc;
        }
        double currentDoubleVersion = Double.parseDouble(currentVersion);
        for (FastMetadata sc : softwareComponents) {
            try {
                double version = Double.parseDouble(sc.getAttribute(VERSION_ATTRIBUTE));
                if (!(currentDoubleVersion >= version)) continue;
                return sc;
            }
            catch (NumberFormatException numberFormatException) {
            }
        }
        return softwareComponents.get(0);
    }

    private static List<FastMetadata> sortResults(List<FastMetadata> results) {
        Collections.sort(results, new VersionSorter());
        return results;
    }

    private boolean requiresRegistration(VariableArray2dOfStringHolder array) {
        try {
            for (int i = 0; i < array.value.length; ++i) {
                if (!array.value[i][0].equals(bundle.getString("PluginSecurityManager.LoadUnregistered.Identifier.notrans"))) continue;
                return !array.value[i][2].equals("Y");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public static boolean isRoleMetadataAvailable() {
        try {
            String foundationReposID = PluginSecurityManager.getFoundationRepositoryIDFromServer();
            if (foundationReposID == null) {
                return false;
            }
            FastMetadata softwareComponent = PluginSecurityManager.getSoftwareComponent(foundationReposID);
            return softwareComponent != null;
        }
        catch (Exception e) {
            Workspace.getDefaultLogger().error((java.lang.Object)"", (Throwable)e);
            return false;
        }
    }

    public void resetFoundationRepositoryID() {
        this.m_strFoundationReposID = null;
    }

    private String getFoundationRepositoryID() throws GenericError, MdException, RemoteException {
        if (this.m_strFoundationReposID != null) {
            return this.m_strFoundationReposID;
        }
        this.m_strFoundationReposID = PluginSecurityManager.getFoundationRepositoryIDFromServer();
        return this.m_strFoundationReposID;
    }

    private static String getFoundationRepositoryIDFromServer() throws GenericError, MdException, RemoteException {
        StringHolder outXML = new StringHolder();
        ((MainConsole)Workspace.getWorkspace()).getOMIConnection().GetMetadataObjects("A0000001.A0000001", "RepositoryBase", outXML, "REPOS", 128, "<XMLSELECT search=\"@RepositoryType='FOUNDATION'\" />");
        String outXMLString = outXML.value;
        Document mainDoc = Workspace.getMdFactory().getOMIUtil().parseXML(outXMLString);
        if (mainDoc != null) {
            Node firstNode = mainDoc.getFirstChild();
            NodeList nodeList = firstNode.getChildNodes();
            NamedNodeMap childNodeMap = nodeList.item(0).getAttributes();
            return childNodeMap.getNamedItem("Id").getNodeValue();
        }
        return null;
    }

    static class VersionSorter
    implements Comparator<FastMetadata> {
        VersionSorter() {
        }

        @Override
        public int compare(FastMetadata sc1, FastMetadata sc2) {
            Double double2;
            Double double1;
            if (sc1 == null) {
                return -1;
            }
            if (sc2 == null) {
                return 1;
            }
            if (sc1 == sc2) {
                return 0;
            }
            String version1 = sc1.getAttribute(PluginSecurityManager.VERSION_ATTRIBUTE);
            String version2 = sc2.getAttribute(PluginSecurityManager.VERSION_ATTRIBUTE);
            if (version1 == null) {
                return -1;
            }
            if (version2 == null) {
                return 1;
            }
            try {
                double1 = Double.parseDouble(version1);
            }
            catch (NumberFormatException e) {
                return -1;
            }
            try {
                double2 = Double.parseDouble(version2);
            }
            catch (NumberFormatException e) {
                return 1;
            }
            double d1 = double1;
            double d2 = double2;
            if (d1 == d2) {
                return 0;
            }
            if (d1 > d2) {
                return -1;
            }
            return 1;
        }
    }
}

