/*
 * Decompiled with CFR 0.152.
 */
package com.sas.console.plugins.Root;

import com.sas.console.plugins.IntObjPair;
import com.sas.console.plugins.NodeInterface;
import com.sas.console.plugins.PluginNavigationInterface;
import com.sas.console.plugins.Root.CategoryNode;
import com.sas.console.plugins.Root.RootNode;
import com.sas.console.utils.FontUtil;
import com.sas.console.visuals.ConsoleHelpAction;
import com.sas.console.visuals.MainConsole;
import com.sas.console.visuals.PluginHelpAction;
import com.sas.workspace.WAdminResource;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class Desktop
extends JLayeredPane {
    private static final long serialVersionUID = 9200000001L;
    protected JLabel m_backgroundLabel;
    protected JScrollPane m_mainScrollPane;
    protected JPanel m_mainPanel;
    protected JLabel m_smcLabel;
    protected JLabel m_sasLabel;
    protected JPanel m_header;
    protected JPanel m_lightBlueHeader;
    protected ImageIcon m_backgroundImage;
    protected ImageIcon m_smcImage;
    protected ImageIcon m_sasImage;
    protected JButton m_roadmapsButton;
    protected JTextArea m_roadDesc;
    protected ArrayList m_sectionButtons;
    protected ArrayList m_sectionList;
    protected static Color SECTION_BUTTON_BACKGROUND = new Color(220, 220, 220);
    protected static Color LIGHT_BLUE = new Color(22, 91, 176);
    protected static Color SAS_BLUE = new Color(59, 140, 203);
    protected static Color GRAY_TEXT = new Color(102, 102, 102);
    protected static Color BLUE_TEXT = new Color(0, 51, 153);
    protected MainConsole m_console;
    protected List m_categoryNodes;
    protected static WAdminResource bundle = new WAdminResource(Desktop.class);

    public Desktop(MainConsole console, NodeInterface node) {
        this.m_console = console;
        if (node instanceof RootNode) {
            this.m_categoryNodes = ((RootNode)node).getCategoryNodes();
        } else {
            this.m_categoryNodes = new Vector(1);
            this.m_categoryNodes.add(node);
        }
        this._initialize();
        this._initializeTasks();
        this._layoutWidgets();
    }

    protected void _initialize() {
        this.setOpaque(true);
        if (FontUtil.isHighContrast()) {
            this.setBackground(Color.black);
        } else {
            this.setBackground(Color.white);
        }
        this.m_mainPanel = new JPanel();
        this.m_mainPanel.setOpaque(false);
        this.m_header = new JPanel();
        this.m_header.setBackground(SAS_BLUE);
        this.m_lightBlueHeader = new JPanel();
        this.m_lightBlueHeader.setBackground(LIGHT_BLUE);
        this.m_lightBlueHeader.setMinimumSize(new Dimension(200, 4));
        this.m_lightBlueHeader.setPreferredSize(new Dimension(200, 4));
        this.m_smcImage = bundle.getImageIcon("RootNode.SMCLogoIcon.image");
        this.m_smcLabel = new JLabel(this.m_smcImage);
        this.m_sasImage = bundle.getImageIcon("RootNode.SASLogoIcon.image");
        this.m_sasLabel = new JLabel(this.m_sasImage);
        this.m_backgroundImage = FontUtil.isHighContrast() ? bundle.getImageIcon("RootNode.Desktopblack.image") : bundle.getImageIcon("RootNode.Desktop.image");
        this.m_backgroundLabel = new JLabel(this.m_backgroundImage);
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        this.m_mainPanel.setSize(this.getWidth(), this.getHeight());
        this.m_mainPanel.doLayout();
        int x2 = this.getWidth() - this.m_backgroundLabel.getWidth();
        this.m_backgroundLabel.setLocation(x2, this.m_mainScrollPane.getHeight() - this.m_backgroundLabel.getHeight() - this.m_mainScrollPane.getHorizontalScrollBar().getHeight());
    }

    protected void _layoutWidgets() {
        this.add((Component)this.m_mainPanel, JLayeredPane.DEFAULT_LAYER);
        GridBagLayout gbl = new GridBagLayout();
        this.m_mainPanel.setLayout(gbl);
        this.m_smcLabel.setSize(this.m_smcImage.getIconWidth(), this.m_smcImage.getIconHeight());
        this.m_sasLabel.setSize(this.m_sasImage.getIconWidth(), this.m_sasImage.getIconHeight());
        this.m_header.setLayout(new BorderLayout(0, 0));
        this.m_header.add((Component)this.m_smcLabel, "West");
        this.m_header.add((Component)this.m_sasLabel, "East");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.anchor = 18;
        gbl.setConstraints(this.m_header, gbc);
        this.m_mainPanel.add(this.m_header);
        this.m_mainPanel.setLocation(0, 0);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.anchor = 18;
        gbl.setConstraints(this.m_lightBlueHeader, gbc);
        this.m_mainPanel.add(this.m_lightBlueHeader);
        this.m_backgroundLabel.setSize(this.m_backgroundImage.getIconWidth(), this.m_backgroundImage.getIconHeight());
        JPanel scrolledPanel = new JPanel();
        scrolledPanel.setOpaque(false);
        this.m_mainScrollPane = new JScrollPane(scrolledPanel){
            private static final long serialVersionUID = 1L;

            @Override
            public void paintComponent(Graphics g) {
                Graphics2D g2d = (Graphics2D)g;
                if (!FontUtil.isHighContrast()) {
                    g2d.setPaint(new GradientPaint(0.0f, 0.0f, new Color(255, 255, 255), this.getWidth(), this.getHeight(), new Color(242, 249, 255)));
                    g2d.fill(new Rectangle(0, 0, this.getWidth(), this.getHeight()));
                }
                super.paintComponent(g2d);
            }
        };
        this.m_mainScrollPane.getViewport().setOpaque(false);
        this.m_mainScrollPane.setOpaque(false);
        this.m_mainScrollPane.setBorder(null);
        this.m_mainScrollPane.add((Component)this.m_backgroundLabel, JLayeredPane.DEFAULT_LAYER);
        JScrollBar vScrollBar = this.m_mainScrollPane.getVerticalScrollBar();
        vScrollBar.setUnitIncrement(20);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.anchor = 18;
        gbl.setConstraints(this.m_mainScrollPane, gbc);
        this.m_mainPanel.add(this.m_mainScrollPane);
        gbl = new GridBagLayout();
        scrolledPanel.setLayout(gbl);
        int gridy = 3;
        this.m_sectionButtons = new ArrayList();
        for (Section section : this.m_sectionList) {
            SectionButton sectionButton = new SectionButton(section);
            FontUtil.setFontForHC(sectionButton);
            this.m_sectionButtons.add(sectionButton);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = gridy++;
            gbc.weightx = 1.0;
            gbc.insets = new Insets(7, 0, 0, 6);
            gbc.fill = 2;
            gbc.anchor = 18;
            gbl.setConstraints(sectionButton, gbc);
            scrolledPanel.add(sectionButton);
            JTextArea desc = new JTextArea(section.getDesc());
            desc.setFont(new JLabel().getFont());
            desc.setOpaque(false);
            desc.setLineWrap(true);
            desc.setWrapStyleWord(true);
            FontUtil.setFontForHC(desc);
            desc.setSize(500, new JLabel().getFont().getSize());
            desc.setEditable(false);
            desc.setFocusable(false);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = gridy++;
            gbc.weightx = 1.0;
            gbc.insets = new Insets(7, 8, 0, 0);
            gbc.fill = 2;
            gbc.anchor = 18;
            gbl.setConstraints(desc, gbc);
            scrolledPanel.add(desc);
            for (SelectPluginTask task : section.getTasks()) {
                JButton taskButton = new JButton(task);
                FontUtil.setFontForHC(taskButton);
                if (!FontUtil.isHighContrast()) {
                    taskButton.setBackground(Color.white);
                    taskButton.setForeground(BLUE_TEXT);
                }
                taskButton.setOpaque(false);
                taskButton.setMargin(new Insets(1, 3, 1, 3));
                taskButton.addKeyListener(new DesktopHelpKeyListener(task.getPlugin()));
                taskButton.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseEntered(MouseEvent e) {
                        MainConsole.getWorkspace().setCursor(Cursor.getPredefinedCursor(12));
                    }

                    @Override
                    public void mouseExited(MouseEvent e) {
                        MainConsole.getWorkspace().setCursor(Cursor.getPredefinedCursor(0));
                    }

                    @Override
                    public void mousePressed(MouseEvent e) {
                        MainConsole.getWorkspace().setCursor(Cursor.getPredefinedCursor(0));
                    }
                });
                gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = gridy++;
                gbc.insets = new Insets(10, 24, 2, 0);
                gbc.anchor = 18;
                gbl.setConstraints(taskButton, gbc);
                scrolledPanel.add(taskButton);
                JTextArea taskdesc = new JTextArea(task.m_desciption);
                taskdesc.setFont(taskButton.getFont());
                FontUtil.setFontForHC(taskdesc);
                taskdesc.setForeground(GRAY_TEXT);
                taskdesc.setOpaque(false);
                taskdesc.setLineWrap(true);
                taskdesc.setWrapStyleWord(true);
                taskdesc.setSize(500, taskButton.getFont().getSize());
                taskdesc.setEditable(false);
                taskdesc.setFocusable(false);
                gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = gridy++;
                gbc.weightx = 1.0;
                gbc.insets = new Insets(0, 49, 2, 0);
                gbc.fill = 0;
                gbc.anchor = 18;
                gbl.setConstraints(taskdesc, gbc);
                scrolledPanel.add(taskdesc);
            }
        }
        JPanel junk = new JPanel();
        junk.setOpaque(false);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.anchor = 18;
        gbl.setConstraints(junk, gbc);
        scrolledPanel.add(junk);
    }

    protected void _initializeTasks() {
        this.m_sectionList = new ArrayList();
        for (int i = 0; i < this.m_categoryNodes.size(); ++i) {
            CategoryNode cat = (CategoryNode)this.m_categoryNodes.get(i);
            Section section = new Section(cat.getName(), cat.getDescription());
            for (int j = 0; j < cat.getChildCount(); ++j) {
                NodeInterface node = (NodeInterface)cat.getChildAt(j);
                PluginNavigationInterface p = node.getPlugin();
                if (p.getName().equalsIgnoreCase(bundle.getString("Plugin.Name.txt"))) continue;
                section.addTask(new SelectPluginTask(node.getIcon(16), p));
            }
            this.m_sectionList.add(section);
        }
    }

    protected class DesktopHelpKeyListener
    extends KeyAdapter {
        protected PluginNavigationInterface m_plugin;

        public DesktopHelpKeyListener(PluginNavigationInterface plugin) {
            this.m_plugin = plugin;
        }

        @Override
        public void keyPressed(KeyEvent e) {
            switch (e.getKeyCode()) {
                case 112: {
                    if (e.isShiftDown()) {
                        PluginHelpAction pHelpAction = new PluginHelpAction(Desktop.this.m_console, this.m_plugin);
                        pHelpAction.actionPerformed(null);
                        break;
                    }
                    ConsoleHelpAction consoleHelpAction = new ConsoleHelpAction(Desktop.this.m_console);
                    consoleHelpAction.actionPerformed(null);
                    break;
                }
            }
        }
    }

    class SectionButton
    extends JTextField {
        private static final long serialVersionUID = 9200000001L;
        protected int m_initialWidth;

        public SectionButton(Section section) {
            super(section.getName(), 13);
            this.m_initialWidth = 0;
            this.setBorder(BorderFactory.createEmptyBorder(2, 8, 2, 0));
            this.setBackground(SECTION_BUTTON_BACKGROUND);
            this.setEditable(false);
            this.setEnabled(false);
            this.setDisabledTextColor(Color.black);
        }
    }

    class SelectPluginTask
    extends AbstractAction
    implements TaskLinkActionInterface {
        private static final long serialVersionUID = 9200000001L;
        public String m_desciption;
        protected PluginNavigationInterface m_plugin;

        public SelectPluginTask(Icon icon, PluginNavigationInterface plugin) {
            this.m_desciption = plugin.getDescription();
            this.m_plugin = plugin;
            this.putValue("Name", plugin.getName());
            this.putValue("SmallIcon", icon);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            NodeInterface node = this.m_plugin.getRootNode();
            NodeInterface parentNode = (NodeInterface)node.getParent();
            int index = parentNode.getIndex(node);
            IntObjPair pair = new IntObjPair(index, node);
            Vector<IntObjPair> childList = new Vector<IntObjPair>(1);
            childList.add(pair);
            this.m_plugin.firePluginChange(4, node, childList);
            if (event.getSource() != null && event.getSource() instanceof JButton) {
                JButton myButton = (JButton)event.getSource();
                myButton.getModel().setRollover(false);
            }
        }

        public PluginNavigationInterface getPlugin() {
            return this.m_plugin;
        }
    }

    static interface TaskLinkActionInterface
    extends Action {
    }

    class Section {
        protected String m_strName;
        protected String m_desc;
        protected ArrayList m_taskList = new ArrayList();

        public Section(String strName, String desc) {
            this.m_strName = strName;
            this.m_desc = desc;
        }

        public String getName() {
            return this.m_strName;
        }

        public String getDesc() {
            return this.m_desc;
        }

        public List getTasks() {
            return this.m_taskList;
        }

        public void addTask(TaskLinkActionInterface task) {
            this.m_taskList.add(task);
        }
    }
}

