/*
 * Decompiled with CFR 0.152.
 */
package com.sas.console.plugins.Root;

import com.sas.console.plugins.AbstractNode;
import com.sas.console.plugins.CustomViewInterface;
import com.sas.console.plugins.NodeInterface;
import com.sas.console.plugins.PluginNavigationInterface;
import com.sas.console.plugins.Root.DesktopView;
import com.sas.console.plugins.TableModelInterface;
import com.sas.console.visuals.MainConsole;
import com.sas.visuals.Resources;
import com.sas.workspace.WAdminResource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class CategoryNode
extends AbstractNode {
    protected String m_categoryID;
    private Vector m_nonpluginchildren;
    private TreeMap m_plugins;
    protected String m_desc;
    protected DesktopView m_desktopView;
    protected static WAdminResource bundle = new WAdminResource(CategoryNode.class);

    public CategoryNode(String categoryID, NodeInterface parent) {
        super(parent.getPlugin(), bundle.getString(categoryID + ".Name.txt"));
        this.m_categoryID = categoryID;
        this.m_nonpluginchildren = new Vector(1);
        this.m_plugins = new TreeMap();
        this.setParent(parent);
        this.setDescription(bundle.getString(categoryID + ".Desc.txt"));
    }

    public void setDescription(String desc) {
        this.m_desc = desc;
    }

    public String getDescription() {
        return this.m_desc;
    }

    @Override
    public List getContextMenuActions() {
        return null;
    }

    @Override
    public CustomViewInterface getCustomView() {
        if (this.m_desktopView == null) {
            this.m_desktopView = new DesktopView((MainConsole)this.getPlugin().getConsole(), this);
        }
        return this.m_desktopView;
    }

    @Override
    public TableModelInterface getListViewData() {
        return null;
    }

    @Override
    public List getToolBarActions() {
        return null;
    }

    @Override
    public Icon getIcon(int size) {
        ImageIcon icon = null;
        if (this.m_categoryID.equals("Application")) {
            icon = Resources.getImageIcon((String)bundle.getString("Application.Icon.image"), (int)size);
        } else if (this.m_categoryID.equals("Environment")) {
            icon = Resources.getImageIcon((String)bundle.getString("Environment.Icon.image"), (int)size);
        } else if (this.m_categoryID.equals("Maintenance")) {
            icon = Resources.getImageIcon((String)bundle.getString("Maintenance.Icon.image"), (int)size);
        } else if (this.m_categoryID.equals("Monitor")) {
            icon = Resources.getImageIcon((String)bundle.getString("Monitor.Icon.image"), (int)size);
        }
        return icon;
    }

    public String getCategoryID() {
        return this.m_categoryID;
    }

    @Override
    public String getStatusLineText() {
        return null;
    }

    public boolean addPlugin(PluginNavigationInterface plugin) {
        if (!this.m_plugins.containsValue(plugin)) {
            this.m_plugins.put(plugin.getName(), plugin);
            this.m_desktopView = null;
            return true;
        }
        return false;
    }

    public boolean removePlugin(PluginNavigationInterface plugin) {
        if (this.m_plugins.containsValue(plugin)) {
            this.m_plugins.remove(plugin.getName());
            this.m_desktopView = null;
            return true;
        }
        return false;
    }

    @Override
    public int getChildCount() {
        return this.m_nonpluginchildren.size() + this.m_plugins.size();
    }

    public int getNonPluginChildCount() {
        return this.m_nonpluginchildren.size();
    }

    @Override
    public TreeNode getChildAt(int index) {
        if (this.m_plugins.size() > index) {
            return ((PluginNavigationInterface)this.m_plugins.entrySet().toArray(new Map.Entry[0])[index].getValue()).getRootNode();
        }
        return (TreeNode)this.m_nonpluginchildren.elementAt(index - this.m_plugins.size());
    }

    public Boolean displaysSASMCProperties() {
        return Boolean.FALSE;
    }

    @Override
    public void insert(MutableTreeNode child, int index) {
        this.m_nonpluginchildren.insertElementAt(child, index);
        this.m_desktopView = null;
    }

    @Override
    public void refresh() {
    }

    public List getPlugins() {
        return new ArrayList(this.m_plugins.values());
    }

    public void removeAllPlugins() {
        this.m_plugins.clear();
        this.m_desktopView = null;
    }
}

