/*
 * Decompiled with CFR 0.152.
 */
package com.sas.console.plugins;

import com.sas.console.plugins.PluginInterface;
import com.sas.workspace.WAdminResource;
import java.util.List;
import java.util.Vector;

public class PluginActionException
extends RuntimeException {
    protected PluginInterface m_plugin;
    protected List m_errorCodesList;
    protected static final WAdminResource bundle = new WAdminResource(PluginActionException.class);
    protected WAdminResource m_thirdPartyBundle;
    static final long serialVersionUID = -4857838395685814599L;

    public PluginActionException(String strMessage, PluginInterface plugin, int[] errorCodesArray) {
        this(strMessage, plugin, errorCodesArray, null);
    }

    public PluginActionException(String strMessage, PluginInterface plugin, int errorCode) {
        this(strMessage, plugin, errorCode, null);
    }

    public PluginActionException(String strMessage, PluginInterface plugin, int[] errorCodesArray, WAdminResource thirdPartyBundle) {
        super(strMessage);
        this.m_plugin = plugin;
        this.m_thirdPartyBundle = thirdPartyBundle;
        if (errorCodesArray != null) {
            if (this.m_errorCodesList == null) {
                this.m_errorCodesList = new Vector();
            }
            for (int i = 0; i < errorCodesArray.length; ++i) {
                int value = errorCodesArray[i];
                this.m_errorCodesList.add(new Integer(value));
            }
        }
    }

    public PluginActionException(String strMessage, PluginInterface plugin, int errorCode, WAdminResource thirdPartyBundle) {
        this(strMessage, plugin, null, thirdPartyBundle);
        if (this.m_errorCodesList == null) {
            this.m_errorCodesList = new Vector();
        }
        this.m_errorCodesList.add(new Integer(errorCode));
    }

    public PluginActionException(String strMessage, int[] errorCodesArray) {
        this(strMessage, null, errorCodesArray, null);
    }

    public PluginActionException(String strMessage, int errorCode) {
        this(strMessage, null, errorCode, null);
    }

    public PluginActionException(String strMessage, int[] errorCodesArray, WAdminResource thirdPartyBundle) {
        this(strMessage, null, errorCodesArray, thirdPartyBundle);
    }

    public PluginActionException(String strMessage, int errorCode, WAdminResource thirdPartyBundle) {
        this(strMessage, null, errorCode, thirdPartyBundle);
    }

    public PluginActionException(String strMessage) {
        this(strMessage, null, null, null);
    }

    public PluginActionException(int errorCode) {
        this(null, null, errorCode, null);
    }

    public PluginActionException(int[] errorCodesArray) {
        this(null, null, errorCodesArray, null);
    }

    public PluginActionException(int errorCode, WAdminResource thirdPartyBundle) {
        this(null, null, errorCode, thirdPartyBundle);
    }

    public PluginActionException(int[] errorCodesArray, WAdminResource thirdPartyBundle) {
        this(null, null, errorCodesArray, thirdPartyBundle);
    }

    public PluginActionException(PluginInterface plugin, int errorCode) {
        this(null, plugin, errorCode, null);
    }

    public PluginActionException(PluginInterface plugin, int[] errorCodesArray) {
        this(null, plugin, errorCodesArray, null);
    }

    public PluginActionException(PluginInterface plugin, int errorCode, WAdminResource thirdPartyBundle) {
        this(null, plugin, errorCode, thirdPartyBundle);
    }

    public PluginActionException(PluginInterface plugin, int[] errorCodesArray, WAdminResource thirdPartyBundle) {
        this(null, plugin, errorCodesArray, thirdPartyBundle);
    }

    @Override
    public String getMessage() {
        String strPrefix = "";
        String strMessage = "";
        if (this.m_plugin != null) {
            String strClassName = this.m_plugin.getClass().toString();
            strClassName = strClassName.substring(0, strClassName.lastIndexOf("."));
            String strPluginName = strClassName.substring(strClassName.lastIndexOf(".") + 1);
            strPrefix = bundle.getString("PluginActionException.Prefix." + strPluginName + ".notrans");
            if (strPrefix.startsWith("Missing resource") && this.m_thirdPartyBundle != null && (strPrefix = this.m_thirdPartyBundle.getString("PluginActionException.Prefix." + strPluginName + ".notrans")).startsWith("Missing resource")) {
                strPrefix = "";
            }
        }
        if (this.m_errorCodesList != null) {
            for (int i = 0; i < this.m_errorCodesList.size(); ++i) {
                int errorCode = (Integer)this.m_errorCodesList.get(i);
                if (strPrefix.length() != 0) {
                    strMessage = strMessage + strPrefix + " ";
                }
                String strErrorCode = this.getErrorCodeString(errorCode);
                String strValue = bundle.getString("PluginActionException.ErrorCode." + strErrorCode + ".txt");
                if (strValue.startsWith("Missing resource") && this.m_thirdPartyBundle != null) {
                    strValue = this.m_thirdPartyBundle.getString("PluginActionException.ErrorCode." + strErrorCode + ".txt");
                }
                if (strValue.startsWith("Missing resource")) {
                    if (super.getMessage() != null) {
                        strMessage = strMessage + strErrorCode + " - " + super.getMessage();
                    } else {
                        strErrorCode = this.getErrorCodeString(0);
                        strValue = bundle.getString("PluginActionException.ErrorCode." + strErrorCode + ".txt");
                        strMessage = strMessage + strErrorCode + " - " + strValue;
                    }
                } else {
                    strMessage = strMessage + strErrorCode + " - " + strValue;
                }
                if (i >= this.m_errorCodesList.size() - 1) continue;
                strMessage = strMessage + " OR ";
            }
        } else if (super.getMessage() != null) {
            if (strPrefix.length() != 0) {
                strMessage = strPrefix + " - ";
            }
            strMessage = strMessage + super.getMessage();
        }
        return strMessage;
    }

    protected String getErrorCodeString(int errorCode) {
        String strErrorCode = String.valueOf(errorCode);
        while (strErrorCode.length() < 3) {
            strErrorCode = "0" + strErrorCode;
        }
        return strErrorCode;
    }
}

