/*
 * Decompiled with CFR 0.152.
 */
package com.sas.console.plugins;

import com.sas.console.ConsoleInterface;
import com.sas.console.models.RefreshKeyListener;
import com.sas.console.plugins.AbstractNode;
import com.sas.console.plugins.CustomTableColumnInterface;
import com.sas.console.plugins.CustomTableDefaultAction;
import com.sas.console.plugins.CustomTableDefaultActionInterface;
import com.sas.console.plugins.CustomTableSorter;
import com.sas.console.utils.CustomTableUtil;
import com.sas.console.utils.FontUtil;
import com.sas.console.visuals.ConsoleAction;
import com.sas.console.visuals.CopyAction;
import com.sas.console.visuals.CustomTablePropertyAction;
import com.sas.console.visuals.DeleteAction;
import com.sas.console.visuals.MainConsole;
import com.sas.console.visuals.PasteAction;
import com.sas.console.visuals.SubmenuAction;
import com.sas.console.visuals.ToolTipStrippingJPopupMenu;
import com.sas.metadata.remote.MdException;
import com.sas.swing.visuals.tableview.ColumnHeader;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsBooleanTableColumn;
import com.sas.workspace.WsDateTableColumn;
import com.sas.workspace.WsEnumeratedTableColumn;
import com.sas.workspace.WsIconTableColumn;
import com.sas.workspace.WsIntegerTableColumn;
import com.sas.workspace.WsMetadataTableColumn;
import com.sas.workspace.WsPopupMenuRequestListener;
import com.sas.workspace.WsStringTableColumn;
import com.sas.workspace.WsTable;
import com.sas.workspace.mgmt.MnemonicModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.undo.UndoManager;

public class CustomTablePane
extends JScrollPane
implements CustomTableDefaultActionInterface {
    private static final long serialVersionUID = 9200000001L;
    private static final int INITIAL_SORTED_DIRECTION = -1111;
    private static final String SORTED_COLUMN = ".SortedColumn";
    private static final String SORTED_DIRECTION = ".SortedDirection";
    protected CustomTableColumnInterface[] m_columnInterfaces;
    protected int m_vColumnCount;
    protected int m_hColumnCount;
    protected int m_rowCount;
    protected String m_settingsPrefix;
    protected CustomWsTable m_table;
    protected CustomWsTableModel m_tableModel;
    protected CustomTableKeyListener m_keyListener;
    private boolean m_bPingServerOnSelectionChange = true;
    protected static WAdminResource visualsBundle = new WAdminResource(DeleteAction.class);
    private static WAdminResource bundle = new WAdminResource(CustomTablePane.class);

    public CustomTablePane(CustomTableColumnInterface[] visibleColumnInterfaces, int rowCount, String settingsPrefix) {
        this(visibleColumnInterfaces, null, rowCount, settingsPrefix);
    }

    public CustomTablePane(CustomTableColumnInterface[] visibleColumnInterfaces, CustomTableColumnInterface[] hiddenColumnInterfaces, int rowCount, String settingsPrefix) {
        this.m_vColumnCount = visibleColumnInterfaces.length;
        this.m_hColumnCount = hiddenColumnInterfaces != null ? hiddenColumnInterfaces.length : 0;
        this.m_columnInterfaces = new CustomTableColumnInterface[this.m_vColumnCount + this.m_hColumnCount];
        for (int i = 0; i < this.m_vColumnCount; ++i) {
            this.m_columnInterfaces[i] = visibleColumnInterfaces[i];
        }
        int c = this.m_vColumnCount;
        for (int j = 0; j < this.m_hColumnCount; ++j) {
            this.m_columnInterfaces[c] = hiddenColumnInterfaces[j];
            ++c;
        }
        this.m_rowCount = rowCount;
        this.m_settingsPrefix = settingsPrefix;
        this.m_tableModel = new CustomWsTableModel();
        this.m_table = new CustomWsTable(this.m_tableModel);
        this.m_table.setAutoResizeMode(4);
        this.m_table.setUndoManager(new UndoManager());
        this.m_table.setEditable(false);
        this.m_table.setShowGrid(false);
        this.m_table.setCellSelectionEnabled(false);
        this.m_table.setRowSelectionAllowed(true);
        this.hideInitiallyHiddenColumns();
        this.restoreSettings();
        this.setViewportView((Component)((Object)this.m_table));
        this.m_table.setDeleteKeyAction(new CustomTableDeleteAction());
        this.m_keyListener = new CustomTableKeyListener(this);
        this.m_table.addKeyListener(this.m_keyListener);
        if (Workspace.getWorkspace() instanceof ConsoleInterface) {
            this.m_table.addKeyListener(new RefreshKeyListener((ConsoleInterface)Workspace.getWorkspace()));
        }
        this.m_table.setTablePopupMenuRequestListener(new CellPopupMenuRequestListener(this));
        this.m_table.setColumnHeaderPopupMenuRequestListener(new ColumnPopupMenuRequestListener());
        this.m_table.setRowHeaderPopupMenuRequestListener(new RowPopupMenuRequestListener());
        this.m_table.setDefaultAction(new ConsoleAction(new CustomTableDefaultAction(this)));
        if (FontUtil.isHighContrast()) {
            FontUtil.setFontForHC((Component)this.m_table.getColumnHeader());
            this.m_table.getColumnHeader().setHeight(28);
            this.m_table.setRowHeight(28);
        } else {
            this.m_table.getColumnHeader().setHeight(21);
        }
        FontUtil.setFontForHC((Component)((Object)this.m_table));
    }

    @Override
    public void setDefaultAction(Action action) {
        this.m_table.setDefaultAction(action);
    }

    @Override
    public Action getDefaultAction() {
        return this.m_table.getDefaultAction();
    }

    @Override
    public void saveSettings() {
        this.m_table.saveSettings(this.m_settingsPrefix);
        this.saveSettingsSortedColumn();
    }

    public void saveSettingsSortedColumn() {
        WorkspaceFile fileAppDefaults = Workspace.getWorkspace().getAppDefaultsFile();
        StringBuffer settingsPrefix = new StringBuffer(this.m_settingsPrefix);
        StringBuffer columnsPrefix = new StringBuffer(settingsPrefix);
        columnsPrefix.append(SORTED_COLUMN);
        StringBuffer directionPrefix = new StringBuffer(settingsPrefix);
        directionPrefix.append(SORTED_DIRECTION);
        int[] sortedColumns = this.m_table.getSortColumns();
        if (sortedColumns != null) {
            int[] sortedDirections = this.m_table.getSortDirections();
            String sortedColumnName = this.m_table.getColumnName(sortedColumns[0]);
            fileAppDefaults.setPropertyString(columnsPrefix.toString(), sortedColumnName);
            fileAppDefaults.setPropertyInt(directionPrefix.toString(), sortedDirections[0]);
        } else {
            fileAppDefaults.removeProperty(columnsPrefix.toString());
            fileAppDefaults.removeProperty(directionPrefix.toString());
        }
    }

    private String getSavedSortedColumn() {
        WorkspaceFile fileAppDefaults = Workspace.getWorkspace().getAppDefaultsFile();
        StringBuffer settingsPrefix = new StringBuffer(this.m_settingsPrefix);
        settingsPrefix.append(SORTED_COLUMN);
        String columnType = fileAppDefaults.getPropertyString(settingsPrefix.toString(), bundle.getString("TM.ColHdr.Name.txt"));
        return columnType;
    }

    private int getSavedSortedDirection() {
        WorkspaceFile fileAppDefaults = Workspace.getWorkspace().getAppDefaultsFile();
        StringBuffer settingsPrefix = new StringBuffer(this.m_settingsPrefix);
        settingsPrefix.append(SORTED_DIRECTION);
        int sortedDirection = fileAppDefaults.getPropertyInt(settingsPrefix.toString(), -1111);
        return sortedDirection;
    }

    private void restoreSettingsSortedColumn() {
        String savedSortedColumn = this.getSavedSortedColumn();
        TableColumnModel visibleColumns = this.m_table.getColumnModel();
        int column = -1;
        for (int i = visibleColumns.getColumnCount() - 1; i >= 0 && column == -1; --i) {
            TableColumn tableColumn = visibleColumns.getColumn(i);
            String headerValue = tableColumn.getHeaderValue().toString();
            if (!headerValue.equalsIgnoreCase(savedSortedColumn)) continue;
            column = i;
            int direction = this.getSavedSortedDirection();
            if (direction == -1111) continue;
            this.m_table.sort(column, this.getSavedSortedDirection());
        }
    }

    @Override
    public void restoreSettings() {
        this.m_table.restoreSettings(this.m_settingsPrefix);
        this.restoreSettingsSortedColumn();
    }

    @Override
    public void setAutoResizeMode(int mode) {
        this.m_table.setAutoResizeMode(mode);
    }

    @Override
    public int getAutoResizeMode() {
        return this.m_table.getAutoResizeMode();
    }

    @Override
    public List getContextMenuActions() {
        Workspace workspace = Workspace.getWorkspace();
        if (workspace instanceof MainConsole) {
            int status = ((MainConsole)workspace).getServerStatus();
            ((MainConsole)workspace).checkIServerStatus();
            if (((MainConsole)workspace).getServerStatus() != status) {
                return null;
            }
        }
        if (this.m_table.getCurrentColumn() == -1) {
            this.m_table.setCurrentColumn(0);
        }
        int modelIndex = this.m_table.convertColumnIndexToModel(this.m_table.getCurrentColumn());
        CustomTableColumnInterface column = this.m_columnInterfaces[modelIndex];
        int[] selectedRows = this.m_table.getSelectedRowsFromSelectedCells();
        if (selectedRows.length > 0) {
            this.m_table.convertRowIndexesToModel(selectedRows);
        }
        return column.getContextMenuActions(selectedRows);
    }

    @Override
    public List getToolBarActions() {
        Workspace workspace = Workspace.getWorkspace();
        if (workspace instanceof MainConsole) {
            int status = ((MainConsole)workspace).getServerStatus();
            ((MainConsole)workspace).checkIServerStatus();
            if (((MainConsole)workspace).getServerStatus() != status) {
                return null;
            }
        }
        if (this.m_rowCount == 0) {
            return null;
        }
        if (this.m_table != null && this.m_table.getCurrentColumn() == -1) {
            this.m_table.setCurrentColumn(0);
        }
        int modelIndex = this.m_table.convertColumnIndexToModel(this.m_table.getCurrentColumn());
        CustomTableColumnInterface column = this.m_columnInterfaces[modelIndex];
        int[] selectedRows = this.m_table.getSelectedRowsFromSelectedCells();
        if (selectedRows.length > 0) {
            this.m_table.convertRowIndexesToModel(selectedRows);
        }
        return column.getToolbarActions(selectedRows);
    }

    @Override
    public void addMouseListener(MouseListener mouse) {
        this.m_table.addMouseListener(mouse);
    }

    @Override
    public void removeMouseListener(MouseListener mouse) {
        this.m_table.removeMouseListener(mouse);
    }

    @Override
    public void addFocusListener(FocusListener focus) {
        if (this.m_table != null) {
            this.m_table.addFocusListener(focus);
        }
    }

    @Override
    public void removeFocusListener(FocusListener focus) {
        this.m_table.removeFocusListener(focus);
    }

    public void selectRow(int row) {
        this.m_table.selectRow(row);
    }

    public int getRowCount() {
        return this.m_table.getRowCount();
    }

    public ColumnHeader getTableColumnHeader() {
        return this.m_table.getColumnHeader();
    }

    public boolean isSortingEnabled() {
        return this.m_table.isSortingEnabled();
    }

    @Override
    public void deleteRow(int row) {
        row = this.convertRowIndexToView(row);
        this.m_table.undoableDeleteRow(row);
        --this.m_rowCount;
    }

    @Override
    public void insertRow(int afterRow, ArrayList rowData) {
        this.m_table.undoableInsertRow(afterRow, rowData);
        ++this.m_rowCount;
    }

    @Override
    public void refreshRow(int row) {
        this.m_tableModel.refreshRowData(row);
        this.m_tableModel.fireTableRowsUpdated(row, row);
    }

    @Override
    public void refresh(CustomTableColumnInterface[] columnModels, int newRowCount) {
        int j;
        int i;
        this.m_columnInterfaces = columnModels;
        if (newRowCount <= this.m_rowCount) {
            for (i = 0; i < newRowCount; ++i) {
                this.m_tableModel.refreshRowData(i);
            }
            for (j = this.m_rowCount - 1; j >= newRowCount; --j) {
                this.deleteRow(j);
            }
        } else {
            for (i = 0; i < this.m_rowCount; ++i) {
                this.m_tableModel.refreshRowData(i);
            }
            for (j = this.m_rowCount; j < newRowCount; ++j) {
                ArrayList<Object> rowData = new ArrayList<Object>();
                for (int c = 0; c < this.m_columnInterfaces.length; ++c) {
                    CustomTableColumnInterface column = this.m_columnInterfaces[c];
                    rowData.add(column.getDisplayValue(j));
                }
                this.insertRow(j - 1, rowData);
            }
        }
        this.m_rowCount = newRowCount;
        this.m_table.clearSelection();
        this.m_table.repaint();
        int[] columns = this.m_table.getSortColumns();
        int[] directions = this.m_table.getSortDirections();
        if (columns != null && directions != null) {
            for (int i2 = 0; i2 < columns.length; ++i2) {
                this.m_table.sort(columns[i2], directions[i2]);
            }
        }
    }

    @Override
    public int convertRowIndexToModel(int viewIndex) {
        return this.m_table.convertRowIndexToModel(viewIndex);
    }

    @Override
    public int convertRowIndexToView(int modelIndex) {
        return this.m_table.convertRowIndexToView(modelIndex);
    }

    @Override
    public void setRowHeaderVisible(boolean visible) {
        this.m_table.setRowHeaderVisible(visible);
    }

    private int getColumnNumber(String inputColumnName) {
        int columnNumber = -1;
        int numberOfColumns = this.m_table.getColumnCount();
        for (int i = numberOfColumns - 1; i >= 0 && columnNumber == -1; --i) {
            String columnName = this.m_table.getColumnName(i);
            if (!columnName.equalsIgnoreCase(inputColumnName)) continue;
            columnNumber = i;
        }
        return columnNumber;
    }

    private int getRowByNameAndType(int nameColumnNumber, String inputName, int typeColumnNumber, String inputType) {
        int row = -1;
        int numberOfRows = this.m_table.getRowCount();
        for (int i = numberOfRows - 1; i >= 0 && row == -1; --i) {
            String name = (String)this.m_table.getValueAt(i, nameColumnNumber);
            String type = (String)this.m_table.getValueAt(i, typeColumnNumber);
            if (!name.equalsIgnoreCase(inputName) || !type.equalsIgnoreCase(inputType)) continue;
            row = i;
        }
        return row;
    }

    public int getRow(String inputName, String inputType) {
        int nameColumnNumber = this.getColumnNumber(bundle.getString("TM.ColHdr.Name.txt"));
        int typeColumnNumber = this.getColumnNumber(bundle.getString("TM.ColHdr.Type.txt"));
        int row = this.getRowByNameAndType(nameColumnNumber, inputName, typeColumnNumber, inputType);
        return row;
    }

    @Override
    public CustomTableColumnInterface getCurrentColumn() {
        int index = this.m_table.getCurrentColumn();
        if (index == -1) {
            return null;
        }
        int modelIndex = this.m_table.convertColumnIndexToModel(index);
        return this.m_columnInterfaces[modelIndex];
    }

    @Override
    public void setCurrentColumn(int index) {
        this.m_table.setCurrentColumn(index);
    }

    @Override
    public int[] getSelectedRows() {
        int[] selectedRows = this.m_table.getSelectedRowsFromSelectedCells();
        this.m_table.convertRowIndexesToModel(selectedRows);
        return selectedRows;
    }

    @Override
    public void sort(int columnIndex) {
        this.m_table.sort(columnIndex);
    }

    @Override
    public void sort(int[] columnIndexes, int[] directions) {
        this.m_table.sort(columnIndexes, directions);
    }

    @Override
    public void sort(int columnIndex, int direction) {
        this.m_table.sort(columnIndex, direction);
    }

    @Override
    public void setSorter(CustomTableSorter sorter) {
        this.m_table.setSorter(sorter);
    }

    @Override
    public void setTableProperties(Map properties) {
        Serializable newVal;
        Object value;
        if (properties.containsKey("GRID_VISIBLE") && (value = properties.get("GRID_VISIBLE")) instanceof Boolean) {
            newVal = (Boolean)value;
            this.m_table.setShowGrid((Boolean)newVal);
        }
        if (properties.containsKey("GRID_VERTICAL") && (value = properties.get("GRID_VERTICAL")) instanceof Boolean) {
            newVal = (Boolean)value;
            this.m_table.setShowVerticalLines((Boolean)newVal);
        }
        if (properties.containsKey("GRID_HORIZONTAL") && (value = properties.get("GRID_HORIZONTAL")) instanceof Boolean) {
            newVal = (Boolean)value;
            this.m_table.setShowHorizontalLines((Boolean)newVal);
        }
        if (properties.containsKey("GRID_COLOR") && (value = properties.get("GRID_COLOR")) instanceof Color) {
            newVal = (Color)value;
            this.m_table.setGridColor((Color)newVal);
        }
        if (properties.containsKey("BACKGROUND_COLOR") && (value = properties.get("BACKGROUND_COLOR")) instanceof Color) {
            newVal = (Color)value;
            this.m_table.setBackground((Color)newVal);
        }
        if (properties.containsKey("FOREGROUND_COLOR") && (value = properties.get("FOREGROUND_COLOR")) instanceof Color) {
            newVal = (Color)value;
            this.m_table.setForeground((Color)newVal);
        }
        if (properties.containsKey("SELECTION_BACKGROUND_COLOR") && (value = properties.get("SELECTION_BACKGROUND_COLOR")) instanceof Color) {
            newVal = (Color)value;
            this.m_table.setSelectionBackground((Color)newVal);
        }
        if (properties.containsKey("SELECTION_FOREGROUND_COLOR") && (value = properties.get("SELECTION_FOREGROUND_COLOR")) instanceof Color) {
            newVal = (Color)value;
            this.m_table.setSelectionForeground((Color)newVal);
        }
        if (properties.containsKey("COLUMN_HEADERS_VISIBLE") && (value = properties.get("COLUMN_HEADERS_VISIBLE")) instanceof Boolean) {
            newVal = (Boolean)value;
            this.m_table.setColumnHeaderVisible((Boolean)newVal);
        }
        if (properties.containsKey("COLUMN_HIDING") && (value = properties.get("COLUMN_HIDING")) instanceof Boolean) {
            newVal = (Boolean)value;
            this.m_table.setColumnHidingEnabled((Boolean)newVal);
        }
        if (properties.containsKey("COLUMN_HOLDING") && (value = properties.get("COLUMN_HOLDING")) instanceof Boolean) {
            newVal = (Boolean)value;
            this.m_table.setColumnHoldingEnabled((Boolean)newVal);
        }
        if (properties.containsKey("COLUMN_REORDERING") && (value = properties.get("COLUMN_REORDERING")) instanceof Boolean) {
            newVal = (Boolean)value;
            this.m_table.setColumnsReorderable((Boolean)newVal);
        }
        if (properties.containsKey("ROW_HEADERS_VISIBLE") && (value = properties.get("ROW_HEADERS_VISIBLE")) instanceof Boolean) {
            newVal = (Boolean)value;
            this.m_table.setRowHeaderVisible((Boolean)newVal);
        }
        if (properties.containsKey("ROW_HOLDING") && (value = properties.get("ROW_HOLDING")) instanceof Boolean) {
            newVal = (Boolean)value;
            this.m_table.setRowHoldingEnabled((Boolean)newVal);
        }
        if (properties.containsKey("ROW_REORDERING") && (value = properties.get("ROW_REORDERING")) instanceof Boolean) {
            newVal = (Boolean)value;
            this.m_table.setRowsReorderable((Boolean)newVal);
        }
        if (properties.containsKey("CURSOR") && (value = properties.get("CURSOR")) instanceof Cursor) {
            newVal = (Cursor)value;
            this.m_table.setCursor((Cursor)newVal);
        }
        if (properties.containsKey("FONT") && (value = properties.get("FONT")) instanceof Font) {
            newVal = (Font)value;
            this.m_table.setFont((Font)newVal);
        }
        if (properties.containsKey("AUTO_RESIZE_MODE") && (value = properties.get("AUTO_RESIZE_MODE")) instanceof Integer) {
            newVal = (Integer)value;
            this.m_table.setAutoResizeMode((Integer)newVal);
        }
        if (properties.containsKey("SELECTION_MODE") && (value = properties.get("SELECTION_MODE")) instanceof Integer) {
            newVal = (Integer)value;
            this.m_table.setSelectionMode((Integer)newVal);
        }
    }

    protected void hideInitiallyHiddenColumns() {
        for (int i = 0; i < this.m_columnInterfaces.length; ++i) {
            CustomTableColumnInterface column = this.m_columnInterfaces[i];
            if (!column.isInitiallyHidden()) continue;
            this.m_table.hideColumn(i);
        }
    }

    protected boolean displaysProperties(Object object) {
        boolean ret = true;
        if (object == null) {
            return ret;
        }
        if (object instanceof AbstractNode) {
            AbstractNode node = (AbstractNode)object;
            try {
                Method callback = node.getClass().getMethod("displaysSASMCProperties", null);
                Boolean result = (Boolean)callback.invoke((Object)node, (Object[])null);
                ret = result;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return ret;
    }

    @Override
    public void addKeyListener(KeyListener keyListener) {
        this.m_table.addKeyListener(keyListener);
    }

    public void setPingServerOnSelectionChange(boolean flag) {
        this.m_bPingServerOnSelectionChange = flag;
    }

    private class CustomWsTable
    extends WsTable {
        private static final long serialVersionUID = 1L;

        public CustomWsTable(WsAbstractTableModel mdl) {
            super(mdl);
        }

        protected void sortImpl(int[] aColumns, int[] aDirections) {
            int[] rows = this.getSelectedRows();
            this.convertRowIndexesToModel(rows);
            super.sortImpl(aColumns, aDirections);
            this.convertRowIndexesToView(rows);
            this.selectRows(rows);
        }

        public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
            Workspace workspace;
            if (CustomTablePane.this.m_bPingServerOnSelectionChange && (workspace = Workspace.getWorkspace()) instanceof MainConsole) {
                int status = ((MainConsole)workspace).getServerStatus();
                ((MainConsole)workspace).checkIServerStatus();
                if (((MainConsole)workspace).getServerStatus() != status) {
                    return;
                }
            }
            super.changeSelection(rowIndex, columnIndex, toggle, extend);
        }
    }

    protected class CustomTableDeleteAction
    extends AbstractAction {
        private static final long serialVersionUID = 9200000001L;

        protected CustomTableDeleteAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            List actions = CustomTablePane.this.getContextMenuActions();
            for (int i = 0; i < actions.size(); ++i) {
                AbstractAction action = (AbstractAction)actions.get(i);
                if (action == null || !action.getValue("Name").equals(visualsBundle.getString("Common.DeleteAction.Name.txt"))) continue;
                ConsoleAction ca = new ConsoleAction(action);
                ca.actionPerformed(event);
                break;
            }
        }
    }

    protected class RowPopupMenuRequestListener
    implements WsPopupMenuRequestListener {
        protected RowPopupMenuRequestListener() {
        }

        public void popupMenuRequested(MouseEvent e) {
            ToolTipStrippingJPopupMenu mnuPopup = new ToolTipStrippingJPopupMenu();
            CustomTablePane.this.m_table.addColumnHeaderMenuItems(mnuPopup);
            int index = CustomTablePane.this.m_table.getCurrentColumn();
            if (index == -1) {
                CustomTablePane.this.m_table.setCurrentColumn(0);
                index = 0;
            }
            int modelIndex = CustomTablePane.this.m_table.convertColumnIndexToModel(index);
            CustomTableColumnInterface column = CustomTablePane.this.m_columnInterfaces[modelIndex];
            int[] selectedRows = CustomTablePane.this.m_table.getSelectedRowsFromSelectedCells();
            CustomTablePane.this.m_table.convertRowIndexesToModel(selectedRows);
            List actions = column.getRowHeaderContextMenuActions(selectedRows);
            if (actions != null) {
                for (int j = 0; j < actions.size(); ++j) {
                    Action action = (Action)actions.get(j);
                    if (action == null) {
                        mnuPopup.add(new JSeparator());
                        continue;
                    }
                    if (action instanceof SubmenuAction) {
                        SubmenuAction submenuAction = (SubmenuAction)action;
                        JMenu submenu = SubmenuAction.generateSubmenu(submenuAction);
                        ((JPopupMenu)mnuPopup).add(submenu);
                        continue;
                    }
                    ConsoleAction menuaction = new ConsoleAction(action);
                    ((JPopupMenu)mnuPopup).add(MnemonicModel.getMenuItemWithMnemonic((Action)menuaction));
                }
            }
            mnuPopup.show((Component)e.getSource(), e.getX(), e.getY());
        }
    }

    protected class ColumnPopupMenuRequestListener
    implements WsPopupMenuRequestListener {
        protected ColumnPopupMenuRequestListener() {
        }

        public void popupMenuRequested(MouseEvent e) {
            int modelIndex;
            CustomTableColumnInterface column;
            List actions;
            ToolTipStrippingJPopupMenu mnuPopup = new ToolTipStrippingJPopupMenu();
            CustomTablePane.this.m_table.addColumnHeaderMenuItems(mnuPopup);
            int visualColumnIndex = CustomTablePane.this.m_table.getPopupMenuColumn();
            if (visualColumnIndex < CustomTablePane.this.m_columnInterfaces.length && (actions = (column = CustomTablePane.this.m_columnInterfaces[modelIndex = CustomTablePane.this.m_table.convertColumnIndexToModel(visualColumnIndex)]).getHeaderContextMenuActions()) != null) {
                mnuPopup.add(new JSeparator());
                for (int j = 0; j < actions.size(); ++j) {
                    Action action = (Action)actions.get(j);
                    if (action == null) {
                        mnuPopup.add(new JSeparator());
                        continue;
                    }
                    if (action instanceof SubmenuAction) {
                        SubmenuAction submenuAction = (SubmenuAction)action;
                        JMenu submenu = SubmenuAction.generateSubmenu(submenuAction);
                        ((JPopupMenu)mnuPopup).add(submenu);
                        continue;
                    }
                    ConsoleAction menuaction = new ConsoleAction(action);
                    ((JPopupMenu)mnuPopup).add(MnemonicModel.getMenuItemWithMnemonic((Action)menuaction));
                }
            }
            mnuPopup.show((Component)e.getSource(), e.getX(), e.getY());
        }
    }

    protected class CellPopupMenuRequestListener
    implements WsPopupMenuRequestListener {
        protected CustomTablePane m_pane;

        public CellPopupMenuRequestListener(CustomTablePane pane) {
            this.m_pane = pane;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void popupMenuRequested(MouseEvent e) {
            Workspace workspace = Workspace.getWorkspace();
            if (workspace instanceof MainConsole) {
                int current = ((MainConsole)workspace).getServerStatus();
                ((MainConsole)workspace).checkIServerStatus();
                if (((MainConsole)workspace).getServerStatus() != current) {
                    return;
                }
            }
            ToolTipStrippingJPopupMenu mnuPopup = new ToolTipStrippingJPopupMenu();
            Action lastAction = null;
            int modelIndex = CustomTablePane.this.m_table.convertColumnIndexToModel(CustomTablePane.this.m_table.getPopupMenuColumn());
            CustomTableColumnInterface column = CustomTablePane.this.m_columnInterfaces[modelIndex];
            int[] selectedRows = CustomTablePane.this.m_table.getSelectedRowsFromSelectedCells();
            CustomTablePane.this.m_table.convertRowIndexesToModel(selectedRows);
            List actions = null;
            try {
                CustomTablePane.this.setCursor(Cursor.getPredefinedCursor(3));
                actions = column.getContextMenuActions(selectedRows);
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
            finally {
                CustomTablePane.this.setCursor(Cursor.getPredefinedCursor(0));
            }
            if (actions != null) {
                for (int j = 0; j < actions.size(); ++j) {
                    Action action = (Action)actions.get(j);
                    if (action == null) {
                        mnuPopup.add(new JSeparator());
                        continue;
                    }
                    if (action instanceof SubmenuAction) {
                        SubmenuAction submenuAction = (SubmenuAction)action;
                        JMenu submenu = SubmenuAction.generateSubmenu(submenuAction);
                        ((JPopupMenu)mnuPopup).add(submenu);
                        continue;
                    }
                    ConsoleAction newConsoleAction = new ConsoleAction(action);
                    ((JPopupMenu)mnuPopup).add(MnemonicModel.getMenuItemWithMnemonic((Action)newConsoleAction));
                }
                if (actions.size() > 0) {
                    lastAction = (Action)actions.get(actions.size() - 1);
                }
            }
            if (selectedRows.length == 1 && CustomTablePane.this.displaysProperties(column.getElementInterface(selectedRows[0]))) {
                if (lastAction != null) {
                    mnuPopup.add(new JSeparator());
                }
                ConsoleAction menuaction = new ConsoleAction(new CustomTablePropertyAction(this.m_pane));
                ((JPopupMenu)mnuPopup).add(MnemonicModel.getMenuItemWithMnemonic((Action)menuaction));
            }
            mnuPopup.show((Component)e.getSource(), e.getX(), e.getY());
        }
    }

    protected class CustomTableKeyListener
    extends KeyAdapter {
        protected CustomTablePane m_pane;

        public CustomTableKeyListener(CustomTablePane pane) {
            this.m_pane = pane;
        }

        @Override
        public void keyPressed(KeyEvent e) {
            switch (e.getKeyCode()) {
                case 127: {
                    DeleteAction deleteAction = new DeleteAction((MainConsole)Workspace.getWorkspace());
                    deleteAction.actionPerformed(null);
                    break;
                }
                case 121: {
                    if (!e.isShiftDown()) break;
                    e.consume();
                    this.m_pane.m_table.showPopup(this.m_pane.m_table.getSelectedRow(), 0);
                    break;
                }
                case 525: {
                    e.consume();
                    this.m_pane.m_table.showPopup(this.m_pane.m_table.getSelectedRow(), 0);
                    break;
                }
                case 67: {
                    if (!e.isControlDown()) break;
                    e.consume();
                    CopyAction copyAction = new CopyAction();
                    copyAction.actionPerformed(new ActionEvent(e.getSource(), e.getID(), ""));
                    break;
                }
                case 86: {
                    if (!e.isControlDown()) break;
                    PasteAction pasteAction = new PasteAction();
                    pasteAction.actionPerformed(new ActionEvent(e.getSource(), e.getID(), ""));
                }
            }
        }
    }

    protected class CustomWsTableModel
    extends WsAbstractTableModel {
        private static final long serialVersionUID = 9200000001L;

        public CustomWsTableModel() {
            this.createColumnModels();
        }

        private void createColumnModels() {
            this.m_aColumns = new WsAbstractTableColumn[this.getColumnCount() + this.getHiddenColumnCount()];
            for (int i = 0; i < CustomTablePane.this.m_columnInterfaces.length; ++i) {
                WsIntegerTableColumn iColumn;
                CustomTableColumnInterface columnInterface = CustomTablePane.this.m_columnInterfaces[i];
                if (columnInterface instanceof WsAbstractTableColumn) {
                    WsAbstractTableColumn column;
                    this.m_aColumns[i] = column = (WsAbstractTableColumn)columnInterface;
                } else if (columnInterface.getColumnType() == 1) {
                    WsStringTableColumn sColumn = new WsStringTableColumn(i);
                    this.m_aColumns[i] = sColumn;
                } else if (columnInterface.getColumnType() == 2) {
                    iColumn = new WsIntegerTableColumn(i);
                    this.m_aColumns[i] = iColumn;
                } else if (columnInterface.getColumnType() == 3) {
                    WsBooleanTableColumn bColumn = new WsBooleanTableColumn(i);
                    this.m_aColumns[i] = bColumn;
                } else if (columnInterface.getColumnType() == 0) {
                    iColumn = new WsIconTableColumn(i);
                    this.m_aColumns[i] = iColumn;
                } else if (columnInterface.getColumnType() == 5) {
                    WsMetadataTableColumn mColumn = new WsMetadataTableColumn();
                    this.m_aColumns[i] = mColumn;
                } else if (columnInterface.getColumnType() == 4) {
                    WsEnumeratedTableColumn eColumn = new WsEnumeratedTableColumn(i);
                    this.m_aColumns[i] = eColumn;
                } else if (columnInterface.getColumnType() == 6) {
                    WsDateTableColumn dColumn = new WsDateTableColumn(i);
                    dColumn.setShowAsBlankDate(CustomTableUtil.getBlankDate());
                    this.m_aColumns[i] = dColumn;
                }
                this.m_aColumns[i].setName(columnInterface.getColumnName());
                this.m_aColumns[i].setWidth(columnInterface.getDefaultWidth());
                this.m_aColumns[i].setComparator(columnInterface.getComparator());
            }
            int rowSize = CustomTablePane.this.m_rowCount;
            for (int row = 0; row < rowSize; ++row) {
                ArrayList<Object> sysrow = new ArrayList<Object>();
                for (int j = 0; j < this.m_aColumns.length; ++j) {
                    CustomTableColumnInterface column = CustomTablePane.this.m_columnInterfaces[j];
                    Object item = column.getDisplayValue(row);
                    if (item == null) continue;
                    sysrow.add(item);
                }
                if (sysrow.isEmpty()) continue;
                this.m_lData.add(sysrow);
            }
        }

        public void refreshRowData(int row) {
            ArrayList<Object> sysrow = new ArrayList<Object>();
            for (int j = 0; j < this.m_aColumns.length; ++j) {
                CustomTableColumnInterface column = CustomTablePane.this.m_columnInterfaces[j];
                sysrow.add(column.getDisplayValue(row));
            }
            this.m_lData.remove(row);
            this.m_lData.add(row, sysrow);
        }

        public int getColumnCount() {
            return CustomTablePane.this.m_vColumnCount;
        }

        public int getHiddenColumnCount() {
            return CustomTablePane.this.m_hColumnCount;
        }

        public void populateStore() throws MdException, RemoteException {
        }

        public void moveDataToModel() throws MdException, RemoteException {
        }

        public void moveDataToStore() throws MdException, RemoteException {
        }
    }
}

