/*
 * Decompiled with CFR 0.152.
 */
package com.sas.console.folderview.visuals;

import com.sas.console.folderview.visuals.BIAbstractNode;
import com.sas.console.folderview.visuals.ConsoleFolderView;
import com.sas.console.folderview.visuals.FolderNode;
import com.sas.console.folderview.visuals.FolderViewUtil;
import com.sas.console.folderview.visuals.Images;
import com.sas.console.folderview.visuals.LogicalTypesAndServicesAdapter;
import com.sas.console.folderview.visuals.RootNode;
import com.sas.console.plugins.ElementInterface;
import com.sas.console.plugins.NodeInterface;
import com.sas.console.visuals.ConsoleViewManager;
import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.LogicalObjectInterface;
import com.sas.metadata.logical.LogicalTypeIconInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.logical.UtilMetadata;
import com.sas.metadata.logical.visuals.Config;
import com.sas.metadata.logical.visuals.UtilGui;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Root;
import com.sas.services.ServiceException;
import com.sas.services.information.ChildServerInterface;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.browse.BrowseMetadataInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.publicobject.BasePublicObject;
import com.sas.services.information.publicobject.DetailsProcessorInterface;
import com.sas.services.information.publicobject.PublicObjectInterface;
import com.sas.services.information.sasfolders.ContainerNode;
import com.sas.services.information.sasfolders.FolderModelInterface;
import com.sas.services.information.sasfolders.ModelConfiguration;
import com.sas.services.information.sasfolders.PublicObjectNodeInterface;
import com.sas.services.information.sasfolders.SASFoldersModel;
import com.sas.services.information.sasfolders.SASFoldersUtil;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.Icon;

public abstract class TableItem
implements ElementInterface {
    private BIAbstractNode _parent;
    private Root _root;
    private Root _rootCopy;
    private LogicalObjectInterface _loi;
    private Date _lastUpdated;
    private PublicObjectInterface _poi;
    protected PublicObjectNodeInterface _pnode;
    protected DetailsProcessorInterface _detailsInterface;
    protected BIAbstractNode _correspondingNode;

    protected TableItem(BIAbstractNode parent, PublicObjectInterface member) {
        this._parent = parent;
        this._poi = member;
        try {
            this._detailsInterface = (DetailsProcessorInterface)this._poi.getProcessorInterface("com.sas.services.information.publicobject.DetailsProcessorInterface");
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        this.updateLastUpdated();
    }

    protected void updateLastUpdated() {
        if (this._detailsInterface != null) {
            try {
                this._lastUpdated = this._detailsInterface.getModifyDate();
            }
            catch (ServiceException e) {
                Workspace.getDefaultLogger().error((Object)("com.sas.console.folderview.visuals.TableItem.updateLastUpdated could not get last update date from server, using current date: " + e.getCause()));
                this._lastUpdated = new Date();
            }
            catch (RemoteException e) {
                this._lastUpdated = new Date();
            }
        }
    }

    public LogicalObjectInterface getLogicalObjectInterface() {
        if (this._loi == null && this._poi != null) {
            try {
                this._loi = LogicalTypesAndServicesAdapter.getInstance().convertToLogicalObject(this._poi);
            }
            catch (Exception e) {
                Workspace.getDefaultLogger().error((Object)e.getLocalizedMessage());
                return null;
            }
        }
        return this._loi;
    }

    public PublicObjectInterface getPublicObjectInterface() {
        return this._poi;
    }

    public void setPublicObjectInterface(PublicObjectInterface member) throws ServiceException, RemoteException {
        this._poi = member;
        this._detailsInterface = (DetailsProcessorInterface)this._poi.getProcessorInterface("com.sas.services.information.publicobject.DetailsProcessorInterface");
    }

    public Root getRoot() {
        if (this._root == null) {
            try {
                this._root = LogicalTypesAndServicesAdapter.getInstance().convertToJOMAObject(RootNode.getPrimaryObjectStore(), this._poi);
            }
            catch (RemoteException re) {
                Workspace.getDefaultLogger().error((Object)("com.sas.console.folderview.visuals.TableItem:Could not get metadata object from server: " + re.getCause()));
                return null;
            }
            catch (MdException mde) {
                Workspace.getDefaultLogger().error((Object)("com.sas.console.folderview.visuals.TableItem:Could not get metadata object from server: " + mde.getCause()));
                return null;
            }
        }
        return this._root;
    }

    @Override
    public Root getMetadataObject() {
        if (this._rootCopy == null) {
            try {
                this._rootCopy = (Root)UtilMetadata.createANewStoreAndGetObjectIntoIt((CMetadata)this.getRoot());
            }
            catch (RemoteException e) {
                return null;
            }
            catch (MdException e) {
                return null;
            }
        }
        return this._rootCopy;
    }

    @Override
    public void delete() {
    }

    @Override
    public void persist() {
    }

    @Override
    public NodeInterface getNode() {
        return this._parent;
    }

    @Override
    public void setName(String strName) {
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public String getName() {
        String name = "";
        try {
            name = this._detailsInterface.getDisplayName();
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        catch (RemoteException re) {
            UtilGui.displayRemoteException((RemoteException)re);
        }
        return name;
    }

    String getDescription() {
        try {
            return this._detailsInterface.getDescription();
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return "";
    }

    @Override
    public Icon getIcon(int size) {
        Icon icon = null;
        try {
            if (this._poi.getTypeDescriptor() != null) {
                String publicType = this._poi.getTypeDescriptor().getTypeName();
                TypeInterface ti = Factory.getInstance().getTypeInterface(publicType);
                if (ti instanceof LogicalTypeIconInterface && !((LogicalTypeIconInterface)ti).isIconLoadedFromType()) {
                    LogicalObjectInterface loi = this.getLogicalObjectInterface();
                    if (loi != null) {
                        icon = loi.getIcon();
                    }
                } else {
                    icon = this._poi.getTypeDescriptor().getIcon();
                }
            }
        }
        catch (Exception e) {
            Workspace.getDefaultLogger().warn((Object)e.getLocalizedMessage());
            return Images.getGenericIcon();
        }
        if (icon == null) {
            icon = Images.getGenericIcon();
        }
        return icon;
    }

    protected PublicObjectNodeInterface getPublicObjectNodeInterface() {
        if (this._pnode == null) {
            SASFoldersModel sasfoldersModel = (SASFoldersModel)((ConsoleFolderView)ConsoleViewManager.getView(1)).getSASFoldersModel();
            try {
                this._pnode = sasfoldersModel.getObject(this.getPublicObjectInterface());
            }
            catch (ServiceException e) {
                return null;
            }
            catch (RemoteException e) {
                return null;
            }
        }
        return this._pnode;
    }

    public void refreshObjectFromServer() {
        try {
            PublicObjectNodeInterface po = this.getPublicObjectNodeInterface();
            if (po != null) {
                if (po instanceof ContainerNode && !(po instanceof FolderNode)) {
                    this.refreshNonFolderContainer(po);
                } else {
                    po.refresh();
                }
                this.updateLastUpdated();
            }
            this._root = (Root)UtilMetadata.locateExistingObject((MdObjectStore)((MdObjectStore)this.getRoot().getObjectStore()), (String)this.getRoot().getCMetadataType(), (String)this.getRoot().getFQID());
            if (this.getLogicalObjectInterface() != null) {
                this._loi.refresh(this._root);
            }
        }
        catch (Exception e) {
            UtilGui.displayExceptionError((Exception)e);
        }
    }

    public void refreshNonFolderContainer(PublicObjectNodeInterface po) throws ServiceException, RemoteException {
        ServerInterface server = FolderViewUtil.getServerInterface();
        FolderModelInterface folderModel = po.getFolderModel();
        if (server != null && folderModel != null) {
            String template;
            Filter filter = new Filter();
            ModelConfiguration config = folderModel.getConfiguration();
            if (config != null && (template = config.getObjectDetails().getTemplate()) != null && template.length() > 0) {
                int flags = -2080374764;
                filter.setOMRFlags(flags);
                filter.setOMRTemplate("<Templates>" + template + "</Templates>");
            }
            BrowseMetadataInterface browse = server.browseFetch(SASFoldersUtil.getISEntityKey((PublicObjectInterface)po), (FilterInterface)filter);
            ((BasePublicObject)po).setBrowseObject(browse);
        }
    }

    public void refreshObjectFromServerAndUpdateTable() {
        int myIndex = this._parent._itemList.indexOf(this);
        this.refreshObjectFromServer();
        if (myIndex > -1) {
            this._parent.updateTableVisual(myIndex);
        }
    }

    Date getLastUpdated() {
        if (this._lastUpdated == null) {
            return new Date();
        }
        return this._lastUpdated;
    }

    @Override
    public List getPropertyTabs() {
        return this.doGetPropertyTabs(false);
    }

    public List<WAPropertyTab> getPropertyTabs(LogicalObjectInterface loi, ChildServerInterface transaction, MetadataInterface smartObject, Root jomaObject, Config config) throws MdException, RemoteException {
        this.doGetPropertyTabs(false);
        Factory loiFactory = Factory.getInstance();
        return loiFactory.getPropertyTabs(loi, transaction, smartObject, (Root)smartObject.getRepositoryEntity(), config);
    }

    List doGetPropertyTabs(boolean updateTableIfModifiedEventIsSeen) {
        ArrayList tabList = new ArrayList(0);
        this._root = this.getRoot();
        try {
            this._rootCopy = (Root)UtilMetadata.createANewStoreAndGetObjectIntoIt((CMetadata)this._root);
            LogicalObjectInterface loi = this.getLogicalObjectInterface();
            Factory loiFactory = Factory.getInstance();
            if (!loiFactory.isSmartObjectBasedDialog(loi)) {
                return LogicalTypesAndServicesAdapter.getInstance().getFactory().getPropertyTabs(this.getLogicalObjectInterface(), this._rootCopy, null);
            }
        }
        catch (MdException md) {
            UtilGui.displayMdException((MdException)md);
            return new ArrayList(0);
        }
        catch (RemoteException re) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
            return new ArrayList(0);
        }
        return tabList;
    }

    public BIAbstractNode getCorrespondingNode() {
        return this._correspondingNode;
    }
}

