/*
 * Decompiled with CFR 0.152.
 */
package com.sas.console.folderview.visuals;

import com.sas.console.folderview.visuals.ActionExport;
import com.sas.console.folderview.visuals.ActionImport;
import com.sas.console.folderview.visuals.BIAbstractNode;
import com.sas.console.folderview.visuals.BIActionInterface;
import com.sas.console.folderview.visuals.LogicalTypesAndServicesAdapter;
import com.sas.console.folderview.visuals.RootNode;
import com.sas.console.folderview.visuals.TableItem;
import com.sas.console.folderview.visuals.VirtualFolderNode;
import com.sas.console.plugins.ElementInterface;
import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.LogicalObjectInterface;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.TransportableContainerTypeInterface;
import com.sas.metadata.logical.TransportableType2Interface;
import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.services.ServiceException;
import com.sas.services.information.sasfolders.ContainerNodeInterface;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;

public class PromotionController {
    private static PromotionBIAction _biai = new PromotionBIAction();

    public static BIActionInterface getBIActionInterface() {
        return _biai;
    }

    static class PromotionBIAction
    implements BIActionInterface {
        private Set _logicalTypeNamesOfInterest;

        PromotionBIAction() {
        }

        @Override
        public List getActionsForTableItems(ElementInterface[] tableItems, BIAbstractNode node) {
            ArrayList<ActionExport> actionList = new ArrayList<ActionExport>(1);
            if (node instanceof RootNode) {
                actionList.add(new ActionExport(tableItems));
            } else if (this.isExportAllowed(tableItems)) {
                ActionExport exportAction = new ActionExport(tableItems);
                actionList.add(exportAction);
            }
            return actionList;
        }

        @Override
        public List getActionsForNode(BIAbstractNode node, boolean isNodeSelected, List tableItems) {
            ArrayList<AbstractAction> actionList = new ArrayList<AbstractAction>(2);
            if (node instanceof RootNode) {
                RootNode rn = (RootNode)node;
                actionList.add(new ActionExport(rn.getSoftwareComponent()));
                actionList.add(new ActionImport(rn.getSoftwareComponent()));
            } else {
                BIAbstractNode bn = node;
                ContainerNodeInterface container = bn.getContainerInterface();
                try {
                    if (this.isExportAllowed(node)) {
                        actionList.add(new ActionExport(container));
                    }
                }
                catch (Exception e) {
                    Workspace.getDefaultLogger().error((Object)e.getLocalizedMessage());
                }
                try {
                    if (this.isImportAllowed(node)) {
                        actionList.add(new ActionImport(container));
                    }
                }
                catch (Exception e) {
                    Workspace.getDefaultLogger().error((Object)e.getLocalizedMessage());
                }
            }
            return actionList;
        }

        @Override
        public Set getLogicalTypeNamesOfInterest() {
            if (this._logicalTypeNamesOfInterest == null) {
                this._logicalTypeNamesOfInterest = new HashSet();
                LogicalTypesAndServicesAdapter adapter = LogicalTypesAndServicesAdapter.getInstance();
                Factory factory = adapter.getFactory();
                TypeInterface[] types = null;
                try {
                    types = factory.getTypesSupported();
                }
                catch (RemoteException e) {
                    Workspace.getDefaultLogger().error((Object)("\n\nCouldn't load type dictionary. Cause: " + e.getLocalizedMessage()));
                }
                catch (LogicalTypeException e) {
                    Workspace.getDefaultLogger().error((Object)("\n\nCouldn't load type dictionary. Cause: " + e.getLocalizedMessage()));
                }
                int len = types.length;
                for (int i = 0; i < len; ++i) {
                    if (!(types[i] instanceof TransportableTypeInterface)) continue;
                    this._logicalTypeNamesOfInterest.add(types[i].getPublicType());
                }
            }
            return this._logicalTypeNamesOfInterest;
        }

        private boolean isExportAllowed(ElementInterface[] tableItems) {
            for (int index = 0; index < tableItems.length; ++index) {
                LogicalObjectInterface obj;
                ElementInterface item = tableItems[index];
                if (!(item instanceof TableItem) || (obj = ((TableItem)item).getLogicalObjectInterface()) == null) continue;
                TypeInterface ti = obj.getTypeInterface();
                if (ti instanceof TransportableType2Interface && !((TransportableType2Interface)ti).isExportAllowed()) {
                    return false;
                }
                if (ti instanceof TransportableTypeInterface) continue;
                return false;
            }
            return true;
        }

        private boolean isExportAllowed(BIAbstractNode node) throws RemoteException, ServiceException, LogicalTypeException {
            if (node instanceof VirtualFolderNode) {
                return true;
            }
            LogicalObjectInterface logicalObject = node.getLogicalObjectInterface();
            if (logicalObject != null) {
                TypeInterface type = logicalObject.getTypeInterface();
                if (type instanceof TransportableType2Interface) {
                    return ((TransportableType2Interface)type).isExportAllowed();
                }
                if (!(type instanceof TransportableTypeInterface)) {
                    return false;
                }
            }
            return true;
        }

        private boolean isImportAllowed(BIAbstractNode node) throws RemoteException, ServiceException, LogicalTypeException {
            TypeInterface type;
            if (node instanceof VirtualFolderNode) {
                return true;
            }
            LogicalObjectInterface logicalObject = node.getLogicalObjectInterface();
            if (logicalObject != null && (type = logicalObject.getTypeInterface()) instanceof TransportableContainerTypeInterface) {
                return ((TransportableContainerTypeInterface)type).isImportAllowed();
            }
            return false;
        }
    }
}

