/*
 * Decompiled with CFR 0.152.
 */
package com.sas.console.folderview.visuals;

import com.sas.console.folderview.visuals.ActionCopy;
import com.sas.console.folderview.visuals.ActionDelete;
import com.sas.console.folderview.visuals.ActionImport;
import com.sas.console.folderview.visuals.ActionRename;
import com.sas.console.folderview.visuals.BIAbstractNode;
import com.sas.console.folderview.visuals.BIActionFactory;
import com.sas.console.folderview.visuals.BIActionInterface;
import com.sas.console.folderview.visuals.ElementItem;
import com.sas.console.folderview.visuals.FolderNode;
import com.sas.console.folderview.visuals.FolderViewUtil;
import com.sas.console.folderview.visuals.LogicalTypesAndServicesAdapter;
import com.sas.console.folderview.visuals.NonFolderContainerItem;
import com.sas.console.folderview.visuals.RB;
import com.sas.console.folderview.visuals.SearchFolderNode;
import com.sas.console.folderview.visuals.TableItem;
import com.sas.console.folderview.visuals.VirtualFolderNode;
import com.sas.metadata.logical.ActionType;
import com.sas.metadata.logical.ContainerContextInterface;
import com.sas.metadata.logical.LogicalObjectInterface;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.ObjectFactoryInterface;
import com.sas.metadata.logical.visuals.UtilGui;
import com.sas.metadata.promotion.visuals.CopyPasteManager;
import com.sas.metadata.remote.Root;
import com.sas.services.ServiceException;
import com.sas.services.information.publicobject.PublicObjectInterface;
import com.sas.services.information.publicobject.TypeDescriptorInterface;
import com.sas.services.information.sasfolders.ContainerNodeInterface;
import com.sas.services.information.sasfolders.FolderNodeInterface;
import com.sas.services.information.sasfolders.MemberNodeInterface;
import com.sas.services.information.sasfolders.PublicObjectNodeInterface;
import com.sas.services.information.sasfolders.VirtualFolderNodeInterface;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.OpRequestUI;
import com.sas.workspace.Workspace;
import java.awt.Component;
import java.awt.Cursor;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeNode;

public class NonFolderContainerNode
extends BIAbstractNode
implements Comparable {
    protected NonFolderContainerItem _containerItem;
    protected PublicObjectInterface _publicObject;
    protected List m_childList;

    public NonFolderContainerNode(BIAbstractNode parent, ContainerNodeInterface containerInterface) throws LogicalTypeException, RemoteException {
        super(parent, containerInterface.getName());
        this._containerItem = new NonFolderContainerItem(this, parent, (PublicObjectNodeInterface)containerInterface);
        this.m_containerNodeInterface = containerInterface;
        this.m_isFavorite = this.isFavorite();
    }

    public NonFolderContainerNode(BIAbstractNode parent, PublicObjectInterface publicObject) throws LogicalTypeException, RemoteException {
        super(parent, publicObject.getName());
        this._containerItem = new NonFolderContainerItem(this, parent, publicObject);
        this.m_isFavorite = this.isFavorite();
    }

    @Override
    public List getPropertyTabs() {
        return this._containerItem.doGetPropertyTabs(true);
    }

    @Override
    public LogicalObjectInterface getLogicalObjectInterface() throws RemoteException, ServiceException, LogicalTypeException {
        if (this.m_logicalObject == null) {
            LogicalObjectInterface loi = null;
            if (this.m_containerNodeInterface != null) {
                loi = LogicalTypesAndServicesAdapter.getInstance().convertToLogicalObject((PublicObjectInterface)this.m_containerNodeInterface);
            } else if (this._containerItem != null && this._containerItem.getRoot() != null) {
                loi = LogicalTypesAndServicesAdapter.getInstance().convertToLogicalObject(this._containerItem.getRoot());
            }
            if (loi != null) {
                this.m_logicalObject = loi;
            }
        }
        return this.m_logicalObject;
    }

    @Override
    public Root getMetadataObject() {
        return this._containerItem.getMetadataObject();
    }

    @Override
    protected List<Action> doConstructActionList(boolean separatorsSupported, boolean isNodeSelected) {
        Action action;
        ArrayList<Action> actionsList = new ArrayList<Action>();
        LogicalObjectInterface loi = null;
        boolean addedActionsSinceLastSeparator = false;
        try {
            loi = this.getLogicalObjectInterface();
        }
        catch (ServiceException se) {
            UtilGui.displayExceptionError((Exception)((Object)se));
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        catch (LogicalTypeException e) {
            e.printStackTrace();
        }
        if (!this.getTypeName().equals("FavoritesGroup")) {
            try {
                if (this.m_containerNodeInterface != null && CopyPasteManager.isCopyAllowed((PublicObjectInterface)this.m_containerNodeInterface)) {
                    ArrayList<PublicObjectInterface> copyObject = new ArrayList<PublicObjectInterface>(1);
                    copyObject.add((PublicObjectInterface)this.m_containerNodeInterface);
                    ActionCopy copyAction = new ActionCopy(copyObject);
                    actionsList.add(copyAction);
                    addedActionsSinceLastSeparator = true;
                }
            }
            catch (Exception e) {
                UtilGui.displayExceptionError((Exception)e);
            }
            if (separatorsSupported && addedActionsSinceLastSeparator) {
                actionsList.add(null);
            }
        }
        try {
            Action deleteAction = this.createDeleteAction(this);
            if (deleteAction != null) {
                actionsList.add(deleteAction);
                addedActionsSinceLastSeparator = true;
            } else {
                addedActionsSinceLastSeparator = false;
            }
        }
        catch (Exception e) {
            UtilGui.displayExceptionError((Exception)e);
        }
        try {
            Action renameAction = this.createRenameAction(this);
            if (renameAction != null) {
                actionsList.add(renameAction);
                addedActionsSinceLastSeparator = true;
            } else {
                addedActionsSinceLastSeparator = false;
            }
        }
        catch (Exception e) {
            UtilGui.displayExceptionError((Exception)e);
        }
        if (addedActionsSinceLastSeparator && separatorsSupported) {
            actionsList.add(null);
        }
        addedActionsSinceLastSeparator = false;
        for (BIActionInterface biai : BIActionFactory.getBIActionInterfaces()) {
            List actionsForThisBIAI = biai.getActionsForNode(this, isNodeSelected, this.getElementsOfInterestToBIActionInterface(biai));
            Iterator i = actionsForThisBIAI.iterator();
            while (i.hasNext()) {
                action = (Action)i.next();
                this.checkForContextActions(action);
                if (!(action instanceof ActionImport)) continue;
                i.remove();
                break;
            }
            if (actionsForThisBIAI.size() <= 0) continue;
            if (separatorsSupported && addedActionsSinceLastSeparator) {
                actionsList.add(null);
            }
            actionsList.addAll(actionsForThisBIAI);
            addedActionsSinceLastSeparator = true;
        }
        if (separatorsSupported && addedActionsSinceLastSeparator) {
            actionsList.add(null);
        }
        addedActionsSinceLastSeparator = false;
        ObjectFactoryInterface ofi = loi.getTypeInterface().getObjectFactory();
        Action[] actions = null;
        try {
            if (ofi != null) {
                actions = ofi.getActions(loi, this.getMetadataObject(), null);
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        if (actions != null && actions.length > 0) {
            if (separatorsSupported && addedActionsSinceLastSeparator) {
                actionsList.add(null);
            }
            for (int j = 0; j < actions.length; ++j) {
                action = actions[j];
                this.checkForContextActions(action);
                if (action == null) {
                    if (!separatorsSupported) continue;
                    actionsList.add(action);
                    continue;
                }
                actionsList.add(action);
            }
            addedActionsSinceLastSeparator = true;
        }
        if (separatorsSupported && addedActionsSinceLastSeparator) {
            actionsList.add(null);
        }
        return actionsList;
    }

    private Action createDeleteAction(NonFolderContainerNode node) throws LogicalTypeException, RemoteException, ServiceException {
        LogicalObjectInterface parentLogicalObject;
        ObjectFactoryInterface objFactory;
        if (this.m_isFavorite && !node.getTypeName().equals("FavoritesGroup")) {
            return null;
        }
        TreeNode parentNode = node.getParent();
        if (parentNode instanceof NonFolderContainerNode && (objFactory = (parentLogicalObject = ((BIAbstractNode)parentNode).getLogicalObjectInterface()).getTypeInterface().getObjectFactory()) instanceof ContainerContextInterface) {
            ArrayList<LogicalObjectInterface> objects = new ArrayList<LogicalObjectInterface>(1);
            objects.add(node.getLogicalObjectInterface());
            boolean isSupported = ((ContainerContextInterface)objFactory).isActionSupportedForMembers(ActionType.DELETE, parentLogicalObject, objects);
            if (!isSupported) {
                return null;
            }
        }
        ActionDelete deleteAction = new ActionDelete(node);
        boolean enabled = true;
        try {
            enabled = node.getLogicalObjectInterface().isDeleteAllowed();
        }
        catch (Exception e) {
            enabled = false;
            e.printStackTrace();
        }
        deleteAction.setEnabled(enabled);
        return deleteAction;
    }

    private Action createRenameAction(NonFolderContainerNode node) throws LogicalTypeException, RemoteException, ServiceException {
        LogicalObjectInterface parentLogicalObject;
        ObjectFactoryInterface objFactory;
        if (this.m_isFavorite && !node.getTypeName().equals("FavoritesGroup")) {
            return null;
        }
        TreeNode parentNode = node.getParent();
        if (parentNode instanceof NonFolderContainerNode && (objFactory = (parentLogicalObject = ((BIAbstractNode)parentNode).getLogicalObjectInterface()).getTypeInterface().getObjectFactory()) instanceof ContainerContextInterface) {
            ArrayList<LogicalObjectInterface> objects = new ArrayList<LogicalObjectInterface>(1);
            objects.add(node.getLogicalObjectInterface());
            boolean isSupported = ((ContainerContextInterface)objFactory).isActionSupportedForMembers(ActionType.RENAME, parentLogicalObject, objects);
            if (!isSupported) {
                return null;
            }
        }
        ActionRename renameAction = new ActionRename(node);
        boolean enabled = true;
        try {
            enabled = node.getLogicalObjectInterface().isRenameAllowed();
        }
        catch (Exception e) {
            enabled = false;
            e.printStackTrace();
        }
        renameAction.setEnabled(enabled);
        return renameAction;
    }

    @Override
    protected void addElement(PublicObjectNodeInterface po) {
        NonFolderContainerItem ei = new NonFolderContainerItem(this, (BIAbstractNode)this, po);
        this._itemList.add(ei);
    }

    @Override
    protected void populateNode(boolean populateFolders, boolean populateMembers) {
        boolean populated = false;
        try {
            String typeName;
            TypeDescriptorInterface typeDesc;
            ContainerNodeInterface container = this.getContainerInterface();
            if (container != null && (typeDesc = container.getTypeDescriptor()) != null && (typeName = typeDesc.getTypeName()) != null && typeName.equalsIgnoreCase("SearchFolder")) {
                String progressText = RB.getStringResource("NonFolderContainerNode.RunSearch.Description.txt");
                String progressTitle = RB.getStringResource("NonFolderContainerNode.RunSearch.Title.txt");
                OpRequestUI request = new OpRequestUI((Component)SwingUtilities.getWindowAncestor((Component)Workspace.getWorkspace()), progressText, progressTitle);
                request.setDelayBeforeProgressCancelDialog(1000);
                request.execute((Runnable)new populateNodeRunnable(populateFolders, populateMembers));
                populated = true;
            }
        }
        catch (Exception e) {
            Workspace.getWorkspace();
            Workspace.getDefaultLogger().error((Object)("Node could not be populated. Reason: " + e.getLocalizedMessage()));
        }
        if (!populated) {
            this.populateNodeWithChildren(populateFolders, populateMembers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void populateNodeWithChildren(boolean populateFolders, boolean populateMembers) {
        if (this.m_containerNodeInterface == null) {
            return;
        }
        this.m_childList = new ArrayList(0);
        Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(3));
        try {
            if (populateFolders && populateMembers) {
                this.m_containerNodeInterface.refresh();
            }
            this.m_console.fireConsoleChange(15);
            this.m_childList = this.m_containerNodeInterface.getChildren();
            for (PublicObjectNodeInterface object : this.m_childList) {
                boolean isSearchFolder = object.getTypeDescriptor().getTypeName().equalsIgnoreCase("SearchFolder");
                if (object instanceof ContainerNodeInterface && populateFolders) {
                    VirtualFolderNodeInterface folder;
                    if (object instanceof VirtualFolderNodeInterface) {
                        folder = (VirtualFolderNodeInterface)object;
                        VirtualFolderNode virtualFolderNode = null;
                        try {
                            virtualFolderNode = new VirtualFolderNode((BIAbstractNode)this, folder);
                        }
                        catch (RemoteException e) {
                            e.printStackTrace();
                        }
                        this._folderNodeList.add(virtualFolderNode);
                        this._itemList.add(virtualFolderNode.getItem());
                    } else if (object instanceof FolderNodeInterface) {
                        folder = (FolderNodeInterface)object;
                        FolderNode folderNode = new FolderNode(this, (ContainerNodeInterface)folder);
                        this._folderNodeList.add(folderNode);
                        this._itemList.add(folderNode.getItem());
                    } else if (object instanceof ContainerNodeInterface) {
                        ContainerNodeInterface container = (ContainerNodeInterface)object;
                        NonFolderContainerNode containerNode = null;
                        try {
                            containerNode = isSearchFolder ? new SearchFolderNode((BIAbstractNode)this, container) : new NonFolderContainerNode((BIAbstractNode)this, container);
                        }
                        catch (LogicalTypeException logicalTypeException) {
                            // empty catch block
                        }
                        this._folderNodeList.add(containerNode);
                        this._itemList.add(containerNode.getItem());
                    }
                }
                if (!populateMembers || !(object instanceof MemberNodeInterface)) continue;
                MemberNodeInterface member = (MemberNodeInterface)object;
                ElementItem memberItem = new ElementItem(this, (PublicObjectInterface)member);
                this._itemList.add(memberItem);
            }
            if (populateFolders) {
                Collections.sort(this._folderNodeList);
            }
            if (populateMembers) {
                Collections.sort(this._itemList);
            }
        }
        catch (ServiceException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
            Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
        }
        catch (RemoteException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
            Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
        }
        finally {
            Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    @Override
    public TableItem getItem() {
        return this._containerItem;
    }

    @Override
    public Icon getIcon(int size) {
        return this._containerItem.getIcon(size);
    }

    @Override
    public int compareTo(Object o) {
        return FolderViewUtil.compare(this, o);
    }

    private class populateNodeRunnable
    implements Runnable {
        boolean populateFolders;
        boolean populateMembers;

        private populateNodeRunnable(boolean populateF, boolean populateM) {
            this.populateFolders = populateF;
            this.populateMembers = populateM;
        }

        @Override
        public void run() {
            NonFolderContainerNode.this.populateNodeWithChildren(this.populateFolders, this.populateMembers);
        }
    }
}

