/*
 * Decompiled with CFR 0.152.
 */
package com.sas.console.folderview.visuals;

import com.sas.console.folderview.visuals.FolderViewUtil;
import com.sas.console.folderview.visuals.RootNode;
import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.LogicalObjectInterface;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.SimpleLogicalObjectInterface;
import com.sas.metadata.logical.visuals.UtilGui;
import com.sas.metadata.promotion.ObjectConverter;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdFactoryEvent;
import com.sas.metadata.remote.MdFactoryListener;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Root;
import com.sas.services.ServiceException;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.publicobject.PublicObjectInterface;
import com.sas.services.information.sasfolders.VirtualFolderNode;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class LogicalTypesAndServicesAdapter {
    private static LogicalTypesAndServicesAdapter _instance;
    Map m_loiMap = new HashMap(0);
    private Factory _factory;
    private ObjectConverter m_converter;
    private MdFactoryListener m_listener;

    public static LogicalTypesAndServicesAdapter getInstance() {
        return _instance;
    }

    public void clearObjectCache() {
        this.m_loiMap.clear();
        try {
            MdFactory factory;
            if (this.m_listener != null && (factory = Workspace.getMdFactory()) != null) {
                factory.removeMdFactoryListener(this.m_listener);
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    public void removeItemFromCache(String logicalObjectId) {
        this.m_loiMap.remove(logicalObjectId);
    }

    public Factory getFactory() {
        return this._factory;
    }

    LogicalTypesAndServicesAdapter() {
        if (_instance != null) {
            throw new IllegalStateException("Logic error: LogicalTypesAndServicesAdapter constructor should only be called once.");
        }
        this._factory = Factory.getInstance();
        _instance = this;
        this.installListener();
        this.m_converter = ObjectConverter.getInstance();
    }

    public Root convertToJOMAObject(MdObjectStore store, PublicObjectInterface obj) throws MdException, RemoteException {
        String sType = null;
        String sName = null;
        String sFQID = null;
        try {
            sType = obj.getTypeDescriptor().getMetadataType();
            sFQID = obj.getIdentifier();
            sName = obj.getName();
        }
        catch (ServiceException e) {
            UtilGui.displayInternalError((String)e.getMessage());
        }
        int iOptionsToPassIn = 264;
        Root mdo = (Root)Workspace.getMdFactory().createComplexMetadataObject(store, sName, sType, sFQID);
        if (!mdo.isNewObject()) {
            Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)mdo, null, null, null, iOptionsToPassIn);
        }
        return mdo;
    }

    Root convertToJOMAObject(LogicalObjectInterface loi, MdStore store) throws MdException, RemoteException {
        return (Root)Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths(store, loi.getTypeInterface().getMetadataType(), loi.getID(), null, null, null, 264);
    }

    public PublicObjectInterface[] convertToPublicObjects(SimpleLogicalObjectInterface[] logicalObjects, ServerInterface server) throws ServiceException, RemoteException {
        return this.m_converter.convertToPublicObjects(logicalObjects, server);
    }

    public PublicObjectInterface convertToPublicObject(Root metadataObject) {
        ServerInterface server = null;
        String objectIdentifier = null;
        MetadataInterface publicObject = null;
        try {
            server = FolderViewUtil.getServerInterface(FolderViewUtil.getSessionContextInterface());
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        try {
            objectIdentifier = metadataObject.getFQID() + "/" + metadataObject.getCMetadataType();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        try {
            publicObject = server.fetch(objectIdentifier, true);
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return publicObject;
    }

    public PublicObjectInterface convertToPublicObject(SimpleLogicalObjectInterface logicalObject, ServerInterface server) throws ServiceException, RemoteException {
        return this.m_converter.convertToPublicObject(logicalObject, server);
    }

    public PublicObjectInterface convertToPublicObject(SimpleLogicalObjectInterface logicalObject) throws ServiceException, RemoteException {
        return this.convertToPublicObject(logicalObject, FolderViewUtil.getServerInterface(FolderViewUtil.getSessionContextInterface()));
    }

    public LogicalObjectInterface convertToLogicalObject(PublicObjectInterface publicObject) throws ServiceException, RemoteException {
        if (publicObject instanceof VirtualFolderNode) {
            return null;
        }
        Root jomaObject = null;
        LogicalObjectInterface loi = null;
        try {
            jomaObject = this.convertToJOMAObject(RootNode.getPrimaryObjectStore(), publicObject);
        }
        catch (MdException e) {
            e.printStackTrace();
        }
        try {
            loi = Factory.getInstance().getObject(jomaObject);
        }
        catch (LogicalTypeException e) {
            e.printStackTrace();
        }
        if (loi != null) {
            this.m_loiMap.put(loi.getID(), loi);
        }
        return loi;
    }

    public LogicalObjectInterface[] convertToLogicalObjects(Root[] aObjects) throws MdException, RemoteException, LogicalTypeException {
        LogicalObjectInterface[] aLOBs = new LogicalObjectInterface[aObjects.length];
        for (int iObject = 0; iObject < aObjects.length; ++iObject) {
            LogicalObjectInterface lob;
            aLOBs[iObject] = lob = Factory.getInstance().getObject(aObjects[iObject]);
            this.m_loiMap.put(aObjects[iObject].getFQID(), lob);
        }
        return aLOBs;
    }

    public LogicalObjectInterface convertToLogicalObject(Root metaObject) throws LogicalTypeException, RemoteException, ServiceException {
        LogicalObjectInterface loiObject = Factory.getInstance().getObject(metaObject);
        this.m_loiMap.put(metaObject.getFQID(), loiObject);
        return loiObject;
    }

    private void installListener() {
        try {
            if (this.m_listener == null) {
                this.m_listener = new LogicalObjectFactoryListener();
            }
            Workspace.getMdFactory().addMdFactoryListener(this.m_listener);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    private void updateMapForModifiedOrDeletedObjects(Map objectMap) {
        Set loiKeys = objectMap.keySet();
        String[] aKeys = loiKeys.toArray(new String[loiKeys.size()]);
        for (int iKey = 0; iKey < aKeys.length; ++iKey) {
            Object obj = objectMap.get(aKeys[iKey]);
            if (obj == null) continue;
            this.m_loiMap.remove(obj);
        }
    }

    private class LogicalObjectFactoryListener
    implements MdFactoryListener {
        private LogicalObjectFactoryListener() {
        }

        public void MdObjectsCreated(MdFactoryEvent ev) {
            Map eventMap = ev.getObjectMap();
            Set eventKeys = eventMap.keySet();
            String[] keysArray = eventKeys.toArray(new String[eventKeys.size()]);
            for (int iKey = 0; iKey < keysArray.length; ++iKey) {
                String objType = (String)eventMap.get(keysArray[iKey]);
                if (objType != null) continue;
                Root JomaObjectFromMap = null;
                try {
                    JomaObjectFromMap = (Root)Workspace.getMdFactory().getOMIUtil().getMetadataObjects(keysArray[iKey], objType).get(0);
                    LogicalObjectInterface loi = Factory.getInstance().getObject(JomaObjectFromMap);
                    LogicalTypesAndServicesAdapter.this.m_loiMap.put(keysArray[iKey], loi);
                    continue;
                }
                catch (RemoteException re) {
                    MessageUtil.displayMessage((String)re.getLocalizedMessage(), (int)0);
                    continue;
                }
                catch (MdException me) {
                    MessageUtil.displayMessage((String)me.getLocalizedMessage(), (int)0);
                    continue;
                }
                catch (LogicalTypeException le) {
                    MessageUtil.displayMessage((String)le.getLocalizedMessage(), (int)0);
                }
            }
        }

        public void MdObjectsModified(MdFactoryEvent ev) {
            LogicalTypesAndServicesAdapter.this.updateMapForModifiedOrDeletedObjects(ev.getObjectMap());
        }

        public void MdObjectsDeleted(MdFactoryEvent ev) {
            LogicalTypesAndServicesAdapter.this.updateMapForModifiedOrDeletedObjects(ev.getObjectMap());
        }
    }
}

