/*
 * Decompiled with CFR 0.152.
 */
package com.sas.console.folderview.visuals;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class Log
extends Formatter {
    private static final char DIVIDER = '|';
    private static final String SPACES = "                                                                      ";
    private static final long startTime = System.currentTimeMillis();

    public static void initLogging() {
        Logger projectLogger;
        Logger globalLogger = Logger.getLogger("");
        Handler[] handlers = globalLogger.getHandlers();
        for (int i = 0; i < handlers.length; ++i) {
            handlers[i].setFormatter(new Log());
        }
        String thisPackage = Log.class.getName();
        thisPackage = thisPackage.substring(0, thisPackage.lastIndexOf(46));
        Logger logger = projectLogger = Logger.getLogger(thisPackage);
        Level level = null;
        while ((level = logger.getLevel()) == null) {
            logger = logger.getParent();
        }
        projectLogger.log(level, "Logging initialized, level = " + level.toString());
    }

    @Override
    public String format(LogRecord rec) {
        int lastDot;
        String time = Long.toString(rec.getMillis() - startTime);
        String level = rec.getLevel().toString();
        String className = rec.getSourceClassName();
        String pkgName = null;
        if (className != null && (lastDot = className.lastIndexOf(46)) > -1 && lastDot < className.length() - 1) {
            pkgName = className.substring(0, lastDot);
            className = className.substring(lastDot + 1);
        }
        String methodName = rec.getSourceMethodName();
        String msg = rec.getMessage();
        Object[] params = rec.getParameters();
        Throwable th = rec.getThrown();
        StringBuffer sbuf = new StringBuffer();
        this.rightJustify(sbuf, time, 8);
        sbuf.append('|');
        this.leftJustify(sbuf, level, 7);
        sbuf.append('|');
        this.rightJustify(sbuf, pkgName, 20);
        sbuf.append('|');
        this.leftJustify(sbuf, className, 23);
        sbuf.append('|');
        sbuf.append(methodName);
        sbuf.append(" : ");
        sbuf.append(msg);
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                sbuf.append(' ');
                sbuf.append(params[i].toString());
            }
        }
        if (th != null) {
            StringWriter sw = new StringWriter();
            th.printStackTrace(new PrintWriter(sw));
            sbuf.append('\n');
            sbuf.append(sw.toString());
        } else {
            sbuf.append('\n');
        }
        return sbuf.toString();
    }

    private void rightJustify(StringBuffer buf, String item, int desiredLength) {
        int length;
        if (item == null) {
            item = "null";
        }
        if ((length = item.length()) > desiredLength) {
            item = item.substring(length - desiredLength);
        } else if (length < desiredLength) {
            item = SPACES.substring(0, desiredLength - length) + item;
        }
        buf.append(item);
    }

    private void leftJustify(StringBuffer buf, String item, int desiredLength) {
        int length;
        if (item == null) {
            item = "null";
        }
        if ((length = item.length()) > desiredLength) {
            item = item.substring(length - desiredLength);
        } else if (length < desiredLength) {
            item = item + SPACES.substring(0, desiredLength - length);
        }
        buf.append(item);
    }
}

