/*
 * Decompiled with CFR 0.152.
 */
package com.sas.console.folderview.visuals;

import com.sas.console.folderview.visuals.BIAbstractNode;
import com.sas.console.folderview.visuals.ConsoleFolderTree;
import com.sas.console.folderview.visuals.ConsoleFolderView;
import com.sas.console.folderview.visuals.FolderViewUtil;
import com.sas.console.folderview.visuals.LogicalTypesAndServicesAdapter;
import com.sas.console.folderview.visuals.RootNode;
import com.sas.console.folderview.visuals.TableItem;
import com.sas.console.plugins.ElementInterface;
import com.sas.console.utils.FolderUtil;
import com.sas.console.visuals.ConsoleViewManager;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactoryEvent;
import com.sas.metadata.remote.MdFactoryListener;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Tree;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.metadata.VirtualFolder;
import com.sas.services.information.publicobject.PublicObjectContainerInterface;
import com.sas.services.information.publicobject.PublicObjectInterface;
import com.sas.services.information.sasfolders.ContainerNodeInterface;
import com.sas.services.information.sasfolders.FolderModelInterface;
import com.sas.services.information.sasfolders.FolderNodeInterface;
import com.sas.services.information.sasfolders.PublicObjectNodeInterface;
import com.sas.services.information.sasfolders.SASFoldersModelInterface;
import com.sas.services.information.sasfolders.SASFoldersUtil;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class FolderviewMetadataFactoryListener
implements MdFactoryListener {
    public static final int CREATED_EVENT = 0;
    public static final int MODIFIED_EVENT = 1;
    public static final int DELETED_EVENT = 2;
    protected static ArrayList m_createdItemsList = new ArrayList(0);
    protected static ArrayList<PublicObjectInterface> m_virtualFolderItemCreatedItemsList = new ArrayList(0);
    protected ConsoleFolderView m_folderView = (ConsoleFolderView)ConsoleViewManager.getView(1);

    public void MdObjectsCreated(MdFactoryEvent event) throws RemoteException {
        HashMap treeToMembersMap = new HashMap();
        HashSet<String> virtualFolderRefreshCache = new HashSet<String>(5);
        Map eventMap = event.getObjectMap();
        ConsoleFolderView folderView = (ConsoleFolderView)ConsoleViewManager.getView(1);
        Iterator iter = eventMap.keySet().iterator();
        while (iter.hasNext()) {
            Root parent = null;
            String newObjectId = (String)iter.next();
            m_createdItemsList.add(newObjectId);
            String objectType = (String)eventMap.get(newObjectId);
            try {
                MdObjectStore primObjStore = RootNode.getPrimaryObjectStore();
                if (primObjStore == null) {
                    return;
                }
                Root newObject = (Root)primObjStore.getObject(newObjectId);
                if (newObject == null) {
                    newObject = FolderViewUtil.fetchObjectFromServer(newObjectId, objectType);
                }
                if (parent == null && newObject != null) {
                    parent = FolderUtil.getParentContainer(newObject);
                }
                if (parent == null) {
                    PublicObjectInterface po = LogicalTypesAndServicesAdapter.getInstance().convertToPublicObject(newObject);
                    try {
                        PublicObjectContainerInterface container = po.getContainer();
                        if (container != null && container instanceof VirtualFolder) {
                            this.handleVirtualFolder(po, container, virtualFolderRefreshCache);
                            continue;
                        }
                        if (container != null) {
                            parent = FolderViewUtil.fetchObjectFromServer(container.getIdentifier(), container.getTypeDescriptor().getMetadataType());
                        }
                    }
                    catch (ServiceException e) {
                        Workspace.getWorkspace();
                        Workspace.getDefaultLogger().warn((Object)e.getLocalizedMessage());
                    }
                }
                if (parent == null || parent instanceof Tree && ((Tree)parent).getPublicType() == "") continue;
                this.updateTreeToMembersMap(treeToMembersMap, newObject, parent);
            }
            catch (MdException mde) {
                mde.printStackTrace();
            }
        }
        if (!treeToMembersMap.isEmpty()) {
            folderView.processMdFactoryEvents(treeToMembersMap, 0);
        }
    }

    private void handleVirtualFolder(PublicObjectInterface publicObject, PublicObjectContainerInterface container, Set<String> virtualFolderRefreshCache) {
        block7: {
            ConsoleFolderTree folderTree = (ConsoleFolderTree)ConsoleViewManager.getView(1).getComponent();
            SASFoldersModelInterface folderModel = this.m_folderView.getSASFoldersModel();
            try {
                PublicObjectNodeInterface member;
                PublicObjectNodeInterface virtualFolderNode;
                OMIRepositoryInterface ri = (OMIRepositoryInterface)FolderViewUtil.getServerInterface().getFoundationRepository();
                FolderNodeInterface pn = SASFoldersUtil.getSystemFolderNode((FolderModelInterface)folderModel, (OMIRepositoryInterface)ri);
                BIAbstractNode systemFolderNode = folderTree.findNodeByPath(pn.getDisplayPath());
                BIAbstractNode containerParentNode = folderTree.findNodeById(systemFolderNode, container.getIdentifier());
                if (container != null && !virtualFolderRefreshCache.contains(container.getIdentifier()) && (virtualFolderNode = folderModel.getObject((PublicObjectInterface)container)) != null) {
                    virtualFolderNode.refresh();
                    virtualFolderRefreshCache.add(container.getIdentifier());
                }
                if ((member = folderModel.getObject(publicObject)) == null || containerParentNode == null) break block7;
                if (member instanceof ContainerNodeInterface) {
                    try {
                        containerParentNode.addContainer(publicObject);
                        break block7;
                    }
                    catch (LogicalTypeException e) {
                        return;
                    }
                }
                containerParentNode.addMemberToVisual(member);
            }
            catch (ServiceException e) {
                Workspace.getDefaultLogger().error((Object)("handleVirtualFolder: Could not obtain id of parent container. Reason: " + e.getLocalizedMessage()));
            }
            catch (RemoteException e) {
                Workspace.getDefaultLogger().error((Object)("handleVirtualFolder: Could not obtain id of parent container. Reason: " + e.getLocalizedMessage()));
            }
        }
    }

    public void MdObjectsDeleted(MdFactoryEvent event) throws RemoteException {
        Map membersMap = event.getObjectMap();
        HashMap treeToMembersMap = new HashMap();
        ConsoleFolderTree folderTree = (ConsoleFolderTree)ConsoleViewManager.getView(1).getComponent();
        for (String deletedId : membersMap.keySet()) {
            TableItem tableElementUnderUserHomeFolderPath;
            BIAbstractNode parentNode;
            ElementInterface tableElement = folderTree.findMemberById((BIAbstractNode)folderTree.getModel().getRoot(), deletedId);
            if (tableElement == null || (parentNode = (BIAbstractNode)tableElement.getNode()) == null) continue;
            this.updateTreeToMembersMapForDelete(treeToMembersMap, parentNode, tableElement);
            if (folderTree.nodeIsChildOfUserHomeFolder(parentNode)) {
                TableItem tableElementUnderMyFolder = (TableItem)folderTree.findMemberById(folderTree.getHomeFolderNode(), deletedId);
                if (tableElementUnderMyFolder == null) continue;
                this.updateTreeToMembersMapForDelete(treeToMembersMap, (BIAbstractNode)tableElementUnderMyFolder.getNode(), tableElementUnderMyFolder);
                continue;
            }
            if (!folderTree.nodeIsChildOfMyFolder(parentNode) || (tableElementUnderUserHomeFolderPath = (TableItem)folderTree.findMemberById(folderTree.getRootFolderNode(FolderViewUtil.getRootOfPath(this.m_folderView.getUserHomeFolderPath())), deletedId)) == null) continue;
            this.updateTreeToMembersMapForDelete(treeToMembersMap, (BIAbstractNode)tableElementUnderUserHomeFolderPath.getNode(), tableElementUnderUserHomeFolderPath);
        }
        if (!treeToMembersMap.isEmpty()) {
            this.m_folderView.processMdFactoryEvents(treeToMembersMap, 2);
        }
    }

    public void MdObjectsModified(MdFactoryEvent event) throws RemoteException {
        HashMap treeToMembersMap = new HashMap();
        Map eventMap = event.getObjectMap();
        ConsoleFolderView folderView = (ConsoleFolderView)ConsoleViewManager.getView(1);
        for (String newObjectId : eventMap.keySet()) {
            if (m_createdItemsList.contains(newObjectId)) {
                m_createdItemsList.remove(newObjectId);
                continue;
            }
            String objectType = (String)eventMap.get(newObjectId);
            try {
                MdObjectStore primObjStore = RootNode.getPrimaryObjectStore();
                if (primObjStore == null) {
                    return;
                }
                Root newObject = FolderViewUtil.fetchObjectFromServer(newObjectId, objectType);
                Root parentFolder = FolderUtil.getParentContainer(newObject);
                if (parentFolder == null) {
                    PublicObjectInterface po = LogicalTypesAndServicesAdapter.getInstance().convertToPublicObject(newObject);
                    try {
                        PublicObjectContainerInterface container = po.getContainer();
                        if (container != null) {
                            parentFolder = FolderViewUtil.fetchObjectFromServer(container.getIdentifier(), container.getTypeDescriptor().getMetadataType());
                        }
                    }
                    catch (ServiceException e) {
                        Workspace.getDefaultLogger().warn((Object)e.getLocalizedMessage());
                    }
                }
                if (parentFolder == null || parentFolder instanceof Tree && ((Tree)parentFolder).getPublicType() == "") continue;
                this.updateTreeToMembersMap(treeToMembersMap, newObject, parentFolder);
            }
            catch (MdException mdException) {}
        }
        if (!treeToMembersMap.isEmpty()) {
            folderView.processMdFactoryEvents(treeToMembersMap, 1);
        }
        m_createdItemsList.clear();
    }

    private void updateTreeToMembersMap(Map treeToMembersMap, Root object, Root parentFolder) {
        if (!treeToMembersMap.containsKey(parentFolder)) {
            ArrayList<Root> membersList = new ArrayList<Root>(0);
            membersList.add(object);
            treeToMembersMap.put(parentFolder, membersList);
        } else {
            ArrayList membersList = (ArrayList)treeToMembersMap.get(parentFolder);
            membersList.add(object);
            treeToMembersMap.put(parentFolder, membersList);
        }
    }

    private void updateTreeToMembersMapForDelete(Map treeToMembersMap, BIAbstractNode parentNode, ElementInterface element) {
        if (!treeToMembersMap.containsKey(parentNode)) {
            ArrayList<ElementInterface> membersList = new ArrayList<ElementInterface>(0);
            membersList.add(element);
            treeToMembersMap.put(parentNode, membersList);
        } else {
            ArrayList membersList = (ArrayList)treeToMembersMap.get(parentNode);
            membersList.add(element);
            treeToMembersMap.put(parentNode, membersList);
        }
    }
}

