/*
 * Decompiled with CFR 0.152.
 */
package com.sas.console.folderview.visuals;

import com.sas.console.folderview.visuals.BIAbstractNode;
import com.sas.console.folderview.visuals.FolderItem;
import com.sas.console.folderview.visuals.FolderNode;
import com.sas.console.folderview.visuals.HomeFolderItem;
import com.sas.console.folderview.visuals.HomeFolderNode;
import com.sas.console.folderview.visuals.NonFolderContainerItem;
import com.sas.console.folderview.visuals.NonFolderContainerNode;
import com.sas.console.folderview.visuals.RootNode;
import com.sas.console.folderview.visuals.TableItem;
import com.sas.console.plugins.AbstractNode;
import com.sas.console.plugins.ElementInterface;
import com.sas.console.plugins.IntObjPair;
import com.sas.console.utils.ServerUtil;
import com.sas.console.visuals.MainConsole;
import com.sas.metadata.logical.UtilMetadata;
import com.sas.metadata.promotion.ImportSummaryInterface;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.FavoritesContainer;
import com.sas.metadata.remote.Identity;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdFactoryEvent;
import com.sas.metadata.remote.MdOMIUtil;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Tree;
import com.sas.nls.collator.SASCollatorFactory;
import com.sas.nls.collator.SASStringComparator;
import com.sas.services.ServiceException;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.UserFolderType;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.IdentityInterface;
import com.sas.services.information.metadata.PersonInterface;
import com.sas.services.information.publicobject.PublicObjectInterface;
import com.sas.services.session.SessionContextInterface;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FolderViewUtil {
    public static String ROOT_PATH = "/";
    private static final String FOLDER_TEMPLATE = "<TEMPLATES><Tree><ParentTree/><SoftwareComponents/></Tree></TEMPLATES>";
    private static WAdminResource _mainConsoleBundle = new WAdminResource(MainConsole.class);
    static final SASStringComparator shared_comparator = SASCollatorFactory.createCollator();

    static WAdminResource getMainConsoleResourceBundle() {
        return _mainConsoleBundle;
    }

    static CMetadata getDefaultRepository() {
        return Workspace.getWorkspace().getDefaultRepository();
    }

    static String getDefaultRepositoryFQID() {
        CMetadata defaultRepository = FolderViewUtil.getDefaultRepository();
        if (defaultRepository == null) {
            return null;
        }
        try {
            String reposFQID = defaultRepository.getFQID();
            return reposFQID;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return null;
        }
    }

    static String getUserHomeFolderPathFromServer() throws RemoteException, MdException {
        String path = "";
        String select = "<XMLSelect search =\"@PropertyName='Path to Users Root Folder'\"/>";
        int flags = 392;
        List newObjectList = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)RootNode.getPrimaryObjectStore(), UtilMetadata.getFoundationRepositoryID(), "Property", flags, select);
        if (newObjectList.size() > 0) {
            path = ((Property)newObjectList.get(0)).getDefaultValue();
        }
        return path;
    }

    static Tree getHomeFolderFromServer(boolean createIfNotFound) throws MdException, RemoteException {
        Object treeObject;
        SessionContextInterface session = FolderViewUtil.getSessionContextInterface();
        ServerInterface serverInterface = FolderViewUtil.getServerInterface(session);
        FolderInterface myFolder = null;
        try {
            myFolder = serverInterface.getHomeFolder(null, UserFolderType.MYFOLDER, null, createIfNotFound);
        }
        catch (ServiceException exc) {
            try {
                IdentityInterface id = session.getUserContext().getPerson();
                if (id == null) {
                    Workspace.getDefaultLogger().error((Object)"loadChildren - Public user has no home folder");
                } else if (id instanceof PersonInterface) {
                    Workspace.getDefaultLogger().error((Object)"loadChildren - Logging in as individual user, but no home folder found (not configured?)", (Throwable)exc);
                } else {
                    Workspace.getDefaultLogger().error((Object)"loadChildren - no My Folder locations for group logins.");
                }
            }
            catch (Exception anything) {
                Workspace.getDefaultLogger().error((Object)"loadChildren - no My Folder location is defined for group logins or Public.");
                Workspace.getDefaultLogger().debug((Object)"loadChildren - no My Folder location is defined for group logins or Public.", (Throwable)anything);
            }
        }
        Tree tree = null;
        if (myFolder != null && (treeObject = myFolder.getRepositoryEntity()) instanceof CMetadata) {
            tree = (Tree)treeObject;
        }
        return tree;
    }

    public static SessionContextInterface getSessionContextInterface() {
        return ServerUtil.getSessionContextInterface();
    }

    public static ServerInterface getServerInterface() throws RemoteException {
        return ServerUtil.getServerInterface();
    }

    public static ServerInterface getServerInterface(SessionContextInterface session) throws RemoteException {
        return ServerUtil.getServerInterface(session);
    }

    public static String getLocalizedHomeFolderName() {
        MdFactory factory = Workspace.getMdFactory();
        MdObjectStore store = RootNode.getPrimaryObjectStore();
        String localizedName = "My Folder";
        String currentUser = "";
        try {
            MdOMIUtil mdUtility = factory.getOMIUtil();
            Identity currentUserIdentity = mdUtility.getIdentity(store);
            if (currentUserIdentity != null) {
                currentUser = currentUserIdentity.getName();
            }
            localizedName = mdUtility.getUserHomeFolderName(currentUser, "My Folder");
        }
        catch (MdException mde) {
            Workspace.getDefaultLogger().info((Object)"Could not get localized name for \"My Folder.\"");
        }
        catch (RemoteException re) {
            Workspace.getDefaultLogger().info((Object)"Could not get localized name for \"My Folder.\"");
        }
        return localizedName;
    }

    public static String getRootOfPath(String treePath) {
        if (treePath == null) {
            return null;
        }
        String[] pathComponents = treePath.split("/");
        if (pathComponents.length != 0 && pathComponents[0].equalsIgnoreCase(treePath)) {
            return null;
        }
        return pathComponents.length == 0 ? "/" : pathComponents[1];
    }

    public static void sortChildList(List list) {
        boolean sorted = false;
        int numberOfCompares = list.size() - 1;
        while (!sorted) {
            sorted = true;
            for (int i = 0; i < numberOfCompares; ++i) {
                IntObjPair ioPair1 = (IntObjPair)list.get(i);
                IntObjPair ioPair2 = (IntObjPair)list.get(i + 1);
                if (ioPair1.getIndex() <= ioPair2.getIndex()) continue;
                list.set(i, ioPair2);
                list.set(i + 1, ioPair1);
                sorted = false;
            }
            --numberOfCompares;
        }
    }

    public static void fireObjectsCreatedEvent(Map mapNewObjects) throws RemoteException {
        MdFactory factory = Workspace.getMdFactory();
        factory.fireMdObjectsCreated(new MdFactoryEvent(factory, mapNewObjects));
    }

    public static void fireObjectsModifiedEvent(Map mapModifiedObjects) throws RemoteException {
        MdFactory factory = Workspace.getMdFactory();
        factory.fireMdObjectsModified(new MdFactoryEvent(factory, mapModifiedObjects));
    }

    public static void generateMdFactoryEvents(ImportSummaryInterface importSummary) {
        HashMap<String, String> createdItemsMap = new HashMap<String, String>();
        HashMap<String, String> modifiedItemsMap = new HashMap<String, String>();
        try {
            List summaryItems = importSummary.getImportedObjects();
            for (int i = 0; i < summaryItems.size(); ++i) {
                PublicObjectInterface importedItem = (PublicObjectInterface)summaryItems.get(i);
                try {
                    if (importSummary.wasObjectCreated(importedItem)) {
                        createdItemsMap.put(importedItem.getIdentifier(), importedItem.getTypeDescriptor().getMetadataType());
                        continue;
                    }
                    modifiedItemsMap.put(importedItem.getIdentifier(), importedItem.getTypeDescriptor().getMetadataType());
                    continue;
                }
                catch (ServiceException serviceException) {
                    // empty catch block
                }
            }
            if (!createdItemsMap.isEmpty()) {
                FolderViewUtil.fireObjectsCreatedEvent(createdItemsMap);
                FolderViewUtil.fireObjectsModifiedEvent(createdItemsMap);
            }
            if (!modifiedItemsMap.isEmpty()) {
                FolderViewUtil.fireObjectsModifiedEvent(modifiedItemsMap);
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
    }

    public static Root fetchObjectFromServer(String fqid, String type) throws MdException, RemoteException {
        List newObjectList = null;
        MdObjectStore pluginStore = RootNode.getPrimaryObjectStore();
        int flags = 396;
        String template = type.equalsIgnoreCase("Tree") ? FOLDER_TEMPLATE : "<TEMPLATES><" + type + "><Trees/></" + type + "></TEMPLATES>";
        String select = "<XMLSelect search =\" @Id = '" + fqid + "'\"/>";
        newObjectList = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)pluginStore, UtilMetadata.makeRepositoryFQIDFromRoot((String)fqid), type, flags, template + select);
        if (newObjectList.size() > 0) {
            return (Root)newObjectList.get(0);
        }
        System.out.println("Null object retrieved - fetchObjectFromServer:" + fqid);
        return null;
    }

    public static ElementInterface checkNodeForElement(BIAbstractNode parentNode, String fqid) {
        for (int i = 0; i < parentNode._itemList.size(); ++i) {
            TableItem element = (TableItem)parentNode._itemList.get(i);
            try {
                if (!element.getPublicObjectInterface().getIdentifier().equals(fqid)) continue;
                return element;
            }
            catch (RemoteException remoteException) {
                continue;
            }
            catch (ServiceException se) {
                se.printStackTrace();
            }
        }
        return null;
    }

    public static Tree findTreeRootOfFavorite(FavoritesContainer container) {
        FavoritesContainer itemToExamine = container;
        try {
            AssociationList treeList = itemToExamine.getTrees();
            if (treeList.size() > 0) {
                return (Tree)treeList.get(0);
            }
            FavoritesContainer parentContainer = itemToExamine.getParentContainer();
            if (parentContainer != null) {
                return FolderViewUtil.findTreeRootOfFavorite(parentContainer);
            }
        }
        catch (RemoteException e) {
            return null;
        }
        catch (MdException e) {
            return null;
        }
        return null;
    }

    public static int getComparisonPeckingOrder(Object obj) {
        int ret = -1;
        if (obj instanceof RootNode) {
            ret = 1;
        } else if (obj instanceof HomeFolderNode) {
            ret = 2;
        } else if (obj instanceof FolderNode) {
            ret = 3;
        } else if (obj instanceof NonFolderContainerNode) {
            ret = 6;
        } else if (obj instanceof HomeFolderItem) {
            ret = 4;
        } else if (obj instanceof FolderItem) {
            ret = obj instanceof NonFolderContainerItem ? 6 : 5;
        } else if (obj instanceof TableItem) {
            ret = 6;
        } else {
            ClassCastException cce = new ClassCastException("FolderViewUtil can't evaluate a " + obj.getClass());
            throw cce;
        }
        return ret;
    }

    public static String getComparisonString(Object obj) {
        if (obj instanceof AbstractNode) {
            AbstractNode abn = (AbstractNode)obj;
            return abn.getName();
        }
        if (obj instanceof TableItem) {
            TableItem tbi = (TableItem)obj;
            return tbi.getName();
        }
        ClassCastException cce = new ClassCastException("FolderViewUtil can't evaluate a " + obj.getClass());
        throw cce;
    }

    public static int compare(Object receiver, Object argument) {
        int argumentPriority;
        if (argument == null) {
            ClassCastException cce = new ClassCastException("can't compare null and " + receiver.getClass());
            throw cce;
        }
        if (receiver == null) {
            ClassCastException cce = new ClassCastException("can't compare null and " + argument.getClass());
            throw cce;
        }
        if (receiver == argument) {
            return 0;
        }
        int receiverPriority = FolderViewUtil.getComparisonPeckingOrder(receiver);
        if (receiverPriority == (argumentPriority = FolderViewUtil.getComparisonPeckingOrder(argument))) {
            String mykey = FolderViewUtil.getComparisonString(receiver);
            String hisKey = FolderViewUtil.getComparisonString(argument);
            return shared_comparator.compare(mykey, hisKey);
        }
        if (receiverPriority > argumentPriority) {
            return 1;
        }
        return -1;
    }
}

