/*
 * Decompiled with CFR 0.152.
 */
package com.sas.console.folderview.visuals;

import com.sas.console.folderview.visuals.ActionCopy;
import com.sas.console.folderview.visuals.ActionDelete;
import com.sas.console.folderview.visuals.ActionPaste;
import com.sas.console.folderview.visuals.ActionPasteSpecial;
import com.sas.console.folderview.visuals.ActionRename;
import com.sas.console.folderview.visuals.BIAbstractNode;
import com.sas.console.folderview.visuals.BIActionFactory;
import com.sas.console.folderview.visuals.BIActionInterface;
import com.sas.console.folderview.visuals.ElementItem;
import com.sas.console.folderview.visuals.FolderItem;
import com.sas.console.folderview.visuals.FolderViewUtil;
import com.sas.console.folderview.visuals.HomeFolderItem;
import com.sas.console.folderview.visuals.Images;
import com.sas.console.folderview.visuals.LogicalTypesAndServicesAdapter;
import com.sas.console.folderview.visuals.NonFolderContainerNode;
import com.sas.console.folderview.visuals.RB;
import com.sas.console.folderview.visuals.RootNode;
import com.sas.console.folderview.visuals.SearchFolderNode;
import com.sas.console.folderview.visuals.TableItem;
import com.sas.console.folderview.visuals.VirtualFolderItem;
import com.sas.console.folderview.visuals.VirtualFolderNode;
import com.sas.console.visuals.MainConsole;
import com.sas.console.visuals.SubmenuAction;
import com.sas.metadata.logical.ActionType;
import com.sas.metadata.logical.ContainerContextInterface;
import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.FolderInterface;
import com.sas.metadata.logical.LogicalObjectInterface;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.ObjectFactoryInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.logical.UtilMetadata;
import com.sas.metadata.logical.visuals.ActionNewFolder;
import com.sas.metadata.logical.visuals.ActionNewFolderUnderContentMappedRoot;
import com.sas.metadata.logical.visuals.NewObjectActionInterface;
import com.sas.metadata.logical.visuals.UtilGui;
import com.sas.metadata.promotion.visuals.CopyPasteManager;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Tree;
import com.sas.nls.collator.SASCollatorFactory;
import com.sas.services.ServiceException;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.publicobject.PublicObjectContainerInterface;
import com.sas.services.information.publicobject.PublicObjectInterface;
import com.sas.services.information.publicobject.TypeDescriptorInterface;
import com.sas.services.information.sasfolders.ContainerNodeInterface;
import com.sas.services.information.sasfolders.FolderNodeInterface;
import com.sas.services.information.sasfolders.MemberNodeInterface;
import com.sas.services.information.sasfolders.PublicObjectNodeInterface;
import com.sas.services.information.sasfolders.UsersFolderNode;
import com.sas.services.information.sasfolders.VirtualFolderNodeInterface;
import com.sas.swing.visuals.util.Util;
import com.sas.workspace.Workspace;
import java.awt.Cursor;
import java.awt.Frame;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.tree.TreeNode;

public class FolderNode
extends BIAbstractNode
implements Comparable {
    protected FolderItem _folderItem;
    protected Tree _tree;
    protected Tree _treeCopy;
    private static final NewObjectActionComparator NEW_OBJECT_ACTION_COMPARATOR = new NewObjectActionComparator();
    private static final List _subTreesList = new ArrayList(1);
    private static final List _membersList = new ArrayList(1);

    FolderNode(BIAbstractNode parent, ContainerNodeInterface folderInterface) throws RemoteException {
        super(parent, folderInterface.getName());
        this.m_containerNodeInterface = folderInterface;
        this.m_isFavorite = this.isFavorite();
        if (folderInterface instanceof UsersFolderNode) {
            this._folderItem = new HomeFolderItem(this, parent, (ContainerNodeInterface)((UsersFolderNode)folderInterface));
        }
        if (folderInterface instanceof VirtualFolderNodeInterface) {
            this._folderItem = new VirtualFolderItem(this, parent, (VirtualFolderNodeInterface)this.m_containerNodeInterface);
        } else if (folderInterface instanceof FolderNodeInterface) {
            this._folderItem = new FolderItem(this, parent, this.m_containerNodeInterface);
        }
        this._initialize();
    }

    private void _initialize() {
    }

    public Tree getTree() {
        if (this._tree == null) {
            try {
                this._tree = (Tree)LogicalTypesAndServicesAdapter.getInstance().convertToJOMAObject(RootNode.getPrimaryObjectStore(), (PublicObjectInterface)this.getContainerInterface());
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
            catch (MdException e) {
                e.printStackTrace();
            }
        }
        return this._tree;
    }

    public void refreshObjectFromServer() {
        try {
            this._tree = (Tree)UtilMetadata.locateExistingObject((MdObjectStore)((MdObjectStore)this._tree.getObjectStore()), (String)this._tree.getCMetadataType(), (String)this._tree.getFQID());
            this.m_containerNodeInterface.refresh();
            this.getLogicalObjectInterface().refresh((Root)this._tree);
        }
        catch (Exception e) {
            UtilGui.displayExceptionError((Exception)e);
        }
    }

    @Override
    public Icon getIcon(int size) {
        return this._folderItem.getIcon(size);
    }

    @Override
    protected void addElement(PublicObjectNodeInterface mi) {
        ElementItem ti = null;
        if (mi instanceof MemberNodeInterface) {
            ti = new ElementItem(this, (PublicObjectInterface)((MemberNodeInterface)mi));
        }
        this._itemList.add(ti);
    }

    void removeElement(ElementItem ei) {
        this._itemList.remove(ei);
    }

    @Override
    public Root getMetadataObject() {
        return this._folderItem.getMetadataObject();
    }

    public FolderInterface getFolderInterface() throws LogicalTypeException, ServiceException, RemoteException {
        return (FolderInterface)this.getLogicalObjectInterface();
    }

    @Override
    public List getPropertyTabs() {
        return this._folderItem.doGetPropertyTabs(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void populateNode(boolean populateFolders, boolean populateMembers) {
        Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(3));
        try {
            if (populateFolders && populateMembers) {
                this.m_containerNodeInterface.refresh();
            }
            List childList = this.m_containerNodeInterface.getChildren();
            for (PublicObjectNodeInterface object : childList) {
                if (object instanceof ContainerNodeInterface && populateFolders) {
                    VirtualFolderNodeInterface folder;
                    if (object instanceof VirtualFolderNodeInterface) {
                        folder = (VirtualFolderNodeInterface)object;
                        VirtualFolderNode virtualFolderNode = null;
                        try {
                            virtualFolderNode = new VirtualFolderNode((BIAbstractNode)this, folder);
                        }
                        catch (RemoteException e) {
                            e.printStackTrace();
                        }
                        this._folderNodeList.add(virtualFolderNode);
                        this._itemList.add(virtualFolderNode.getItem());
                    } else if (object instanceof FolderNodeInterface) {
                        folder = (FolderNodeInterface)object;
                        FolderNode folderNode = new FolderNode(this, (ContainerNodeInterface)folder);
                        this._folderNodeList.add(folderNode);
                        this._itemList.add(folderNode.getItem());
                    } else if (object instanceof ContainerNodeInterface) {
                        ContainerNodeInterface container = (ContainerNodeInterface)object;
                        boolean isSearchFolder = container.getTypeDescriptor().getTypeName().equalsIgnoreCase("SearchFolder");
                        NonFolderContainerNode containerNode = null;
                        try {
                            containerNode = isSearchFolder ? new SearchFolderNode((BIAbstractNode)this, container) : new NonFolderContainerNode((BIAbstractNode)this, container);
                        }
                        catch (LogicalTypeException e) {
                            e.printStackTrace();
                        }
                        this._folderNodeList.add(containerNode);
                        this._itemList.add(containerNode.getItem());
                    }
                }
                if (populateMembers && object instanceof MemberNodeInterface) {
                    MemberNodeInterface member = (MemberNodeInterface)object;
                    ElementItem memberItem = new ElementItem(this, (PublicObjectInterface)member);
                    this._itemList.add(memberItem);
                }
                if (populateFolders) {
                    Collections.sort(this._folderNodeList);
                }
                if (!populateMembers) continue;
                Collections.sort(this._itemList);
            }
        }
        catch (Exception e) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
        }
        finally {
            Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    @Override
    public int compareTo(Object o) {
        return FolderViewUtil.compare(this, o);
    }

    @Override
    protected List doConstructActionList(boolean separatorsSupported, boolean isNodeSelected) {
        try {
            MainConsole frame = this.m_console;
            Factory factory = LogicalTypesAndServicesAdapter.getInstance().getFactory();
            ArrayList<Action> actionsList = new ArrayList<Action>();
            int actionListSizeAtPreviousSeparator = 0;
            FolderInterface folderInterface = null;
            try {
                folderInterface = (FolderInterface)this.getLogicalObjectInterface();
            }
            catch (ServiceException se) {
                UtilGui.displayExceptionError((Exception)((Object)se));
            }
            try {
                if (CopyPasteManager.isCopyAllowed((PublicObjectInterface)this.m_containerNodeInterface)) {
                    ArrayList<PublicObjectInterface> copyObject = new ArrayList<PublicObjectInterface>(1);
                    copyObject.add((PublicObjectInterface)this.m_containerNodeInterface);
                    actionsList.add(new ActionCopy(copyObject));
                }
                if (CopyPasteManager.isPasteAllowed()) {
                    boolean allowed = CopyPasteManager.isPasteAllowed((PublicObjectContainerInterface)this.m_containerNodeInterface);
                    ActionPaste actPaste = new ActionPaste(this);
                    actPaste.setEnabled(allowed);
                    actionsList.add(actPaste);
                    if (separatorsSupported) {
                        ActionPasteSpecial actPasteSpecial = new ActionPasteSpecial(this);
                        actionsList.add(actPasteSpecial);
                        actPasteSpecial.setEnabled(allowed);
                    }
                }
            }
            catch (ServiceException allowed) {
                // empty catch block
            }
            if (separatorsSupported && actionsList.size() > actionListSizeAtPreviousSeparator) {
                actionsList.add(null);
                actionListSizeAtPreviousSeparator = actionsList.size();
            }
            SubmenuAction newSubmenuAction = null;
            if (folderInterface != null) {
                newSubmenuAction = new SubmenuAction(RB.getStringResource("FolderNode.New.Title.txt"), Images.getNewStarburstIcon16());
                actionsList.add(newSubmenuAction);
                if (separatorsSupported) {
                    actionsList.add(null);
                    actionListSizeAtPreviousSeparator = actionsList.size();
                }
                try {
                    Object newFolderAction = folderInterface.isContentBacked() ? new ActionNewFolderUnderContentMappedRoot(folderInterface, (Frame)((Object)frame), factory, null, FolderViewUtil.getDefaultRepository().getName()) : new ActionNewFolder(folderInterface, (Frame)((Object)frame), factory, null);
                    newFolderAction.putValue("SmallIcon", Images.getNewFolderIcon16());
                    if (newFolderAction instanceof NewObjectActionInterface) {
                        String rawDisplayText = ((NewObjectActionInterface)newFolderAction).getActionLabel();
                        Util.setLabelAndMnemonicOnAction((Action)newFolderAction, (String)rawDisplayText);
                    }
                    newFolderAction.setEnabled(folderInterface.isCreateChildAllowed());
                    newSubmenuAction.addAction((Action)newFolderAction);
                }
                catch (RemoteException ex) {
                    Workspace.handleRemoteException((RemoteException)ex);
                }
                if (isNodeSelected) {
                    try {
                        Action renameAction;
                        Action deleteAction = this.createDeleteAction(folderInterface);
                        if (deleteAction != null) {
                            actionsList.add(deleteAction);
                        }
                        if ((renameAction = this.createRenameAction(folderInterface)) != null) {
                            actionsList.add(renameAction);
                        }
                    }
                    catch (Exception e) {
                        UtilGui.displayExceptionError((Exception)e);
                    }
                }
            }
            boolean addedActionsSinceLastSeparator = actionsList.size() > actionListSizeAtPreviousSeparator;
            for (BIActionInterface biai : BIActionFactory.getBIActionInterfaces()) {
                List actionsForThisBIAI = biai.getActionsForNode(this, isNodeSelected, this.getElementsOfInterestToBIActionInterface(biai));
                if (actionsForThisBIAI.size() <= 0) continue;
                if (separatorsSupported && addedActionsSinceLastSeparator) {
                    actionsList.add(null);
                }
                for (int i = 0; i < actionsForThisBIAI.size(); ++i) {
                    Action action = (Action)actionsForThisBIAI.get(i);
                    this.checkForContextActions(action);
                    actionsList.add(action);
                }
                addedActionsSinceLastSeparator = true;
            }
            if (folderInterface != null) {
                ServerInterface server = FolderViewUtil.getServerInterface();
                String folderType = folderInterface.getTypeInterface().getPublicType();
                ArrayList<Action> newObjectActions = new ArrayList<Action>(6);
                TypeInterface[] types = LogicalTypesAndServicesAdapter.getInstance().getFactory().getTypesSupported();
                for (int i = 0; i < types.length; ++i) {
                    Action[] actions;
                    TypeInterface ti = types[i];
                    TypeDescriptorInterface typeDesc = server.getTypeDescriptor(ti.getPublicType());
                    if (typeDesc == null || !folderType.equalsIgnoreCase(typeDesc.getContainerType())) continue;
                    ObjectFactoryInterface ofi = ti.getObjectFactory();
                    if (this._tree == null) {
                        try {
                            this._tree = (Tree)LogicalTypesAndServicesAdapter.getInstance().convertToJOMAObject((LogicalObjectInterface)folderInterface, (MdStore)RootNode.getPrimaryObjectStore());
                        }
                        catch (MdException e) {
                            e.printStackTrace();
                        }
                    }
                    if (ofi == null || (actions = ofi.getActions((LogicalObjectInterface)folderInterface, (Root)this._tree, null)) == null || actions.length <= 0) continue;
                    boolean addedTypeSeparator = false;
                    for (int j = 0; j < actions.length; ++j) {
                        Action action = actions[j];
                        if (action instanceof NewObjectActionInterface) {
                            String rawDisplayText = ((NewObjectActionInterface)action).getActionLabel();
                            Util.setLabelAndMnemonicOnAction((Action)action, (String)rawDisplayText);
                            newObjectActions.add(action);
                            continue;
                        }
                        if (!addedTypeSeparator && separatorsSupported) {
                            addedTypeSeparator = true;
                            if (addedActionsSinceLastSeparator) {
                                actionsList.add(null);
                            }
                        }
                        if (action == null) {
                            if (!separatorsSupported) continue;
                            actionsList.add(action);
                            continue;
                        }
                        actionsList.add(action);
                    }
                    addedActionsSinceLastSeparator = true;
                }
                if (newSubmenuAction != null && newObjectActions.size() > 0) {
                    if (separatorsSupported && newSubmenuAction.getActions().size() == 1) {
                        newSubmenuAction.addAction(null);
                    }
                    Collections.sort(newObjectActions, NEW_OBJECT_ACTION_COMPARATOR);
                    newSubmenuAction.addActions(newObjectActions);
                }
            }
            if (separatorsSupported && addedActionsSinceLastSeparator) {
                actionsList.add(null);
            }
            return actionsList;
        }
        catch (RemoteException e) {
            Workspace.getDefaultLogger().error((Object)("\n\nCouldn't load type dictionary. Cause: " + e.getLocalizedMessage()));
            Workspace.handleRemoteException((RemoteException)e);
            return null;
        }
        catch (Exception e) {
            Workspace.getDefaultLogger().error((Object)("\n\nCouldn't load type dictionary. Cause: " + e.getLocalizedMessage()));
            return null;
        }
    }

    private Action createDeleteAction(FolderInterface folderInterface) throws LogicalTypeException, RemoteException, ServiceException {
        LogicalObjectInterface parentLogicalObject;
        ObjectFactoryInterface objFactory;
        if (folderInterface.isCustomRepositoryRoot()) {
            return null;
        }
        if (this.m_isFavorite) {
            return null;
        }
        TreeNode parentNode = this.getParent();
        if (parentNode instanceof NonFolderContainerNode && (objFactory = (parentLogicalObject = ((NonFolderContainerNode)parentNode).getLogicalObjectInterface()).getTypeInterface().getObjectFactory()) instanceof ContainerContextInterface) {
            ArrayList<FolderInterface> objects = new ArrayList<FolderInterface>(1);
            objects.add(folderInterface);
            boolean isSupported = ((ContainerContextInterface)objFactory).isActionSupportedForMembers(ActionType.DELETE, parentLogicalObject, objects);
            if (!isSupported) {
                return null;
            }
        }
        ActionDelete deleteAction = new ActionDelete(this);
        deleteAction.setEnabled(folderInterface.isDeleteAllowed());
        return deleteAction;
    }

    private Action createRenameAction(FolderInterface folderInterface) throws LogicalTypeException, RemoteException, ServiceException {
        LogicalObjectInterface parentLogicalObject;
        ObjectFactoryInterface objFactory;
        if (folderInterface.isCustomRepositoryRoot()) {
            return null;
        }
        if (this.m_isFavorite) {
            return null;
        }
        TreeNode parentNode = this.getParent();
        if (parentNode instanceof NonFolderContainerNode && (objFactory = (parentLogicalObject = ((NonFolderContainerNode)parentNode).getLogicalObjectInterface()).getTypeInterface().getObjectFactory()) instanceof ContainerContextInterface) {
            ArrayList<FolderInterface> objects = new ArrayList<FolderInterface>(1);
            objects.add(folderInterface);
            boolean isSupported = ((ContainerContextInterface)objFactory).isActionSupportedForMembers(ActionType.RENAME, parentLogicalObject, objects);
            if (!isSupported) {
                return null;
            }
        }
        ActionRename renameAction = new ActionRename(this);
        renameAction.setEnabled(folderInterface.isRenameAllowed());
        return renameAction;
    }

    @Override
    public TableItem getItem() {
        return this._folderItem;
    }

    static {
        _subTreesList.add("SubTrees");
        _membersList.add("Members");
    }

    private static class NewObjectActionComparator
    implements Comparator<Action> {
        private Comparator<String> _comparator = SASCollatorFactory.createCollator();

        private NewObjectActionComparator() {
        }

        @Override
        public int compare(Action action1, Action action2) {
            int index;
            Object name1 = action1.getValue("Name");
            Object name2 = action2.getValue("Name");
            if (!(name1 instanceof String)) {
                return -1;
            }
            if (!(name2 instanceof String)) {
                return 1;
            }
            String s1 = Util.getDisplayLabel((String)((String)name1));
            String s2 = Util.getDisplayLabel((String)((String)name2));
            if (s1 == null) {
                return -1;
            }
            if (s2 == null) {
                return 1;
            }
            String ellipsis = "...";
            if (s1.endsWith("...")) {
                index = s1.lastIndexOf("...");
                s1 = s1.substring(0, index);
            }
            if (s2.endsWith("...")) {
                index = s2.lastIndexOf("...");
                s2 = s2.substring(0, index);
            }
            return this._comparator.compare(s1, s2);
        }
    }
}

