/*
 * Decompiled with CFR 0.152.
 */
package com.sas.console.folderview.visuals;

import com.sas.console.folderview.visuals.BIAbstractNode;
import com.sas.console.folderview.visuals.BIActionInterface;
import com.sas.console.folderview.visuals.LogicalTypesAndServicesAdapter;
import com.sas.console.folderview.visuals.NonFolderContainerNode;
import com.sas.console.folderview.visuals.TableItem;
import com.sas.console.plugins.ElementInterface;
import com.sas.metadata.logical.ContainerContextInterface;
import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.LogicalObjectInterface;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.ObjectFactoryInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.services.information.sasfolders.ContainerNodeInterface;
import com.sas.services.information.sasfolders.FolderNodeInterface;
import com.sas.services.information.sasfolders.PublicObjectNodeInterface;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Action;
import javax.swing.tree.TreeNode;

public class ContainerActionController {
    private static ContainerAction _action = new ContainerAction();

    public static BIActionInterface getBIActionInterface() {
        return _action;
    }

    static class ContainerAction
    implements BIActionInterface {
        private Set<String> _logicalTypeNamesOfInterest;

        ContainerAction() {
        }

        @Override
        public List<Action> getActionsForTableItems(ElementInterface[] tableItems, BIAbstractNode parentNode) {
            if (parentNode == null || parentNode.getContainerInterface() instanceof FolderNodeInterface) {
                return Collections.emptyList();
            }
            try {
                LogicalObjectInterface logicalObject = parentNode.getLogicalObjectInterface();
                ObjectFactoryInterface objFactory = logicalObject.getTypeInterface().getObjectFactory();
                if (objFactory instanceof ContainerContextInterface) {
                    ArrayList<LogicalObjectInterface> selectedMembers = new ArrayList<LogicalObjectInterface>();
                    for (int index = 0; index < tableItems.length; ++index) {
                        LogicalObjectInterface loi;
                        ElementInterface ei = tableItems[index];
                        if (!(ei instanceof TableItem) || (loi = ((TableItem)ei).getLogicalObjectInterface()) == null) continue;
                        selectedMembers.add(loi);
                    }
                    ContainerNodeInterface container = parentNode.getContainerInterface();
                    ArrayList allMembers = new ArrayList(container.getChildren());
                    ArrayList<Action> actionList = new ArrayList<Action>(4);
                    Action[] actions = ((ContainerContextInterface)objFactory).getActionsForMembers(logicalObject, selectedMembers, allMembers);
                    if (actions != null && actions.length > 0) {
                        for (int index = 0; index < actions.length; ++index) {
                            actionList.add(actions[index]);
                        }
                    }
                    return actionList;
                }
            }
            catch (Exception e) {
                Workspace.getDefaultLogger().error((Object)("\n\nError loading container actions. Cause: " + e.getLocalizedMessage()));
            }
            return Collections.emptyList();
        }

        @Override
        public List<Action> getActionsForNode(BIAbstractNode node, boolean isNodeSelected, List tableItems) {
            TreeNode parent = node.getParent();
            if (parent instanceof NonFolderContainerNode) {
                try {
                    NonFolderContainerNode parentNode = (NonFolderContainerNode)parent;
                    LogicalObjectInterface logicalObject = parentNode.getLogicalObjectInterface();
                    ObjectFactoryInterface objFactory = logicalObject.getTypeInterface().getObjectFactory();
                    if (objFactory instanceof ContainerContextInterface) {
                        ArrayList<LogicalObjectInterface> selectedMembers = new ArrayList<LogicalObjectInterface>(1);
                        selectedMembers.add(node.getLogicalObjectInterface());
                        ContainerNodeInterface container = parentNode.getContainerInterface();
                        ArrayList<PublicObjectNodeInterface> allMembers = new ArrayList<PublicObjectNodeInterface>();
                        for (PublicObjectNodeInterface child : container.getChildren()) {
                            allMembers.add(child);
                        }
                        ArrayList<Action> actionList = new ArrayList<Action>(4);
                        Action[] actions = ((ContainerContextInterface)objFactory).getActionsForMembers(logicalObject, selectedMembers, allMembers);
                        if (actions != null && actions.length > 0) {
                            for (int index = 0; index < actions.length; ++index) {
                                actionList.add(actions[index]);
                            }
                        }
                        return actionList;
                    }
                }
                catch (Exception e) {
                    Workspace.getDefaultLogger().error((Object)("\n\nError loading container actions. Cause: " + e.getLocalizedMessage()));
                }
            }
            return Collections.emptyList();
        }

        @Override
        public Set<String> getLogicalTypeNamesOfInterest() {
            if (this._logicalTypeNamesOfInterest == null) {
                this._logicalTypeNamesOfInterest = new HashSet<String>();
                LogicalTypesAndServicesAdapter adapter = LogicalTypesAndServicesAdapter.getInstance();
                Factory factory = adapter.getFactory();
                TypeInterface[] types = null;
                try {
                    types = factory.getTypesSupported();
                }
                catch (RemoteException e) {
                    Workspace.getDefaultLogger().error((Object)("\n\nCouldn't load type dictionary. Cause: " + e.getLocalizedMessage()));
                }
                catch (LogicalTypeException e) {
                    Workspace.getDefaultLogger().error((Object)("\n\nCouldn't load type dictionary. Cause: " + e.getLocalizedMessage()));
                }
                int len = types.length;
                for (int i = 0; i < len; ++i) {
                    this._logicalTypeNamesOfInterest.add(types[i].getPublicType());
                }
            }
            return this._logicalTypeNamesOfInterest;
        }
    }
}

