/*
 * Decompiled with CFR 0.152.
 */
package com.sas.console.folderview.visuals;

import com.sas.console.ConsoleChangeEvent;
import com.sas.console.ConsoleChangeListener;
import com.sas.console.ConsoleInterface;
import com.sas.console.folderview.visuals.BIAbstractNode;
import com.sas.console.folderview.visuals.BIActionFactory;
import com.sas.console.folderview.visuals.ConsoleFolderTree;
import com.sas.console.folderview.visuals.ContainerItemInterface;
import com.sas.console.folderview.visuals.ElementItem;
import com.sas.console.folderview.visuals.FolderItem;
import com.sas.console.folderview.visuals.FolderNode;
import com.sas.console.folderview.visuals.FolderTreeModel;
import com.sas.console.folderview.visuals.FolderViewEvent;
import com.sas.console.folderview.visuals.FolderViewListener;
import com.sas.console.folderview.visuals.FolderViewLogicalTypeActionListener;
import com.sas.console.folderview.visuals.FolderViewUtil;
import com.sas.console.folderview.visuals.HomeFolderItem;
import com.sas.console.folderview.visuals.HomeFolderNode;
import com.sas.console.folderview.visuals.Log;
import com.sas.console.folderview.visuals.LogicalTypesAndServicesAdapter;
import com.sas.console.folderview.visuals.RB;
import com.sas.console.folderview.visuals.RootFolderNode;
import com.sas.console.folderview.visuals.RootNode;
import com.sas.console.folderview.visuals.TableItem;
import com.sas.console.plugins.CustomViewInterface;
import com.sas.console.plugins.ElementInterface;
import com.sas.console.plugins.IntObjPair;
import com.sas.console.plugins.NodeInterface;
import com.sas.console.utils.FontUtil;
import com.sas.console.visuals.ConsoleTreeSelectionListener;
import com.sas.console.visuals.ConsoleViewInterface;
import com.sas.console.visuals.ConsoleViewManager;
import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.LogicalTypeActionListener;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.UtilMetadata;
import com.sas.metadata.remote.FavoritesContainer;
import com.sas.metadata.remote.Identity;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.remote.Tree;
import com.sas.services.ServiceException;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.publicobject.PublicObjectContainerInterface;
import com.sas.services.information.publicobject.PublicObjectInterface;
import com.sas.services.information.sasfolders.ContainerNodeInterface;
import com.sas.services.information.sasfolders.FolderModelFactory;
import com.sas.services.information.sasfolders.MemberNode;
import com.sas.services.information.sasfolders.MemberNodeInterface;
import com.sas.services.information.sasfolders.ModelConfiguration;
import com.sas.services.information.sasfolders.PublicObjectNodeInterface;
import com.sas.services.information.sasfolders.SASFoldersModel;
import com.sas.services.information.sasfolders.SASFoldersModelInterface;
import com.sas.services.information.search.ResultDetails;
import com.sas.services.user.UserContextInterface;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.JComponent;

public class ConsoleFolderView
implements ConsoleViewInterface,
ConsoleChangeListener {
    protected String m_name;
    protected String m_displayName;
    protected ConsoleFolderTree m_folderTree;
    protected JComponent m_treePanel;
    protected ConsoleInterface m_console;
    protected int m_index;
    protected Vector m_folderViewListenerList;
    protected SASFoldersModelInterface m_sasFoldersModel;
    protected String m_userHomeFolderPath;
    protected Tree m_userHomeFolder;

    public ConsoleFolderView(ConsoleInterface console) {
        this.m_console = console;
        this.m_index = 1;
    }

    @Override
    public void initialize() {
        this.setName(RB.getStringResource("Common.FolderView.txt"));
        this.setDisplayName(RB.getStringResource("Common.Folders.txt"));
        new LogicalTypesAndServicesAdapter();
        this.m_folderTree = new ConsoleFolderTree(this.m_console);
        FontUtil.setFontForHC(this.m_folderTree);
        if (FontUtil.isHighContrast()) {
            this.m_folderTree.setRowHeight(28);
        }
        this.m_folderTree.addTreeSelectionListener(new ConsoleTreeSelectionListener(this.m_console, this.m_folderTree));
        Log.initLogging();
        BIActionFactory.init();
        Factory.getInstance().addActionListener((LogicalTypeActionListener)new FolderViewLogicalTypeActionListener());
    }

    public void initRootNode() {
        try {
            this.m_sasFoldersModel = FolderModelFactory.createSASFoldersModel((ServerInterface)FolderViewUtil.getServerInterface(FolderViewUtil.getSessionContextInterface()));
            ModelConfiguration config = this.m_sasFoldersModel.getConfiguration();
            ResultDetails resDet = config.getObjectDetails();
            resDet.setDatesIncluded(true);
            resDet.setDescriptionIncluded(true);
            config.setDisplayUsersHomeFolder(true);
            config.setDisplaySystemFolders(true);
            config.setFolderRefreshValue(-1L);
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        ((RootNode)this.m_folderTree.getModel().getRoot()).initialize();
    }

    public SASFoldersModelInterface getSASFoldersModel() {
        return this.m_sasFoldersModel;
    }

    public void destroySASFoldersModel() {
        this.m_sasFoldersModel = null;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public void setName(String newName) {
        this.m_name = newName;
    }

    @Override
    public JComponent getComponent() {
        return this.m_folderTree;
    }

    @Override
    public int getIndex() {
        return this.m_index;
    }

    @Override
    public void setIndex(int index) {
        this.m_index = index;
    }

    @Override
    public void setComponent(JComponent component) {
        this.m_treePanel = component;
    }

    @Override
    public ConsoleInterface getConsole() {
        return this.m_console;
    }

    @Override
    public int getType() {
        return 1;
    }

    public synchronized void addFolderViewListener(FolderViewListener listener) {
        if (this.m_folderViewListenerList == null) {
            this.m_folderViewListenerList = new Vector(1);
        }
        if (this.m_folderViewListenerList.contains(listener)) {
            return;
        }
        this.m_folderViewListenerList.add(listener);
    }

    public void removeFolderViewListener(FolderViewListener listener) {
        if (this.m_folderViewListenerList == null) {
            return;
        }
        this.m_folderViewListenerList.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void fireFolderViewChange(int eventType, NodeInterface parentNode, List pairList) {
        Vector targets;
        if (parentNode == null) {
            return;
        }
        ConsoleFolderView consoleFolderView = this;
        synchronized (consoleFolderView) {
            if (this.m_folderViewListenerList == null) {
                return;
            }
            targets = (Vector)this.m_folderViewListenerList.clone();
        }
        FolderViewEvent event = new FolderViewEvent(this, eventType, parentNode, pairList);
        for (int index = 0; index < targets.size(); ++index) {
            FolderViewListener target = (FolderViewListener)targets.elementAt(index);
            target.folderViewChanged(event);
        }
    }

    @Override
    public String getDisplayName() {
        return this.m_displayName;
    }

    @Override
    public void setDisplayName(String displayName) {
        this.m_displayName = displayName;
    }

    @Override
    public void cleanupChangeListeners(NodeInterface node) {
        ConsoleFolderView folderView = (ConsoleFolderView)ConsoleViewManager.getView(1);
        if (folderView != null) {
            folderView.removeFolderViewListener((FolderTreeModel)this.m_folderTree.getModel());
            folderView.removeFolderViewListener((ConsoleFolderTree.FolderTreeSelectionModel)this.m_folderTree.getSelectionModel());
        }
    }

    public void processMdFactoryEvents(Map membersMap, int eventType) {
        this.m_userHomeFolderPath = this.getUserHomeFolderPath();
        if (eventType == 2) {
            Vector<IntObjPair> deleteChildList = new Vector<IntObjPair>(0);
            for (BIAbstractNode parentNode : membersMap.keySet()) {
                ArrayList memberList = (ArrayList)membersMap.get(parentNode);
                for (int i = 0; i < memberList.size(); ++i) {
                    ElementInterface memberItem = (ElementInterface)memberList.get(i);
                    if (memberItem instanceof ContainerItemInterface) {
                        ContainerItemInterface ci = (ContainerItemInterface)((Object)memberItem);
                        BIAbstractNode containerNode = ci.getCorrespondingNode();
                        int indexOfNode = -1;
                        FolderItem userIdentityFolder = null;
                        if (containerNode instanceof HomeFolderNode) {
                            indexOfNode = this.getIndex(parentNode, (HomeFolderNode)containerNode);
                            try {
                                userIdentityFolder = this.getUsersIdentityFolder(parentNode);
                                this.removeIdentityHomeFolder(userIdentityFolder, (HomeFolderNode)containerNode);
                            }
                            catch (MdException e) {
                                userIdentityFolder = null;
                            }
                            catch (RemoteException e) {
                                userIdentityFolder = null;
                            }
                        } else {
                            indexOfNode = parentNode.getIndex(containerNode);
                        }
                        IntObjPair ioPair = new IntObjPair(indexOfNode, containerNode);
                        deleteChildList.add(ioPair);
                        ContainerNodeInterface sasFoldersNode = ((ContainerItemInterface)((Object)memberItem)).getCorrespondingNode().getContainerInterface();
                        if (sasFoldersNode != null) {
                            this.removeItemFromSASFoldersModel((PublicObjectNodeInterface)sasFoldersNode);
                        }
                        parentNode.removeElementFromVisual(memberItem);
                        parentNode.remove(containerNode);
                        continue;
                    }
                    if (!(memberItem instanceof ElementItem)) continue;
                    PublicObjectNodeInterface sasFoldersNode = ((ElementItem)memberItem).getPublicObjectNodeInterface();
                    if (sasFoldersNode != null) {
                        this.removeItemFromSASFoldersModel(sasFoldersNode);
                    }
                    parentNode.removeElementFromVisual(memberItem);
                }
                if (deleteChildList.size() > 0) {
                    this.fireFolderViewChange(2, parentNode, deleteChildList);
                }
                deleteChildList.clear();
            }
        } else {
            String parentTreePath = null;
            for (Object parent : membersMap.keySet()) {
                List itemList = (List)membersMap.get(parent);
                if (this.hasMyFolder(itemList)) {
                    this.updateMyFolderToRootNode(itemList);
                }
                try {
                    PublicObjectNodeInterface pon;
                    PublicObjectInterface publicObject;
                    List changedItemsList;
                    Tree parentTree;
                    String rootOfParentTreePath = null;
                    if (parent instanceof SoftwareComponent) {
                        parentTreePath = FolderViewUtil.ROOT_PATH;
                    } else if (parent instanceof Tree) {
                        if (((Tree)parent).getPublicType() == "") continue;
                        parentTreePath = UtilMetadata.getPath((Tree)((Tree)parent), (boolean)false);
                    } else if (parent instanceof FavoritesContainer && (parentTree = FolderViewUtil.findTreeRootOfFavorite((FavoritesContainer)parent)) != null) {
                        rootOfParentTreePath = parentTree.getName();
                    }
                    if (rootOfParentTreePath == null) {
                        rootOfParentTreePath = FolderViewUtil.getRootOfPath(parentTreePath);
                    }
                    if (rootOfParentTreePath == null) {
                        return;
                    }
                    BIAbstractNode rootOfParentNode = this.m_folderTree.getRootFolderNode(rootOfParentTreePath);
                    BIAbstractNode parentNode = rootOfParentTreePath.equals(FolderViewUtil.ROOT_PATH) ? (RootNode)this.m_folderTree.getModel().getRoot() : (parentTreePath == null ? this.m_folderTree.findNodeById(rootOfParentNode, parent.getFQID()) : this.m_folderTree.findNodeByPath(parentTreePath));
                    if (parentNode == null) {
                        HomeFolderNode homeFolderNode;
                        if (parent instanceof Tree && this.isItemUserHomeFolderNode((Tree)parent)) {
                            homeFolderNode = this.getHomeFolderNode();
                            if (homeFolderNode != null) {
                                parentNode = homeFolderNode;
                            }
                        } else if (parent instanceof Tree && this.m_folderTree.nodeIsChildOfUserHomeFolder(rootOfParentNode) && (homeFolderNode = this.getHomeFolderNode()) != null) {
                            parentNode = this.m_folderTree.findNodeById(homeFolderNode, parent.getFQID());
                        }
                        if (parentNode == null) {
                            if (eventType != 1) continue;
                            changedItemsList = (List)membersMap.get(parent);
                            RootNode sasFolders = null;
                            for (int i = changedItemsList.size() - 1; i >= 0 && sasFolders == null; --i) {
                                Root item = (Root)changedItemsList.get(i);
                                if (!(item instanceof Tree) || !this.isItemUserHomeFolderNode((Tree)item)) continue;
                                sasFolders = this.m_folderTree.getRootNode();
                                sasFolders.updateFolderInVisual((Tree)item);
                            }
                            continue;
                        }
                    }
                    if (eventType == 0) {
                        List newItemsToAdd = (List)membersMap.get(parent);
                        for (int i = 0; i < newItemsToAdd.size(); ++i) {
                            FolderNode folderNode;
                            Root item = (Root)newItemsToAdd.get(i);
                            publicObject = LogicalTypesAndServicesAdapter.getInstance().convertToPublicObject(item);
                            pon = this.m_sasFoldersModel.getObject(publicObject);
                            if (publicObject instanceof PublicObjectContainerInterface) {
                                FolderNode node;
                                if (pon != null) {
                                    parentNode.addFolderToVisual((ContainerNodeInterface)pon);
                                } else {
                                    parentNode.addChildContainerToVisual(publicObject);
                                }
                                if (parent instanceof Tree && this.isItemUserHomeFolderNode((Tree)parent) && !(parentNode instanceof HomeFolderNode)) {
                                    if (pon != null) {
                                        this.m_folderTree.getHomeFolderNode().addFolderToVisual((ContainerNodeInterface)pon);
                                        continue;
                                    }
                                    if (publicObject == null) continue;
                                    this.m_folderTree.getHomeFolderNode().addChildContainerToVisual((PublicObjectInterface)pon);
                                    continue;
                                }
                                if (!this.m_folderTree.nodeIsChildOfUserHomeFolder(parentNode) || (node = (FolderNode)this.m_folderTree.findNodeById(this.getHomeFolderNode(), parent.getFQID())) == null) continue;
                                if (publicObject instanceof ContainerNodeInterface) {
                                    node.addFolderToVisual((ContainerNodeInterface)publicObject);
                                    continue;
                                }
                                node.addContainer((PublicObjectInterface)((PublicObjectContainerInterface)publicObject));
                                continue;
                            }
                            parentNode.addMemberToVisual(pon);
                            if (parent instanceof Tree && this.isItemUserHomeFolderNode((Tree)parent) && !(parentNode instanceof HomeFolderNode)) {
                                this.getHomeFolderNode().addMemberToVisual(pon);
                                continue;
                            }
                            if (!this.m_folderTree.nodeIsChildOfUserHomeFolder(parentNode) || parentNode instanceof HomeFolderNode || (folderNode = (FolderNode)this.m_folderTree.findNodeById(this.getHomeFolderNode(), parent.getFQID())) == null) continue;
                            folderNode.addMemberToVisual((PublicObjectNodeInterface)new MemberNode(publicObject.getIdentifier(), publicObject.getName(), publicObject.getTypeDescriptor()));
                        }
                        continue;
                    }
                    if (eventType != 1) continue;
                    changedItemsList = (List)membersMap.get(parent);
                    for (int i = 0; i < changedItemsList.size(); ++i) {
                        BIAbstractNode nodeToUpdate;
                        BIAbstractNode newParent;
                        Root item = (Root)changedItemsList.get(i);
                        publicObject = LogicalTypesAndServicesAdapter.getInstance().convertToPublicObject(item);
                        pon = this.m_sasFoldersModel.getObject(publicObject);
                        if (item instanceof Tree) {
                            HomeFolderNode homeFolderNode;
                            parentNode.updateFolderInVisual((Tree)item);
                            newParent = this.reparentObjectIfNecessary(parentNode, pon);
                            if (newParent != null) {
                                parent = newParent instanceof FolderNode ? ((FolderNode)newParent).getTree() : ((RootNode)newParent).getSoftwareComponent();
                            }
                            if (parent instanceof Tree && this.isItemUserHomeFolderNode((Tree)parent) && !(parentNode instanceof HomeFolderNode)) {
                                this.m_folderTree.getHomeFolderNode().updateFolderInVisual((Tree)item);
                                continue;
                            }
                            if (this.m_folderTree.nodeIsChildOfUserHomeFolder(parentNode) && !this.isItemUserHomeFolderNode((Tree)item) && !(parentNode instanceof HomeFolderNode)) {
                                BIAbstractNode nodeToUpdate2;
                                if (parentNode == null || (nodeToUpdate2 = this.m_folderTree.findNodeById(this.getHomeFolderNode(), parent.getFQID())) == null) continue;
                                nodeToUpdate2.updateFolderInVisual((Tree)item);
                                continue;
                            }
                            if (!(item instanceof Tree) || !this.isItemUserHomeFolderNode((Tree)item) || (homeFolderNode = this.getHomeFolderNode()) == null) continue;
                            homeFolderNode.setName(item.getName());
                            homeFolderNode.updateFolderInVisual((Tree)item);
                            RootNode sasFolders = this.m_folderTree.getRootNode();
                            sasFolders.updateFolderInVisual((Tree)item);
                            int indexOfNode = this.getIndex(sasFolders, homeFolderNode);
                            IntObjPair ioPair = new IntObjPair(indexOfNode, homeFolderNode);
                            ArrayList<IntObjPair> childList = new ArrayList<IntObjPair>(1);
                            childList.add(ioPair);
                            this.fireFolderViewChange(4, parentNode, childList);
                            continue;
                        }
                        if (this.m_sasFoldersModel == null || item == null) continue;
                        if (pon instanceof ContainerNodeInterface) {
                            parentNode.updateContainerInVisual(publicObject);
                        } else {
                            parentNode.updateMemberInVisual(pon.getIdentifier());
                        }
                        if (parent instanceof Tree && this.isItemUserHomeFolderNode((Tree)parent) && !(parentNode instanceof HomeFolderNode)) {
                            if (pon instanceof ContainerNodeInterface) {
                                this.m_folderTree.getHomeFolderNode().updateContainerInVisual((PublicObjectInterface)pon);
                            } else {
                                this.m_folderTree.getHomeFolderNode().updateMemberInVisual(pon.getIdentifier());
                            }
                        } else if (item instanceof Tree && this.m_folderTree.nodeIsChildOfUserHomeFolder(parentNode) && !this.isItemUserHomeFolderNode((Tree)item) && !(parentNode instanceof HomeFolderNode) && parentNode != null && (nodeToUpdate = this.m_folderTree.findNodeById(this.getHomeFolderNode(), parent.getFQID())) != null) {
                            nodeToUpdate.updateContainerInVisual((PublicObjectInterface)pon);
                        }
                        newParent = null;
                        if (pon != null) {
                            newParent = (FolderNode)this.reparentObjectIfNecessary(parentNode, pon);
                        }
                        if (newParent != null) {
                            parentNode = newParent;
                            parent = ((FolderNode)newParent).getTree();
                        }
                        BIAbstractNode node = null;
                        if (this.m_folderTree.nodeIsChildOfMyFolder(parentNode)) {
                            node = this.m_folderTree.findNodeById(this.m_folderTree.findNodeByPath(this.m_userHomeFolderPath), parent.getFQID());
                        } else if (this.m_folderTree.nodeIsChildOfUserHomeFolder(parentNode)) {
                            node = this.m_folderTree.findNodeById(this.getHomeFolderNode(), parent.getFQID());
                        }
                        if (node == null) continue;
                        node.updateMemberInVisual(item.getFQID());
                    }
                }
                catch (LogicalTypeException rootOfParentTreePath) {
                }
                catch (RemoteException rootOfParentTreePath) {
                }
                catch (MdException rootOfParentTreePath) {
                }
                catch (ServiceException e) {
                    e.printStackTrace();
                }
            }
        }
        this.m_userHomeFolderPath = null;
        this.m_userHomeFolder = null;
    }

    private Tree getMyFolderFromList(List itemList) {
        Tree myFolder = null;
        Tree returnTree = null;
        try {
            for (int i = itemList.size() - 1; i >= 0 && returnTree == null; --i) {
                HomeFolderNode node;
                myFolder = (Tree)itemList.get(i);
                if (myFolder instanceof HomeFolderNode) {
                    returnTree = ((HomeFolderNode)myFolder).getTree();
                }
                if (myFolder instanceof HomeFolderItem) {
                    returnTree = ((FolderNode)((HomeFolderItem)myFolder).getCorrespondingNode())._tree;
                } else if (myFolder instanceof FolderItem) {
                    myFolder = ((FolderNode)((FolderItem)myFolder).getCorrespondingNode())._tree;
                } else if (myFolder instanceof RootFolderNode) {
                    myFolder = ((RootFolderNode)myFolder).getTree();
                }
                if (returnTree == null && myFolder instanceof Tree && (node = this.getHomeFolderNode()) != null) {
                    ContainerNodeInterface po = node.getContainerInterface();
                    String myFolderID = myFolder.getFQID();
                    String tempTreeID = null;
                    try {
                        tempTreeID = po.getIdentifier();
                    }
                    catch (ServiceException e) {
                        returnTree = null;
                    }
                    if (tempTreeID != null && myFolderID.equalsIgnoreCase(tempTreeID)) {
                        returnTree = myFolder;
                    }
                }
                if (returnTree != null || !(myFolder instanceof Tree)) continue;
                UserContextInterface userContext = this.m_console.getSessionContext().getUserContext();
                String name = userContext.getName();
                if ("unknown".equals(name)) {
                    name = "";
                }
                Tree identity = Workspace.getMdFactory().getOMIUtil().getUserHomeFolder(RootNode.getPrimaryObjectStore(), name, "Home Folder", "", 0);
                Tree myFolderParent = myFolder.getParentTree();
                if (identity != null && myFolderParent != null && identity.getFQID().equalsIgnoreCase(myFolderParent.getFQID())) {
                    returnTree = myFolder;
                    continue;
                }
                myFolder = null;
            }
        }
        catch (MdException e) {
            returnTree = null;
        }
        catch (RemoteException e) {
            returnTree = null;
        }
        return returnTree;
    }

    private boolean hasMyFolder(List itemList) {
        return this.getMyFolderFromList(itemList) != null;
    }

    private List getChildList(HomeFolderNode inputNode) {
        ArrayList<IntObjPair> tempList = new ArrayList<IntObjPair>();
        IntObjPair pair = new IntObjPair(0, inputNode);
        tempList.add(pair);
        return tempList;
    }

    private boolean changingActualMyFolder(HomeFolderNode myHomeFolder, Tree myFolder) {
        Tree tempTree = myHomeFolder.getTree();
        return tempTree == myFolder;
    }

    private void updateMyFolderToRootNode(RootNode sasFolders, Tree myFolder) throws RemoteException, LogicalTypeException, ServiceException {
        HomeFolderNode myHomeFolder = this.getHomeFolderNode();
        if (myHomeFolder == null) {
            PublicObjectInterface publicObject = LogicalTypesAndServicesAdapter.getInstance().convertToPublicObject((Root)myFolder);
            PublicObjectNodeInterface publicObjectNode = this.m_sasFoldersModel.getObject(publicObject);
            if (publicObject != null && publicObjectNode instanceof com.sas.services.information.sasfolders.FolderNode) {
                myHomeFolder = new HomeFolderNode(sasFolders, (ContainerNodeInterface)((com.sas.services.information.sasfolders.FolderNode)publicObjectNode));
                sasFolders._folderNodeList.add(0, myHomeFolder);
                sasFolders._itemList.add(0, myHomeFolder.getItem());
                myHomeFolder.setName(myFolder.getName());
                List childList = this.getChildList(myHomeFolder);
                this.fireFolderViewChange(8, sasFolders, childList);
            }
        } else if (this.changingActualMyFolder(myHomeFolder, myFolder)) {
            myHomeFolder.setName(myFolder.getName());
        }
        Collections.sort(sasFolders._folderNodeList);
        Collections.sort(sasFolders._itemList);
        sasFolders.updateTableVisual();
    }

    private void updateMyFolderToRootNode(List itemList) {
        try {
            RootNode sasFolders = this.m_folderTree.getRootNode();
            Tree myFolder = this.getMyFolderFromList(itemList);
            if (!this.hasMyFolder(sasFolders._folderNodeList)) {
                this.updateMyFolderToRootNode(sasFolders, myFolder);
            }
        }
        catch (RemoteException sasFolders) {
        }
        catch (LogicalTypeException sasFolders) {
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
    }

    private void removeIdentityHomeFolder(FolderItem identityFolder, HomeFolderNode myFolder) {
        if (identityFolder != null) {
            String myFolderName = myFolder.getName();
            FolderNode parentNode = (FolderNode)identityFolder.getCorrespondingNode();
            Vector list = identityFolder.getCorrespondingNode()._itemList;
            Vector list2 = identityFolder.getCorrespondingNode()._folderNodeList;
            FolderItem item = null;
            FolderNode myFolderNode = null;
            for (int i = list.size() - 1; i >= 0 && item == null; --i) {
                item = (FolderItem)list.get(i);
                myFolderNode = (FolderNode)item.getCorrespondingNode();
                if (myFolderNode.getName().equalsIgnoreCase(myFolderName)) continue;
                item = null;
            }
            if (item != null) {
                Vector<IntObjPair> deleteChildList = new Vector<IntObjPair>();
                int indexOfNode = this.getIndex(parentNode, myFolder);
                IntObjPair ioPair = new IntObjPair(indexOfNode, myFolder);
                deleteChildList.add(ioPair);
                list.remove(item);
                list2.remove(myFolderNode);
                this.fireFolderViewChange(2, parentNode, deleteChildList);
                parentNode.removeElementFromVisual(item);
            }
        }
    }

    private FolderItem getUsersIdentityFolder(BIAbstractNode sasFolders) throws MdException, RemoteException {
        FolderItem identityHomeFolder = null;
        String usersPath = "";
        usersPath = this.getUserHomeFolderPath();
        usersPath = FolderViewUtil.getRootOfPath(usersPath);
        Vector list = sasFolders._itemList;
        FolderItem usersFolder = null;
        for (int i = list.size() - 1; i >= 0 && usersFolder == null; --i) {
            usersFolder = (FolderItem)list.get(i);
            String itemName = usersFolder.getName();
            if (itemName.equalsIgnoreCase(usersPath)) continue;
            usersFolder = null;
        }
        if (usersFolder != null) {
            Identity identity;
            Vector list2 = usersFolder.getCorrespondingNode()._itemList;
            if (list2.isEmpty()) {
                usersFolder.getCorrespondingNode().populateNode(true, false);
            }
            if ((identity = Workspace.getMdFactory().getOMIUtil().getIdentity(RootNode.getPrimaryObjectStore())) == null) {
                return null;
            }
            for (int i = list2.size() - 1; i >= 0 && identityHomeFolder == null; --i) {
                TableItem tableItem = (TableItem)list2.get(i);
                if (!(tableItem instanceof FolderItem)) continue;
                identityHomeFolder = (FolderItem)list2.get(i);
                Tree tempItentityHomeFolder = identity.getAssociatedHomeFolder();
                if (tempItentityHomeFolder != null && identityHomeFolder.getName().equalsIgnoreCase(tempItentityHomeFolder.getName())) continue;
                identityHomeFolder = null;
            }
        }
        return identityHomeFolder;
    }

    private int getIndex(BIAbstractNode parentNode, HomeFolderNode homeFolder) {
        int index = -1;
        Vector list = parentNode._folderNodeList;
        for (int i = list.size() - 1; i >= 0 && index == -1; --i) {
            FolderNode node = (FolderNode)list.get(i);
            if (!node.getName().equalsIgnoreCase(homeFolder.getName())) continue;
            index = i;
        }
        return index;
    }

    private HomeFolderNode getHomeFolderNode() {
        HomeFolderNode homeFolder = null;
        RootNode sasFolders = this.m_folderTree.getRootNode();
        for (int i = sasFolders._folderNodeList.size() - 1; i >= 0 && homeFolder == null; --i) {
            Object folderNode = sasFolders._folderNodeList.get(i);
            if (!(folderNode instanceof HomeFolderNode)) continue;
            homeFolder = (HomeFolderNode)folderNode;
        }
        return homeFolder;
    }

    private boolean isItemUserHomeFolderNode(Tree item) {
        boolean isHomeFolder = false;
        Tree homeFolderNodeItem = null;
        HomeFolderNode homeFolder = this.getHomeFolderNode();
        if (homeFolder != null) {
            homeFolderNodeItem = homeFolder.getTree();
            try {
                isHomeFolder = homeFolderNodeItem.getFQID().equalsIgnoreCase(item.getFQID());
            }
            catch (RemoteException e) {
                isHomeFolder = false;
            }
        }
        return isHomeFolder;
    }

    private BIAbstractNode reparentObjectIfNecessary(BIAbstractNode parentInMetadata, PublicObjectNodeInterface element) throws RemoteException, LogicalTypeException, ServiceException {
        TableItem tableElement;
        String rootOfUserHomeFolderPath = null;
        BIAbstractNode newParent = null;
        rootOfUserHomeFolderPath = FolderViewUtil.getRootOfPath(this.m_userHomeFolderPath);
        FolderNode userHomeFolderNode = null;
        if (rootOfUserHomeFolderPath != null) {
            userHomeFolderNode = (FolderNode)this.m_folderTree.getRootFolderNode(rootOfUserHomeFolderPath);
        }
        if (!(element instanceof ContainerNodeInterface) && (tableElement = (TableItem)this.m_folderTree.findMemberById((RootNode)this.m_folderTree.getModel().getRoot(), element.getIdentifier())) != null) {
            String parentInMetadataId = null;
            String parentInVisualId = null;
            try {
                parentInMetadataId = parentInMetadata.getContainerInterface().getIdentifier();
            }
            catch (ServiceException e) {
                e.printStackTrace();
            }
            BIAbstractNode parentInVisual = (BIAbstractNode)tableElement.getNode();
            try {
                parentInVisualId = parentInVisual.getContainerInterface().getIdentifier();
            }
            catch (ServiceException e) {
                e.printStackTrace();
            }
            if (!parentInVisualId.equals(parentInMetadataId)) {
                FolderNode parentUnderHomeFolderNode;
                ElementItem homeFolderTableElement;
                newParent = parentInMetadata;
                parentInVisual.removeElementFromVisual(tableElement);
                if (userHomeFolderNode != null && this.m_folderTree.nodeIsChildOfMyFolder(parentInVisual)) {
                    ElementItem userHomeFolderItem = (ElementItem)this.m_folderTree.findMemberById(userHomeFolderNode, element.getIdentifier());
                    if (userHomeFolderItem != null) {
                        FolderNode parentOfElementUnderUserHomeFolder = (FolderNode)userHomeFolderItem.getNode();
                        parentOfElementUnderUserHomeFolder.removeElementFromVisual(userHomeFolderItem);
                    }
                } else if (this.m_folderTree.nodeIsChildOfUserHomeFolder(parentInVisual) && (homeFolderTableElement = (ElementItem)this.m_folderTree.findMemberById(this.m_folderTree.getHomeFolderNode(), element.getIdentifier())) != null) {
                    FolderNode parentUnderHomeFolderNode2 = (FolderNode)homeFolderTableElement.getNode();
                    parentUnderHomeFolderNode2.removeElementFromVisual(homeFolderTableElement);
                }
                if (element instanceof MemberNodeInterface) {
                    parentInMetadata.addMemberToVisual(element);
                } else if (element instanceof ContainerNodeInterface) {
                    parentInMetadata.addContainer((PublicObjectInterface)element);
                }
                if (userHomeFolderNode != null && this.m_folderTree.nodeIsChildOfMyFolder(parentInMetadata)) {
                    BIAbstractNode parentUnderUserHomeFolderNode = this.m_folderTree.findNodeById(userHomeFolderNode, ((FolderNode)parentInMetadata).getTree().getFQID());
                    if (parentUnderUserHomeFolderNode != null) {
                        parentUnderUserHomeFolderNode.addMemberToVisual(element);
                    }
                } else if (userHomeFolderNode != null && this.m_folderTree.nodeIsChildOfUserHomeFolder(parentInMetadata) && (parentUnderHomeFolderNode = (FolderNode)this.m_folderTree.findNodeById(this.m_folderTree.getHomeFolderNode(), ((FolderNode)parentInMetadata).getTree().getFQID())) != null) {
                    parentUnderHomeFolderNode.addMemberToVisual(element);
                }
            }
        }
        return newParent;
    }

    public void registerMetadataListener() {
        this.m_folderTree.registerMetadataListener();
    }

    public void unregisterMetadataListener() {
        this.m_folderTree.unregisterMetadataListener();
    }

    public String getUserHomeFolderPath() {
        if (this.m_userHomeFolderPath == null) {
            try {
                this.m_userHomeFolderPath = FolderViewUtil.getUserHomeFolderPathFromServer();
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
            catch (MdException e) {
                e.printStackTrace();
            }
        }
        return this.m_userHomeFolderPath;
    }

    public Tree getHomeFolder() {
        if (this.m_userHomeFolder == null) {
            try {
                this.m_userHomeFolder = FolderViewUtil.getHomeFolderFromServer(false);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
            catch (MdException e) {
                e.printStackTrace();
            }
        }
        return this.m_userHomeFolder;
    }

    boolean isUserHomeFolder(Tree tree) throws RemoteException, MdException {
        Tree userHomeFolder = this.getHomeFolder();
        return userHomeFolder != null && userHomeFolder.getFQID().equals(tree.getFQID());
    }

    @Override
    public void consoleChange(ConsoleChangeEvent event) {
        switch (event.getEventType()) {
            case 4: {
                this.m_sasFoldersModel = null;
            }
        }
    }

    @Override
    public CustomViewInterface getCustomView() {
        return null;
    }

    protected void removeItemFromSASFoldersModel(PublicObjectNodeInterface item) {
        String sasFoldersNodeName = null;
        if (this.m_sasFoldersModel != null && item != null) {
            try {
                ((SASFoldersModel)this.m_sasFoldersModel).removeNodeFromParent(item);
                sasFoldersNodeName = item.getName();
            }
            catch (ServiceException e) {
                Logger.getLogger("ConsoleFolderView.log").warning("Could not remove " + sasFoldersNodeName + " from SAS Folders Model");
            }
            catch (RemoteException e) {
                Logger.getLogger("ConsoleFolderView.log").warning("Could not remove " + sasFoldersNodeName + " from SAS Folders Model");
            }
        }
    }
}

