/*
 * Decompiled with CFR 0.152.
 */
package com.sas.console.folderview.visuals;

import com.sas.console.ConsoleChangeEvent;
import com.sas.console.ConsoleChangeListener;
import com.sas.console.ConsoleInterface;
import com.sas.console.folderview.visuals.BIAbstractNode;
import com.sas.console.folderview.visuals.ConsoleFolderView;
import com.sas.console.folderview.visuals.FolderNode;
import com.sas.console.folderview.visuals.FolderTreeModel;
import com.sas.console.folderview.visuals.FolderViewEvent;
import com.sas.console.folderview.visuals.FolderViewListener;
import com.sas.console.folderview.visuals.FolderViewUtil;
import com.sas.console.folderview.visuals.FolderviewMetadataFactoryListener;
import com.sas.console.folderview.visuals.HomeFolderNode;
import com.sas.console.folderview.visuals.RB;
import com.sas.console.folderview.visuals.RootNode;
import com.sas.console.folderview.visuals.SearchFolderNode;
import com.sas.console.models.HelpKeyListener;
import com.sas.console.models.RefreshKeyListener;
import com.sas.console.plugins.ElementInterface;
import com.sas.console.plugins.NodeInterface;
import com.sas.console.utils.FontUtil;
import com.sas.console.visuals.ConsoleAction;
import com.sas.console.visuals.ConsoleTree;
import com.sas.console.visuals.ConsoleTreeExpansionListener;
import com.sas.console.visuals.ConsoleViewManager;
import com.sas.console.visuals.CopyAction;
import com.sas.console.visuals.DeleteAction;
import com.sas.console.visuals.MainConsole;
import com.sas.console.visuals.OpenAction;
import com.sas.console.visuals.PasteAction;
import com.sas.console.visuals.PropertyAction;
import com.sas.console.visuals.RefreshAction;
import com.sas.console.visuals.SubmenuAction;
import com.sas.console.visuals.ToolTipStrippingJPopupMenu;
import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactoryListener;
import com.sas.services.ServiceException;
import com.sas.services.information.publicobject.TypeDescriptorInterface;
import com.sas.visuals.Resources;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.mgmt.MnemonicModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.rmi.RemoteException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.MouseInputAdapter;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class ConsoleFolderTree
extends ConsoleTree
implements ConsoleChangeListener {
    private static final long serialVersionUID = 9200000001L;
    protected FolderTreeSelectionModel m_selectionModel;
    protected RootNode _rootNode;
    WAdminResource bundle = FolderViewUtil.getMainConsoleResourceBundle();
    ImageIcon m_folderIcon = Resources.getImageIcon((String)this.bundle.getString("MainConsole.ImageIcon.DefaultIcon.image"), (int)16);
    protected MainConsole m_console;
    protected ConsoleFolderView m_folderView;
    private FolderviewMetadataFactoryListener m_factoryListener;

    public ConsoleFolderTree(ConsoleInterface console) {
        this.m_console = (MainConsole)console;
        this.m_console.addConsoleListener(this);
        this._initialize();
    }

    protected void _initialize() {
        this._rootNode = new RootNode(null, RB.getStringResource("ConsoleFolderTree.RootNode.txt"), this.m_console);
        FolderTreeModel m_treeModel = new FolderTreeModel(this._rootNode, this.m_console);
        this.setModel(m_treeModel);
        this.m_folderView = (ConsoleFolderView)ConsoleViewManager.getView(1);
        this.setCellRenderer(new FolderTreeCellRenderer());
        this.m_selectionModel = new FolderTreeSelectionModel();
        this.setSelectionModel(this.m_selectionModel);
        this.setBackground(UIManager.getColor("List.background"));
        this.addKeyListener(new HelpKeyListener(this.m_console, true));
        this.addKeyListener(new RefreshKeyListener(this.m_console));
        this.addKeyListener(new FolderTreeKeyListener());
        this.addFocusListener(new FolderTreeFocusListener());
        this.setRootVisible(true);
        ConsoleTreeExpansionListener expansionListener = new ConsoleTreeExpansionListener();
        this.addTreeExpansionListener(expansionListener);
        this.addTreeWillExpandListener(expansionListener);
        this.expandPath(this._rootNode.getTreePath());
        if (this.m_popMenu == null) {
            this.m_popMenu = new ToolTipStrippingJPopupMenu();
        }
        MouseInputAdapter mouseListener = new MouseInputAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if ((e.getModifiers() & 4) != 0) {
                    int selectedRow = ConsoleFolderTree.this.getRowForLocation(e.getX(), e.getY());
                    TreePath selectedPath = ConsoleFolderTree.this.getPathForLocation(e.getX(), e.getY());
                    if (selectedRow != -1) {
                        ConsoleFolderTree.this.setSelectionRow(selectedRow);
                        ConsoleFolderTree.this._buildPopupMenu(selectedPath);
                        ConsoleFolderTree.this.m_popMenu.show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            }
        };
        this.addMouseListener(mouseListener);
    }

    protected void _buildPopupMenu(TreePath path) {
        this.m_popMenu = new ToolTipStrippingJPopupMenu();
        Object node = path.getLastPathComponent();
        if (node != null && node instanceof NodeInterface) {
            NodeInterface currentNode = (NodeInterface)node;
            if (this.m_console.isConnected()) {
                ConsoleAction consoleRefreshAction = new ConsoleAction(new RefreshAction(currentNode, ConsoleViewManager.getCurrentView()));
                this.m_popMenu.add(MnemonicModel.getMenuItemWithMnemonic((Action)consoleRefreshAction));
            }
            Vector<Action> actionList = new Vector<Action>(0);
            List nodeActions = currentNode.getContextMenuActions();
            if (nodeActions != null) {
                actionList.addAll(nodeActions);
            }
            Action[] extendedActions = this.m_console.getExtendedContextMenuActions(currentNode);
            for (int index = 0; extendedActions != null && index < extendedActions.length; ++index) {
                actionList.add(extendedActions[index]);
            }
            if (!currentNode.isLeaf()) {
                OpenAction openAction = new OpenAction(this, path);
                ConsoleAction consoleOpenAction = new ConsoleAction(openAction);
                if (this.isExpanded(path)) {
                    consoleOpenAction.setEnabled(false);
                }
                this.m_popMenu.add(MnemonicModel.getMenuItemWithMnemonic((Action)consoleOpenAction));
            }
            this.m_popMenu.addSeparator();
            ImageIcon blankIcon = Resources.getImageIcon((String)this.bundle.getString("Common.BlankIcon.image"), (int)16);
            Object[] actions = actionList.toArray();
            for (int i = 0; i < actions.length; ++i) {
                Action actionObject = (Action)actions[i];
                if (actionObject instanceof SubmenuAction) {
                    SubmenuAction submenuAction = (SubmenuAction)actionObject;
                    JMenu submenu = SubmenuAction.generateSubmenu(submenuAction);
                    this.m_popMenu.add(submenu);
                    continue;
                }
                if (actionObject == null) {
                    this.m_popMenu.addSeparator();
                    continue;
                }
                if (actionObject.getValue("SmallIcon") == null) {
                    actionObject.putValue("SmallIcon", blankIcon);
                }
                Action newAction = actionObject;
                ConsoleAction newConsoleAction = new ConsoleAction(newAction);
                this.m_popMenu.add(MnemonicModel.getMenuItemWithMnemonic((Action)newConsoleAction));
            }
            PropertyAction propertiesAction = new PropertyAction(currentNode, ConsoleViewManager.getCurrentView());
            ConsoleAction consolePropertiesAction = new ConsoleAction(propertiesAction);
            this.m_popMenu.add(MnemonicModel.getMenuItemWithMnemonic((Action)consolePropertiesAction));
        }
    }

    @Override
    public void consoleChange(ConsoleChangeEvent event) {
        switch (event.getEventType()) {
            case 3: {
                RootNode root = (RootNode)this.getModel().getRoot();
                TreePath rootPath = root.getTreePath();
                this.expandPath(rootPath);
                this.setSelectionPath(rootPath);
                try {
                    if (Workspace.getMdFactory().getOMIUtil().getRepositories().size() <= 0) break;
                    this.registerMetadataListener();
                }
                catch (RemoteException re) {
                    Workspace.getDefaultLogger().error((Object)("Failed on getRepositories() call in ConsoleFolderTree:consoleChange(). Reason: " + re.getLocalizedMessage()));
                }
                catch (MdException me) {
                    Workspace.getDefaultLogger().error((Object)("Failed on getRepositories() call in ConsoleFolderTree:consoleChange(). Reason: " + me.getLocalizedMessage()));
                }
                break;
            }
            case 12: {
                this.unregisterMetadataListener();
                this.m_folderView.destroySASFoldersModel();
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                try {
                    if (Workspace.getMdFactory().getOMIUtil().getRepositories().size() != 0) break;
                    this.unregisterMetadataListener();
                    break;
                }
                catch (RemoteException re) {
                    Workspace.getDefaultLogger().error((Object)("Failed on getRepositories() call in ConsoleFolderTree:consoleChange(). Reason: " + re.getLocalizedMessage()));
                    break;
                }
                catch (MdException me) {
                    Workspace.getDefaultLogger().error((Object)("Failed on getRepositories() call in ConsoleFolderTree:consoleChange(). Reason: " + me.getLocalizedMessage()));
                }
            }
        }
    }

    public ConsoleInterface getConsole() {
        return this.m_console;
    }

    public void registerMetadataListener() {
        Factory logicalObjectFactory = Factory.getInstance();
        try {
            TypeInterface[] typesArray = logicalObjectFactory.getTypesSupported();
            HashSet<String> typesSet = new HashSet<String>();
            for (int i = 0; i < typesArray.length; ++i) {
                TypeInterface type = typesArray[i];
                typesSet.add(type.getMetadataType());
            }
            String[] typesStringArray = new String[typesSet.size()];
            System.arraycopy(typesSet.toArray(), 0, typesStringArray, 0, typesSet.size());
            this.m_factoryListener = new FolderviewMetadataFactoryListener();
            Workspace.getMdFactory().addMdFactoryListener((MdFactoryListener)this.m_factoryListener, typesStringArray);
        }
        catch (RemoteException re) {
            Workspace.getDefaultLogger().error((Object)re.getLocalizedMessage());
        }
        catch (LogicalTypeException re) {
            Workspace.getDefaultLogger().error((Object)re.getLocalizedMessage());
        }
    }

    public void unregisterMetadataListener() {
        try {
            Workspace.getMdFactory().removeMdFactoryListener((MdFactoryListener)this.m_factoryListener);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public BIAbstractNode getRootFolderNode(String rootOfParentTreePath) {
        RootNode rootNode = (RootNode)this.getModel().getRoot();
        if (rootOfParentTreePath.equals("/")) {
            return rootNode;
        }
        Vector folderList = rootNode._folderNodeList;
        for (int i = 0; i < folderList.size(); ++i) {
            BIAbstractNode currentNode = (BIAbstractNode)folderList.get(i);
            String currentNodeName = currentNode.getName();
            if (!currentNodeName.equals(rootOfParentTreePath)) continue;
            return currentNode;
        }
        return null;
    }

    public BIAbstractNode findNodeByPath(String metadataPath) {
        if (metadataPath.equals(FolderViewUtil.ROOT_PATH)) {
            return this._rootNode;
        }
        String[] pathComponents = metadataPath.split("/");
        LinkedList<String> pathList = new LinkedList<String>();
        for (int i = 1; i < pathComponents.length; ++i) {
            pathList.add(pathComponents[i]);
        }
        return this.searchForChildNodeByName(this._rootNode, pathList);
    }

    protected BIAbstractNode searchForChildNodeByName(BIAbstractNode startNode, LinkedList pathList) {
        for (int i = 0; i < startNode._folderNodeList.size(); ++i) {
            BIAbstractNode searchNode = (BIAbstractNode)startNode._folderNodeList.get(i);
            if (!searchNode.getName().equals(pathList.peek())) continue;
            pathList.removeFirst();
            if (pathList.isEmpty()) {
                return searchNode;
            }
            return this.searchForChildNodeByName(searchNode, pathList);
        }
        return null;
    }

    public ElementInterface findMemberById(BIAbstractNode startNode, String fqid) {
        if (startNode == null) {
            return null;
        }
        ElementInterface foundElement = null;
        foundElement = FolderViewUtil.checkNodeForElement(startNode, fqid);
        if (foundElement != null) {
            return foundElement;
        }
        if (startNode.foldersPopulated()) {
            for (int i = 0; i < startNode._folderNodeList.size(); ++i) {
                BIAbstractNode folderNode = (BIAbstractNode)startNode._folderNodeList.get(i);
                foundElement = FolderViewUtil.checkNodeForElement(folderNode, fqid);
                if (foundElement != null) {
                    return foundElement;
                }
                foundElement = this.searchBranchForElement(folderNode, fqid);
                if (foundElement == null) continue;
                return foundElement;
            }
        }
        return null;
    }

    protected ElementInterface searchBranchForElement(BIAbstractNode startNode, String fqid) {
        ElementInterface foundElement = null;
        foundElement = FolderViewUtil.checkNodeForElement(startNode, fqid);
        if (foundElement != null) {
            return foundElement;
        }
        if (startNode.foldersPopulated()) {
            for (int i = 0; i < startNode._folderNodeList.size(); ++i) {
                BIAbstractNode folderNode = (BIAbstractNode)startNode._folderNodeList.get(i);
                foundElement = FolderViewUtil.checkNodeForElement(folderNode, fqid);
                if (foundElement != null) {
                    return foundElement;
                }
                foundElement = this.searchBranchForElement(folderNode, fqid);
                if (foundElement == null) continue;
                return foundElement;
            }
        }
        return null;
    }

    public BIAbstractNode findNodeById(BIAbstractNode startNode, String fqid) {
        block10: {
            if (startNode == null || fqid == null) {
                return null;
            }
            try {
                FolderNode folderNode;
                if (startNode instanceof FolderNode && (folderNode = (FolderNode)startNode).getTree().getFQID().equals(fqid)) {
                    return folderNode;
                }
                if (!startNode.foldersPopulated()) break block10;
                for (int i = 0; i < startNode._folderNodeList.size(); ++i) {
                    String id;
                    BIAbstractNode folderNode2;
                    block11: {
                        folderNode2 = (BIAbstractNode)startNode._folderNodeList.get(i);
                        id = "";
                        if (folderNode2.getContainerInterface() == null) {
                            try {
                                id = folderNode2.getLogicalObjectInterface().getID();
                                break block11;
                            }
                            catch (LogicalTypeException e) {
                                Workspace.getDefaultLogger().error((Object)(" ConsoleFolderTree:findNodeById:" + e.getLocalizedMessage()));
                                continue;
                            }
                        }
                        id = folderNode2.getContainerInterface().getIdentifier();
                    }
                    if (id.equals(fqid)) {
                        return folderNode2;
                    }
                    BIAbstractNode branchNode = this.searchBranchForNode(folderNode2, fqid);
                    if (branchNode == null) continue;
                    return branchNode;
                }
            }
            catch (RemoteException e) {
                Workspace.getDefaultLogger().error((Object)(" ConsoleFolderTree:findNodeById:" + e.getLocalizedMessage()));
            }
            catch (ServiceException e) {
                return null;
            }
        }
        return null;
    }

    protected BIAbstractNode searchBranchForNode(BIAbstractNode startNode, String fqid) {
        if (startNode.foldersPopulated()) {
            for (int i = 0; i < startNode._folderNodeList.size(); ++i) {
                BIAbstractNode searchNode = (BIAbstractNode)startNode._folderNodeList.get(i);
                try {
                    String id = "";
                    if (searchNode.getContainerInterface() == null) {
                        try {
                            id = searchNode.getLogicalObjectInterface().getID();
                        }
                        catch (LogicalTypeException e) {
                            Workspace.getDefaultLogger().debug((Object)("ConsoleFolderTree:Could not find logical object for " + searchNode.getName()));
                        }
                    } else {
                        id = searchNode.getContainerInterface().getIdentifier();
                    }
                    if (id.equals(fqid)) {
                        return searchNode;
                    }
                }
                catch (RemoteException e) {
                    Workspace.getDefaultLogger().error((Object)(" ConsoleFolderTree:searchBranchForNode:" + e.getLocalizedMessage()));
                }
                catch (ServiceException e) {
                    Workspace.getDefaultLogger().error((Object)(" ConsoleFolderTree:searchBranchForNode:" + e.getLocalizedMessage()));
                }
                BIAbstractNode branchNode = this.searchBranchForNode(searchNode, fqid);
                if (branchNode == null) continue;
                return branchNode;
            }
        }
        return null;
    }

    public RootNode getRootNode() {
        return this._rootNode;
    }

    public HomeFolderNode getHomeFolderNode() {
        return (HomeFolderNode)this.getRootFolderNode(FolderViewUtil.getLocalizedHomeFolderName());
    }

    public boolean nodeIsChildOfUserHomeFolder(BIAbstractNode searchNode) {
        if (searchNode == null) {
            return false;
        }
        FolderNode userHomeFolderNode = null;
        boolean isChild = false;
        userHomeFolderNode = (FolderNode)this.findNodeByPath(this.m_folderView.getUserHomeFolderPath());
        if (userHomeFolderNode != null) {
            isChild = searchNode.isDescendantOf(userHomeFolderNode);
        }
        return isChild;
    }

    public boolean nodeIsChildOfMyFolder(BIAbstractNode searchNode) {
        HomeFolderNode homeFolderNode = null;
        boolean isChild = false;
        homeFolderNode = this.getHomeFolderNode();
        if (homeFolderNode != null && searchNode != null) {
            isChild = searchNode.isDescendantOf(homeFolderNode);
        }
        return isChild;
    }

    public static boolean nodeIsFavorite(BIAbstractNode node) {
        String typeName = node.getTypeName();
        return typeName.equals("FavoritesFolder");
    }

    private static boolean isTypeContainedByFolder(String publicType) throws ServiceException, RemoteException {
        Factory factory;
        TypeDescriptorInterface descriptor;
        return publicType != null && ((descriptor = (factory = Factory.getInstance()).getTypeDescriptorFromTypeDictionary(publicType)) != null && descriptor.getContainerType() != null || descriptor.getContainerType().length() != 0);
    }

    public class FolderTreeSelectionModel
    extends DefaultTreeSelectionModel
    implements FolderViewListener {
        private static final long serialVersionUID = 9200000001L;

        public FolderTreeSelectionModel() {
            this.setSelectionMode(1);
        }

        @Override
        public void folderViewChanged(FolderViewEvent evt) {
            int eventType = evt.getEventType();
            NodeInterface parent = evt.getParentNode();
            TreePath eventPath = parent.getTreePath();
            TreePath selPath = null;
            switch (eventType) {
                case 2: {
                    TreePath treePath = this.getLeadSelectionPath();
                    if (treePath == null || (selPath = treePath.getParentPath()) == null || !eventPath.toString().equals(selPath.toString())) break;
                    ConsoleFolderTree.this.makeVisible(selPath);
                    this.setSelectionPath(selPath);
                    ConsoleFolderTree.this.scrollPathToVisible(selPath);
                    break;
                }
                case 16: {
                    TreePath leadSelectionPath = this.getLeadSelectionPath();
                    if (leadSelectionPath != null) {
                        selPath = leadSelectionPath.getParentPath();
                        ConsoleFolderTree.this.makeVisible(eventPath);
                        this.setSelectionPath(eventPath);
                        ConsoleFolderTree.this.scrollPathToVisible(eventPath);
                    }
                    if (ConsoleFolderTree.this.hasFocus()) break;
                    ConsoleFolderTree.this.requestFocus();
                    break;
                }
                case 8: {
                    TreePath currentPath = this.getSelectionPath();
                    if (currentPath != null) break;
                    this.setSelectionPath(eventPath);
                    break;
                }
            }
        }
    }

    class FolderTreeCellRenderer
    extends DefaultTreeCellRenderer
    implements TreeCellRenderer {
        private static final long serialVersionUID = 9200000001L;

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            JLabel label = new JLabel();
            FontUtil.setFontForHC(label);
            int iconSize = 16;
            if (value instanceof BIAbstractNode) {
                BIAbstractNode node = (BIAbstractNode)value;
                label.setText(node.getName());
                label.setIcon(node.getIcon(iconSize));
            }
            label.setOpaque(true);
            int treeLastSelected = ConsoleFolderTree.this.m_console.getViewLastSelected();
            if (selected && treeLastSelected == 1 && hasFocus) {
                label.setBackground(SystemColor.textHighlight);
                label.setForeground(SystemColor.textHighlightText);
            } else if (selected && treeLastSelected != 1 || selected && treeLastSelected == 1 && !hasFocus) {
                Color background = UIManager.getColor("TextField.inactiveForeground");
                Color foreground = UIManager.getColor("TextField.inactiveBackground");
                if (foreground == null) {
                    foreground = UIManager.getColor("TextField.background");
                }
                label.setBackground(background);
                label.setForeground(foreground);
            } else {
                label.setBackground(UIManager.getColor("List.background"));
                label.setForeground(SystemColor.textText);
            }
            return label;
        }
    }

    class FolderTreeFocusListener
    implements FocusListener {
        FolderTreeFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent event) {
            ConsoleFolderTree.this.m_console.checkIServerStatus();
            if (ConsoleViewManager.getCurrentViewType() != 1) {
                return;
            }
            NodeInterface node = (NodeInterface)ConsoleFolderTree.this.getLastSelectedPathComponent();
            if (node == null) {
                return;
            }
            ConsoleFolderTree.this.m_console.setViewLastSelected(1);
            ConsoleFolderTree.this.m_console.setTreeLastSelected(true);
            if (ConsoleFolderTree.this.m_console.getDefaultRepository() == null) {
                return;
            }
            if (!ConsoleFolderTree.this.m_console.getToolBarUpdated()) {
                List actionList = node.getToolBarActions();
                Action[] extendedActions = ConsoleFolderTree.this.m_console.getExtendedToolBarActions(node);
                for (int index = 0; extendedActions != null && index < extendedActions.length; ++index) {
                    actionList.add(extendedActions[index]);
                }
                ConsoleFolderTree.this.m_console.updateToolBar(actionList);
                ConsoleFolderTree.this.m_console.updateMenuBar(true);
            }
            if (!(node instanceof SearchFolderNode)) {
                ConsoleFolderTree.this.m_console.refreshStatusLineText(node);
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
            ConsoleFolderTree.this.m_console.setToolBarUpdated(false);
        }
    }

    protected class FolderTreeKeyListener
    extends KeyAdapter {
        @Override
        public void keyPressed(KeyEvent e) {
            switch (e.getKeyCode()) {
                case 127: {
                    DeleteAction deleteAction = new DeleteAction(ConsoleFolderTree.this.m_console);
                    deleteAction.actionPerformed(null);
                    break;
                }
                case 121: {
                    if ((e.getModifiersEx() & 0x40) == 0) break;
                    e.consume();
                    Rectangle rect = ConsoleFolderTree.this.getPathBounds(ConsoleFolderTree.this.getLeadSelectionPath());
                    Point pt = rect.getLocation();
                    MouseEvent me = new MouseEvent((Component)e.getSource(), 501, 0L, 0, pt.x + rect.width / 2, pt.y + rect.height / 2, 1, true);
                    int selectedRow = ConsoleFolderTree.this.getRowForLocation(me.getX(), me.getY());
                    TreePath selectedPath = ConsoleFolderTree.this.getPathForLocation(me.getX(), me.getY());
                    if (selectedRow == -1) break;
                    ConsoleFolderTree.this.setSelectionRow(selectedRow);
                    ConsoleFolderTree.this._buildPopupMenu(selectedPath);
                    ConsoleFolderTree.this.m_popMenu.show(me.getComponent(), me.getX(), me.getY());
                    break;
                }
                case 525: {
                    e.consume();
                    Rectangle rect = ConsoleFolderTree.this.getPathBounds(ConsoleFolderTree.this.getLeadSelectionPath());
                    Point pt = rect.getLocation();
                    MouseEvent me = new MouseEvent((Component)e.getSource(), 501, 0L, 0, pt.x + rect.width / 2, pt.y + rect.height / 2, 1, true);
                    int selectedRow = ConsoleFolderTree.this.getRowForLocation(me.getX(), me.getY());
                    TreePath selectedPath = ConsoleFolderTree.this.getPathForLocation(me.getX(), me.getY());
                    if (selectedRow == -1) break;
                    ConsoleFolderTree.this.setSelectionRow(selectedRow);
                    ConsoleFolderTree.this._buildPopupMenu(selectedPath);
                    ConsoleFolderTree.this.m_popMenu.show(me.getComponent(), me.getX(), me.getY());
                    break;
                }
                case 67: {
                    if (!e.isControlDown()) break;
                    e.consume();
                    CopyAction copyAction = new CopyAction();
                    copyAction.actionPerformed(new ActionEvent(e.getSource(), e.getID(), ""));
                    break;
                }
                case 86: {
                    if (!e.isControlDown()) break;
                    e.consume();
                    PasteAction pasteAction = new PasteAction();
                    pasteAction.actionPerformed(new ActionEvent(e.getSource(), e.getID(), ""));
                    break;
                }
            }
        }
    }
}

