/*
 * Decompiled with CFR 0.152.
 */
package com.sas.console.folderview.visuals;

import com.sas.console.ConsoleChangeListener;
import com.sas.console.folderview.visuals.ActionRename;
import com.sas.console.folderview.visuals.BIActionInterface;
import com.sas.console.folderview.visuals.ConsoleFolderTree;
import com.sas.console.folderview.visuals.ConsoleFolderView;
import com.sas.console.folderview.visuals.ContainerItemInterface;
import com.sas.console.folderview.visuals.FolderNode;
import com.sas.console.folderview.visuals.FolderTreeModel;
import com.sas.console.folderview.visuals.FolderViewUtil;
import com.sas.console.folderview.visuals.HomeFolderItem;
import com.sas.console.folderview.visuals.LogicalTypesAndServicesAdapter;
import com.sas.console.folderview.visuals.NonFolderContainerItem;
import com.sas.console.folderview.visuals.NonFolderContainerNode;
import com.sas.console.folderview.visuals.RootFolderNode;
import com.sas.console.folderview.visuals.RootNode;
import com.sas.console.folderview.visuals.SearchFolderNode;
import com.sas.console.folderview.visuals.TableAbstractColumn;
import com.sas.console.folderview.visuals.TableColumnDescription;
import com.sas.console.folderview.visuals.TableColumnIcon;
import com.sas.console.folderview.visuals.TableColumnLastUpdated;
import com.sas.console.folderview.visuals.TableColumnName;
import com.sas.console.folderview.visuals.TableColumnType;
import com.sas.console.folderview.visuals.TableItem;
import com.sas.console.folderview.visuals.TableView;
import com.sas.console.plugins.AbstractNode;
import com.sas.console.plugins.CustomTableInterface;
import com.sas.console.plugins.CustomTablePane;
import com.sas.console.plugins.CustomViewInterface;
import com.sas.console.plugins.ElementInterface;
import com.sas.console.plugins.IntObjPair;
import com.sas.console.plugins.NodeInterface;
import com.sas.console.plugins.TableModelInterface;
import com.sas.console.visuals.ConsoleViewManager;
import com.sas.console.visuals.MainConsole;
import com.sas.metadata.logical.ActionContextInterface;
import com.sas.metadata.logical.ContainerChangeEvent;
import com.sas.metadata.logical.FolderInterface;
import com.sas.metadata.logical.LogicalObjectInterface;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.visuals.Config;
import com.sas.metadata.logical.visuals.UtilGui;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Tree;
import com.sas.services.ServiceException;
import com.sas.services.information.ChildServerInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.publicobject.PublicObjectContainerInterface;
import com.sas.services.information.publicobject.PublicObjectInterface;
import com.sas.services.information.sasfolders.ContainerNodeInterface;
import com.sas.services.information.sasfolders.PublicObjectNodeInterface;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.Workspace;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public abstract class BIAbstractNode
extends AbstractNode
implements ConsoleChangeListener {
    protected static TableView _viewBeingDisplayed;
    protected Vector _folderNodeList = new Vector();
    protected Vector _itemList = new Vector();
    protected MainConsole m_console;
    protected String m_name;
    protected ConsoleFolderView m_view;
    protected ContainerNodeInterface m_containerNodeInterface;
    protected LogicalObjectInterface m_logicalObject;
    protected FolderTreeModel m_model;
    private TableView _tableView;
    private TableAbstractColumn[] _columnModels;
    private boolean _memberListInitialized;
    private boolean _folderListInitialized;
    protected boolean m_isFavorite;

    BIAbstractNode(NodeInterface parent, String name) {
        super(parent, name);
        this.m_name = name;
        this.m_console = (MainConsole)ConsoleViewManager.getConsole();
        this.m_view = (ConsoleFolderView)ConsoleViewManager.getView(1);
    }

    public LogicalObjectInterface getLogicalObjectInterface() throws RemoteException, ServiceException, LogicalTypeException {
        if (this.m_logicalObject == null) {
            LogicalObjectInterface loi = null;
            try {
                loi = LogicalTypesAndServicesAdapter.getInstance().convertToLogicalObject((PublicObjectInterface)this.m_containerNodeInterface);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            if (loi != null && loi instanceof FolderInterface) {
                this.m_logicalObject = (FolderInterface)loi;
            }
        }
        return this.m_logicalObject;
    }

    public ContainerNodeInterface getContainerInterface() {
        return this.m_containerNodeInterface;
    }

    @Override
    public Enumeration children() {
        return this._folderNodeList.elements();
    }

    @Override
    public TreeNode getChildAt(int index) {
        return (BIAbstractNode)this._folderNodeList.get(index);
    }

    @Override
    public int getChildCount() {
        return this._folderNodeList.size();
    }

    @Override
    public int getIndex(TreeNode treeNode) {
        return this._folderNodeList.indexOf(treeNode);
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public void remove(MutableTreeNode node) {
        this._folderNodeList.remove(node);
    }

    @Override
    public void willExpand(TreeExpansionEvent event) throws ExpandVetoException {
        if (this._folderListInitialized) {
            return;
        }
        this.getContents(true, false);
    }

    @Override
    public void refresh() {
        this.getContents(true, true);
        this.updateTableVisual();
    }

    protected abstract void addElement(PublicObjectNodeInterface var1);

    private void getContents(boolean populateFolders, boolean populateMembers) {
        if (populateFolders) {
            this._folderNodeList.removeAllElements();
            this._itemList.removeAllElements();
        }
        if (!populateFolders && populateMembers) {
            this._itemList.setSize(this._folderNodeList.size());
        }
        if (!this.m_console.isConnected()) {
            return;
        }
        CMetadata defaultRepository = this.m_console.getDefaultRepository();
        if (defaultRepository == null) {
            return;
        }
        this.populateNode(populateFolders, populateMembers);
        if (populateFolders) {
            this._folderListInitialized = true;
        }
        if (populateMembers) {
            this._memberListInitialized = true;
        }
    }

    protected abstract void populateNode(boolean var1, boolean var2);

    @Override
    public List getToolBarActions() {
        if (this.m_console.getDefaultRepository() == null) {
            return null;
        }
        List actionList = this.constructActionList(false, true);
        for (int i = 0; i < actionList.size(); ++i) {
            AbstractAction aa = (AbstractAction)actionList.get(i);
            if (!(aa instanceof ActionRename)) continue;
            actionList.remove(i);
            break;
        }
        return actionList;
    }

    @Override
    public List getContextMenuActions() {
        if (this.m_console.getDefaultRepository() == null) {
            return null;
        }
        return this.constructActionList(true, true);
    }

    List constructActionList(boolean separatorsSupported, boolean isNodeSelected) {
        return this.doConstructActionList(separatorsSupported, isNodeSelected);
    }

    protected abstract List doConstructActionList(boolean var1, boolean var2);

    protected List getElementsOfInterestToBIActionInterface(BIActionInterface biai) {
        ArrayList<TableItem> list = new ArrayList<TableItem>(0);
        Set supportedLogicalNames = biai.getLogicalTypeNamesOfInterest();
        Iterator it = this._itemList.iterator();
        try {
            while (it.hasNext()) {
                TableItem ti;
                PublicObjectInterface node;
                Object o = it.next();
                if (!(o instanceof TableItem) || (node = (ti = (TableItem)o).getPublicObjectInterface()) == null || node.getTypeDescriptor() == null || !supportedLogicalNames.contains(node.getTypeDescriptor().getTypeName())) continue;
                list.add(ti);
            }
        }
        catch (ServiceException e) {
            UtilGui.displayInternalError((String)e.getLocalizedMessage());
        }
        catch (RemoteException re) {
            UtilGui.displayRemoteException((RemoteException)re);
        }
        return list;
    }

    @Override
    public TableModelInterface getListViewData() {
        return null;
    }

    @Override
    public CustomViewInterface getCustomView() {
        if (!this._folderListInitialized && !this._memberListInitialized) {
            this.getContents(true, true);
        } else if (!this._memberListInitialized) {
            this.getContents(false, true);
        }
        if (this._tableView == null) {
            this.setCustomView();
        }
        _viewBeingDisplayed = this._tableView;
        return this._tableView;
    }

    public abstract TableItem getItem();

    private void setCustomView() {
        this._columnModels = new TableAbstractColumn[TableAbstractColumn.NUMBER_OF_COLUMNS];
        this._columnModels[0] = new TableColumnIcon(this, this._itemList);
        this._columnModels[1] = new TableColumnName(this, this._itemList);
        this._columnModels[2] = new TableColumnDescription(this, this._itemList);
        this._columnModels[3] = new TableColumnType(this, this._itemList);
        this._columnModels[4] = new TableColumnLastUpdated(this, this._itemList);
        this._tableView = new TableView(this, this._columnModels, TableAbstractColumn.NUMBER_OF_COLUMNS, this._itemList, "com.sas.console.folderview.visuals.RightPaneCustomTable");
        CustomTableInterface customTable = (CustomTableInterface)((Object)this._tableView.getComponent());
        customTable.setRowHeaderVisible(false);
        customTable.restoreSettings();
    }

    void updateTableVisual() {
        if (this._tableView == null) {
            return;
        }
        CustomTableInterface customTable = (CustomTableInterface)((Object)this._tableView.getComponent());
        customTable.refresh(this._columnModels, this._itemList.size());
    }

    void updateTableVisual(int rowIndex) {
        if (this._tableView == null) {
            return;
        }
        CustomTableInterface customTable = (CustomTableInterface)((Object)this._tableView.getComponent());
        customTable.refreshRow(rowIndex);
    }

    protected void deleteRowFromVisual(int rowIndex) {
        if (rowIndex < 0 || this._tableView == null) {
            return;
        }
        CustomTableInterface customTable = (CustomTableInterface)((Object)this._tableView.getComponent());
        customTable.deleteRow(rowIndex);
    }

    private void deleteRowFromVisual(ElementInterface ei) {
        if (this._tableView == null) {
            return;
        }
        CustomTablePane customTable = (CustomTablePane)this._tableView.getComponent();
        TableItem tableItem = (TableItem)ei;
        try {
            String type = tableItem.getPublicObjectInterface().getTypeDescriptor().getType();
            int deleteRow = customTable.getRow(ei.getName(), type);
            this.deleteRowFromVisual(customTable.convertRowIndexToModel(deleteRow));
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    BIAbstractNode addFolder(ContainerNodeInterface containerNode) throws LogicalTypeException, ServiceException {
        try {
            BIAbstractNode fn = null;
            boolean isSearchNode = false;
            if (containerNode.getTypeDescriptor().getTypeName().equalsIgnoreCase("SearchFolder")) {
                isSearchNode = true;
            }
            fn = this instanceof RootNode ? new RootFolderNode(this, containerNode) : (this instanceof FolderNode ? (containerNode instanceof com.sas.services.information.sasfolders.FolderNode ? new FolderNode(this, containerNode) : (isSearchNode ? new SearchFolderNode(this, containerNode) : new NonFolderContainerNode(this, containerNode))) : new NonFolderContainerNode(this, containerNode));
            this._folderNodeList.add(fn);
            this._itemList.add(fn.getItem());
            Collections.sort(this._folderNodeList);
            Collections.sort(this._itemList);
            this.updateTableVisual();
            return fn;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return null;
        }
    }

    public void addFolderToVisual(ContainerNodeInterface containerInterface) {
        try {
            if (FolderViewUtil.checkNodeForElement(this, containerInterface.getIdentifier()) == null) {
                BIAbstractNode childNode = this.addFolder(containerInterface);
                int indexToAdd = this.getIndex(childNode);
                Vector<IntObjPair> childList = new Vector<IntObjPair>();
                IntObjPair ioPair = new IntObjPair(indexToAdd, childNode);
                childList.add(ioPair);
                this.m_view.fireFolderViewChange(1, this, childList);
                this.updateTableVisual();
            }
        }
        catch (LogicalTypeException lte) {
            UtilGui.displayExceptionError((Exception)((Object)lte));
        }
        catch (ServiceException e) {
            UtilGui.displayExceptionError((Exception)((Object)e));
        }
        catch (RemoteException e) {
            UtilGui.displayExceptionError((Exception)e);
        }
    }

    public void addChildContainerToVisual(PublicObjectInterface containerPublicObject) {
        try {
            BIAbstractNode childNode = this.addContainer(containerPublicObject);
            int indexToAdd = this.getIndex(childNode);
            Vector<IntObjPair> childList = new Vector<IntObjPair>();
            IntObjPair ioPair = new IntObjPair(indexToAdd, childNode);
            childList.add(ioPair);
            this.m_view.fireFolderViewChange(1, this, childList);
            this.updateTableVisual();
        }
        catch (LogicalTypeException lte) {
            UtilGui.displayExceptionError((Exception)((Object)lte));
        }
    }

    public void addMemberToVisual(PublicObjectNodeInterface member) {
        this.addElement(member);
        this.updateTableVisual();
    }

    public void updateMemberInVisual(String fqid) {
        for (TableItem tableItem : this._itemList) {
            PublicObjectInterface member = tableItem.getPublicObjectInterface();
            try {
                if (!member.getIdentifier().equalsIgnoreCase(fqid)) continue;
                tableItem.refreshObjectFromServerAndUpdateTable();
                break;
            }
            catch (ServiceException e) {
                UtilGui.displayInternalError((String)e.getLocalizedMessage());
            }
            catch (RemoteException re) {
                UtilGui.displayRemoteException((RemoteException)re);
            }
        }
    }

    public boolean isDescendantOf(NodeInterface node) {
        return node.getTreePath().isDescendant(this.getTreePath());
    }

    public int removeElement(ElementInterface ei) {
        int indexOfItemBeforeDelete = this._itemList.indexOf(ei);
        this._itemList.remove(ei);
        if (ei instanceof HomeFolderItem) {
            this._folderNodeList.remove(0);
        }
        return indexOfItemBeforeDelete;
    }

    public void removeElementFromVisual(ElementInterface ei) {
        this.removeElement(ei);
        this.deleteRowFromVisual(ei);
    }

    public void updateFolderInVisual(Tree tree) throws RemoteException, MdException, ServiceException {
        boolean found = false;
        Iterator it = this._itemList.iterator();
        TableItem foundTableItem = null;
        while (it.hasNext()) {
            TableItem tableItem = (TableItem)it.next();
            LogicalObjectInterface loi = tableItem.getLogicalObjectInterface();
            if (!loi.getID().equalsIgnoreCase(tree.getFQID())) continue;
            tableItem.refreshObjectFromServerAndUpdateTable();
            foundTableItem = tableItem;
            foundTableItem.setPublicObjectInterface(LogicalTypesAndServicesAdapter.getInstance().convertToPublicObject((Root)tree));
            found = true;
            break;
        }
        if (found) {
            BIAbstractNode parent = (BIAbstractNode)foundTableItem.getNode();
            FolderNode folderNode = (FolderNode)foundTableItem.getCorrespondingNode();
            folderNode.setName(foundTableItem.getName());
            int index = parent.getIndex(folderNode);
            Vector<IntObjPair> childList = new Vector<IntObjPair>();
            IntObjPair ioPair = new IntObjPair(index, folderNode);
            childList.add(ioPair);
            this.m_view.fireFolderViewChange(4, parent, childList);
        }
    }

    public void updateContainerInVisual(PublicObjectInterface publicObject) throws RemoteException, MdException, ServiceException {
        boolean found = false;
        Iterator it = this._itemList.iterator();
        TableItem foundTableItem = null;
        while (it.hasNext()) {
            TableItem tableItem = (TableItem)it.next();
            PublicObjectInterface po = tableItem.getPublicObjectInterface();
            if (!publicObject.getIdentifier().equalsIgnoreCase(po.getIdentifier())) continue;
            foundTableItem = (NonFolderContainerItem)tableItem;
            foundTableItem.setPublicObjectInterface(publicObject);
            foundTableItem.refreshObjectFromServerAndUpdateTable();
            found = true;
            break;
        }
        if (found) {
            NonFolderContainerNode containerNode = (NonFolderContainerNode)foundTableItem.getCorrespondingNode();
            BIAbstractNode parent = (BIAbstractNode)containerNode.getParent();
            containerNode.setName(foundTableItem.getName());
            int index = parent.getIndex(containerNode);
            Vector<IntObjPair> childList = new Vector<IntObjPair>();
            IntObjPair ioPair = new IntObjPair(index, containerNode);
            childList.add(ioPair);
            this.m_view.fireFolderViewChange(4, parent, childList);
        }
    }

    public boolean foldersPopulated() {
        return this._folderListInitialized;
    }

    protected boolean isFavorite() {
        boolean fav = false;
        if (this.getParent() != null) {
            BIAbstractNode parent = (BIAbstractNode)this.getParent();
            fav = this.checkContainedInFavorites(parent);
        }
        return fav;
    }

    private boolean checkContainedInFavorites(BIAbstractNode node) {
        boolean fav = false;
        fav = ConsoleFolderTree.nodeIsFavorite(node);
        if (!fav && node.getParent() != null) {
            fav = this.checkContainedInFavorites((BIAbstractNode)node.getParent());
        }
        return fav;
    }

    public String getTypeName() {
        ContainerNodeInterface cni = this.getContainerInterface();
        String typeName = "";
        try {
            if (cni != null) {
                typeName = cni.getTypeDescriptor().getTypeName();
            }
        }
        catch (ServiceException e) {
            return "";
        }
        catch (RemoteException e) {
            return "";
        }
        return typeName;
    }

    BIAbstractNode addContainer(PublicObjectInterface publicObject) throws LogicalTypeException {
        NonFolderContainerNode containerNode = null;
        try {
            containerNode = publicObject.getTypeDescriptor().getType().equalsIgnoreCase("SearchFolder") ? new SearchFolderNode(this, publicObject) : new NonFolderContainerNode(this, publicObject);
            this._folderNodeList.add(containerNode);
            this._itemList.add(containerNode.getItem());
            Collections.sort(this._folderNodeList);
            Collections.sort(this._itemList);
            this.updateTableVisual();
            return containerNode;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return null;
        }
        catch (ServiceException ex) {
            Workspace.handleServiceException((ServiceException)ex);
            return containerNode;
        }
    }

    public List<WAPropertyTab> getPropertyTabs(LogicalObjectInterface loi, ChildServerInterface transaction, MetadataInterface smartObject, Root jomaObject, Config config) throws RemoteException, MdException {
        return this.getItem().getPropertyTabs(loi, transaction, smartObject, jomaObject, config);
    }

    protected void checkForContextActions(Action action) {
        String context;
        if (action != null && action instanceof ActionContextInterface && "FAVORITES_CONTEXT".equals(context = ((ActionContextInterface)action).getActionContext())) {
            action.addPropertyChangeListener(new FavoritesChangeListener());
        }
    }

    private void removeContainerFromTreeAndTable(BIAbstractNode parentNode, ElementInterface containerItem) {
        if (parentNode == null || containerItem == null) {
            return;
        }
        if (containerItem instanceof ContainerItemInterface) {
            ContainerItemInterface ci = (ContainerItemInterface)((Object)containerItem);
            BIAbstractNode containerNode = ci.getCorrespondingNode();
            int indexOfNode = parentNode.getIndex(containerNode);
            ArrayList<IntObjPair> deleteChildList = new ArrayList<IntObjPair>();
            IntObjPair ioPair = new IntObjPair(indexOfNode, this);
            deleteChildList.add(ioPair);
            parentNode.removeElementFromVisual(containerItem);
            parentNode.remove(containerNode);
            if (deleteChildList.size() > 0) {
                this.m_view.fireFolderViewChange(2, parentNode, deleteChildList);
            }
        }
    }

    public class FavoritesChangeListener
    implements PropertyChangeListener {
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String eventName = evt.getPropertyName();
            PublicObjectNodeInterface pon = null;
            PublicObjectInterface poi = null;
            if (eventName.equals("CONTAINER_CHANGE_EVENT")) {
                ContainerChangeEvent event = (ContainerChangeEvent)evt.getNewValue();
                ContainerChangeEvent.EventType eventType = event.getEventType();
                try {
                    switch (eventType) {
                        case MEMBER_ADDED: {
                            NonFolderContainerNode containerNode;
                            BIAbstractNode parentNode;
                            poi = event.getMember();
                            if (poi != null) {
                                pon = BIAbstractNode.this.m_view.getSASFoldersModel().getObject(poi);
                            }
                            if (pon == null) break;
                            if (BIAbstractNode.this.m_console.getTreeLastSelected()) {
                                if (pon instanceof ContainerNodeInterface) {
                                    BIAbstractNode.this.addFolderToVisual((ContainerNodeInterface)pon);
                                    break;
                                }
                                BIAbstractNode.this.addMemberToVisual(pon);
                                break;
                            }
                            PublicObjectContainerInterface container = event.getContainer();
                            ElementInterface containerElement = FolderViewUtil.checkNodeForElement(BIAbstractNode.this, container.getIdentifier());
                            if (containerElement != null && containerElement instanceof ContainerItemInterface && (parentNode = ((ContainerItemInterface)((Object)containerElement)).getCorrespondingNode()) instanceof NonFolderContainerNode && (containerNode = (NonFolderContainerNode)parentNode).getMetadataObject().getCMetadataType().equalsIgnoreCase("FavoritesContainer")) {
                                ((NonFolderContainerNode)parentNode).addMemberToVisual(pon);
                            }
                            break;
                        }
                        case MEMBER_MODIFIED: {
                            break;
                        }
                        case MEMBER_REMOVED: {
                            poi = event.getMember();
                            BIAbstractNode parentNode = BIAbstractNode.this;
                            if (poi != null) {
                                pon = BIAbstractNode.this.m_view.getSASFoldersModel().getObject(poi);
                            }
                            if (pon == null) break;
                            ElementInterface ei = null;
                            if (pon.getIdentifier().equals(BIAbstractNode.this.getContainerInterface().getIdentifier())) {
                                parentNode = (BIAbstractNode)parentNode.getParent();
                            }
                            if ((ei = FolderViewUtil.checkNodeForElement(parentNode, pon.getIdentifier())) == null) break;
                            if (pon instanceof ContainerNodeInterface) {
                                BIAbstractNode.this.removeContainerFromTreeAndTable(parentNode, ei);
                                break;
                            }
                            BIAbstractNode.this.removeElementFromVisual(ei);
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

