/*
 * Decompiled with CFR 0.152.
 */
package com.sas.console.folderview.visuals;

import com.sas.console.folderview.visuals.BIAbstractNode;
import com.sas.console.folderview.visuals.ConsoleFolderView;
import com.sas.console.folderview.visuals.Images;
import com.sas.console.folderview.visuals.RB;
import com.sas.console.folderview.visuals.TableItem;
import com.sas.console.utils.MnemonicModel;
import com.sas.console.visuals.ConsoleViewManager;
import com.sas.metadata.logical.FolderInterface;
import com.sas.metadata.logical.LogicalObjectInterface;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.OperationUserInteractionInterface;
import com.sas.metadata.logical.visuals.AbstractOperationUserInteraction;
import com.sas.metadata.logical.visuals.TextInputDialog;
import com.sas.metadata.remote.Root;
import com.sas.services.ServiceException;
import com.sas.services.information.sasfolders.PublicObjectNodeInterface;
import com.sas.services.information.sasfolders.SASFoldersModelInterface;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.Workspace;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import javax.swing.AbstractAction;

final class ActionRename
extends AbstractAction {
    private static final long serialVersionUID = 9200000001L;
    private BIAbstractNode _node;
    private TableItem _tableItem;
    private LogicalObjectInterface _loi;
    private PublicObjectNodeInterface _poi;
    private Root _metadataObject;

    ActionRename(BIAbstractNode folderNode) throws RemoteException, ServiceException, LogicalTypeException {
        this._node = folderNode;
        this._loi = this._node.getLogicalObjectInterface();
        this._poi = this._node.getContainerInterface();
        this._metadataObject = this._node.getMetadataObject();
        MnemonicModel.setActionTextAndMnemonic(this, RB.getStringResource("AR.CtxtMenuItm.txt"), RB.getStringResource("AR.ToolTip.txt"), Images.getRenameIcon16());
    }

    ActionRename(TableItem item) {
        this._tableItem = item;
        this._loi = this._tableItem.getLogicalObjectInterface();
        this._poi = this._tableItem.getPublicObjectNodeInterface();
        this._metadataObject = this._tableItem.getRoot();
        MnemonicModel.setActionTextAndMnemonic(this, RB.getStringResource("AR.CtxtMenuItm.txt"), RB.getStringResource("AR.ToolTip.txt"), Images.getRenameIcon16());
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String originalName;
        String title;
        String message;
        int answer;
        if (this._loi instanceof FolderInterface && ((FolderInterface)this._loi).isSystem() && (answer = MessageUtil.displayMessage((String)(message = MessageFormat.format(RB.getStringResource("AR.SystemFolderWarning.txt"), new String(this._loi.getName()))), (String)(title = RB.getStringResource("AR.SystemFolderWarning.Title.txt")), (int)2, (int)0)) == 1) {
            return;
        }
        String previousNameToDisplay = originalName = this._loi.getName();
        Workspace frame = Workspace.getWorkspace();
        String newName;
        while ((newName = TextInputDialog.showInputDialog((Frame)frame, (String)RB.getStringResource("AR.DlgTitle.txt"), (String)RB.getStringResource("AR.DlgMsg.txt"), (int)60, (String)previousNameToDisplay)) != null) {
            if (newName.equals(originalName)) {
                return;
            }
            previousNameToDisplay = newName;
            try {
                this._loi.isValidName(newName);
            }
            catch (LogicalTypeException lte) {
                MessageUtil.displayMessage((String)lte.getMessage(), (String)RB.getStringResource("COM.ErrDlgTitle.txt"), (int)0, (int)-1);
                continue;
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
                MessageUtil.displayMessage((String)ex.getMessage(), (String)RB.getStringResource("COM.ErrDlgTitle.txt"), (int)0, (int)-1);
                continue;
            }
            AbstractOperationUserInteraction oui = new AbstractOperationUserInteraction(){

                public void updateProgress(String name) {
                }
            };
            try {
                this._loi.rename(newName, (OperationUserInteractionInterface)oui);
                if (this._metadataObject != null) {
                    this._loi.refresh(this._metadataObject);
                }
                if (this._poi != null) {
                    ConsoleFolderView folderView = (ConsoleFolderView)ConsoleViewManager.getView(1);
                    SASFoldersModelInterface folderModel = folderView.getSASFoldersModel();
                    try {
                        this._poi = folderModel.getObject(this._loi.getID(), this._loi.getTypeInterface().getPublicType());
                    }
                    catch (ServiceException serviceException) {
                        // empty catch block
                    }
                }
                if (this._node != null) {
                    this._node.setName(newName);
                }
                return;
            }
            catch (LogicalTypeException e) {
                String errorMessage = MessageFormat.format(RB.getStringResource("AR.RenameFailed.txt"), new String(this._loi.getName()));
                MessageUtil.displayDetailsMessage((String)errorMessage, (String)e.getLocalizedMessage());
                continue;
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
                MessageUtil.displayMessage((String)ex.getMessage(), (String)RB.getStringResource("COM.ErrDlgTitle.txt"), (int)0, (int)-1);
                continue;
            }
            break;
        }
        return;
    }
}

