/*
 * Decompiled with CFR 0.152.
 */
package com.sas.console.folderview.visuals;

import com.sas.console.folderview.visuals.FolderNode;
import com.sas.console.folderview.visuals.FolderViewUtil;
import com.sas.console.folderview.visuals.RB;
import com.sas.console.folderview.visuals.RootNode;
import com.sas.console.utils.MnemonicModel;
import com.sas.metadata.logical.FolderInterface;
import com.sas.metadata.promotion.ImportSummaryInterface;
import com.sas.metadata.promotion.visuals.CopyPasteManager;
import com.sas.services.ServiceException;
import com.sas.services.information.publicobject.PublicObjectContainerInterface;
import com.sas.services.information.publicobject.PublicObjectInterface;
import com.sas.visuals.Resources;
import com.sas.workspace.WAdminResource;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;

final class ActionPasteSpecial
extends AbstractAction {
    private static final long serialVersionUID = 9200000001L;
    private FolderNode _folderNode;
    private RootNode _rootNode;

    private ActionPasteSpecial() {
        WAdminResource bundle = FolderViewUtil.getMainConsoleResourceBundle();
        MnemonicModel.setActionTextAndMnemonic(this, RB.getStringResource("APS.CtxtMenuItm.txt"), RB.getStringResource("APS.ToolTip.txt"), Resources.getImageIcon((String)bundle.getString("Common.BlankIcon.image"), (int)16));
        this._initialize();
    }

    ActionPasteSpecial(FolderNode folderNode) {
        this();
        this._folderNode = folderNode;
    }

    ActionPasteSpecial(RootNode rootNode) {
        this();
        this._rootNode = rootNode;
    }

    private void _initialize() {
    }

    @Override
    public void actionPerformed(ActionEvent unused) {
        if (this._folderNode != null) {
            try {
                CopyPasteManager.pasteSpecial((PublicObjectContainerInterface)this._folderNode.getContainerInterface());
                if (CopyPasteManager.objectsWerePasted()) {
                    this.convertPasteListToMap(CopyPasteManager.getCopyList());
                    FolderViewUtil.generateMdFactoryEvents(CopyPasteManager.getCopySummary());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            try {
                FolderInterface rootFolderLogicalObject = (FolderInterface)this._rootNode.getLogicalObjectInterface();
                if (rootFolderLogicalObject == null) {
                    return;
                }
                CopyPasteManager.pasteSpecial((PublicObjectContainerInterface)this._rootNode.getContainerInterface());
                if (CopyPasteManager.objectsWerePasted()) {
                    ImportSummaryInterface summary = CopyPasteManager.getCopySummary();
                    FolderViewUtil.generateMdFactoryEvents(summary);
                }
            }
            catch (RemoteException remoteException) {
            }
            catch (ServiceException serviceException) {
                // empty catch block
            }
        }
    }

    private Map convertPasteListToMap(List pasteList) {
        HashMap<String, String> returnMap = new HashMap<String, String>();
        for (int i = 0; i < pasteList.size(); ++i) {
            PublicObjectInterface po = (PublicObjectInterface)pasteList.get(i);
            String id = null;
            try {
                id = po.getIdentifier();
                returnMap.put(id, po.getTypeDescriptor().getMetadataType());
                continue;
            }
            catch (ServiceException e) {
                e.printStackTrace();
                continue;
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        return returnMap;
    }
}

