/*
 * Decompiled with CFR 0.152.
 */
package com.sas.console.folderview.visuals;

import com.sas.console.folderview.visuals.FolderViewUtil;
import com.sas.console.folderview.visuals.ImagesPromotion;
import com.sas.console.folderview.visuals.RB;
import com.sas.console.utils.MnemonicModel;
import com.sas.metadata.promotion.ImportSummaryInterface;
import com.sas.metadata.promotion.visuals.ImportWizard;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.remote.Tree;
import com.sas.services.information.publicobject.PublicObjectContainerInterface;
import com.sas.services.information.sasfolders.ContainerNodeInterface;
import com.sas.workspace.OpRequestUI;
import com.sas.workspace.WAdminResource;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

final class ActionImport
extends AbstractAction {
    private static final long serialVersionUID = 9200000001L;
    private Tree _tree;
    private SoftwareComponent _bipService;
    private String _title;
    private ContainerNodeInterface _container;

    ActionImport(Tree tree) {
        this._tree = tree;
        this.initialize();
    }

    ActionImport(SoftwareComponent bipService) {
        this._bipService = bipService;
        this.initialize();
    }

    ActionImport(ContainerNodeInterface container) {
        this._container = container;
        this.initialize();
    }

    private void initialize() {
        this._title = RB.getStringResource("AI.title.txt");
        MnemonicModel.setActionTextAndMnemonic(this, RB.getStringResource("AI.Name.txt"), this._title, ImagesPromotion.getImportIcon16());
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        ImportWizard wizard;
        if (this._tree != null) {
            wizard = new ImportWizard(this._tree, null, this._title);
        } else if (this._bipService != null) {
            wizard = new ImportWizard(this._bipService, null, this._title);
        } else if (this._container != null) {
            wizard = new ImportWizard((PublicObjectContainerInterface)this._container, null, this._title);
        } else {
            return;
        }
        wizard.setDescription(RB.getStringResource("AI.Desc.txt"));
        ImportSummaryInterface summary = null;
        if (wizard.getImportHandler() != null) {
            summary = wizard.getImportHandler().getImportSummary();
        }
        wizard.show();
        if (wizard.getReturnValue() == 1 && wizard.objectsWereImported() && summary != null) {
            WAdminResource bundle = FolderViewUtil.getMainConsoleResourceBundle();
            String title = bundle.getString("MainConsole.Title.txt");
            OpRequestUI threadUI = new OpRequestUI(RB.getStringResource("AI.Progress.txt"));
            threadUI.setTitle(title);
            threadUI.setDelayBeforeProgressCancelDialog(1000);
            threadUI.execute((Runnable)new ImportRunnable(summary));
        }
    }

    private class ImportRunnable
    implements Runnable {
        ImportSummaryInterface m_summary;

        public ImportRunnable(ImportSummaryInterface summary) {
            this.m_summary = summary;
        }

        @Override
        public void run() {
            FolderViewUtil.generateMdFactoryEvents(this.m_summary);
        }
    }
}

