/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.themes.dao.registry;

import com.sas.framework.themes.dao.registry.ThemeRegistrationDAOInterface;
import com.sas.svcs.config.client.ApplicationRegistration;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;

public class PropertiesThemeRegistrationDAO
implements ThemeRegistrationDAOInterface {
    private static final String FILE_PROTOCOL = "file";
    private static final String FILE = ".file";
    public static final String THEME_NAMES = "theme.names";
    public static final String PROTOCOL = ".protocol";
    public static final String HOST = ".host";
    public static final String PORT = ".port";
    public static final String CONTEXT = ".context";
    private Properties props;

    public void setProperties(Properties p) {
        this.props = p;
    }

    @Override
    public void reload() {
    }

    @Override
    public ApplicationRegistration getTheme(String name) {
        ApplicationRegistration r = new ApplicationRegistration();
        r.setName(name);
        r.setProtocol(this.props.getProperty(name + PROTOCOL));
        r.setHost(this.props.getProperty(name + HOST));
        int port = Integer.parseInt(this.props.getProperty(name + PORT));
        r.setPort(port);
        r.setContext(this.props.getProperty(name + CONTEXT));
        return r;
    }

    public List getAllThemes() {
        ArrayList<ApplicationRegistration> list = new ArrayList<ApplicationRegistration>();
        String names = this.props.getProperty(THEME_NAMES);
        StringTokenizer tokens = new StringTokenizer(names, ",");
        while (tokens.hasMoreTokens()) {
            ApplicationRegistration r = new ApplicationRegistration();
            String next = tokens.nextToken();
            r.setName(next);
            if (!FILE_PROTOCOL.equals(this.props.getProperty(next + PROTOCOL))) {
                r.setProtocol(this.props.getProperty(next + PROTOCOL));
                r.setHost(this.props.getProperty(next + HOST));
                int port = Integer.parseInt(this.props.getProperty(next + PORT));
                r.setPort(port);
                r.setContext(this.props.getProperty(next + CONTEXT));
            } else {
                r.setProtocol(FILE_PROTOCOL);
                r.setContext(this.props.getProperty(next + FILE));
            }
            list.add(r);
        }
        return list;
    }
}

