/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.themes.client;

import com.sas.framework.commons.util.CollectionUtil;
import com.sas.framework.themes.client.BaseThemeElement;
import com.sas.framework.themes.client.BrowserType;
import com.sas.framework.themes.client.Image;
import com.sas.framework.themes.client.MediaType;
import com.sas.framework.themes.client.Style;
import com.sas.framework.themes.client.Template;
import com.sas.framework.themes.client.ThemeException;
import com.sas.util.Strings;
import com.sas.util.UsageVersion;
import com.sas.util.ValidateArg;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Theme
implements Serializable {
    static final long serialVersionUID = 1L;
    private static final Logger logger = LogManager.getLogger(Theme.class);
    private String name;
    private String label;
    private String description;
    private String device;
    private String urlPrefix;
    private String internalUrlPrefix;
    private String bundle;
    private String version;
    private String path;
    private String uriPath;
    private HashMap directories = new HashMap();
    private final HashMap imageMap = new HashMap();
    private final HashMap styleMap = new HashMap();
    private HashMap templateMap = new HashMap();

    public final synchronized Theme newRightToLeftTheme() {
        BaseThemeElement rtl;
        BaseThemeElement original;
        Set entries;
        Theme retVal = new Theme();
        retVal.bundle = this.bundle;
        retVal.description = this.description;
        retVal.device = this.device;
        retVal.directories = this.directories;
        retVal.label = this.label;
        retVal.name = this.name;
        retVal.path = this.path;
        retVal.templateMap = this.templateMap;
        retVal.uriPath = this.uriPath;
        retVal.urlPrefix = this.urlPrefix;
        retVal.version = this.version;
        if (!this.imageMap.isEmpty()) {
            retVal.imageMap.putAll(this.imageMap);
            entries = retVal.imageMap.entrySet();
            for (Map.Entry entry : entries) {
                original = (Image)entry.getValue();
                if (null == ((Image)original).getRightToLeftFileName() || ((Image)original).getRightToLeftFileName().length() < 1) continue;
                rtl = ((Image)original).newRightToLeftInstance();
                entry.setValue((Style)rtl);
            }
        }
        if (!this.styleMap.isEmpty()) {
            retVal.styleMap.putAll(this.styleMap);
            entries = retVal.styleMap.entrySet();
            for (Map.Entry entry : entries) {
                original = (Style)entry.getValue();
                rtl = ((Style)original).newRightToLeftInstance();
                entry.setValue((Style)rtl);
            }
        }
        return retVal;
    }

    public String getBundle() {
        return this.bundle;
    }

    public void setBundle(String bundle) {
        this.bundle = bundle;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String p) {
        this.path = p;
    }

    public String getUrlPrefix() {
        return this.urlPrefix;
    }

    public void setUrlPrefix(String u) {
        this.urlPrefix = u;
    }

    public String getInternalUrlPrefix() {
        return this.internalUrlPrefix;
    }

    public void setInternalUrlPrefix(String internalUrlPrefix) {
        this.internalUrlPrefix = internalUrlPrefix;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setDevice(String device) {
        this.device = device;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getName() {
        return this.name;
    }

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    public String getVersion() {
        return this.version;
    }

    public String getDevice() {
        return this.device;
    }

    private String getURIPath(String prefix) {
        String tmpUriPath = null;
        if (null != this.path) {
            tmpUriPath = null != prefix ? prefix + "/" + this.path : this.path;
        }
        return tmpUriPath;
    }

    public String getURIPath() {
        if (null == this.uriPath) {
            this.uriPath = this.getURIPath(this.urlPrefix);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("URI path is: " + this.uriPath);
        }
        return this.uriPath;
    }

    public String getInternalURIPath() {
        String result = this.getURIPath();
        if (null != this.internalUrlPrefix) {
            result = this.getURIPath(this.internalUrlPrefix);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Internal URI path is: " + this.uriPath);
        }
        return result;
    }

    public void addImage(Image image) {
        if (null == image.getStandardPath()) {
            image.setStandardPath(this.getFullPath("IMAGE"));
        }
        this.imageMap.put(image.getName(), image);
    }

    public void addStyleSheet(Style style) {
        this.styleMap.put(style.getName(), style);
    }

    public void addTemplate(Template template) {
        this.templateMap.put(template.getName(), template);
    }

    public void addDirectory(String type, String directory) {
        this.directories.put(type, directory);
    }

    public void merge(Theme old) {
        this.mergeImages(old.getAllImages());
        this.mergeStyles(old.getAllStyles());
        this.mergeTemplates(old.getAllTemplates());
    }

    private void mergeElements(Collection elements, Map current) {
        for (BaseThemeElement element : elements) {
            String nm = element.getName();
            if (current.containsKey(nm)) continue;
            current.put(nm, element);
        }
    }

    private void mergeImages(Collection images) {
        this.mergeElements(images, this.imageMap);
    }

    private void mergeStyles(Collection styles) {
        this.mergeElements(styles, this.styleMap);
    }

    private void mergeTemplates(Collection templates) {
        this.mergeElements(templates, this.templateMap);
    }

    public Image getImage(String nm) {
        return (Image)this.imageMap.get(nm);
    }

    public Style getStyle(String nm) {
        return (Style)this.styleMap.get(nm);
    }

    public Template getTemplate(String nm) {
        return (Template)this.templateMap.get(nm);
    }

    public Style getStyle(String nm, boolean check) {
        if (check) {
            if (this.isValidName("STYLE", nm)) {
                return this.getStyle(nm);
            }
            throw this.newThemeException(nm);
        }
        return this.getStyle(nm);
    }

    public Image getImage(String nm, boolean check) {
        if (check) {
            if (this.isValidName("IMAGE", nm)) {
                return this.getImage(nm);
            }
            throw this.newThemeException(nm);
        }
        return this.getImage(nm);
    }

    public Template getTemplate(String nm, boolean check) {
        if (check) {
            if (this.isValidName("TEMPLATE", nm)) {
                return this.getTemplate(nm);
            }
            throw this.newThemeException(nm);
        }
        return this.getTemplate(nm);
    }

    public Collection getStyleSheets(MediaType media) {
        Collection output = null;
        if (null != this.styleMap && !this.styleMap.isEmpty()) {
            TreeMap<Integer, List> tree = new TreeMap<Integer, List>();
            for (Style style : this.styleMap.values()) {
                if (!((Object)((Object)media)).equals((Object)style.getMediaType())) continue;
                List css = style.getStyleSheets(BrowserType.UNKNOWN.getKey());
                tree.put(style.getOrder(), css);
            }
            if (!tree.isEmpty()) {
                output = tree.values();
                if (logger.isDebugEnabled()) {
                    logger.debug("getStyleSheets() returning list with: " + output.size());
                }
            }
        }
        return CollectionUtil.flatten(output);
    }

    @Deprecated
    public Collection getStyleSheets(MediaType media, BrowserType browser) {
        return this.getStyleSheets(media, browser.getKey());
    }

    public Collection getStyleSheets(MediaType media, String browser) {
        Collection<Object> output = null;
        if (null != this.styleMap && !this.styleMap.isEmpty()) {
            TreeMap<Integer, List> tree = new TreeMap<Integer, List>();
            for (Style style : this.styleMap.values()) {
                if (!((Object)((Object)media)).equals((Object)style.getMediaType())) continue;
                List css = style.getStyleSheets(browser);
                tree.put(style.getOrder(), css);
            }
            if (!tree.isEmpty()) {
                output = tree.values();
                if (logger.isDebugEnabled()) {
                    logger.debug("getStyleSheets() returning list with: " + output.size());
                }
            }
        }
        output = null != output ? CollectionUtil.flatten(output) : Collections.EMPTY_LIST;
        return output;
    }

    public Collection getStyleSheetsForProduct(MediaType media, BrowserType browser, String styleNames) {
        return this.getStyleSheetsForNamedStyles(media, browser, styleNames);
    }

    @Deprecated
    public Collection getStyleSheetsForNamedStyles(MediaType media, BrowserType browser, String styleNames) {
        return this.getStyleSheetsForNamedStyles(media, browser.getKey(), styleNames);
    }

    public Collection getStyleSheetsForNamedStyles(MediaType media, String browser, String styleNames) {
        ValidateArg.notNull((Object)((Object)media), (String)"media");
        ValidateArg.notNull((Object)browser, (String)"browser");
        Collection<Object> output = null;
        ArrayList<String> list = new ArrayList<String>();
        if (null != styleNames && styleNames.length() > 0) {
            String[] namesArray = Strings.split((String)styleNames, (String)"", (String)",", null);
            if (null != namesArray && namesArray.length > 0) {
                for (int i = 0; i < namesArray.length; ++i) {
                    list.add(namesArray[i].trim());
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug("getStyleSheetsForProduct()- styleNames= " + styleNames);
            }
        }
        if (!list.contains("AppDev Studio")) {
            list.add("AppDev Studio");
        }
        if (null != this.styleMap && !this.styleMap.isEmpty()) {
            TreeMap<Integer, List> tree = new TreeMap<Integer, List>();
            for (Style style : this.styleMap.values()) {
                if (!list.contains(style.getName()) && !"ALL".equals(style.getProduct()) || !((Object)((Object)media)).equals((Object)style.getMediaType())) continue;
                List css = style.getStyleSheets(browser);
                tree.put(style.getOrder(), css);
            }
            if (!tree.isEmpty()) {
                output = tree.values();
                if (logger.isDebugEnabled()) {
                    logger.debug("getStyleSheets() returning list with: " + output.size());
                    logger.debug("media type is:" + media.getKey());
                    logger.debug("browser is:" + browser);
                }
            }
        }
        output = null != output ? CollectionUtil.flatten(output) : Collections.EMPTY_LIST;
        return output;
    }

    public boolean isValidName(String type, String nm) {
        HashMap map = null;
        if ("IMAGE".equals(type)) {
            map = this.imageMap;
        } else if ("STYLE".equals(type)) {
            map = this.styleMap;
        } else if ("TEMPLATE".equals(type)) {
            map = this.templateMap;
        } else {
            throw new IllegalArgumentException("The type parameter must be an ELEMENT_TYPE value in ThemeConstants.");
        }
        return null != map && null != nm ? map.containsKey(nm) : false;
    }

    public String getDirectory(String type) {
        if (!Theme.checkElementType(type)) {
            throw new IllegalArgumentException("The type parameter must be an ELEMENT_TYPE value in ThemeConstants.");
        }
        return (String)this.directories.get(type);
    }

    public Collection getImageNames() {
        Collection<Object> output = null;
        output = null != this.imageMap && !this.imageMap.isEmpty() ? this.imageMap.keySet() : Collections.EMPTY_LIST;
        return output;
    }

    public Collection getStyleNames() {
        Collection<Object> output = null;
        output = null != this.styleMap && !this.styleMap.isEmpty() ? this.styleMap.keySet() : Collections.EMPTY_LIST;
        return output;
    }

    public Collection getTemplateNames() {
        Collection<Object> output = null;
        output = null != this.templateMap && !this.templateMap.isEmpty() ? this.templateMap.keySet() : Collections.EMPTY_LIST;
        return output;
    }

    public String toString() {
        return this.getName() + " " + this.getLabel();
    }

    public Collection getAllImages() {
        return this.getAllElements(this.imageMap);
    }

    public Collection getAllStyles() {
        return this.getAllElements(this.styleMap);
    }

    public Collection getAllTemplates() {
        return this.getAllElements(this.templateMap);
    }

    private Collection getAllElements(Map map) {
        ArrayList<BaseThemeElement> col = new ArrayList<BaseThemeElement>();
        for (BaseThemeElement entry : map.values()) {
            col.add(entry);
        }
        return col;
    }

    public String getFullPath(String type) {
        String slash = "/";
        return this.getURIPath() + slash + this.getDirectory(type) + slash;
    }

    public String getInternalFullPath(String type) {
        String slash = "/";
        return this.getInternalURIPath() + slash + this.getDirectory(type) + slash;
    }

    private static boolean checkElementType(String type) {
        boolean result = false;
        if ("IMAGE".equals(type) || "STYLE".equals(type) || "TEMPLATE".equals(type)) {
            result = true;
        }
        return result;
    }

    private ThemeException newThemeException(String value) {
        Object[] val = new Object[]{value};
        ThemeException te = new ThemeException("The theme element, " + val + ", was not properly initialized.");
        return te;
    }

    public boolean isRightToLeftSupported() {
        return true;
    }

    public void setRightToLeftSupported(boolean rtlSupported) {
    }

    public UsageVersion getUsageVersion() {
        UsageVersion uv = new UsageVersion(0, 0);
        if (null != this.getVersion()) {
            try {
                uv = UsageVersion.parseVersion((String)this.getVersion());
            }
            catch (ParseException e) {
                logger.error(e.getMessage());
            }
            catch (IllegalArgumentException e) {
                logger.error(e.getMessage());
            }
        }
        return uv;
    }
}

