/*
 * Decompiled with CFR 0.152.
 */
package MITI.server.services.common.mir;

import MITI.sdk.MIRElementType;
import MITI.sdk.MIRObject;
import MITI.sdk.MIR_Object;
import MITI.server.services.common.mir.AttributeIdentifier;
import MITI.server.services.common.mir.AttributeValue;
import MITI.server.services.common.mir.LinkedObject;
import MITI.server.services.common.mir.ObjectIdentifier;
import java.util.ArrayList;

public class ObjectDefinition
extends ObjectIdentifier {
    private short objectType = (short)-1;
    private String objectName = null;
    private ArrayList<AttributeValue> attributes = new ArrayList();
    private ArrayList<LinkedObject> links = new ArrayList();

    public ObjectDefinition() {
    }

    public ObjectDefinition(int n, int n2, short s) {
        super(n, n2);
        this.objectType = s;
    }

    public ObjectDefinition(int n, int n2, short s, String string) {
        super(n, n2);
        this.objectType = s;
        this.objectName = string;
    }

    public ObjectDefinition(ObjectDefinition objectDefinition) {
        super(objectDefinition.getModelId(), objectDefinition.getObjectId());
        this.objectType = objectDefinition.getObjectType();
        this.objectName = objectDefinition.getObjectName();
        if (objectDefinition.attributes != null) {
            this.attributes = new ArrayList();
            for (AttributeValue attributeValue : objectDefinition.attributes) {
                this.attributes.add(new AttributeValue(attributeValue));
            }
        }
    }

    public ObjectDefinition(ObjectIdentifier objectIdentifier, short s) {
        super(objectIdentifier);
        this.objectType = s;
    }

    public ObjectDefinition(ObjectIdentifier objectIdentifier, short s, String string) {
        super(objectIdentifier);
        this.objectType = s;
        this.objectName = string;
    }

    public ObjectDefinition(MIRObject mIRObject) {
        this(mIRObject.getModelId(), mIRObject.getObjectId(), mIRObject.getElementType(), mIRObject.getName());
    }

    public boolean isInstanceOf(short s) {
        return MIR_Object.isInstanceOf(this.objectType, s);
    }

    @Override
    public String toString() {
        return super.toString() + " " + this.objectName + " [" + MIRElementType.getName(this.objectType) + "]";
    }

    public short getObjectType() {
        return this.objectType;
    }

    public void setObjectType(short s) {
        this.objectType = s;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void setObjectName(String string) {
        this.objectName = string;
    }

    public AttributeValue[] getAttributes() {
        if (!this.attributes.isEmpty()) {
            return this.attributes.toArray(new AttributeValue[this.attributes.size()]);
        }
        return null;
    }

    public void setAttributes(AttributeValue[] attributeValueArray) {
        this.attributes = new ArrayList();
        if (attributeValueArray != null) {
            for (AttributeValue attributeValue : attributeValueArray) {
                this.attributes.add(attributeValue);
            }
        }
    }

    public AttributeValue getAttributeValue(AttributeIdentifier attributeIdentifier) {
        for (AttributeValue attributeValue : this.attributes) {
            if (!attributeValue.equals(attributeIdentifier)) continue;
            return attributeValue;
        }
        return null;
    }

    public String getAttributeValueValue(AttributeIdentifier attributeIdentifier) {
        AttributeValue attributeValue = this.getAttributeValue(attributeIdentifier);
        if (attributeValue != null) {
            return attributeValue.getValue();
        }
        return null;
    }

    public boolean getAttributeValueBooleanValue(AttributeIdentifier attributeIdentifier) {
        AttributeValue attributeValue = this.getAttributeValue(attributeIdentifier);
        if (attributeValue != null) {
            return attributeValue.toBoolean();
        }
        return false;
    }

    public byte getAttributeValueEnumValue(AttributeIdentifier attributeIdentifier) {
        AttributeValue attributeValue = this.getAttributeValue(attributeIdentifier);
        if (attributeValue != null) {
            return attributeValue.toEnum();
        }
        return -1;
    }

    public int getAttributeValueIntValue(AttributeIdentifier attributeIdentifier) {
        AttributeValue attributeValue = this.getAttributeValue(attributeIdentifier);
        if (attributeValue != null) {
            return attributeValue.toInt();
        }
        return 0;
    }

    public String getAttributeStringValue(AttributeIdentifier attributeIdentifier) {
        AttributeValue attributeValue = this.getAttributeValue(attributeIdentifier);
        if (attributeValue != null && attributeValue.getValue() != null) {
            return attributeValue.getValue();
        }
        return "";
    }

    public AttributeValue getAttributeValue(short s) {
        return this.getAttributeValue(new AttributeIdentifier(s));
    }

    public String getAttributeValueValue(short s) {
        return this.getAttributeValueValue(new AttributeIdentifier(s));
    }

    public boolean getAttributeValueBooleanValue(short s) {
        return this.getAttributeValueBooleanValue(new AttributeIdentifier(s));
    }

    public byte getAttributeValueEnumValue(short s) {
        return this.getAttributeValueEnumValue(new AttributeIdentifier(s));
    }

    public int getAttributeValueIntValue(short s) {
        return this.getAttributeValueIntValue(new AttributeIdentifier(s));
    }

    public LinkedObject[] getLinks() {
        if (!this.links.isEmpty()) {
            return this.links.toArray(new LinkedObject[this.links.size()]);
        }
        return null;
    }

    public void setLinks(LinkedObject[] linkedObjectArray) {
        this.links = new ArrayList();
        if (linkedObjectArray != null) {
            for (LinkedObject linkedObject : linkedObjectArray) {
                this.links.add(linkedObject);
            }
        }
    }

    public String getPhysicalNameOrName() {
        AttributeValue attributeValue = this.getAttributeValue((short)106);
        if (attributeValue != null && attributeValue.getValue() != null && attributeValue.getValue().length() > 0) {
            return attributeValue.getValue();
        }
        String string = this.getObjectName();
        if (string == null) {
            return "";
        }
        return string;
    }

    public void _addAttribute(AttributeValue attributeValue) {
        if (attributeValue != null) {
            this.attributes.add(attributeValue);
        }
    }

    public void _addAttributes(AttributeValue[] attributeValueArray) {
        if (attributeValueArray != null) {
            for (AttributeValue attributeValue : attributeValueArray) {
                this.attributes.add(attributeValue);
            }
        }
    }

    public void _addLink(LinkedObject linkedObject) {
        if (linkedObject != null) {
            this.links.add(linkedObject);
        }
    }
}

