/*
 * Decompiled with CFR 0.152.
 */
package MITI.server.services.common.mir;

import MITI.sdk.MIRMetaLink;
import MITI.server.services.common.mir.Condition;

public class LinkPart
implements Comparable<LinkPart> {
    public static final short LINK_TO_SELF = -2;
    public static final short LINK_TO_PARENT = -3;
    public static final short LINK_TO_MODEL = -4;
    public static final short LINK_TO_CONTENT = -5;
    public static final short LINK_TO_LATEST_VERSION = -6;
    public static final short LINK_TO_REVERSE_ROLE = -7;
    private short associationType = (short)-1;
    private Condition condition = null;

    public LinkPart() {
    }

    public LinkPart(LinkPart linkPart) {
        this.associationType = linkPart.associationType;
        if (linkPart.condition != null) {
            this.condition = new Condition(linkPart.condition);
        }
    }

    public LinkPart(short s) {
        this.associationType = s;
    }

    public final short getId() {
        return this.condition == null ? (short)this.associationType : (short)-1;
    }

    public short getAssociationType() {
        return this.associationType;
    }

    public void setAssociationType(short s) {
        this.associationType = s;
    }

    public Condition getCondition() {
        return this.condition;
    }

    public void setCondition(Condition condition) {
        this.condition = condition;
    }

    public boolean equals(Object object) {
        if (object instanceof LinkPart) {
            LinkPart linkPart = (LinkPart)object;
            if (this.condition == null && linkPart.condition != null) {
                return false;
            }
            if (this.condition != null && !this.condition.equals(linkPart.condition)) {
                return false;
            }
            return this.associationType == linkPart.associationType;
        }
        if (object instanceof Short) {
            Short s = (Short)object;
            return this.condition == null && this.associationType == s;
        }
        return false;
    }

    public int hashCode() {
        return this.associationType;
    }

    @Override
    public int compareTo(LinkPart linkPart) {
        if (this.associationType == -1) {
            if (linkPart.associationType != -1) {
                return -1;
            }
        } else {
            if (linkPart.associationType == -1) {
                return 1;
            }
            if (this.associationType < linkPart.associationType) {
                return -1;
            }
            if (this.associationType > linkPart.associationType) {
                return 1;
            }
        }
        if (this.condition == null) {
            if (linkPart.condition == null) {
                return 0;
            }
            return -1;
        }
        if (linkPart.condition == null) {
            return 1;
        }
        return this.condition.compareTo(linkPart.condition);
    }

    public short destinationElementType() {
        short s;
        if (this.condition != null && (s = this.condition.getCastElementType()) != -1) {
            return s;
        }
        if (this.associationType == -2) {
            return 33;
        }
        if (this.associationType == -3) {
            return 33;
        }
        if (this.associationType == -4) {
            return 218;
        }
        if (this.associationType == -5) {
            return 159;
        }
        if (this.associationType == -6) {
            return 31;
        }
        if (this.associationType == -7) {
            return 18;
        }
        MIRMetaLink mIRMetaLink = MIRMetaLink.getByAssociationType(this.associationType);
        if (mIRMetaLink != null) {
            return mIRMetaLink.getReverse().getOwner().getID();
        }
        return -1;
    }

    public short reverseAssociationType() {
        if (this.associationType == -2) {
            return -2;
        }
        if (this.associationType == -7) {
            return -7;
        }
        MIRMetaLink mIRMetaLink = MIRMetaLink.getByAssociationType(this.associationType);
        if (mIRMetaLink != null) {
            return mIRMetaLink.getReverse().getID();
        }
        return -1;
    }

    public boolean unary() {
        if (this.associationType == -2) {
            return true;
        }
        if (this.associationType == -3) {
            return true;
        }
        if (this.associationType == -4) {
            return true;
        }
        if (this.associationType == -5) {
            return true;
        }
        if (this.associationType == -7) {
            return true;
        }
        MIRMetaLink mIRMetaLink = MIRMetaLink.getByAssociationType(this.associationType);
        if (mIRMetaLink != null) {
            return mIRMetaLink.isUnary();
        }
        return false;
    }

    public boolean aggregation() {
        if (this.associationType == -2) {
            return true;
        }
        if (this.associationType == -3) {
            return true;
        }
        if (this.associationType == -4) {
            return true;
        }
        if (this.associationType == -5) {
            return true;
        }
        if (this.associationType == -7) {
            return false;
        }
        MIRMetaLink mIRMetaLink = MIRMetaLink.getByAssociationType(this.associationType);
        if (mIRMetaLink != null) {
            return mIRMetaLink.getType() == 2 || mIRMetaLink.getType() == 3;
        }
        return false;
    }

    public String toMPath() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.associationType == -2) {
            stringBuffer.append(".");
        } else if (this.associationType == -3) {
            stringBuffer.append("..");
        } else if (this.associationType == -4) {
            stringBuffer.append("model");
        } else if (this.associationType == -5) {
            stringBuffer.append("content");
        } else if (this.associationType == -6) {
            stringBuffer.append("version");
        } else if (this.associationType == -7) {
            stringBuffer.append("reverseRole");
        } else {
            MIRMetaLink mIRMetaLink = MIRMetaLink.getByAssociationType(this.associationType);
            if (mIRMetaLink == null) {
                return null;
            }
            stringBuffer.append(mIRMetaLink.getName());
        }
        if (this.condition != null) {
            stringBuffer.append("[").append(this.condition.toMPath()).append("]");
        }
        return stringBuffer.toString();
    }
}

