/*
 * Decompiled with CFR 0.152.
 */
package MITI.server.services.common.mir;

import MITI.server.services.common.mir.AttributeIdentifier;

public class ConditionValue
implements Comparable<ConditionValue> {
    public static final byte AND = 1;
    public static final byte OR = 2;
    public static final byte NONE = 3;
    public static final byte EQUAL = 1;
    public static final byte NOT_EQUAL = 2;
    public static final byte CONTAINS = 3;
    public static final byte NOT_CONTAINS = 4;
    private byte logicOperator = (byte)3;
    private byte comparisonOperator = 1;
    private boolean caseSensitive = true;
    private AttributeIdentifier attribute = null;
    private String value = null;

    public ConditionValue() {
    }

    public ConditionValue(ConditionValue conditionValue) {
        this.logicOperator = conditionValue.logicOperator;
        this.comparisonOperator = conditionValue.comparisonOperator;
        this.caseSensitive = conditionValue.caseSensitive;
        this.attribute = new AttributeIdentifier(conditionValue.attribute);
        this.value = conditionValue.value;
    }

    public ConditionValue(byte by, byte by2, boolean bl, AttributeIdentifier attributeIdentifier, String string) {
        this.logicOperator = by;
        this.comparisonOperator = by2;
        this.caseSensitive = bl;
        this.attribute = attributeIdentifier;
        this.value = string;
    }

    public byte getLogicOperator() {
        return this.logicOperator;
    }

    public void setLogicOperator(byte by) {
        this.logicOperator = by;
    }

    public byte getComparisonOperator() {
        return this.comparisonOperator;
    }

    public void setComparisonOperator(byte by) {
        this.comparisonOperator = by;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean bl) {
        this.caseSensitive = bl;
    }

    public AttributeIdentifier getAttribute() {
        return this.attribute;
    }

    public void setAttribute(AttributeIdentifier attributeIdentifier) {
        this.attribute = attributeIdentifier;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String string) {
        this.value = string.replaceAll("\\\\(['\"\\\\])", "$1");
    }

    boolean matchValue(AttributeIdentifier attributeIdentifier, String string) {
        boolean bl = false;
        switch (this.comparisonOperator) {
            case 2: {
                if (!this.caseSensitive) {
                    bl = !string.equalsIgnoreCase(this.value);
                    break;
                }
                bl = !string.equals(this.value);
                break;
            }
            case 3: {
                if (!this.caseSensitive) {
                    bl = string.toUpperCase().contains(this.value.toUpperCase());
                    break;
                }
                bl = string.contains(this.value);
                break;
            }
            case 4: {
                if (!this.caseSensitive) {
                    bl = !string.toUpperCase().contains(this.value.toUpperCase());
                    break;
                }
                bl = !string.contains(this.value);
                break;
            }
            default: {
                bl = !this.caseSensitive ? string.equalsIgnoreCase(this.value) : string.equals(this.value);
            }
        }
        return bl;
    }

    public boolean equals(Object object) {
        if (object instanceof ConditionValue) {
            ConditionValue conditionValue = (ConditionValue)object;
            return this.logicOperator == conditionValue.logicOperator && this.comparisonOperator == conditionValue.comparisonOperator && this.caseSensitive == conditionValue.caseSensitive && this.attribute.equals(conditionValue.attribute) && this.value.equals(conditionValue.value);
        }
        return false;
    }

    public int hashCode() {
        return this.attribute.hashCode();
    }

    @Override
    public int compareTo(ConditionValue conditionValue) {
        if (this.logicOperator > conditionValue.logicOperator) {
            return 1;
        }
        if (this.logicOperator < conditionValue.logicOperator) {
            return -1;
        }
        if (this.comparisonOperator > conditionValue.comparisonOperator) {
            return 1;
        }
        if (this.comparisonOperator < conditionValue.comparisonOperator) {
            return -1;
        }
        if (this.caseSensitive && !conditionValue.caseSensitive) {
            return 1;
        }
        if (!this.caseSensitive && conditionValue.caseSensitive) {
            return -1;
        }
        if (this.attribute == null) {
            if (conditionValue.attribute != null) {
                return -1;
            }
        } else {
            if (conditionValue.attribute == null) {
                return 1;
            }
            int n = this.attribute.compareTo(conditionValue.attribute);
            if (n != 0) {
                return n;
            }
        }
        if (this.value == null) {
            if (conditionValue.value != null) {
                return -1;
            }
            return 0;
        }
        if (conditionValue.value == null) {
            return 1;
        }
        return this.value.compareTo(conditionValue.value);
    }

    public String toMPath() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.logicOperator == 1) {
            stringBuffer.append("AND ");
        } else if (this.logicOperator == 2) {
            stringBuffer.append("OR ");
        }
        stringBuffer.append(this.attribute.toMPath());
        switch (this.comparisonOperator) {
            case 2: {
                stringBuffer.append("!=");
                break;
            }
            case 3: {
                stringBuffer.append("~");
                break;
            }
            case 4: {
                stringBuffer.append("!~");
                break;
            }
            default: {
                stringBuffer.append("=");
            }
        }
        if (!this.caseSensitive) {
            stringBuffer.append("#");
        }
        stringBuffer.append("'");
        if (this.value != null) {
            stringBuffer.append(this.value.replace("'", "\\'"));
        }
        stringBuffer.append("'");
        return stringBuffer.toString();
    }
}

