/*
 * Decompiled with CFR 0.152.
 */
package MITI.server.services.common.mir;

import MITI.sdk.MIRElementType;
import MITI.server.services.common.mir.AttributeIdentifier;
import MITI.server.services.common.mir.AttributeValue;
import MITI.server.services.common.mir.ConditionValue;
import java.util.Arrays;
import java.util.HashSet;

public class Condition
implements Comparable<Condition> {
    private ConditionValue[] values = null;

    public Condition() {
    }

    public short getCastElementType() {
        int n = -1;
        if (this.values != null) {
            for (ConditionValue conditionValue : this.values) {
                if (conditionValue.getLogicOperator() == 2) {
                    n = -1;
                    break;
                }
                if (conditionValue.getComparisonOperator() != 1 || conditionValue.getAttribute().getId() != 172) continue;
                if (n != -1) {
                    n = -1;
                    break;
                }
                n = MIRElementType.parseString(conditionValue.getValue());
            }
        }
        return (short)n;
    }

    public Condition(Condition condition) {
        if (condition.values != null) {
            this.values = new ConditionValue[condition.values.length];
            for (int i = 0; i < this.values.length; ++i) {
                this.values[i] = new ConditionValue(condition.values[i]);
            }
        }
    }

    public ConditionValue[] getValues() {
        return this.values;
    }

    public void setValues(ConditionValue[] conditionValueArray) {
        this.values = conditionValueArray;
    }

    public AttributeIdentifier[] listAttributes() {
        if (this.values == null || this.values.length == 0) {
            return null;
        }
        HashSet<AttributeIdentifier> hashSet = new HashSet<AttributeIdentifier>();
        for (int i = 0; i < this.values.length; ++i) {
            hashSet.add(this.values[i].getAttribute());
        }
        return hashSet.toArray(new AttributeIdentifier[hashSet.size()]);
    }

    public boolean equals(Object object) {
        if (object instanceof Condition) {
            Condition condition = (Condition)object;
            return Arrays.equals(this.values, condition.values);
        }
        return false;
    }

    public int hashCode() {
        return this.values == null ? 0 : this.values.length;
    }

    @Override
    public int compareTo(Condition condition) {
        if (this.values == null) {
            if (condition.values == null) {
                return 0;
            }
            return -1;
        }
        if (condition.values == null) {
            return 1;
        }
        if (this.values.length < condition.values.length) {
            return -1;
        }
        if (this.values.length < condition.values.length) {
            return 1;
        }
        for (int i = 0; i < this.values.length; ++i) {
            int n = this.values[i].compareTo(condition.values[i]);
            if (n == 0) continue;
            return n;
        }
        return 0;
    }

    public boolean match(AttributeValue[] attributeValueArray) {
        if (attributeValueArray == null) {
            return false;
        }
        boolean bl = true;
        int n = 0;
        for (int i = 0; i < this.values.length; ++i) {
            ConditionValue conditionValue = this.values[i];
            AttributeValue attributeValue = Condition.findAttributeValue(attributeValueArray, conditionValue.getAttribute());
            if (attributeValue == null) continue;
            ++n;
            boolean bl2 = conditionValue.matchValue(attributeValue, attributeValue.getValue());
            if (conditionValue.getLogicOperator() == 2) {
                bl |= bl2;
                continue;
            }
            bl &= bl2;
        }
        return bl && n == this.values.length;
    }

    private static AttributeValue findAttributeValue(AttributeValue[] attributeValueArray, AttributeIdentifier attributeIdentifier) {
        for (int i = 0; i < attributeValueArray.length; ++i) {
            AttributeValue attributeValue = attributeValueArray[i];
            if (!attributeIdentifier.equals(attributeValue)) continue;
            return attributeValue;
        }
        return null;
    }

    public String toString() {
        return this.toMPath();
    }

    public String toMPath() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.values.length; ++i) {
            if (i != 0) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(this.values[i].toMPath());
        }
        return stringBuffer.toString();
    }
}

