/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk.mpath;

import MITI.MIRException;
import MITI.messages.MIR.MIRSDK;
import MITI.sdk.MIRElementType;
import MITI.sdk.MIRMetaAttribute;
import MITI.sdk.MIRMetaClass;
import MITI.sdk.MIRMetaLink;
import MITI.sdk.MIRMetaObject;
import MITI.server.services.common.mir.AttributeIdentifier;
import MITI.server.services.common.mir.Condition;
import MITI.server.services.common.mir.ConditionValue;
import MITI.server.services.common.mir.LinkIdentifier;
import MITI.server.services.common.mir.LinkPart;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Parser {
    private static final String SPACE = "\\s*";
    private static final String BOOLEAN_OPERATOR = "(^|(?i:AND)|(?i:OR))";
    private static final String COMPARISON_OPERATOR = "([!=]?[=~])([#]?)";
    private static final String ID = "((?:\\w|\\.|\\$)*)";
    private static final String QUOTED_STRING = "('(?:[^\\\\']|\\\\.)*')|(\"(?:[^\\\\\"]|\\\\.)*\")";
    private static final String VALUE = "(('(?:[^\\\\']|\\\\.)*')|(\"(?:[^\\\\\"]|\\\\.)*\"))";
    private static final String ATTRIBUTE_NAME = "(('(?:[^\\\\']|\\\\.)*')|(\"(?:[^\\\\\"]|\\\\.)*\")|((?:\\w|\\.|\\$)*))";
    private static final String LINK_CONDITION = "(('(?:[^\\\\']|\\\\.)*')|(\"(?:[^\\\\\"]|\\\\.)*\")|[^\\]])*";
    private static final String CLASS = "(?:\\{((?:\\w|\\.|\\$)*)\\})?";
    private static final String LINK_PART = "(?:(?:\\{((?:\\w|\\.|\\$)*)\\})?((?:\\w|\\.|\\$)*))(?:\\[((('(?:[^\\\\']|\\\\.)*')|(\"(?:[^\\\\\"]|\\\\.)*\")|[^\\]])*)\\])?/?";
    private static final String ATTRIBUTE = "(((?:(?:\\{((?:\\w|\\.|\\$)*)\\})?((?:\\w|\\.|\\$)*))(?:\\[((('(?:[^\\\\']|\\\\.)*')|(\"(?:[^\\\\\"]|\\\\.)*\")|[^\\]])*)\\])?/?)*)(@(?:\\{((?:\\w|\\.|\\$)*)\\})?(('(?:[^\\\\']|\\\\.)*')|(\"(?:[^\\\\\"]|\\\\.)*\")|((?:\\w|\\.|\\$)*)))?";
    private static final String CONDITION = "(^|(?i:AND)|(?i:OR))\\s*((((?:(?:\\{((?:\\w|\\.|\\$)*)\\})?((?:\\w|\\.|\\$)*))(?:\\[((('(?:[^\\\\']|\\\\.)*')|(\"(?:[^\\\\\"]|\\\\.)*\")|[^\\]])*)\\])?/?)*)(@(?:\\{((?:\\w|\\.|\\$)*)\\})?(('(?:[^\\\\']|\\\\.)*')|(\"(?:[^\\\\\"]|\\\\.)*\")|((?:\\w|\\.|\\$)*)))?)\\s*([!=]?[=~])([#]?)\\s*(('(?:[^\\\\']|\\\\.)*')|(\"(?:[^\\\\\"]|\\\\.)*\"))\\s*";
    private static final Pattern attributePattern = Pattern.compile("(((?:(?:\\{((?:\\w|\\.|\\$)*)\\})?((?:\\w|\\.|\\$)*))(?:\\[((('(?:[^\\\\']|\\\\.)*')|(\"(?:[^\\\\\"]|\\\\.)*\")|[^\\]])*)\\])?/?)*)(@(?:\\{((?:\\w|\\.|\\$)*)\\})?(('(?:[^\\\\']|\\\\.)*')|(\"(?:[^\\\\\"]|\\\\.)*\")|((?:\\w|\\.|\\$)*)))?");
    private static final Pattern linkPattern = Pattern.compile("(?:(?:\\{((?:\\w|\\.|\\$)*)\\})?((?:\\w|\\.|\\$)*))(?:\\[((('(?:[^\\\\']|\\\\.)*')|(\"(?:[^\\\\\"]|\\\\.)*\")|[^\\]])*)\\])?/?");
    private static final Pattern conditionPattern = Pattern.compile("(^|(?i:AND)|(?i:OR))\\s*((((?:(?:\\{((?:\\w|\\.|\\$)*)\\})?((?:\\w|\\.|\\$)*))(?:\\[((('(?:[^\\\\']|\\\\.)*')|(\"(?:[^\\\\\"]|\\\\.)*\")|[^\\]])*)\\])?/?)*)(@(?:\\{((?:\\w|\\.|\\$)*)\\})?(('(?:[^\\\\']|\\\\.)*')|(\"(?:[^\\\\\"]|\\\\.)*\")|((?:\\w|\\.|\\$)*)))?)\\s*([!=]?[=~])([#]?)\\s*(('(?:[^\\\\']|\\\\.)*')|(\"(?:[^\\\\\"]|\\\\.)*\"))\\s*");

    public static AttributeIdentifier parseAttribute(short s, String string) throws MIRException {
        MIRMetaClass mIRMetaClass = MIRMetaClass.getByElementType(s);
        if (mIRMetaClass == null) {
            MIRSDK.CLASS_TYPE_NOT_VALID.log(Short.toString(s));
            return null;
        }
        Matcher matcher = attributePattern.matcher(string);
        if (matcher.find()) {
            String string2 = matcher.group(1);
            String string3 = matcher.group(matcher.groupCount() - 4);
            String string4 = matcher.group(matcher.groupCount() - 3);
            LinkIdentifier linkIdentifier = null;
            if (string2 != null && string2.length() != 0) {
                linkIdentifier = Parser.parseLink(s, string2);
                if (linkIdentifier == null) {
                    return null;
                }
                mIRMetaClass = MIRMetaClass.getByElementType(linkIdentifier.destinationElementType());
            }
            AttributeIdentifier attributeIdentifier = new AttributeIdentifier();
            attributeIdentifier.setLink(linkIdentifier);
            if (string4 != null) {
                if (string4.startsWith("\"") || string4.startsWith("'")) {
                    attributeIdentifier.setName(string4.substring(1, string4.length() - 1));
                } else if ((string4 = string4.substring(0, 1).toUpperCase() + string4.substring(1)).equals(AttributeIdentifier.getSpecialAttributeName((short)-2))) {
                    attributeIdentifier.setType((short)-2);
                } else {
                    if (string3 != null && (mIRMetaClass = MIRMetaClass.getByElementType(MIRElementType.getByName(string3))) == null) {
                        MIRSDK.CLASS_NAME_NOT_VALID.log(string3);
                        return null;
                    }
                    MIRMetaAttribute mIRMetaAttribute = Parser.getMetaAttributeByName(mIRMetaClass, string4);
                    if (mIRMetaAttribute == null) {
                        MIRSDK.ATTRIBUTE_NOT_VALID.log(string4, mIRMetaClass.getName());
                        return null;
                    }
                    attributeIdentifier.setType(mIRMetaAttribute.getID());
                }
            }
            return attributeIdentifier;
        }
        return null;
    }

    public static LinkIdentifier parseLink(short s, String string) throws MIRException {
        Object object;
        MIRMetaClass mIRMetaClass = MIRMetaClass.getByElementType(s);
        if (mIRMetaClass == null) {
            return null;
        }
        MIRMetaClass[] mIRMetaClassArray = new MIRMetaClass[]{mIRMetaClass};
        ArrayList<LinkPart> arrayList = new ArrayList<LinkPart>();
        Matcher matcher = linkPattern.matcher(string);
        while (matcher.find()) {
            int n;
            Object object2;
            MIRMetaObject mIRMetaObject;
            object = matcher.group(1);
            String string2 = matcher.group(2);
            String string3 = matcher.group(3);
            LinkPart linkPart = null;
            if (string2 == null || string2.length() == 0) {
                if (matcher.hitEnd()) break;
                return null;
            }
            if (string2.equals(".")) {
                linkPart = new LinkPart(-2);
            } else if (string2.equals("..")) {
                linkPart = new LinkPart(-3);
                mIRMetaClassArray = Parser.getParentMetaClass(mIRMetaClassArray);
            } else if (string2.equals("model")) {
                linkPart = new LinkPart(-4);
                mIRMetaClassArray = new MIRMetaClass[]{MIRMetaClass.getByElementType((short)218)};
            } else if (string2.equals("version")) {
                linkPart = new LinkPart(-6);
                mIRMetaClassArray = new MIRMetaClass[]{MIRMetaClass.getByElementType((short)31)};
            } else if (string2.equals("reverseRole")) {
                linkPart = new LinkPart(-7);
                mIRMetaClassArray = new MIRMetaClass[]{MIRMetaClass.getByElementType((short)18)};
            } else {
                mIRMetaObject = null;
                if (object != null && (object2 = MIRMetaClass.getByElementType(MIRElementType.getByName((String)object))) != null) {
                    mIRMetaClassArray = new MIRMetaClass[]{object2};
                }
                object2 = mIRMetaClassArray;
                n = ((MIRMetaClass[])object2).length;
                for (int i = 0; i < n; ++i) {
                    Object object3 = object2[i];
                    mIRMetaObject = Parser.getMetaLinkByName((MIRMetaClass)object3, string2);
                    if (mIRMetaObject == null) continue;
                    linkPart = new LinkPart(mIRMetaObject.getID());
                    mIRMetaClassArray = new MIRMetaClass[]{((MIRMetaLink)mIRMetaObject).getReverse().getOwner()};
                    break;
                }
            }
            if (linkPart == null) {
                MIRSDK.LINK_PART_NOT_VALID.log(string2);
                return null;
            }
            if (string3 != null && string3.length() != 0) {
                mIRMetaObject = Parser.getCommonParentMetaClass(mIRMetaClassArray);
                object2 = Parser.parseCondition(((MIRMetaClass)mIRMetaObject).getElementType(), string3);
                if (object2 == null) {
                    MIRSDK.CONDITION_NOT_VALID.log(string3);
                    return null;
                }
                linkPart.setCondition((Condition)object2);
                n = ((Condition)object2).getCastElementType();
                if (n != -1) {
                    mIRMetaClassArray = new MIRMetaClass[]{MIRMetaClass.getByElementType((short)n)};
                }
            }
            arrayList.add(linkPart);
        }
        if (arrayList.size() > 0) {
            object = new LinkIdentifier();
            ((LinkIdentifier)object).setAssociations(arrayList.toArray(new LinkPart[arrayList.size()]));
            return object;
        }
        return null;
    }

    public static Condition parseCondition(short s, String string) throws MIRException {
        Object object;
        MIRMetaClass mIRMetaClass = MIRMetaClass.getByElementType(s);
        if (mIRMetaClass == null) {
            MIRSDK.CLASS_TYPE_NOT_VALID.log(Short.toString(s));
            return null;
        }
        short s2 = s;
        ArrayList<ConditionValue> arrayList = new ArrayList<ConditionValue>();
        Matcher matcher = conditionPattern.matcher(string);
        while (matcher.find()) {
            AttributeIdentifier attributeIdentifier;
            String string2 = matcher.group(1);
            object = matcher.group(2);
            String string3 = matcher.group(matcher.groupCount() - 4);
            boolean bl = !"#".equals(matcher.group(matcher.groupCount() - 3));
            String string4 = matcher.group(matcher.groupCount() - 2);
            if (string4 == null) {
                return null;
            }
            if (string4.length() >= 2) {
                string4 = string4.substring(1, string4.length() - 1);
            }
            ConditionValue conditionValue = new ConditionValue();
            if (string2 != null) {
                if (string2.equalsIgnoreCase("AND")) {
                    conditionValue.setLogicOperator((byte)1);
                } else if (string2.equalsIgnoreCase("OR")) {
                    conditionValue.setLogicOperator((byte)2);
                }
            }
            if (string3 != null) {
                if (string3.equals("!=")) {
                    conditionValue.setComparisonOperator((byte)2);
                } else if (string3.equals("~") || string3.equals("=~")) {
                    conditionValue.setComparisonOperator((byte)3);
                } else if (string3.equals("!~")) {
                    conditionValue.setComparisonOperator((byte)4);
                }
            }
            conditionValue.setCaseSensitive(bl);
            if (conditionValue.getLogicOperator() != 1) {
                s2 = s;
            }
            if ((attributeIdentifier = Parser.parseAttribute(s2, (String)object)) == null) {
                MIRSDK.ATTRIBUTE_NOT_VALID.log(object, MIRElementType.getName(s2));
                return null;
            }
            conditionValue.setAttribute(attributeIdentifier);
            conditionValue.setValue(string4);
            if (conditionValue.getComparisonOperator() == 1 && conditionValue.getAttribute().getId() == 172) {
                s2 = MIRElementType.parseString(conditionValue.getValue());
            }
            arrayList.add(conditionValue);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            object = (ConditionValue)arrayList.get(i);
            if ((i != 0 || ((ConditionValue)object).getLogicOperator() == 3) && (i == 0 || ((ConditionValue)object).getLogicOperator() != 3)) continue;
            return null;
        }
        if (arrayList.size() > 0) {
            Condition condition = new Condition();
            condition.setValues(arrayList.toArray(new ConditionValue[arrayList.size()]));
            return condition;
        }
        return null;
    }

    private static MIRMetaClass[] getParentMetaClass(MIRMetaClass[] mIRMetaClassArray) {
        ArrayList<MIRMetaClass> arrayList = new ArrayList<MIRMetaClass>();
        for (MIRMetaClass mIRMetaClass : mIRMetaClassArray) {
            for (int n = 0; n < mIRMetaClass.getLinkCount(); n = (int)((byte)(n + 1))) {
                MIRMetaLink mIRMetaLink = mIRMetaClass.getLink(n);
                if (mIRMetaLink.getType() != 2) continue;
                arrayList.add(mIRMetaLink.getDestinationMetaClass());
            }
        }
        return arrayList.toArray(new MIRMetaClass[arrayList.size()]);
    }

    private static MIRMetaClass getCommonParentMetaClass(MIRMetaClass[] mIRMetaClassArray) {
        MIRMetaClass mIRMetaClass = mIRMetaClassArray[0];
        while (mIRMetaClass.getElementType() != 33) {
            boolean bl = true;
            for (MIRMetaClass mIRMetaClass2 : mIRMetaClassArray) {
                if (mIRMetaClass.isSuperClassOf(mIRMetaClass2.getElementType())) continue;
                bl = false;
                break;
            }
            if (bl) break;
            mIRMetaClass = mIRMetaClass.getParent();
        }
        return mIRMetaClass;
    }

    private static MIRMetaAttribute getMetaAttributeByName(MIRMetaClass mIRMetaClass, String string) throws MIRException {
        MIRMetaAttribute mIRMetaAttribute = mIRMetaClass.getAttributeByName(string);
        for (int n = 0; n < mIRMetaClass.getChildCount(); n = (int)((byte)(n + 1))) {
            MIRMetaAttribute mIRMetaAttribute2 = Parser.getMetaAttributeByName(mIRMetaClass.getChild(n), string);
            if (mIRMetaAttribute2 == null) continue;
            if (mIRMetaAttribute == null) {
                mIRMetaAttribute = mIRMetaAttribute2;
                continue;
            }
            if (mIRMetaAttribute2.equals(mIRMetaAttribute)) continue;
            throw new MIRException(MIRSDK.MPATH_AMBIGUOUS_ATTRIBUTE.getMessage(mIRMetaAttribute.getFullName(), mIRMetaAttribute2.getFullName()));
        }
        return mIRMetaAttribute;
    }

    private static MIRMetaLink getMetaLinkByName(MIRMetaClass mIRMetaClass, String string) throws MIRException {
        MIRMetaLink mIRMetaLink = mIRMetaClass.getLinkByName(string);
        for (int n = 0; n < mIRMetaClass.getChildCount(); n = (int)((byte)(n + 1))) {
            MIRMetaLink mIRMetaLink2 = Parser.getMetaLinkByName(mIRMetaClass.getChild(n), string);
            if (mIRMetaLink2 == null) continue;
            if (mIRMetaLink == null) {
                mIRMetaLink = mIRMetaLink2;
                continue;
            }
            if (mIRMetaLink2.equals(mIRMetaLink)) continue;
            throw new MIRException(MIRSDK.MPATH_AMBIGUOUS_LINK.getMessage(mIRMetaLink.getFullName(), mIRMetaLink2.getFullName()));
        }
        return mIRMetaLink;
    }
}

