/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk.mix.ids;

import MITI.sdk.MIRMetaClass;
import MITI.sdk.MIRMetaLink;
import MITI.sdk.MIRObject;
import MITI.sdk.MIR_Object;
import MITI.sdk.mix.MIRObjectCache;
import MITI.server.services.common.mir.ObjectDefinition;
import MITI.server.services.common.mir.ObjectIdentifier;
import java.util.Arrays;
import java.util.Iterator;

public class ModelObjectCache
implements MIRObjectCache {
    private static final int OBJECT_INC_FACTOR = 1000;
    private int modelId;
    private int maxId;
    private MIRObject[] objects;

    public ModelObjectCache(int n) {
        this.modelId = n;
        this.maxId = 0;
        this.objects = new MIRObject[0];
    }

    public void clear() {
        this.maxId = 0;
        this.objects = new MIRObject[0];
    }

    public void put(ObjectIdentifier objectIdentifier, MIRObject mIRObject) {
        if (objectIdentifier.getObjectId() > this.maxId) {
            this.maxId = objectIdentifier.getObjectId();
            if (this.maxId >= this.objects.length) {
                this.objects = Arrays.copyOf(this.objects, this.maxId + 1000);
            }
        }
        mIRObject.setModelId(this.modelId);
        mIRObject.setObjectId(objectIdentifier.getObjectId());
        this.objects[mIRObject.getObjectId()] = mIRObject;
    }

    public void add(MIRObject mIRObject) {
        new PopulateIds().run(mIRObject);
    }

    @Override
    public MIRObject getMirObject(ObjectIdentifier objectIdentifier) {
        if (objectIdentifier.getObjectId() > 0 && objectIdentifier.getObjectId() < this.objects.length) {
            return this.objects[objectIdentifier.getObjectId()];
        }
        return null;
    }

    @Override
    public ObjectIdentifier getObjectIdentifier(MIRObject mIRObject) {
        if (mIRObject.getModelId() == this.modelId && mIRObject.getObjectId() > 0 && mIRObject.getObjectId() < this.objects.length) {
            return new ObjectIdentifier(this.modelId, mIRObject.getObjectId());
        }
        return null;
    }

    @Override
    public ObjectDefinition getObjectDefinition(MIRObject mIRObject) {
        if (mIRObject.getModelId() == this.modelId && mIRObject.getObjectId() > 0 && mIRObject.getObjectId() < this.objects.length) {
            return new ObjectDefinition(this.modelId, mIRObject.getObjectId(), mIRObject.getElementType(), mIRObject.getName());
        }
        return null;
    }

    public int hashCode() {
        return this.modelId;
    }

    public boolean equals(Object object) {
        ModelObjectCache modelObjectCache = (ModelObjectCache)object;
        return this.modelId == modelObjectCache.modelId;
    }

    static /* synthetic */ MIRObject[] access$102(ModelObjectCache modelObjectCache, MIRObject[] mIRObjectArray) {
        modelObjectCache.objects = mIRObjectArray;
        return mIRObjectArray;
    }

    private class PopulateIds {
        int maxAssignedId = 0;
        int countNoId = 0;

        private PopulateIds() {
        }

        public void run(MIRObject mIRObject) {
            this.count(mIRObject);
            if (this.maxAssignedId + this.countNoId + 1 > ModelObjectCache.this.objects.length) {
                ModelObjectCache.access$102(ModelObjectCache.this, Arrays.copyOf(ModelObjectCache.this.objects, this.maxAssignedId + this.countNoId + 1));
            }
            this.assign(mIRObject);
        }

        private void count(MIRObject mIRObject) {
            if (mIRObject.getModelId() == ModelObjectCache.this.modelId && mIRObject.getObjectId() > 0) {
                if (mIRObject.getObjectId() > this.maxAssignedId) {
                    this.maxAssignedId = mIRObject.getObjectId();
                }
            } else {
                ++this.countNoId;
            }
            MIRMetaClass mIRMetaClass = mIRObject.getMetaClass();
            for (MIRMetaLink mIRMetaLink : mIRMetaClass.getLinks()) {
                if (!this.follow(mIRMetaLink)) continue;
                Iterator<? extends MIRObject> iterator = mIRMetaLink.getIterator((MIR_Object)mIRObject);
                while (iterator.hasNext()) {
                    this.count(iterator.next());
                }
            }
        }

        private void assign(MIRObject mIRObject) {
            if (mIRObject.getModelId() == ModelObjectCache.this.modelId && mIRObject.getObjectId() > 0) {
                ModelObjectCache.this.put(new ObjectIdentifier(ModelObjectCache.this.modelId, mIRObject.getObjectId()), mIRObject);
            } else {
                ModelObjectCache.this.put(new ObjectIdentifier(ModelObjectCache.this.modelId, ++this.maxAssignedId), mIRObject);
            }
            MIRMetaClass mIRMetaClass = mIRObject.getMetaClass();
            for (MIRMetaLink mIRMetaLink : mIRMetaClass.getLinks()) {
                if (!this.follow(mIRMetaLink)) continue;
                Iterator<? extends MIRObject> iterator = mIRMetaLink.getIterator((MIR_Object)mIRObject);
                while (iterator.hasNext()) {
                    this.assign(iterator.next());
                }
            }
        }

        private boolean follow(MIRMetaLink mIRMetaLink) {
            return mIRMetaLink.getType() == 3 && mIRMetaLink.getID() != 809 && mIRMetaLink.getID() != 854;
        }
    }
}

