/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk.mix;

import MITI.MIRException;
import MITI.messages.MIR.XSER;
import MITI.sdk.MIRContent;
import MITI.sdk.MIRDirectoryStructureModel;
import MITI.sdk.MIRElementType;
import MITI.sdk.MIRFolderContentModel;
import MITI.sdk.MIRModel;
import MITI.sdk.MIRObject;
import MITI.sdk.MIR_Object;
import MITI.sdk.mix.MIRMIXExport;
import MITI.sdk.mix.MIRMIXImport;
import MITI.sdk.mix.MIRMixIdMap;
import MITI.sdk.mix.checksum.DetailedChecksum;
import MITI.sdk.mix.checksum.DirectoryChecksum;
import MITI.sdk.mix.checksum.FileChecksum;
import MITI.sdk.mix.checksum.MixChecksum;
import MITI.sdk.mix.checksum.ModelChecksum;
import MITI.sdk.mix.ids.MultiModelMixIds;
import MITI.sdk.mix.ids.SingleModelMixIds;
import MITI.sdk.validation.MIRValidation;
import MITI.sdk.validation.MIRValidationLevel;
import MITI.server.services.common.mir.ObjectIdentifier;
import MITI.util.file.FileUtil;
import java.io.File;

public class MIRMixManager {
    protected MIRMixIdMap ids = new MultiModelMixIds();
    private byte level = 0;
    protected File multiModelFile = null;

    public static File getModelFile(File file) {
        if (file != null && file.isDirectory()) {
            return new File(file, "model.xml");
        }
        return file;
    }

    public static File getMultiModelFile(File file) {
        if (file != null && file.isDirectory()) {
            return new File(file, "main.xml");
        }
        return file;
    }

    public static File getFile(File file) {
        File file2 = MIRMixManager.getMultiModelFile(file);
        if (!file2.exists() && !(file2 = MIRMixManager.getModelFile(file)).exists()) {
            file2 = file;
        }
        return file2;
    }

    public MIRMixManager() {
        this(null, 0);
    }

    public final MIRModel readFile(File file) throws MIRException {
        return (MIRModel)this.load(file, (short)218);
    }

    public final void writeFile(File file, MIRModel mIRModel) throws MIRException {
        ModelChecksum modelChecksum = this.computeDefaultChecksum(mIRModel);
        this.save(file, mIRModel, modelChecksum, true, true, false);
    }

    public MIRMixManager(File file) {
        this(file, 0);
    }

    public MIRMixManager(File file, byte by) {
        this.multiModelFile = MIRMixManager.getMultiModelFile(file);
        this.level = by;
    }

    public final MIRDirectoryStructureModel loadDirectoryStructure() throws MIRException {
        return (MIRDirectoryStructureModel)this.load(this.multiModelFile, (short)286);
    }

    public final MIRFolderContentModel loadFolderContentModel() throws MIRException {
        return (MIRFolderContentModel)this.load(this.multiModelFile, (short)288);
    }

    public final File saveDirectoryStructure(MIRDirectoryStructureModel mIRDirectoryStructureModel) throws MIRException {
        ModelChecksum modelChecksum = this.computeDefaultChecksum(mIRDirectoryStructureModel);
        this.save(this.multiModelFile, mIRDirectoryStructureModel, modelChecksum, true, false, true);
        return this.multiModelFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final File getFile(MIRContent mIRContent) throws MIRException {
        Comparable<MIR_Object> comparable;
        ObjectIdentifier objectIdentifier = this.ids.getObjectIdentifier(mIRContent);
        if (objectIdentifier == null) {
            comparable = mIRContent.getRootObject();
            if (comparable.getElementType() == 286) {
                MIRMixIdMap mIRMixIdMap = this.ids;
                synchronized (mIRMixIdMap) {
                    this.ids.add((MIRObject)comparable, MIRMixIdMap.normalizeModelId(this.multiModelFile.getName()));
                }
                objectIdentifier = this.ids.getObjectIdentifier(mIRContent);
            }
            if (objectIdentifier == null) {
                throw new MIRException(XSER.OBJECT_IS_MISSING_XMI_ID.getMessage(mIRContent.getPath(), MIRElementType.getName(mIRContent.getElementType())));
            }
        }
        comparable = new File(this.multiModelFile.getParentFile(), objectIdentifier.getObjectId() + ".xml");
        return comparable;
    }

    public final File getMultiModelFile() {
        return this.multiModelFile;
    }

    public final MIRModel loadModel(MIRContent mIRContent) throws MIRException {
        MIRModel mIRModel = mIRContent.getModel();
        if (mIRModel == null && (mIRModel = (MIRModel)this.load(this.getFile(mIRContent), (short)218)) != null) {
            this.unload(mIRModel);
            mIRContent.addModel(mIRModel);
        }
        return mIRModel;
    }

    public final File saveModel(MIRContent mIRContent) throws MIRException {
        File file = this.getFile(mIRContent);
        this.saveModel(mIRContent, file);
        return file;
    }

    public final File saveModel(MIRContent mIRContent, File file) throws MIRException {
        MIRModel mIRModel = mIRContent.getModel();
        if (mIRModel != null && mIRModel.getModificationTime().isNull()) {
            mIRModel.setModificationTime(mIRContent.getLastModificationTime());
        }
        ModelChecksum modelChecksum = this.computeDefaultChecksum(mIRModel);
        this.save(file, mIRModel, modelChecksum, false, true, true);
        this.propagateChecksum(mIRContent, modelChecksum);
        return file;
    }

    public final File savePartialModel(MIRContent mIRContent) throws MIRException {
        File file = this.getFile(mIRContent);
        MIRModel mIRModel = mIRContent.getModel();
        if (mIRModel != null && mIRModel.getModificationTime().isNull()) {
            mIRModel.setModificationTime(mIRContent.getLastModificationTime());
        }
        this.save(file, mIRModel, null, false, false, true);
        return file;
    }

    private ModelChecksum computeDefaultChecksum(MIRModel mIRModel) {
        ModelChecksum modelChecksum = null;
        if (mIRModel != null) {
            if (mIRModel instanceof MIRDirectoryStructureModel) {
                modelChecksum = new DirectoryChecksum();
            } else {
                modelChecksum = new DetailedChecksum();
                this.configureDebugFile(mIRModel, (DetailedChecksum)modelChecksum);
            }
            modelChecksum.compute(mIRModel);
        }
        return modelChecksum;
    }

    private void configureDebugFile(MIRModel mIRModel, DetailedChecksum detailedChecksum) {
    }

    public final File copyModel(MIRContent mIRContent, File file) throws MIRException {
        File file2 = this.getFile(mIRContent);
        if (FileUtil.copy(file, file2)) {
            file2.setLastModified(file.lastModified());
            FileChecksum fileChecksum = FileChecksum.read(file);
            if (fileChecksum != null) {
                this.propagateChecksum(mIRContent, fileChecksum);
            }
            return file2;
        }
        throw new MIRException(XSER.ERROR_COPYING_FILE.getMessage(file.getAbsoluteFile(), file2.getAbsoluteFile()));
    }

    private final void propagateChecksum(MIRContent mIRContent, MixChecksum mixChecksum) {
        String string = mixChecksum.getStructure();
        mIRContent.setModelKey(string);
    }

    protected void unload(MIRModel mIRModel) {
        this.remove(mIRModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void remove(MIRModel mIRModel) {
        ObjectIdentifier objectIdentifier;
        if (mIRModel != null && (objectIdentifier = this.ids.getObjectIdentifier(mIRModel)) != null) {
            MIRMixIdMap mIRMixIdMap = this.ids;
            synchronized (mIRMixIdMap) {
                this.ids.remove(objectIdentifier);
            }
        }
    }

    private final MIRObject load(File file, short s) throws MIRException {
        ObjectIdentifier objectIdentifier = new ObjectIdentifier(MIRMixIdMap.normalizeModelId(file.getName()), 1);
        MIRObject mIRObject = this.ids.getMirObject(objectIdentifier);
        if (mIRObject == null) {
            mIRObject = new MIRMIXImport(false).run(file, this.ids, null);
            if (mIRObject == null) {
                throw new MIRException(XSER.READ_NULL_ROOT.getMessage(new Object[0]));
            }
            if (!mIRObject.isInstanceOf(s)) {
                throw new MIRException(XSER.OBJECT_TYPE_MISMATCH.getMessage(MIRElementType.getName(mIRObject.getElementType()), MIRElementType.getName(s)));
            }
        }
        return mIRObject;
    }

    private final void save(File file, MIRModel mIRModel, MixChecksum mixChecksum, boolean bl, boolean bl2, boolean bl3) throws MIRException {
        if (mIRModel == null) {
            throw new MIRException(XSER.WRITE_NULL_ROOT.getMessage(new Object[0]));
        }
        MIRValidation.validateModel(mIRModel, bl2 ? MIRValidationLevel.getDefaultLevel() : MIRValidationLevel.TREE, bl3);
        new MIRMIXExport(this.level).run(file, mIRModel, mixChecksum, bl ? this.ids : new SingleModelMixIds());
    }
}

