/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk.mix;

import MITI.MIRException;
import MITI.messages.MIR.XSER;
import MITI.sdk.MIRElementType;
import MITI.sdk.MIRMetaAttribute;
import MITI.sdk.MIRMetaClass;
import MITI.sdk.MIRMetaLink;
import MITI.sdk.mix.MIRMixIdMap;
import MITI.server.services.common.mir.ObjectIdentifier;
import MITI.util.XmlUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class MIRMixHandler
extends DefaultHandler {
    private static HashMap<String, Short> xsiTypes = new HashMap();
    private static ArrayList<HashMap<String, Short>> attributeTypes = new ArrayList(374);
    private static ArrayList<HashMap<String, Short>> linkTypes = new ArrayList(374);
    private int modelId = 0;
    private Stack<Object> objectStack = null;
    private String currentElementValue = "";
    private String version = "7.0.0";
    private Object root = null;
    private boolean importObjectId;
    private int skipCount = 0;
    private String skipUntil = null;
    private boolean[] filter = null;
    private Locator xmlLocator = null;

    public MIRMixHandler(boolean bl) {
        this.importObjectId = bl;
    }

    protected Object read(InputStream inputStream, String string, short[] sArray) throws MIRException {
        try {
            this.modelId = MIRMixIdMap.normalizeModelId(string);
            this.objectStack = new Stack();
            this.root = null;
            this.skipCount = 0;
            this.skipUntil = null;
            this.filter = null;
            if (sArray != null) {
                this.filter = new boolean[374];
                for (Object object : (SAXParserFactory)sArray) {
                    this.filter[object] = true;
                }
            }
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            try {
                sAXParserFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", false);
            }
            catch (ParserConfigurationException | SAXException exception) {
                // empty catch block
            }
            sAXParserFactory.setNamespaceAware(true);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.parse(inputStream, (DefaultHandler)this);
            if (this.root == null) {
                throw new MIRException(XSER.NOT_A_MIX_FILE.getMessage(new Object[0]));
            }
            return this.root;
        }
        catch (IOException iOException) {
            throw new MIRException(iOException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new MIRException(parserConfigurationException);
        }
        catch (SAXException sAXException) {
            if (sAXException.getException() instanceof MIRException) {
                throw (MIRException)sAXException.getException();
            }
            throw new MIRException(sAXException);
        }
    }

    private String getPosition() {
        if (this.xmlLocator == null) {
            return "";
        }
        return this.xmlLocator.getLineNumber() + ":" + this.xmlLocator.getColumnNumber();
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.xmlLocator = locator;
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.currentElementValue = "";
        if (!string.equals(XmlUtil.NS_MIR.getUri())) {
            return;
        }
        if (this.skipCount > 0) {
            if (this.skipUntil.equals(string2)) {
                ++this.skipCount;
            }
            return;
        }
        try {
            Object object = null;
            if (!this.objectStack.isEmpty()) {
                object = this.objectStack.peek();
            }
            MIRMetaLink mIRMetaLink = null;
            if (object != null) {
                short s = this.getObjectType(object);
                mIRMetaLink = this.getLink(s, string2);
            }
            Object object2 = null;
            short s = this.getXsiType(attributes);
            if (this.filter != null && !this.filter[s]) {
                ++this.skipCount;
                this.skipUntil = string2;
                return;
            }
            if (mIRMetaLink == null || mIRMetaLink.getType() == 3) {
                ObjectIdentifier objectIdentifier = this.getHref(attributes);
                if (objectIdentifier != null) {
                    this.objectStack.push(null);
                    return;
                }
                object2 = this.processObject(this.getXmiId(attributes), s);
                this.checkObjectType(object2, s);
                if (this.root == null) {
                    this.root = object2;
                }
                short s2 = this.getObjectType(object2);
                MIRMetaClass mIRMetaClass = MIRMetaClass.getByElementType(s2);
                int n = mIRMetaClass.getAttributeCount();
                for (int n2 = 0; n2 < n; n2 = (int)((byte)(n2 + 1))) {
                    MIRMetaAttribute mIRMetaAttribute = mIRMetaClass.getAttribute(n2);
                    if (!this.importObjectId && mIRMetaAttribute.getID() == 251 || mIRMetaAttribute.getID() == 252 || s2 == 71 && mIRMetaAttribute.getID() == 174) continue;
                    this.processAttribute(object2, mIRMetaAttribute, this.getAttributeValue(mIRMetaAttribute, attributes));
                }
                if (mIRMetaLink != null) {
                    this.processLink(object, mIRMetaLink, object2);
                }
            } else if (mIRMetaLink.getType() == 0) {
                ObjectIdentifier objectIdentifier = this.getHref(attributes);
                if (objectIdentifier != null) {
                    object2 = this.processHrefObject(objectIdentifier, s);
                    this.checkObjectType(object2, s);
                    this.processLink(object, mIRMetaLink, object2);
                } else {
                    ObjectIdentifier[] objectIdentifierArray = this.getXmiIdRef(attributes);
                    for (int i = 0; i < objectIdentifierArray.length; ++i) {
                        object2 = this.getObjectById(objectIdentifierArray[i], s);
                        this.checkObjectType(object2, s);
                        this.processLink(object, mIRMetaLink, object2);
                    }
                }
            }
            this.objectStack.push(object2);
        }
        catch (MIRException mIRException) {
            throw new SAXException(mIRException);
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.currentElementValue = this.currentElementValue + new String(cArray, n, n2);
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        if (string.equals(XmlUtil.NS_XMI.getUri()) && "version".equals(string2) && (this.currentElementValue == null || !this.currentElementValue.equals(this.version))) {
            throw new SAXException(XSER.XMI_VERSION_MISMATCH.getMessage(this.version, this.currentElementValue));
        }
        if (!string.equals(XmlUtil.NS_MIR.getUri())) {
            return;
        }
        if (this.skipCount > 0) {
            if (this.skipUntil.equals(string2)) {
                --this.skipCount;
            }
            return;
        }
        this.objectStack.pop();
    }

    private void checkObjectType(Object object, short s) throws MIRException {
        short s2 = this.getObjectType(object);
        if (s2 != s) {
            throw new MIRException(XSER.OBJECT_TYPE_MISMATCH.getMessage(MIRElementType.getName(s2), MIRElementType.getName(s)));
        }
    }

    private ObjectIdentifier getXmiId(Attributes attributes) throws MIRException {
        String string = attributes.getValue(XmlUtil.NS_XMI.getUri(), "id");
        if (string == null) {
            throw new MIRException(XSER.NOT_A_MIX_FILE.getMessage(new Object[0]));
        }
        ObjectIdentifier objectIdentifier = new ObjectIdentifier(this.modelId, MIRMixIdMap.normalizeObjectId(string));
        return objectIdentifier;
    }

    private ObjectIdentifier[] getXmiIdRef(Attributes attributes) throws MIRException {
        String string = attributes.getValue(XmlUtil.NS_XMI.getUri(), "idref");
        if (string == null || string.length() == 0) {
            throw new MIRException(XSER.NOT_A_MIX_FILE.getMessage(new Object[0]));
        }
        String[] stringArray = string.split(",");
        if (stringArray == null || stringArray.length == 0) {
            throw new MIRException(XSER.NOT_A_MIX_FILE.getMessage(new Object[0]));
        }
        ObjectIdentifier[] objectIdentifierArray = new ObjectIdentifier[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            objectIdentifierArray[i] = new ObjectIdentifier(this.modelId, MIRMixIdMap.normalizeObjectId(stringArray[i]));
        }
        return objectIdentifierArray;
    }

    private ObjectIdentifier getHref(Attributes attributes) throws MIRException {
        String string = attributes.getValue(XmlUtil.NS_XMI.getUri(), "href");
        return MIRMixIdMap.parseHref(string);
    }

    private short getXsiType(Attributes attributes) throws MIRException {
        String string = attributes.getValue(XmlUtil.NS_XMLNS_XSI.getUri(), "type");
        if (string == null) {
            throw new MIRException(XSER.NOT_A_MIX_FILE.getMessage(new Object[0]));
        }
        Short s = xsiTypes.get(string);
        if (s == null) {
            throw new MIRException(XSER.XML_UNKNOWN_CHILD_CLASS_TYPE.getMessage(this.getPosition(), string));
        }
        return s;
    }

    private Object getAttributeValue(MIRMetaAttribute mIRMetaAttribute, Attributes attributes) throws MIRException {
        String string = attributes.getValue("", mIRMetaAttribute.getName());
        if (string == null && (string = attributes.getValue("", "_" + mIRMetaAttribute.getID())) == null) {
            return mIRMetaAttribute.getDefaultValue();
        }
        return mIRMetaAttribute.getValueFromString(this.upgradeValue(mIRMetaAttribute, string), true);
    }

    private MIRMetaLink getLink(short s, String string) throws MIRException {
        MIRMetaClass mIRMetaClass = MIRMetaClass.getByElementType(s);
        if (mIRMetaClass == null) {
            throw new MIRException(XSER.XML_UNKNOWN_META_LINK.getMessage(this.getPosition(), string));
        }
        Short s2 = linkTypes.get(s).get(string);
        MIRMetaLink mIRMetaLink = MIRMetaLink.getByAssociationType(s2 != null ? (short)s2 : (short)-1);
        if (mIRMetaLink == null) {
            throw new MIRException(XSER.XML_UNKNOWN_META_LINK.getMessage(this.getPosition(), string));
        }
        return mIRMetaLink;
    }

    private String upgradeValue(MIRMetaAttribute mIRMetaAttribute, String string) {
        if (mIRMetaAttribute.getID() == 430) {
            if (string.equals("AUTO")) {
                return "0";
            }
            if (string.equals("RELATIONAL")) {
                return "1";
            }
            if (string.equals("FLAT_FILE")) {
                return "2";
            }
            if (string.equals("DIMENSIONAL")) {
                return "3";
            }
            if (string.equals("DIMENSIONAL_CASE_INSENSITIVE")) {
                return "4";
            }
            if (string.equals("NAMESPACE")) {
                return "5";
            }
            if (string.equals("NATIVE_ID")) {
                return "6";
            }
            if (string.equals("REPORT_BY_NAME")) {
                return "7";
            }
            if (string.equals("MATCHING_RULE_SAPBW_DATA_SOURCE")) {
                return "9";
            }
        } else if (mIRMetaAttribute.getID() == 312) {
            if (string.equals("ACCEPTED")) {
                return "REVIEWED";
            }
            if (string.equals("STANDARD")) {
                return "APPROVED";
            }
        } else if (mIRMetaAttribute.getID() == 140 && (string.equals("TRANSFORMATION_TASK_MODEL") || string.equals("ACTIVITY_MODEL") || string.equals("PARAMETER_MODEL") || string.equals("QUERY_MAPPING"))) {
            return "DI_MODEL";
        }
        return string;
    }

    protected boolean isExternalReference(String string) {
        int n = string.indexOf("#_");
        if (n == -1) {
            return false;
        }
        return !string.startsWith(this.modelId + "#_");
    }

    protected abstract short getObjectType(Object var1) throws MIRException;

    protected abstract Object getObjectById(ObjectIdentifier var1, short var2) throws MIRException;

    protected abstract Object processObject(ObjectIdentifier var1, short var2) throws MIRException;

    protected abstract Object processHrefObject(ObjectIdentifier var1, short var2) throws MIRException;

    protected abstract void processAttribute(Object var1, MIRMetaAttribute var2, Object var3) throws MIRException;

    protected abstract void processLink(Object var1, MIRMetaLink var2, Object var3) throws MIRException;

    static {
        for (short s = 0; s < 374; s = (short)(s + 1)) {
            MIRMetaClass mIRMetaClass = MIRMetaClass.getByElementType(s);
            if (mIRMetaClass != null && !mIRMetaClass.isAbstract()) {
                xsiTypes.put("mir:" + mIRMetaClass.getName(), mIRMetaClass.getID());
                xsiTypes.put("_" + String.valueOf(mIRMetaClass.getID()), mIRMetaClass.getID());
                attributeTypes.add(new HashMap());
                for (MIRMetaAttribute mIRMetaAttribute : mIRMetaClass.getAttributes()) {
                    attributeTypes.get(s).put(mIRMetaAttribute.getName(), mIRMetaAttribute.getID());
                    attributeTypes.get(s).put("_" + String.valueOf(mIRMetaAttribute.getID()), mIRMetaAttribute.getID());
                }
                linkTypes.add(new HashMap());
                for (MIRMetaLink mIRMetaLink : mIRMetaClass.getLinks()) {
                    linkTypes.get(s).put(mIRMetaLink.getName(), mIRMetaLink.getID());
                    linkTypes.get(s).put("_" + String.valueOf(mIRMetaLink.getID()), mIRMetaLink.getID());
                }
                continue;
            }
            attributeTypes.add(null);
            linkTypes.add(null);
        }
        xsiTypes.put("mir:TransformationTaskModel", (short)258);
        xsiTypes.put("mir:ActivityModel", (short)258);
        xsiTypes.put("_271", (short)258);
        xsiTypes.put("mir:ParameterModel", (short)258);
        xsiTypes.put("_291", (short)258);
        xsiTypes.put("mir:QueryMapping", (short)258);
        xsiTypes.put("_276", (short)258);
        linkTypes.get(258).put("QueryMapping", (short)279);
        linkTypes.get(258).put("_1070", (short)279);
    }
}

