/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk.mix;

import MITI.MIRException;
import MITI.sdk.MIRElementType;
import MITI.sdk.MIRMetaAttribute;
import MITI.sdk.MIRMetaClass;
import MITI.sdk.MIRMetaLink;
import MITI.sdk.MIRMetaObject;
import MITI.sdk.MIRObject;
import MITI.sdk.MIR_Object;
import MITI.sdk.mix.checksum.MixChecksum;
import MITI.server.services.common.mir.ObjectIdentifier;
import MITI.util.VersionInfo;
import MITI.util.XmlUtil;
import MITI.util.XmlVersion;
import MITI.util.file.FileUtil;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public abstract class MIRMIXWriter {
    private static String exporterVersion = "";
    private static String xmiDisclaimer;
    private Writer writer = null;
    private XmlVersion xmlVersion = XmlVersion.XML_11;
    private boolean optimizeTagNames = false;
    private boolean optimizeID = false;
    private boolean optimizeDefaultValues = true;
    private boolean optimizeIdrefs = false;
    private boolean optimizeReverseLinks = true;
    private boolean writeBridgeBuildDate = true;
    private String xsiSchemaLocation = null;

    public void setOptimizeDefaultValues(boolean bl) {
        this.optimizeDefaultValues = bl;
    }

    public void setOptimizeID(boolean bl) {
        this.optimizeID = bl;
    }

    public void setOptimizeIdrefs(boolean bl) {
        this.optimizeIdrefs = bl;
    }

    public void setOptimizeReverseLinks(boolean bl) {
        this.optimizeReverseLinks = bl;
    }

    public void setWriteBridgeBuildDate(boolean bl) {
        this.writeBridgeBuildDate = bl;
    }

    public void setOptimizeTagNames(boolean bl) {
        this.optimizeTagNames = bl;
    }

    public void setXsiSchemaLocation(String string) {
        this.xsiSchemaLocation = string;
    }

    protected void openDocument(OutputStream outputStream, MixChecksum mixChecksum) throws MIRException {
        this.xmlVersion = XmlVersion.get();
        this.writer = new BufferedWriter(new OutputStreamWriter(outputStream, FileUtil.UTF8));
        try {
            this.writer.write(this.xmlVersion.getDecl("UTF-8"));
            this.writer.write("\n");
            this.writer.append("<!--").append(xmiDisclaimer).append("-->\n");
            this.startElement("xmi:XMI");
            this.writeAttribute("xmi:version", "2.0");
            this.writeAttribute("xmlns:mir", XmlUtil.NS_MIR.getUri());
            this.writeAttribute("xmlns:xmi", XmlUtil.NS_XMI.getUri());
            this.writeAttribute("xmlns:xsi", XmlUtil.NS_XMLNS_XSI.getUri());
            if (this.xsiSchemaLocation != null) {
                this.writeAttribute("xsi:schemaLocation", this.xsiSchemaLocation);
            }
            this.closeElement();
            this.startElement("xmi:Documentation");
            this.closeElement();
            this.dataElement("exporter", "Meta Integration Model Bridge");
            if (this.writeBridgeBuildDate) {
                this.dataElement("exporterVersion", exporterVersion);
            }
            if (mixChecksum != null) {
                String string = mixChecksum.toXml();
                this.writer.append(string).append("\n");
            }
            this.endElement("xmi:Documentation");
            this.startElement("xmi:MetaModel");
            this.closeElement();
            this.dataElement("name", "MIR");
            this.dataElement("version", "7.0.0");
            this.endElement("xmi:MetaModel");
        }
        catch (IOException iOException) {
            throw new MIRException(iOException);
        }
    }

    protected void closeDocument() throws MIRException {
        try {
            this.endElement("xmi:XMI");
        }
        catch (IOException iOException) {
            throw new MIRException(iOException);
        }
        finally {
            try {
                this.writer.flush();
                this.writer.close();
            }
            catch (IOException iOException) {
                throw new MIRException(iOException);
            }
        }
    }

    protected void printObject(MIRObject mIRObject, MIRMetaLink mIRMetaLink) throws MIRException {
        try {
            ObjectIdentifier objectIdentifier = this.getXmiId(mIRObject);
            MIRMetaClass mIRMetaClass = mIRObject.getMetaClass();
            boolean bl = true;
            this.startObject(objectIdentifier, mIRMetaClass, mIRMetaLink);
            for (MIRMetaAttribute member : mIRMetaClass.getAttributes()) {
                this.printAttribute(member, member.get(mIRObject));
            }
            for (MIRMetaLink mIRMetaLink2 : mIRMetaClass.getLinks()) {
                Iterator<? extends MIRObject> iterator;
                if (mIRMetaLink2.getType() == 3) {
                    iterator = mIRMetaLink2.getIterator((MIR_Object)mIRObject);
                    if (!iterator.hasNext()) continue;
                    if (bl) {
                        this.closeElement();
                    }
                    bl = false;
                    while (iterator.hasNext()) {
                        MIRObject mIRObject2 = iterator.next();
                        if (this.isExternalReference(mIRObject, mIRObject2)) continue;
                        this.printObject(mIRObject2, mIRMetaLink2);
                    }
                    continue;
                }
                if (mIRMetaLink2.getType() != 0 && (this.optimizeReverseLinks || mIRMetaLink2.getType() != 1) || !(iterator = mIRMetaLink2.getIterator((MIR_Object)mIRObject)).hasNext()) continue;
                if (bl) {
                    this.closeElement();
                }
                bl = false;
                this.printLink(mIRObject, mIRMetaLink2, iterator);
            }
            this.endObject(mIRMetaLink != null ? mIRMetaLink : mIRMetaClass, bl);
        }
        catch (IOException iOException) {
            throw new MIRException(iOException);
        }
    }

    private void startObject(ObjectIdentifier objectIdentifier, MIRMetaClass mIRMetaClass, MIRMetaLink mIRMetaLink) throws MIRException {
        try {
            this.writer.append('<');
            if (mIRMetaLink == null) {
                this.writer.append("mir:");
            }
            if (this.optimizeID) {
                this.writer.append('_').append(String.valueOf(mIRMetaLink != null ? mIRMetaLink.getID() : mIRMetaClass.getID()));
            } else {
                this.writer.append(mIRMetaLink != null ? mIRMetaLink.getName() : mIRMetaClass.getName());
            }
            if (mIRMetaLink == null) {
                this.writeAttribute("xmlns", XmlUtil.NS_MIR.getUri());
            }
            this.printElementType(mIRMetaClass.getID());
            this.writer.append(" xmi:id=\"_").append(String.valueOf(objectIdentifier.getObjectId())).append('\"');
        }
        catch (IOException iOException) {
            throw new MIRException(iOException);
        }
    }

    private void endObject(MIRMetaObject mIRMetaObject, boolean bl) throws MIRException {
        try {
            if (bl) {
                this.writer.append("/");
            } else {
                this.writer.append("</");
                if (mIRMetaObject instanceof MIRMetaClass) {
                    this.writer.append("mir:");
                }
                if (this.optimizeID) {
                    this.writer.append('_').append(String.valueOf(mIRMetaObject.getID()));
                } else {
                    this.writer.append(mIRMetaObject.getName());
                }
            }
            this.closeElement();
        }
        catch (IOException iOException) {
            throw new MIRException(iOException);
        }
    }

    private void printAttribute(MIRMetaAttribute mIRMetaAttribute, Object object) throws MIRException {
        try {
            if (mIRMetaAttribute.getID() == 172 || mIRMetaAttribute.getID() == 251 || mIRMetaAttribute.getID() == 252) {
                return;
            }
            boolean bl = object.equals(mIRMetaAttribute.getDefaultValue());
            if (this.optimizeDefaultValues && bl) {
                return;
            }
            String string = mIRMetaAttribute.getValueToString(object, true);
            if (string.isEmpty() && bl) {
                return;
            }
            if (this.optimizeTagNames) {
                this.writeAttribute(mIRMetaAttribute.getID(), string);
            } else {
                this.writeAttribute(mIRMetaAttribute.getName(), string);
            }
        }
        catch (IOException iOException) {
            throw new MIRException(iOException);
        }
    }

    private void printLink(MIRObject mIRObject, MIRMetaLink mIRMetaLink, Iterator<? extends MIRObject> iterator) throws MIRException {
        try {
            if (!this.optimizeIdrefs || mIRMetaLink.isUnary()) {
                while (iterator.hasNext()) {
                    MIRObject mIRObject2 = iterator.next();
                    if (this.isExternalReference(mIRObject, mIRObject2)) continue;
                    this.printLink(mIRMetaLink, mIRObject2.getElementType(), this.getXmiId(mIRObject2));
                }
            } else {
                TreeMap<Short, ArrayList> treeMap = new TreeMap<Short, ArrayList>();
                while (iterator.hasNext()) {
                    MIRObject mIRObject3 = iterator.next();
                    if (this.isExternalReference(mIRObject, mIRObject3)) continue;
                    treeMap.computeIfAbsent(mIRObject3.getElementType(), s -> new ArrayList()).add(this.getXmiId(mIRObject3));
                }
                for (Map.Entry entry : treeMap.entrySet()) {
                    this.printLink(mIRMetaLink, (short)((Short)entry.getKey()), (Collection)entry.getValue());
                }
            }
        }
        catch (IOException iOException) {
            throw new MIRException(iOException);
        }
    }

    private void printElementType(short s) throws IOException {
        this.writer.append(" xsi:type=\"");
        if (this.optimizeID) {
            this.writer.append('_').append(String.valueOf(s));
        } else {
            this.writer.append("mir:").append(MIRElementType.getName(s));
        }
        this.writer.append('\"');
    }

    private void printLink(MIRMetaLink mIRMetaLink, short s, Collection<ObjectIdentifier> collection) throws IOException {
        this.writer.write(60);
        if (this.optimizeID) {
            this.writer.append('_').append(String.valueOf(mIRMetaLink.getID()));
        } else {
            this.writer.append(mIRMetaLink.getName());
        }
        this.printElementType(s);
        this.writer.append(" xmi:idref=\"");
        boolean bl = true;
        for (ObjectIdentifier objectIdentifier : collection) {
            if (bl) {
                bl = false;
            } else {
                this.writer.append(',');
            }
            this.writer.append('_').append(String.valueOf(objectIdentifier.getObjectId()));
        }
        this.writer.append('\"');
        this.closeEmptyElement();
    }

    private void printLink(MIRMetaLink mIRMetaLink, short s, ObjectIdentifier objectIdentifier) throws IOException {
        this.writer.write(60);
        if (this.optimizeID) {
            this.writer.append('_').append(String.valueOf(mIRMetaLink.getID()));
        } else {
            this.writer.append(mIRMetaLink.getName());
        }
        this.printElementType(s);
        this.writer.append(" xmi:idref=\"_").append(String.valueOf(objectIdentifier.getObjectId())).append('\"');
        this.closeEmptyElement();
    }

    protected abstract ObjectIdentifier getXmiId(MIRObject var1) throws MIRException;

    private boolean isExternalReference(MIRObject mIRObject, MIRObject mIRObject2) {
        return mIRObject.getRootModel() != mIRObject2.getRootModel();
    }

    private Writer startElement(String string) throws IOException {
        return this.writer.append('<').append(string);
    }

    private Writer endElement(String string) throws IOException {
        return this.writer.append("</").append(string).append(">\n");
    }

    private Writer closeElement() throws IOException {
        return this.writer.append(">\n");
    }

    private Writer closeEmptyElement() throws IOException {
        this.writer.append('/');
        return this.closeElement();
    }

    private Writer dataElement(String string, String string2) throws IOException {
        return this.writer.append('<').append(string).append('>').append(string2).append('<').append('/').append(string).append('>').append('\n');
    }

    private Writer writeAttribute(String string, String string2) throws IOException {
        return this.writer.append(' ').append(string).append('=').append('\"').append(XmlUtil.escapeXml(string2, this.xmlVersion)).append('\"');
    }

    private Writer writeAttribute(int n, String string) throws IOException {
        return this.writer.append(' ').append('_').append(String.valueOf(n)).append('=').append('\"').append(XmlUtil.escapeXml(string, this.xmlVersion)).append('\"');
    }

    static {
        VersionInfo versionInfo = VersionInfo.loadMitiJar(MIRMIXWriter.class);
        if (versionInfo != null) {
            String string = versionInfo.getVersionString();
            String string2 = versionInfo.getDate();
            if (string != null && string2 != null) {
                exporterVersion = string + " " + string2;
            }
        }
        xmiDisclaimer = "\nThis MIR XMI document is based upon the Meta Integration Repository (MIR) Metamodel which is copyrighted intellectual property of Meta Integration Technology, Inc. (MITI).  Generation of this document code does not include any licenses or any other rights to you under any MITI intellectual property agreement. If you would like a license from MITI (e.g., to parse, generate or distribute), you need to contact MITI directly.\nMITI reserves the rights to change the MIR Metamodel and MIR XMI file format at its own discretion.\nCompanies with a valid and current license to this document format have a non-transferable, non-sublicensable, personal, license to parse, generate or distribute or otherwise disclose copies of such a Company Implementation, only if Company (i) prominently displays this complete notice in all copies of such formatted documents, and (ii) distributes or discloses the samples of this format only under a license agreement that includes this notice as a term of such license agreement, and does not include any other terms that are inconsistent with this notice.\nMeta Integration is a registered trademark of Meta Integration Technology, Inc.\n";
    }
}

