/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk.mix;

import MITI.MIRException;
import MITI.messages.MIR.XSER;
import MITI.sdk.MIRAllClasses;
import MITI.sdk.MIRMetaAttribute;
import MITI.sdk.MIRMetaLink;
import MITI.sdk.MIRObject;
import MITI.sdk.mix.MIRMixHandler;
import MITI.sdk.mix.MIRMixIdMap;
import MITI.sdk.mix.MIRMixLink;
import MITI.sdk.mix.ids.SingleModelMixIds;
import MITI.server.services.common.mir.ObjectIdentifier;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

public class MIRMIXImport
extends MIRMixHandler {
    private MIRMixIdMap ids = null;
    private Set<MIRObject> forwardReferences = null;
    private ArrayList<MIRMixLink> forwardLinks = null;

    public MIRMIXImport() {
        this(false);
    }

    public MIRMIXImport(boolean bl) {
        super(bl);
    }

    public static MIRObject load(File file) throws MIRException {
        return new MIRMIXImport(false).run(file, new SingleModelMixIds(), null);
    }

    public static MIRObject sparseLoad(File file, short[] sArray) throws MIRException {
        return new MIRMIXImport(false).run(file, new SingleModelMixIds(), sArray);
    }

    protected MIRObject run(File file, MIRMixIdMap mIRMixIdMap, short[] sArray) throws MIRException {
        this.ids = mIRMixIdMap;
        this.forwardReferences = new TreeSet<MIRObject>();
        this.forwardLinks = new ArrayList();
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new MIRException(fileNotFoundException);
        }
        return this.load(fileInputStream, file.getName(), sArray);
    }

    protected MIRObject run(byte[] byArray, String string, MIRMixIdMap mIRMixIdMap, short[] sArray) throws MIRException {
        this.ids = mIRMixIdMap;
        this.forwardReferences = new TreeSet<MIRObject>();
        this.forwardLinks = new ArrayList();
        return this.load(new ByteArrayInputStream(byArray), string, sArray);
    }

    private MIRObject load(InputStream inputStream, String string, short[] sArray) throws MIRException {
        MIRObject mIRObject = (MIRObject)this.read(inputStream, string, sArray);
        for (MIRMixLink object : this.forwardLinks) {
            object.process();
        }
        if (this.forwardReferences.size() > 0) {
            Iterator<Object> iterator = this.forwardReferences.iterator();
            if (sArray != null) {
                Arrays.sort(sArray);
            }
            while (iterator.hasNext()) {
                MIRObject mIRObject2 = (MIRObject)iterator.next();
                if (sArray != null && Arrays.binarySearch(sArray, mIRObject2.getElementType()) >= 0) {
                    mIRObject2.delete();
                    continue;
                }
                throw new MIRException(XSER.UNKNOWN_OBJECT.getMessage(mIRObject2.getName(), this.ids.getObjectIdentifier(mIRObject2).toString()));
            }
        }
        return mIRObject;
    }

    @Override
    public short getObjectType(Object object) {
        return ((MIRObject)object).getElementType();
    }

    @Override
    public Object getObjectById(ObjectIdentifier objectIdentifier, short s) {
        MIRObject mIRObject = this.ids.getMirObject(objectIdentifier);
        if (mIRObject == null) {
            mIRObject = (MIRObject)this.processObject(objectIdentifier, s);
            this.forwardReferences.add(mIRObject);
        }
        return mIRObject;
    }

    @Override
    public Object processObject(ObjectIdentifier objectIdentifier, short s) {
        MIRObject mIRObject = this.ids.getMirObject(objectIdentifier);
        if (mIRObject == null) {
            mIRObject = MIRAllClasses.createMIRObject(s);
            this.ids.put(objectIdentifier, mIRObject);
        } else {
            this.forwardReferences.remove(mIRObject);
        }
        return mIRObject;
    }

    @Override
    public Object processHrefObject(ObjectIdentifier objectIdentifier, short s) {
        MIRObject mIRObject = this.ids.getMirObject(objectIdentifier);
        if (mIRObject == null) {
            mIRObject = MIRAllClasses.createMIRObject(s);
            this.ids.put(objectIdentifier, mIRObject);
        }
        return mIRObject;
    }

    @Override
    public void processAttribute(Object object, MIRMetaAttribute mIRMetaAttribute, Object object2) {
        if (mIRMetaAttribute.getID() == 172) {
            return;
        }
        MIRObject mIRObject = (MIRObject)object;
        mIRMetaAttribute.set(mIRObject, object2);
    }

    @Override
    public void processLink(Object object, MIRMetaLink mIRMetaLink, Object object2) {
        if (this.forwardReferences.contains(object2)) {
            this.forwardLinks.add(new MIRMixLink((MIRObject)object, mIRMetaLink, (MIRObject)object2));
        } else {
            mIRMetaLink.add((MIRObject)object, (MIRObject)object2);
        }
    }
}

