/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk.id.objects;

import MITI.sdk.MIRElement;
import MITI.sdk.MIRMetaAttribute;
import MITI.sdk.MIRMetaClass;
import MITI.sdk.MIRMetaLink;
import MITI.sdk.MIRModel;
import MITI.sdk.MIRModelObject;
import MITI.sdk.MIRObject;
import MITI.sdk.MIRReportItem;
import MITI.sdk.MIR_Object;
import MITI.sdk.collections.MIRSdkCollection;
import MITI.sdk.id.MIRSystemId;
import MITI.sdk.id.objects.MIRReportItemIdentity;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

public class MIRObjectIdentity {
    public MIRSystemId.Type type = null;
    public String localPart = null;
    public MIRObject parent = null;
    public MIRObject content = null;
    private static final ArrayList<Class<? extends MIRObjectIdentity>> identityClasses = new ArrayList<Object>(Collections.nCopies(374, null));

    private static Class<? extends MIRObjectIdentity> getIdentityClass(MIRObject mIRObject) {
        Class clazz = identityClasses.get(mIRObject.getElementType());
        if (clazz == null) {
            try {
                String string = MIRObjectIdentity.class.getPackage().getName() + "." + mIRObject.getClass().getSimpleName() + "Identity";
                clazz = Class.forName(string).asSubclass(MIRObjectIdentity.class);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (clazz == null) {
                clazz = mIRObject instanceof MIRReportItem ? MIRReportItemIdentity.class : MIRObjectIdentity.class;
            }
            identityClasses.set(mIRObject.getElementType(), clazz);
        }
        return clazz;
    }

    public static MIRObjectIdentity compute(MIRObject mIRObject) {
        MIRObjectIdentity mIRObjectIdentity = null;
        try {
            Class<? extends MIRObjectIdentity> clazz = MIRObjectIdentity.getIdentityClass(mIRObject);
            Constructor<? extends MIRObjectIdentity> constructor = clazz.getDeclaredConstructor(MIRObject.class);
            mIRObjectIdentity = constructor.newInstance(mIRObject);
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return mIRObjectIdentity;
    }

    protected MIRObjectIdentity(MIRObject mIRObject) {
        this.computeSystemId(mIRObject);
    }

    private void computeSystemId(MIRObject mIRObject) {
        Comparable<MIR_Object> comparable;
        if (mIRObject instanceof MIRElement && ((MIRElement)mIRObject).getNativeId().length() > 0) {
            this.type = MIRSystemId.Type.NATIVE_ID;
            this.localPart = ((MIRElement)mIRObject).getNativeId();
        } else {
            comparable = null;
            MIRMetaClass mIRMetaClass = mIRObject.getMetaClass();
            for (int n = 0; n < mIRMetaClass.getLinkCount(); n = (int)((byte)(n + 1))) {
                Iterator<? extends MIRObject> iterator;
                MIRMetaLink mIRMetaLink = mIRMetaClass.getLink(n);
                if (mIRMetaLink.getType() != 2 && mIRMetaLink.getID() != 598 || mIRMetaLink.getID() == 838 || !(iterator = mIRMetaLink.getIterator((MIR_Object)mIRObject)).hasNext()) continue;
                MIRObject mIRObject2 = iterator.next();
                MIRMetaLink mIRMetaLink2 = mIRMetaLink.getReverse();
                MIRSdkCollection mIRSdkCollection = mIRMetaLink2.getCollection(mIRObject2);
                if (mIRSdkCollection != null && mIRSdkCollection.getType() == MIRSdkCollection.Type.PHYSICAL_NAME) {
                    this.parent = mIRObject2;
                    comparable = mIRMetaLink2;
                    continue;
                }
                if (mIRMetaLink.getType() != 2 || this.parent != null) continue;
                this.parent = mIRObject2;
                comparable = mIRMetaLink2;
            }
            if (this.parent == null) {
                this.type = MIRSystemId.Type.LOGICAL;
                this.localPart = mIRObject.getName();
            } else {
                this.computeSystemId((MIRMetaLink)comparable, mIRObject);
            }
        }
        if ((this.type == MIRSystemId.Type.NATIVE_ID || mIRObject instanceof MIRModel) && (comparable = mIRObject.getRootModel()) != null) {
            this.content = comparable.getParent();
        }
    }

    protected void computeSystemId(MIRMetaLink mIRMetaLink, MIRObject mIRObject) {
        MIRSdkCollection mIRSdkCollection;
        MIRSdkCollection.Type type;
        String string;
        String string2 = mIRObject.getName();
        String string3 = string = mIRObject instanceof MIRModelObject ? ((MIRModelObject)mIRObject).getPhysicalName() : "";
        if (string.isEmpty()) {
            string = string2;
        }
        MIRSdkCollection.Type type2 = type = (mIRSdkCollection = mIRMetaLink.getCollection(this.parent)) != null ? mIRSdkCollection.getType() : MIRSdkCollection.Type.OBJECT;
        if (type == MIRSdkCollection.Type.PHYSICAL_NAME) {
            this.type = MIRSystemId.Type.PHYSICAL;
            this.localPart = "[" + mIRMetaLink.getID() + "]" + string;
        } else if (type == MIRSdkCollection.Type.NAME) {
            this.type = MIRSystemId.Type.LOGICAL;
            this.localPart = "[" + mIRMetaLink.getID() + "]" + string2;
        } else if (type == MIRSdkCollection.Type.OPTIONAL_NAME && !string2.isEmpty()) {
            this.type = MIRSystemId.Type.LOGICAL;
            this.localPart = "[" + mIRMetaLink.getID() + "]" + string2;
        } else if (mIRMetaLink.isUnary()) {
            this.type = MIRSystemId.Type.LOGICAL;
            this.localPart = "[" + mIRMetaLink.getID() + "]" + string2;
        } else {
            this.type = MIRSystemId.Type.RANDOM;
            this.localPart = "[" + mIRMetaLink.getID() + "]" + MIRObjectIdentity.getObjectHash(mIRObject);
        }
    }

    public static int getObjectHash(MIRObject mIRObject) {
        String string = "";
        MIRMetaClass mIRMetaClass = mIRObject.getMetaClass();
        for (int n = 0; n < mIRMetaClass.getAttributeCount(); n = (int)((byte)(n + 1))) {
            MIRMetaAttribute mIRMetaAttribute = mIRMetaClass.getAttribute(n);
            if (mIRMetaAttribute.getID() == 251 || mIRMetaAttribute.getID() == 252) continue;
            string = string + mIRMetaAttribute.getName() + "=" + mIRMetaAttribute.get(mIRObject).toString();
        }
        return string.hashCode();
    }
}

