/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk.id;

import MITI.sdk.MIRContent;
import MITI.sdk.MIRDirectoryStructureModel;
import MITI.sdk.MIRFolder;
import MITI.sdk.MIRFolderContent;
import MITI.sdk.MIRModel;
import MITI.sdk.MIRObject;
import MITI.sdk.id.MIRSystemIdCache;
import MITI.sdk.id.objects.MIRObjectIdentity;

public class MIRSystemId {
    private Type type = null;
    private String id = "";
    private boolean isRandom = false;

    private static boolean isDatabaseMultiModel(MIRModel mIRModel) {
        MIRModel mIRModel2;
        MIRContent mIRContent = mIRModel.getContent();
        return mIRContent != null && (mIRModel2 = mIRContent.getRootModel()) instanceof MIRDirectoryStructureModel && ((MIRDirectoryStructureModel)mIRModel2).getType() == 4;
    }

    private static boolean isDatabaseMultiCatalog(MIRDirectoryStructureModel mIRDirectoryStructureModel) {
        if (mIRDirectoryStructureModel.getType() == 4) {
            for (MIRFolderContent mIRFolderContent : mIRDirectoryStructureModel.getFolderContents()) {
                if (!(mIRFolderContent instanceof MIRFolder) || !mIRFolderContent.getNativeType().equals("CATALOG")) continue;
                return true;
            }
        }
        return false;
    }

    protected MIRSystemId(MIRSystemIdCache mIRSystemIdCache, MIRObject mIRObject) {
        MIRSystemId mIRSystemId;
        MIRObjectIdentity mIRObjectIdentity = MIRObjectIdentity.compute(mIRObject);
        this.type = mIRObjectIdentity.type;
        if (mIRObjectIdentity.content != null) {
            mIRSystemId = mIRSystemIdCache.getObjectIdentity(mIRObjectIdentity.content);
            this.id = this.id + mIRSystemId.getId() + "##";
            this.isRandom |= mIRSystemId.isRandom();
        }
        if (mIRObjectIdentity.parent != null) {
            mIRSystemId = mIRSystemIdCache.getObjectIdentity(mIRObjectIdentity.parent);
            this.id = this.id + mIRSystemId.getId() + "/";
            this.isRandom |= mIRSystemId.isRandom;
        }
        if (!(mIRObject instanceof MIRDirectoryStructureModel && MIRSystemId.isDatabaseMultiCatalog((MIRDirectoryStructureModel)mIRObject) || mIRObject instanceof MIRModel && MIRSystemId.isDatabaseMultiModel((MIRModel)mIRObject))) {
            this.id = this.id + mIRObjectIdentity.localPart;
            this.isRandom |= this.type == Type.RANDOM;
            if (!mIRSystemIdCache.isUnique(mIRObject, this)) {
                this.isRandom = true;
                this.id = this.id + "#" + mIRSystemIdCache.generateUniqueId();
            }
        }
    }

    public String getId() {
        return this.id;
    }

    public boolean isRandom() {
        return this.isRandom;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof MIRSystemId) {
            MIRSystemId mIRSystemId = (MIRSystemId)object;
            return this.id.equals(mIRSystemId.id);
        }
        return false;
    }

    public static enum Type {
        NATIVE_ID("nid"),
        LOGICAL("lid"),
        PHYSICAL("pid"),
        RANDOM("nsid");

        private String uri = null;

        private Type(String string2) {
            this.uri = string2;
        }

        public String toString() {
            return this.uri;
        }
    }
}

