/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk;

import MITI.messages.MIR.MIRSDK;
import MITI.sdk.MIRClassifierMap;
import MITI.sdk.MIRDiModel;
import MITI.sdk.MIREmbeddedCallTransformation;
import MITI.sdk.MIRMetaAttribute;
import MITI.sdk.MIRMetaClass;
import MITI.sdk.MIRMetaLink;
import MITI.sdk.MIRObject;
import MITI.sdk.MIRObjectCollections;
import MITI.sdk.MIRStepElement;
import MITI.sdk.MIRTransformationDataSet;
import MITI.sdk.MIR_Object;
import MITI.sdk.collections.MIRObjectCollection;
import MITI.sdk.collections.MIRSdkCollection;
import java.util.Iterator;
import java.util.SortedSet;

public abstract class MIRTransformation
extends MIRStepElement {
    protected transient String aTechnicalName = "";
    protected transient MIRObjectCollection<MIRClassifierMap> classifierMaps = null;
    protected transient MIRDiModel hasDiModel = null;
    protected transient MIREmbeddedCallTransformation hasEmbeddedCallTransformation = null;
    protected transient MIRTransformationDataSet hasErrorTransformationDataSet = null;
    private static MIRMetaClass metaClass = MIRTransformation.staticGetMetaClass();

    @Override
    public short getElementType() {
        return 79;
    }

    @Override
    public void setFrom(MIR_Object mIR_Object) {
        super.setFrom(mIR_Object);
        if (mIR_Object.isInstanceOf((short)79)) {
            this.setTechnicalName(((MIRTransformation)mIR_Object).getTechnicalName());
        }
    }

    @Override
    public MIRObject getParent() {
        if (this.hasDiModel != null) {
            return this.hasDiModel;
        }
        if (this.hasEmbeddedCallTransformation != null) {
            return this.hasEmbeddedCallTransformation;
        }
        return super.getParent();
    }

    @Override
    public int getParentCount() {
        return (this.hasDiModel != null ? 1 : 0) + (this.hasEmbeddedCallTransformation != null ? 1 : 0) + super.getParentCount();
    }

    public final void setTechnicalName(String string) {
        this.aTechnicalName = string == null ? "" : string;
    }

    public final String getTechnicalName() {
        return this.aTechnicalName;
    }

    protected MIRObjectCollection<MIRClassifierMap> getClassifierMapCollection() {
        this.classifierMaps = MIRObjectCollections.get(this.classifierMaps, MIRSdkCollection.Type.OBJECT);
        return this.classifierMaps;
    }

    public SortedSet<MIRClassifierMap> getClassifierMaps() {
        return MIRObjectCollections.sortedSet(this.classifierMaps);
    }

    public final void addClassifierMap(MIRClassifierMap mIRClassifierMap) {
        if (mIRClassifierMap == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Transformation", "ClassifierMap"));
        }
        if (mIRClassifierMap._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Transformation", "ClassifierMap"));
        }
        if (mIRClassifierMap.hasTransformation != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("ClassifierMap", "Transformation"));
        }
        if (this.classifierMaps != null && this.classifierMaps.contains(mIRClassifierMap)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Transformation", "ClassifierMap"));
        }
        this.getClassifierMapCollection().add(mIRClassifierMap);
        mIRClassifierMap.hasTransformation = this;
    }

    public final int getClassifierMapCount() {
        if (this.classifierMaps != null) {
            return this.classifierMaps.size();
        }
        return 0;
    }

    public final boolean containsClassifierMap(MIRClassifierMap mIRClassifierMap) {
        if (mIRClassifierMap != null && this.classifierMaps != null) {
            return this.classifierMaps.contains(mIRClassifierMap);
        }
        return false;
    }

    public final MIRClassifierMap getClassifierMap(String string) {
        if (this.classifierMaps != null) {
            return this.classifierMaps.get(string);
        }
        return null;
    }

    public final Iterator<MIRClassifierMap> getClassifierMapIterator() {
        if (this.classifierMaps != null) {
            return this.classifierMaps.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeClassifierMap(MIRClassifierMap mIRClassifierMap) {
        if (mIRClassifierMap != null && this.classifierMaps != null && this.classifierMaps.remove(mIRClassifierMap)) {
            mIRClassifierMap.hasTransformation = null;
            if (this.classifierMaps.isEmpty()) {
                this.classifierMaps = null;
            }
            return true;
        }
        return false;
    }

    public final void removeClassifierMaps() {
        if (this.classifierMaps != null) {
            for (MIRClassifierMap mIRClassifierMap : this.classifierMaps) {
                mIRClassifierMap.hasTransformation = null;
            }
            this.classifierMaps = null;
        }
    }

    public final void addDiModel(MIRDiModel mIRDiModel) {
        if (mIRDiModel == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Transformation", "DiModel"));
        }
        if (mIRDiModel._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Transformation", "DiModel"));
        }
        if (this.hasDiModel != null) {
            if (this.hasDiModel._equals(mIRDiModel)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Transformation", "DiModel"));
            }
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("Transformation", "DiModel"));
        }
        if (mIRDiModel.transformations != null && !mIRDiModel._allowName(mIRDiModel.transformations, this)) {
            throw new IllegalArgumentException(MIRSDK.NAME_COLLISION.getMessage("DiModel", mIRDiModel.getPath(), "Transformation", "Object", this.getName()));
        }
        this.hasDiModel = mIRDiModel;
        mIRDiModel.getTransformationCollection().add(this);
    }

    public final MIRDiModel getDiModel() {
        return this.hasDiModel;
    }

    public final boolean removeDiModel() {
        if (this.hasDiModel != null) {
            this.hasDiModel.transformations.remove(this);
            if (this.hasDiModel.transformations.isEmpty()) {
                this.hasDiModel.transformations = null;
            }
            this.hasDiModel = null;
            return true;
        }
        return false;
    }

    public final void addEmbeddedCallTransformation(MIREmbeddedCallTransformation mIREmbeddedCallTransformation) {
        if (mIREmbeddedCallTransformation == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Transformation", "EmbeddedCallTransformation"));
        }
        if (mIREmbeddedCallTransformation._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Transformation", "EmbeddedCallTransformation"));
        }
        if (this.hasEmbeddedCallTransformation != null) {
            if (this.hasEmbeddedCallTransformation._equals(mIREmbeddedCallTransformation)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Transformation", "EmbeddedCallTransformation"));
            }
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("Transformation", "EmbeddedCallTransformation"));
        }
        if (mIREmbeddedCallTransformation.transformations != null && !mIREmbeddedCallTransformation._allowName(mIREmbeddedCallTransformation.transformations, this)) {
            throw new IllegalArgumentException(MIRSDK.NAME_COLLISION.getMessage("EmbeddedCallTransformation", mIREmbeddedCallTransformation.getPath(), "Transformation", "Object", this.getName()));
        }
        this.hasEmbeddedCallTransformation = mIREmbeddedCallTransformation;
        mIREmbeddedCallTransformation.getTransformationCollection().add(this);
    }

    public final MIREmbeddedCallTransformation getEmbeddedCallTransformation() {
        return this.hasEmbeddedCallTransformation;
    }

    public final boolean removeEmbeddedCallTransformation() {
        if (this.hasEmbeddedCallTransformation != null) {
            this.hasEmbeddedCallTransformation.transformations.remove(this);
            if (this.hasEmbeddedCallTransformation.transformations.isEmpty()) {
                this.hasEmbeddedCallTransformation.transformations = null;
            }
            this.hasEmbeddedCallTransformation = null;
            return true;
        }
        return false;
    }

    public final void addErrorTransformationDataSet(MIRTransformationDataSet mIRTransformationDataSet) {
        if (mIRTransformationDataSet == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Transformation", "ErrorTransformationDataSet"));
        }
        if (mIRTransformationDataSet._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Transformation", "ErrorTransformationDataSet"));
        }
        if (this.hasErrorTransformationDataSet != null) {
            if (this.hasErrorTransformationDataSet._equals(mIRTransformationDataSet)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Transformation", "ErrorTransformationDataSet"));
            }
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("Transformation", "ErrorTransformationDataSet"));
        }
        if (mIRTransformationDataSet.hasErrorOfTransformation != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("TransformationDataSet", "ErrorOfTransformation"));
        }
        this.hasErrorTransformationDataSet = mIRTransformationDataSet;
        mIRTransformationDataSet.hasErrorOfTransformation = this;
    }

    public final MIRTransformationDataSet getErrorTransformationDataSet() {
        return this.hasErrorTransformationDataSet;
    }

    public final boolean removeErrorTransformationDataSet() {
        if (this.hasErrorTransformationDataSet != null) {
            this.hasErrorTransformationDataSet.hasErrorOfTransformation = null;
            this.hasErrorTransformationDataSet = null;
            return true;
        }
        return false;
    }

    public abstract SortedSet<MIRTransformationDataSet> getInputTransformationDataSets();

    public abstract int getInputTransformationDataSetCount();

    public abstract boolean containsInputTransformationDataSet(MIRTransformationDataSet var1);

    public abstract MIRTransformationDataSet getInputTransformationDataSet(String var1);

    public abstract Iterator<MIRTransformationDataSet> getInputTransformationDataSetIterator();

    public abstract SortedSet<MIRTransformationDataSet> getOutputTransformationDataSets();

    public abstract int getOutputTransformationDataSetCount();

    public abstract boolean containsOutputTransformationDataSet(MIRTransformationDataSet var1);

    public abstract MIRTransformationDataSet getOutputTransformationDataSet(String var1);

    public abstract Iterator<MIRTransformationDataSet> getOutputTransformationDataSetIterator();

    public static MIRMetaClass staticGetMetaClass() {
        if (metaClass == null) {
            metaClass = new MIRMetaClass(MIRStepElement.staticGetMetaClass(), 79, "Transformation", true);
            new MIRMetaAttribute(metaClass, 400, "TechnicalName", "java.lang.String", null, "");
            new MIRMetaLink(metaClass, 236, "ClassifierMap", false, 3, 76, 69);
            new MIRMetaLink(metaClass, 325, "DiModel", true, 2, 258, 279);
            new MIRMetaLink(metaClass, 955, "EmbeddedCallTransformation", true, 2, 320, 950);
            new MIRMetaLink(metaClass, 749, "ErrorTransformationDataSet", true, 3, 256, 750);
        }
        return metaClass;
    }

    @Override
    public MIRMetaClass getMetaClass() {
        return MIRTransformation.staticGetMetaClass();
    }

    @Override
    protected boolean _isValidName() {
        if (this.hasDiModel != null && !this.hasDiModel._allowName(this.hasDiModel.transformations, this)) {
            return false;
        }
        if (this.hasEmbeddedCallTransformation != null && !this.hasEmbeddedCallTransformation._allowName(this.hasEmbeddedCallTransformation.transformations, this)) {
            return false;
        }
        return super._isValidName();
    }

    @Override
    protected void _rename(String string) {
        if (this.hasDiModel != null) {
            this.hasDiModel.transformations.rename(this, string);
        }
        if (this.hasEmbeddedCallTransformation != null) {
            this.hasEmbeddedCallTransformation.transformations.rename(this, string);
        }
        super._rename(string);
    }
}

