/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk;

import MITI.messages.MIR.MIRSDK;
import MITI.sdk.MIRConceptualDomain;
import MITI.sdk.MIRMetaAttribute;
import MITI.sdk.MIRMetaClass;
import MITI.sdk.MIRMetaLink;
import MITI.sdk.MIRModelUser;
import MITI.sdk.MIRNamespaceElement;
import MITI.sdk.MIRObjectCollections;
import MITI.sdk.MIRSynonymGroup;
import MITI.sdk.MIRTermRelationship;
import MITI.sdk.MIRTermStatus;
import MITI.sdk.MIRTermType;
import MITI.sdk.MIRTypeValue;
import MITI.sdk.MIR_Object;
import MITI.sdk.collections.MIRObjectCollection;
import MITI.sdk.collections.MIRSdkCollection;
import java.util.Iterator;
import java.util.SortedSet;

public class MIRTerm
extends MIRNamespaceElement {
    protected transient String aAbbreviation = "";
    protected transient String aAlternateAbbreviation = "";
    protected transient String aDocumentation = "";
    protected transient String aExample = "";
    protected transient boolean aQualifier = false;
    protected transient byte aStatus = 0;
    protected transient byte aType = 0;
    protected transient String aUsage = "";
    protected transient MIRObjectCollection<MIRTermRelationship> destinationOfTermRelationships = null;
    protected transient MIRSynonymGroup hasPreferredBySynonymGroup = null;
    protected transient MIRTerm hasReplacedByTerm = null;
    protected transient MIRObjectCollection<MIRTerm> replacedTerms = null;
    protected transient MIRConceptualDomain hasRepresentedByConceptualDomain = null;
    protected transient MIRObjectCollection<MIRTermRelationship> sourceOfTermRelationships = null;
    protected transient MIRModelUser hasStewardModelUser = null;
    protected transient MIRSynonymGroup hasSynonymGroup = null;
    protected transient MIRObjectCollection<MIRTypeValue> typeValues = null;
    private static MIRMetaClass metaClass = MIRTerm.staticGetMetaClass();

    public MIRTerm() {
    }

    public MIRTerm(MIRTerm mIRTerm) {
        this.setFrom(mIRTerm);
    }

    @Override
    public Object clone() {
        return new MIRTerm(this);
    }

    @Override
    public short getElementType() {
        return 203;
    }

    @Override
    public void setFrom(MIR_Object mIR_Object) {
        super.setFrom(mIR_Object);
        if (mIR_Object.isInstanceOf((short)203)) {
            this.setAbbreviation(((MIRTerm)mIR_Object).getAbbreviation());
            this.setAlternateAbbreviation(((MIRTerm)mIR_Object).getAlternateAbbreviation());
            this.setDocumentation(((MIRTerm)mIR_Object).getDocumentation());
            this.setExample(((MIRTerm)mIR_Object).getExample());
            this.setQualifier(((MIRTerm)mIR_Object).getQualifier());
            this.setStatus(((MIRTerm)mIR_Object).getStatus());
            this.setType(((MIRTerm)mIR_Object).getType());
            this.setUsage(((MIRTerm)mIR_Object).getUsage());
        }
    }

    public final void setAbbreviation(String string) {
        this.aAbbreviation = string == null ? "" : string;
    }

    public final String getAbbreviation() {
        return this.aAbbreviation;
    }

    public final void setAlternateAbbreviation(String string) {
        this.aAlternateAbbreviation = string == null ? "" : string;
    }

    public final String getAlternateAbbreviation() {
        return this.aAlternateAbbreviation;
    }

    public final void setDocumentation(String string) {
        this.aDocumentation = string == null ? "" : string;
    }

    public final String getDocumentation() {
        return this.aDocumentation;
    }

    public final void setExample(String string) {
        this.aExample = string == null ? "" : string;
    }

    public final String getExample() {
        return this.aExample;
    }

    public final void setQualifier(boolean bl) {
        this.aQualifier = bl;
    }

    public final boolean getQualifier() {
        return this.aQualifier;
    }

    public final void setStatus(byte by) {
        this.aStatus = by;
    }

    public final byte getStatus() {
        return this.aStatus;
    }

    public final void setType(byte by) {
        this.aType = by;
    }

    public final byte getType() {
        return this.aType;
    }

    public final void setUsage(String string) {
        this.aUsage = string == null ? "" : string;
    }

    public final String getUsage() {
        return this.aUsage;
    }

    protected MIRObjectCollection<MIRTermRelationship> getDestinationOfTermRelationshipCollection() {
        this.destinationOfTermRelationships = MIRObjectCollections.get(this.destinationOfTermRelationships, MIRSdkCollection.Type.OBJECT);
        return this.destinationOfTermRelationships;
    }

    public SortedSet<MIRTermRelationship> getDestinationOfTermRelationships() {
        return MIRObjectCollections.sortedSet(this.destinationOfTermRelationships);
    }

    public final void addDestinationOfTermRelationship(MIRTermRelationship mIRTermRelationship) {
        if (mIRTermRelationship == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Term", "DestinationOfTermRelationship"));
        }
        if (mIRTermRelationship._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Term", "DestinationOfTermRelationship"));
        }
        if (mIRTermRelationship.hasDestinationTerm != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("TermRelationship", "DestinationTerm"));
        }
        if (this.destinationOfTermRelationships != null && this.destinationOfTermRelationships.contains(mIRTermRelationship)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Term", "DestinationOfTermRelationship"));
        }
        this.getDestinationOfTermRelationshipCollection().add(mIRTermRelationship);
        mIRTermRelationship.hasDestinationTerm = this;
    }

    public final int getDestinationOfTermRelationshipCount() {
        if (this.destinationOfTermRelationships != null) {
            return this.destinationOfTermRelationships.size();
        }
        return 0;
    }

    public final boolean containsDestinationOfTermRelationship(MIRTermRelationship mIRTermRelationship) {
        if (mIRTermRelationship != null && this.destinationOfTermRelationships != null) {
            return this.destinationOfTermRelationships.contains(mIRTermRelationship);
        }
        return false;
    }

    public final MIRTermRelationship getDestinationOfTermRelationship(String string) {
        if (this.destinationOfTermRelationships != null) {
            return this.destinationOfTermRelationships.get(string);
        }
        return null;
    }

    public final Iterator<MIRTermRelationship> getDestinationOfTermRelationshipIterator() {
        if (this.destinationOfTermRelationships != null) {
            return this.destinationOfTermRelationships.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeDestinationOfTermRelationship(MIRTermRelationship mIRTermRelationship) {
        if (mIRTermRelationship != null && this.destinationOfTermRelationships != null && this.destinationOfTermRelationships.remove(mIRTermRelationship)) {
            mIRTermRelationship.hasDestinationTerm = null;
            if (this.destinationOfTermRelationships.isEmpty()) {
                this.destinationOfTermRelationships = null;
            }
            return true;
        }
        return false;
    }

    public final void removeDestinationOfTermRelationships() {
        if (this.destinationOfTermRelationships != null) {
            for (MIRTermRelationship mIRTermRelationship : this.destinationOfTermRelationships) {
                mIRTermRelationship.hasDestinationTerm = null;
            }
            this.destinationOfTermRelationships = null;
        }
    }

    public final void addPreferredBySynonymGroup(MIRSynonymGroup mIRSynonymGroup) {
        if (mIRSynonymGroup == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Term", "PreferredBySynonymGroup"));
        }
        if (mIRSynonymGroup._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Term", "PreferredBySynonymGroup"));
        }
        if (this.hasPreferredBySynonymGroup != null) {
            if (this.hasPreferredBySynonymGroup._equals(mIRSynonymGroup)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Term", "PreferredBySynonymGroup"));
            }
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("Term", "PreferredBySynonymGroup"));
        }
        if (mIRSynonymGroup.hasPreferredTerm != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("SynonymGroup", "PreferredTerm"));
        }
        this.hasPreferredBySynonymGroup = mIRSynonymGroup;
        mIRSynonymGroup.hasPreferredTerm = this;
    }

    public final MIRSynonymGroup getPreferredBySynonymGroup() {
        return this.hasPreferredBySynonymGroup;
    }

    public final boolean removePreferredBySynonymGroup() {
        if (this.hasPreferredBySynonymGroup != null) {
            this.hasPreferredBySynonymGroup.hasPreferredTerm = null;
            this.hasPreferredBySynonymGroup = null;
            return true;
        }
        return false;
    }

    public final void addReplacedByTerm(MIRTerm mIRTerm) {
        if (mIRTerm == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Term", "ReplacedByTerm"));
        }
        if (mIRTerm._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Term", "ReplacedByTerm"));
        }
        if (this.hasReplacedByTerm != null) {
            if (this.hasReplacedByTerm._equals(mIRTerm)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Term", "ReplacedByTerm"));
            }
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("Term", "ReplacedByTerm"));
        }
        this.hasReplacedByTerm = mIRTerm;
        mIRTerm.getReplacedTermCollection().add(this);
    }

    public final MIRTerm getReplacedByTerm() {
        return this.hasReplacedByTerm;
    }

    public final boolean removeReplacedByTerm() {
        if (this.hasReplacedByTerm != null) {
            this.hasReplacedByTerm.replacedTerms.remove(this);
            if (this.hasReplacedByTerm.replacedTerms.isEmpty()) {
                this.hasReplacedByTerm.replacedTerms = null;
            }
            this.hasReplacedByTerm = null;
            return true;
        }
        return false;
    }

    protected MIRObjectCollection<MIRTerm> getReplacedTermCollection() {
        this.replacedTerms = MIRObjectCollections.get(this.replacedTerms, MIRSdkCollection.Type.OBJECT);
        return this.replacedTerms;
    }

    public SortedSet<MIRTerm> getReplacedTerms() {
        return MIRObjectCollections.sortedSet(this.replacedTerms);
    }

    public final void addReplacedTerm(MIRTerm mIRTerm) {
        if (mIRTerm == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Term", "ReplacedTerm"));
        }
        if (mIRTerm._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Term", "ReplacedTerm"));
        }
        if (mIRTerm.hasReplacedByTerm != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("Term", "ReplacedByTerm"));
        }
        if (this.replacedTerms != null && this.replacedTerms.contains(mIRTerm)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Term", "ReplacedTerm"));
        }
        this.getReplacedTermCollection().add(mIRTerm);
        mIRTerm.hasReplacedByTerm = this;
    }

    public final int getReplacedTermCount() {
        if (this.replacedTerms != null) {
            return this.replacedTerms.size();
        }
        return 0;
    }

    public final boolean containsReplacedTerm(MIRTerm mIRTerm) {
        if (mIRTerm != null && this.replacedTerms != null) {
            return this.replacedTerms.contains(mIRTerm);
        }
        return false;
    }

    public final MIRTerm getReplacedTerm(String string) {
        if (this.replacedTerms != null) {
            return this.replacedTerms.get(string);
        }
        return null;
    }

    public final Iterator<MIRTerm> getReplacedTermIterator() {
        if (this.replacedTerms != null) {
            return this.replacedTerms.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeReplacedTerm(MIRTerm mIRTerm) {
        if (mIRTerm != null && this.replacedTerms != null && this.replacedTerms.remove(mIRTerm)) {
            mIRTerm.hasReplacedByTerm = null;
            if (this.replacedTerms.isEmpty()) {
                this.replacedTerms = null;
            }
            return true;
        }
        return false;
    }

    public final void removeReplacedTerms() {
        if (this.replacedTerms != null) {
            for (MIRTerm mIRTerm : this.replacedTerms) {
                mIRTerm.hasReplacedByTerm = null;
            }
            this.replacedTerms = null;
        }
    }

    public final void addRepresentedByConceptualDomain(MIRConceptualDomain mIRConceptualDomain) {
        if (mIRConceptualDomain == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Term", "RepresentedByConceptualDomain"));
        }
        if (mIRConceptualDomain._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Term", "RepresentedByConceptualDomain"));
        }
        if (this.hasRepresentedByConceptualDomain != null) {
            if (this.hasRepresentedByConceptualDomain._equals(mIRConceptualDomain)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Term", "RepresentedByConceptualDomain"));
            }
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("Term", "RepresentedByConceptualDomain"));
        }
        this.hasRepresentedByConceptualDomain = mIRConceptualDomain;
        mIRConceptualDomain.getRepresentedTermCollection().add(this);
    }

    public final MIRConceptualDomain getRepresentedByConceptualDomain() {
        return this.hasRepresentedByConceptualDomain;
    }

    public final boolean removeRepresentedByConceptualDomain() {
        if (this.hasRepresentedByConceptualDomain != null) {
            this.hasRepresentedByConceptualDomain.representedTerms.remove(this);
            if (this.hasRepresentedByConceptualDomain.representedTerms.isEmpty()) {
                this.hasRepresentedByConceptualDomain.representedTerms = null;
            }
            this.hasRepresentedByConceptualDomain = null;
            return true;
        }
        return false;
    }

    protected MIRObjectCollection<MIRTermRelationship> getSourceOfTermRelationshipCollection() {
        this.sourceOfTermRelationships = MIRObjectCollections.get(this.sourceOfTermRelationships, MIRSdkCollection.Type.OBJECT);
        return this.sourceOfTermRelationships;
    }

    public SortedSet<MIRTermRelationship> getSourceOfTermRelationships() {
        return MIRObjectCollections.sortedSet(this.sourceOfTermRelationships);
    }

    public final void addSourceOfTermRelationship(MIRTermRelationship mIRTermRelationship) {
        if (mIRTermRelationship == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Term", "SourceOfTermRelationship"));
        }
        if (mIRTermRelationship._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Term", "SourceOfTermRelationship"));
        }
        if (mIRTermRelationship.hasSourceTerm != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("TermRelationship", "SourceTerm"));
        }
        if (this.sourceOfTermRelationships != null && this.sourceOfTermRelationships.contains(mIRTermRelationship)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Term", "SourceOfTermRelationship"));
        }
        this.getSourceOfTermRelationshipCollection().add(mIRTermRelationship);
        mIRTermRelationship.hasSourceTerm = this;
    }

    public final int getSourceOfTermRelationshipCount() {
        if (this.sourceOfTermRelationships != null) {
            return this.sourceOfTermRelationships.size();
        }
        return 0;
    }

    public final boolean containsSourceOfTermRelationship(MIRTermRelationship mIRTermRelationship) {
        if (mIRTermRelationship != null && this.sourceOfTermRelationships != null) {
            return this.sourceOfTermRelationships.contains(mIRTermRelationship);
        }
        return false;
    }

    public final MIRTermRelationship getSourceOfTermRelationship(String string) {
        if (this.sourceOfTermRelationships != null) {
            return this.sourceOfTermRelationships.get(string);
        }
        return null;
    }

    public final Iterator<MIRTermRelationship> getSourceOfTermRelationshipIterator() {
        if (this.sourceOfTermRelationships != null) {
            return this.sourceOfTermRelationships.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeSourceOfTermRelationship(MIRTermRelationship mIRTermRelationship) {
        if (mIRTermRelationship != null && this.sourceOfTermRelationships != null && this.sourceOfTermRelationships.remove(mIRTermRelationship)) {
            mIRTermRelationship.hasSourceTerm = null;
            if (this.sourceOfTermRelationships.isEmpty()) {
                this.sourceOfTermRelationships = null;
            }
            return true;
        }
        return false;
    }

    public final void removeSourceOfTermRelationships() {
        if (this.sourceOfTermRelationships != null) {
            for (MIRTermRelationship mIRTermRelationship : this.sourceOfTermRelationships) {
                mIRTermRelationship.hasSourceTerm = null;
            }
            this.sourceOfTermRelationships = null;
        }
    }

    public final void addStewardModelUser(MIRModelUser mIRModelUser) {
        if (mIRModelUser == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Term", "StewardModelUser"));
        }
        if (mIRModelUser._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Term", "StewardModelUser"));
        }
        if (this.hasStewardModelUser != null) {
            if (this.hasStewardModelUser._equals(mIRModelUser)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Term", "StewardModelUser"));
            }
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("Term", "StewardModelUser"));
        }
        this.hasStewardModelUser = mIRModelUser;
        mIRModelUser.getStewardOfTermCollection().add(this);
    }

    public final MIRModelUser getStewardModelUser() {
        return this.hasStewardModelUser;
    }

    public final boolean removeStewardModelUser() {
        if (this.hasStewardModelUser != null) {
            this.hasStewardModelUser.stewardOfTerms.remove(this);
            if (this.hasStewardModelUser.stewardOfTerms.isEmpty()) {
                this.hasStewardModelUser.stewardOfTerms = null;
            }
            this.hasStewardModelUser = null;
            return true;
        }
        return false;
    }

    public final void addSynonymGroup(MIRSynonymGroup mIRSynonymGroup) {
        if (mIRSynonymGroup == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Term", "SynonymGroup"));
        }
        if (mIRSynonymGroup._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Term", "SynonymGroup"));
        }
        if (this.hasSynonymGroup != null) {
            if (this.hasSynonymGroup._equals(mIRSynonymGroup)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Term", "SynonymGroup"));
            }
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("Term", "SynonymGroup"));
        }
        this.hasSynonymGroup = mIRSynonymGroup;
        mIRSynonymGroup.getTermCollection().add(this);
    }

    public final MIRSynonymGroup getSynonymGroup() {
        return this.hasSynonymGroup;
    }

    public final boolean removeSynonymGroup() {
        if (this.hasSynonymGroup != null) {
            this.hasSynonymGroup.terms.remove(this);
            if (this.hasSynonymGroup.terms.isEmpty()) {
                this.hasSynonymGroup.terms = null;
            }
            this.hasSynonymGroup = null;
            return true;
        }
        return false;
    }

    protected MIRObjectCollection<MIRTypeValue> getTypeValueCollection() {
        this.typeValues = MIRObjectCollections.get(this.typeValues, MIRSdkCollection.Type.OBJECT);
        return this.typeValues;
    }

    public SortedSet<MIRTypeValue> getTypeValues() {
        return MIRObjectCollections.sortedSet(this.typeValues);
    }

    public final void addTypeValue(MIRTypeValue mIRTypeValue) {
        if (mIRTypeValue == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Term", "TypeValue"));
        }
        if (mIRTypeValue._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Term", "TypeValue"));
        }
        if (mIRTypeValue.hasTerm != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("TypeValue", "Term"));
        }
        if (this.typeValues != null && this.typeValues.contains(mIRTypeValue)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Term", "TypeValue"));
        }
        this.getTypeValueCollection().add(mIRTypeValue);
        mIRTypeValue.hasTerm = this;
    }

    public final int getTypeValueCount() {
        if (this.typeValues != null) {
            return this.typeValues.size();
        }
        return 0;
    }

    public final boolean containsTypeValue(MIRTypeValue mIRTypeValue) {
        if (mIRTypeValue != null && this.typeValues != null) {
            return this.typeValues.contains(mIRTypeValue);
        }
        return false;
    }

    public final MIRTypeValue getTypeValue(String string) {
        if (this.typeValues != null) {
            return this.typeValues.get(string);
        }
        return null;
    }

    public final Iterator<MIRTypeValue> getTypeValueIterator() {
        if (this.typeValues != null) {
            return this.typeValues.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeTypeValue(MIRTypeValue mIRTypeValue) {
        if (mIRTypeValue != null && this.typeValues != null && this.typeValues.remove(mIRTypeValue)) {
            mIRTypeValue.hasTerm = null;
            if (this.typeValues.isEmpty()) {
                this.typeValues = null;
            }
            return true;
        }
        return false;
    }

    public final void removeTypeValues() {
        if (this.typeValues != null) {
            for (MIRTypeValue mIRTypeValue : this.typeValues) {
                mIRTypeValue.hasTerm = null;
            }
            this.typeValues = null;
        }
    }

    public static MIRMetaClass staticGetMetaClass() {
        if (metaClass == null) {
            metaClass = new MIRMetaClass(MIRNamespaceElement.staticGetMetaClass(), 203, "Term", false);
            new MIRMetaAttribute(metaClass, 306, "Documentation", "java.lang.String", null, "");
            new MIRMetaAttribute(metaClass, 304, "Abbreviation", "java.lang.String", null, "");
            new MIRMetaAttribute(metaClass, 305, "AlternateAbbreviation", "java.lang.String", null, "");
            new MIRMetaAttribute(metaClass, 310, "Usage", "java.lang.String", null, "");
            new MIRMetaAttribute(metaClass, 307, "Example", "java.lang.String", null, "");
            new MIRMetaAttribute(metaClass, 312, "Status", "java.lang.Byte", MIRTermStatus.class, (byte)0);
            new MIRMetaAttribute(metaClass, 309, "Type", "java.lang.Byte", MIRTermType.class, (byte)0);
            new MIRMetaAttribute(metaClass, 308, "Qualifier", "java.lang.Boolean", null, false);
            new MIRMetaLink(metaClass, 572, "DestinationOfTermRelationship", false, 0, 204, 571);
            new MIRMetaLink(metaClass, 566, "PreferredBySynonymGroup", true, 1, 202, 565);
            new MIRMetaLink(metaClass, 568, "ReplacedByTerm", true, 1, 203, 567);
            new MIRMetaLink(metaClass, 567, "ReplacedTerm", false, 0, 203, 568);
            new MIRMetaLink(metaClass, 554, "RepresentedByConceptualDomain", true, 1, 205, 553);
            new MIRMetaLink(metaClass, 570, "SourceOfTermRelationship", false, 0, 204, 569);
            new MIRMetaLink(metaClass, 587, "StewardModelUser", true, 1, 201, 588);
            new MIRMetaLink(metaClass, 564, "SynonymGroup", true, 1, 202, 563);
            new MIRMetaLink(metaClass, 579, "TypeValue", false, 0, 7, 580);
        }
        return metaClass;
    }

    @Override
    public MIRMetaClass getMetaClass() {
        return MIRTerm.staticGetMetaClass();
    }

    @Override
    protected void _rename(String string) {
        if (this.hasReplacedByTerm != null) {
            this.hasReplacedByTerm.replacedTerms.rename(this, string);
        }
        if (this.hasRepresentedByConceptualDomain != null) {
            this.hasRepresentedByConceptualDomain.representedTerms.rename(this, string);
        }
        if (this.hasStewardModelUser != null) {
            this.hasStewardModelUser.stewardOfTerms.rename(this, string);
        }
        if (this.hasSynonymGroup != null) {
            this.hasSynonymGroup.terms.rename(this, string);
        }
        super._rename(string);
    }
}

