/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk;

import MITI.messages.MIR.MIRSDK;
import MITI.sdk.MIRBusinessRule;
import MITI.sdk.MIRDataPackage;
import MITI.sdk.MIRDesignPackage;
import MITI.sdk.MIRMetaAttribute;
import MITI.sdk.MIRMetaClass;
import MITI.sdk.MIRMetaLink;
import MITI.sdk.MIRModel;
import MITI.sdk.MIRObjectCollections;
import MITI.sdk.MIRPhysicalTarget;
import MITI.sdk.MIRStoreType;
import MITI.sdk.MIR_Object;
import MITI.sdk.collections.MIRObjectCollection;
import MITI.sdk.collections.MIRSdkCollection;
import java.util.Iterator;
import java.util.SortedSet;

public class MIRStoreModel
extends MIRModel {
    protected transient byte aStoreType = 0;
    protected transient MIRObjectCollection<MIRBusinessRule> businessRules = null;
    protected transient MIRObjectCollection<MIRDataPackage> dataPackages = null;
    protected transient MIRObjectCollection<MIRDesignPackage> designPackages = null;
    protected transient MIRObjectCollection<MIRPhysicalTarget> physicalTargets = null;
    private static MIRMetaClass metaClass = MIRStoreModel.staticGetMetaClass();

    public MIRStoreModel() {
    }

    public MIRStoreModel(MIRStoreModel mIRStoreModel) {
        this.setFrom(mIRStoreModel);
    }

    @Override
    public Object clone() {
        return new MIRStoreModel(this);
    }

    @Override
    public short getElementType() {
        return 2;
    }

    @Override
    public void setFrom(MIR_Object mIR_Object) {
        super.setFrom(mIR_Object);
        if (mIR_Object.isInstanceOf((short)2)) {
            this.setStoreType(((MIRStoreModel)mIR_Object).getStoreType());
        }
    }

    public final void setStoreType(byte by) {
        this.aStoreType = by;
    }

    public final byte getStoreType() {
        return this.aStoreType;
    }

    protected MIRObjectCollection<MIRBusinessRule> getBusinessRuleCollection() {
        this.businessRules = MIRObjectCollections.get(this.businessRules, MIRSdkCollection.Type.OBJECT);
        return this.businessRules;
    }

    public SortedSet<MIRBusinessRule> getBusinessRules() {
        return MIRObjectCollections.sortedSet(this.businessRules);
    }

    public final void addBusinessRule(MIRBusinessRule mIRBusinessRule) {
        if (mIRBusinessRule == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("StoreModel", "BusinessRule"));
        }
        if (mIRBusinessRule._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("StoreModel", "BusinessRule"));
        }
        if (mIRBusinessRule.hasStoreModel != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("BusinessRule", "StoreModel"));
        }
        if (this.businessRules != null && this.businessRules.contains(mIRBusinessRule)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("StoreModel", "BusinessRule"));
        }
        this.getBusinessRuleCollection().add(mIRBusinessRule);
        mIRBusinessRule.hasStoreModel = this;
    }

    public final int getBusinessRuleCount() {
        if (this.businessRules != null) {
            return this.businessRules.size();
        }
        return 0;
    }

    public final boolean containsBusinessRule(MIRBusinessRule mIRBusinessRule) {
        if (mIRBusinessRule != null && this.businessRules != null) {
            return this.businessRules.contains(mIRBusinessRule);
        }
        return false;
    }

    public final MIRBusinessRule getBusinessRule(String string) {
        if (this.businessRules != null) {
            return this.businessRules.get(string);
        }
        return null;
    }

    public final Iterator<MIRBusinessRule> getBusinessRuleIterator() {
        if (this.businessRules != null) {
            return this.businessRules.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeBusinessRule(MIRBusinessRule mIRBusinessRule) {
        if (mIRBusinessRule != null && this.businessRules != null && this.businessRules.remove(mIRBusinessRule)) {
            mIRBusinessRule.hasStoreModel = null;
            if (this.businessRules.isEmpty()) {
                this.businessRules = null;
            }
            return true;
        }
        return false;
    }

    public final void removeBusinessRules() {
        if (this.businessRules != null) {
            for (MIRBusinessRule mIRBusinessRule : this.businessRules) {
                mIRBusinessRule.hasStoreModel = null;
            }
            this.businessRules = null;
        }
    }

    protected MIRObjectCollection<MIRDataPackage> getDataPackageCollection() {
        this.dataPackages = MIRObjectCollections.get(this.dataPackages, MIRSdkCollection.Type.PHYSICAL_NAME);
        return this.dataPackages;
    }

    public SortedSet<MIRDataPackage> getDataPackages() {
        return MIRObjectCollections.sortedSet(this.dataPackages);
    }

    public final void addDataPackage(MIRDataPackage mIRDataPackage) {
        if (mIRDataPackage == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("StoreModel", "DataPackage"));
        }
        if (mIRDataPackage._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("StoreModel", "DataPackage"));
        }
        if (mIRDataPackage.hasStoreModel != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("DataPackage", "StoreModel"));
        }
        if (this.dataPackages != null) {
            if (this.dataPackages.contains(mIRDataPackage)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("StoreModel", "DataPackage"));
            }
            if (!this._allowName(this.dataPackages, mIRDataPackage)) {
                throw new IllegalArgumentException(MIRSDK.NAME_COLLISION.getMessage("StoreModel", this.getPath(), "DataPackage", "PhysicalName", mIRDataPackage.getPath()));
            }
        }
        this.getDataPackageCollection().add(mIRDataPackage);
        mIRDataPackage.hasStoreModel = this;
    }

    public final boolean addDataPackageUniqueName(MIRDataPackage mIRDataPackage) {
        return this.addDataPackageUniqueName(mIRDataPackage, '/');
    }

    public final boolean addDataPackageUniqueName(MIRDataPackage mIRDataPackage, char c) {
        if (mIRDataPackage == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("StoreModel", "DataPackage"));
        }
        if (mIRDataPackage._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("StoreModel", "DataPackage"));
        }
        if (mIRDataPackage.hasStoreModel != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("DataPackage", "StoreModel"));
        }
        boolean bl = false;
        if (this.dataPackages != null) {
            if (this.dataPackages.contains(mIRDataPackage)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("StoreModel", "DataPackage"));
            }
            if (!this._allowName(this.dataPackages, mIRDataPackage)) {
                mIRDataPackage._rename(mIRDataPackage._setUniqueName(this.dataPackages, c));
                bl = true;
            }
        }
        this.getDataPackageCollection().add(mIRDataPackage);
        mIRDataPackage.hasStoreModel = this;
        return bl;
    }

    public final int getDataPackageCount() {
        if (this.dataPackages != null) {
            return this.dataPackages.size();
        }
        return 0;
    }

    public final boolean containsDataPackage(MIRDataPackage mIRDataPackage) {
        if (mIRDataPackage != null && this.dataPackages != null) {
            return this.dataPackages.contains(mIRDataPackage);
        }
        return false;
    }

    public final MIRDataPackage getDataPackage(String string) {
        if (this.dataPackages != null) {
            return this.dataPackages.get(string);
        }
        return null;
    }

    public final Iterator<MIRDataPackage> getDataPackageIterator() {
        if (this.dataPackages != null) {
            return this.dataPackages.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeDataPackage(MIRDataPackage mIRDataPackage) {
        if (mIRDataPackage != null && this.dataPackages != null && this.dataPackages.remove(mIRDataPackage)) {
            mIRDataPackage.hasStoreModel = null;
            if (this.dataPackages.isEmpty()) {
                this.dataPackages = null;
            }
            return true;
        }
        return false;
    }

    public final void removeDataPackages() {
        if (this.dataPackages != null) {
            for (MIRDataPackage mIRDataPackage : this.dataPackages) {
                mIRDataPackage.hasStoreModel = null;
            }
            this.dataPackages = null;
        }
    }

    protected MIRObjectCollection<MIRDesignPackage> getDesignPackageCollection() {
        this.designPackages = MIRObjectCollections.get(this.designPackages, MIRSdkCollection.Type.NAME);
        return this.designPackages;
    }

    public SortedSet<MIRDesignPackage> getDesignPackages() {
        return MIRObjectCollections.sortedSet(this.designPackages);
    }

    public final void addDesignPackage(MIRDesignPackage mIRDesignPackage) {
        if (mIRDesignPackage == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("StoreModel", "DesignPackage"));
        }
        if (mIRDesignPackage._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("StoreModel", "DesignPackage"));
        }
        if (mIRDesignPackage.hasStoreModel != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("DesignPackage", "StoreModel"));
        }
        if (this.designPackages != null) {
            if (this.designPackages.contains(mIRDesignPackage)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("StoreModel", "DesignPackage"));
            }
            if (!this._allowName(this.designPackages, mIRDesignPackage)) {
                throw new IllegalArgumentException(MIRSDK.NAME_COLLISION.getMessage("StoreModel", this.getPath(), "DesignPackage", "Name", mIRDesignPackage.getPath()));
            }
        }
        this.getDesignPackageCollection().add(mIRDesignPackage);
        mIRDesignPackage.hasStoreModel = this;
    }

    public final boolean addDesignPackageUniqueName(MIRDesignPackage mIRDesignPackage) {
        return this.addDesignPackageUniqueName(mIRDesignPackage, '/');
    }

    public final boolean addDesignPackageUniqueName(MIRDesignPackage mIRDesignPackage, char c) {
        if (mIRDesignPackage == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("StoreModel", "DesignPackage"));
        }
        if (mIRDesignPackage._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("StoreModel", "DesignPackage"));
        }
        if (mIRDesignPackage.hasStoreModel != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("DesignPackage", "StoreModel"));
        }
        boolean bl = false;
        if (this.designPackages != null) {
            if (this.designPackages.contains(mIRDesignPackage)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("StoreModel", "DesignPackage"));
            }
            if (!this._allowName(this.designPackages, mIRDesignPackage)) {
                mIRDesignPackage._rename(mIRDesignPackage._setUniqueName(this.designPackages, c));
                bl = true;
            }
        }
        this.getDesignPackageCollection().add(mIRDesignPackage);
        mIRDesignPackage.hasStoreModel = this;
        return bl;
    }

    public final int getDesignPackageCount() {
        if (this.designPackages != null) {
            return this.designPackages.size();
        }
        return 0;
    }

    public final boolean containsDesignPackage(MIRDesignPackage mIRDesignPackage) {
        if (mIRDesignPackage != null && this.designPackages != null) {
            return this.designPackages.contains(mIRDesignPackage);
        }
        return false;
    }

    public final MIRDesignPackage getDesignPackage(String string) {
        if (this.designPackages != null) {
            return this.designPackages.get(string);
        }
        return null;
    }

    public final Iterator<MIRDesignPackage> getDesignPackageIterator() {
        if (this.designPackages != null) {
            return this.designPackages.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeDesignPackage(MIRDesignPackage mIRDesignPackage) {
        if (mIRDesignPackage != null && this.designPackages != null && this.designPackages.remove(mIRDesignPackage)) {
            mIRDesignPackage.hasStoreModel = null;
            if (this.designPackages.isEmpty()) {
                this.designPackages = null;
            }
            return true;
        }
        return false;
    }

    public final void removeDesignPackages() {
        if (this.designPackages != null) {
            for (MIRDesignPackage mIRDesignPackage : this.designPackages) {
                mIRDesignPackage.hasStoreModel = null;
            }
            this.designPackages = null;
        }
    }

    protected MIRObjectCollection<MIRPhysicalTarget> getPhysicalTargetCollection() {
        this.physicalTargets = MIRObjectCollections.get(this.physicalTargets, MIRSdkCollection.Type.NAME);
        return this.physicalTargets;
    }

    public SortedSet<MIRPhysicalTarget> getPhysicalTargets() {
        return MIRObjectCollections.sortedSet(this.physicalTargets);
    }

    public final void addPhysicalTarget(MIRPhysicalTarget mIRPhysicalTarget) {
        if (mIRPhysicalTarget == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("StoreModel", "PhysicalTarget"));
        }
        if (mIRPhysicalTarget._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("StoreModel", "PhysicalTarget"));
        }
        if (mIRPhysicalTarget.hasStoreModel != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("PhysicalTarget", "StoreModel"));
        }
        if (this.physicalTargets != null) {
            if (this.physicalTargets.contains(mIRPhysicalTarget)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("StoreModel", "PhysicalTarget"));
            }
            if (!this._allowName(this.physicalTargets, mIRPhysicalTarget)) {
                throw new IllegalArgumentException(MIRSDK.NAME_COLLISION.getMessage("StoreModel", this.getPath(), "PhysicalTarget", "Name", mIRPhysicalTarget.getPath()));
            }
        }
        this.getPhysicalTargetCollection().add(mIRPhysicalTarget);
        mIRPhysicalTarget.hasStoreModel = this;
    }

    public final boolean addPhysicalTargetUniqueName(MIRPhysicalTarget mIRPhysicalTarget) {
        return this.addPhysicalTargetUniqueName(mIRPhysicalTarget, '/');
    }

    public final boolean addPhysicalTargetUniqueName(MIRPhysicalTarget mIRPhysicalTarget, char c) {
        if (mIRPhysicalTarget == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("StoreModel", "PhysicalTarget"));
        }
        if (mIRPhysicalTarget._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("StoreModel", "PhysicalTarget"));
        }
        if (mIRPhysicalTarget.hasStoreModel != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("PhysicalTarget", "StoreModel"));
        }
        boolean bl = false;
        if (this.physicalTargets != null) {
            if (this.physicalTargets.contains(mIRPhysicalTarget)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("StoreModel", "PhysicalTarget"));
            }
            if (!this._allowName(this.physicalTargets, mIRPhysicalTarget)) {
                mIRPhysicalTarget._rename(mIRPhysicalTarget._setUniqueName(this.physicalTargets, c));
                bl = true;
            }
        }
        this.getPhysicalTargetCollection().add(mIRPhysicalTarget);
        mIRPhysicalTarget.hasStoreModel = this;
        return bl;
    }

    public final int getPhysicalTargetCount() {
        if (this.physicalTargets != null) {
            return this.physicalTargets.size();
        }
        return 0;
    }

    public final boolean containsPhysicalTarget(MIRPhysicalTarget mIRPhysicalTarget) {
        if (mIRPhysicalTarget != null && this.physicalTargets != null) {
            return this.physicalTargets.contains(mIRPhysicalTarget);
        }
        return false;
    }

    public final MIRPhysicalTarget getPhysicalTarget(String string) {
        if (this.physicalTargets != null) {
            return this.physicalTargets.get(string);
        }
        return null;
    }

    public final Iterator<MIRPhysicalTarget> getPhysicalTargetIterator() {
        if (this.physicalTargets != null) {
            return this.physicalTargets.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removePhysicalTarget(MIRPhysicalTarget mIRPhysicalTarget) {
        if (mIRPhysicalTarget != null && this.physicalTargets != null && this.physicalTargets.remove(mIRPhysicalTarget)) {
            mIRPhysicalTarget.hasStoreModel = null;
            if (this.physicalTargets.isEmpty()) {
                this.physicalTargets = null;
            }
            return true;
        }
        return false;
    }

    public final void removePhysicalTargets() {
        if (this.physicalTargets != null) {
            for (MIRPhysicalTarget mIRPhysicalTarget : this.physicalTargets) {
                mIRPhysicalTarget.hasStoreModel = null;
            }
            this.physicalTargets = null;
        }
    }

    public static MIRMetaClass staticGetMetaClass() {
        if (metaClass == null) {
            metaClass = new MIRMetaClass(MIRModel.staticGetMetaClass(), 2, "StoreModel", false);
            new MIRMetaAttribute(metaClass, 359, "StoreType", "java.lang.Byte", MIRStoreType.class, (byte)0);
            new MIRMetaLink(metaClass, 178, "BusinessRule", false, 3, 100, 33);
            new MIRMetaLink(metaClass, 787, "DataPackage", false, 3, 141, 788);
            new MIRMetaLink(metaClass, 785, "DesignPackage", false, 3, 9, 786);
            new MIRMetaLink(metaClass, 174, "PhysicalTarget", false, 3, 53, 209);
        }
        return metaClass;
    }

    @Override
    public MIRMetaClass getMetaClass() {
        return MIRStoreModel.staticGetMetaClass();
    }
}

