/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk;

import MITI.messages.MIR.MIRSDK;
import MITI.sdk.MIRExpression;
import MITI.sdk.MIRExpressionNode;
import MITI.sdk.MIRMetaAttribute;
import MITI.sdk.MIRMetaClass;
import MITI.sdk.MIRMetaLink;
import MITI.sdk.MIRObject;
import MITI.sdk.MIRObjectCollections;
import MITI.sdk.MIRQueryNode;
import MITI.sdk.MIR_Object;
import MITI.sdk.collections.MIRObjectCollection;
import MITI.sdk.collections.MIRSdkCollection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;

public class MIRStatementNode
extends MIRExpressionNode {
    protected transient int aStatementType = 0;
    protected transient MIRExpression hasExpression = null;
    protected transient MIRObjectCollection<MIRExpressionNode> expressionNodes = null;
    protected transient MIRQueryNode hasQueryNode = null;
    protected transient MIRObjectCollection<MIRExpressionNode> referencedExpressionNodes = null;
    private static MIRMetaClass metaClass = MIRStatementNode.staticGetMetaClass();

    public MIRStatementNode() {
    }

    public MIRStatementNode(MIRStatementNode mIRStatementNode) {
        this.setFrom(mIRStatementNode);
    }

    @Override
    public Object clone() {
        return new MIRStatementNode(this);
    }

    @Override
    public short getElementType() {
        return 134;
    }

    @Override
    public void setFrom(MIR_Object mIR_Object) {
        super.setFrom(mIR_Object);
        if (mIR_Object.isInstanceOf((short)134)) {
            this.setStatementType(((MIRStatementNode)mIR_Object).getStatementType());
        }
    }

    @Override
    public MIRObject getParent() {
        if (this.hasExpression != null) {
            return this.hasExpression;
        }
        if (this.hasQueryNode != null) {
            return this.hasQueryNode;
        }
        return super.getParent();
    }

    @Override
    public int getParentCount() {
        return (this.hasExpression != null ? 1 : 0) + (this.hasQueryNode != null ? 1 : 0) + super.getParentCount();
    }

    public final void setStatementType(int n) {
        this.aStatementType = n;
    }

    public final int getStatementType() {
        return this.aStatementType;
    }

    public final void addExpression(MIRExpression mIRExpression) {
        if (mIRExpression == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("StatementNode", "Expression"));
        }
        if (mIRExpression._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("StatementNode", "Expression"));
        }
        if (this.hasExpression != null) {
            if (this.hasExpression._equals(mIRExpression)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("StatementNode", "Expression"));
            }
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("StatementNode", "Expression"));
        }
        this.hasExpression = mIRExpression;
        mIRExpression.getStatementNodeCollection().add(this);
    }

    public final MIRExpression getExpression() {
        return this.hasExpression;
    }

    public final boolean removeExpression() {
        if (this.hasExpression != null) {
            this.hasExpression.statementNodes.remove(this);
            if (this.hasExpression.statementNodes.isEmpty()) {
                this.hasExpression.statementNodes = null;
            }
            this.hasExpression = null;
            return true;
        }
        return false;
    }

    protected MIRObjectCollection<MIRExpressionNode> getExpressionNodeCollection() {
        this.expressionNodes = MIRObjectCollections.get(this.expressionNodes, MIRSdkCollection.Type.OBJECT);
        return this.expressionNodes;
    }

    public SortedSet<MIRExpressionNode> getExpressionNodes() {
        return MIRObjectCollections.sortedSet(this.expressionNodes);
    }

    public final void addExpressionNode(MIRExpressionNode mIRExpressionNode) {
        if (mIRExpressionNode == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("StatementNode", "ExpressionNode"));
        }
        if (mIRExpressionNode._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("StatementNode", "ExpressionNode"));
        }
        if (mIRExpressionNode.hasStatementNode != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("ExpressionNode", "StatementNode"));
        }
        if (this.expressionNodes != null && this.expressionNodes.contains(mIRExpressionNode)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("StatementNode", "ExpressionNode"));
        }
        this.getExpressionNodeCollection().add(mIRExpressionNode);
        mIRExpressionNode.hasStatementNode = this;
    }

    public final int getExpressionNodeCount() {
        if (this.expressionNodes != null) {
            return this.expressionNodes.size();
        }
        return 0;
    }

    public final boolean containsExpressionNode(MIRExpressionNode mIRExpressionNode) {
        if (mIRExpressionNode != null && this.expressionNodes != null) {
            return this.expressionNodes.contains(mIRExpressionNode);
        }
        return false;
    }

    public final MIRExpressionNode getExpressionNode(String string) {
        if (this.expressionNodes != null) {
            return this.expressionNodes.get(string);
        }
        return null;
    }

    public final Iterator<MIRExpressionNode> getExpressionNodeIterator() {
        if (this.expressionNodes != null) {
            return this.expressionNodes.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final List<MIRExpressionNode> getExpressionNodeByPosition() {
        if (this.expressionNodes != null) {
            ArrayList<MIRExpressionNode> arrayList = new ArrayList<MIRExpressionNode>();
            arrayList.addAll(this.expressionNodes.values());
            MIRObjectCollections.sort(arrayList, MIRExpressionNode.ByPosition);
            return arrayList;
        }
        return MIRObjectCollections.emptyList();
    }

    public final boolean removeExpressionNode(MIRExpressionNode mIRExpressionNode) {
        if (mIRExpressionNode != null && this.expressionNodes != null && this.expressionNodes.remove(mIRExpressionNode)) {
            mIRExpressionNode.hasStatementNode = null;
            if (this.expressionNodes.isEmpty()) {
                this.expressionNodes = null;
            }
            return true;
        }
        return false;
    }

    public final void removeExpressionNodes() {
        if (this.expressionNodes != null) {
            for (MIRExpressionNode mIRExpressionNode : this.expressionNodes) {
                mIRExpressionNode.hasStatementNode = null;
            }
            this.expressionNodes = null;
        }
    }

    public final void addQueryNode(MIRQueryNode mIRQueryNode) {
        if (mIRQueryNode == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("StatementNode", "QueryNode"));
        }
        if (mIRQueryNode._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("StatementNode", "QueryNode"));
        }
        if (this.hasQueryNode != null) {
            if (this.hasQueryNode._equals(mIRQueryNode)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("StatementNode", "QueryNode"));
            }
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("StatementNode", "QueryNode"));
        }
        if (mIRQueryNode.hasQueryStatementNode != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("QueryNode", "QueryStatementNode"));
        }
        this.hasQueryNode = mIRQueryNode;
        mIRQueryNode.hasQueryStatementNode = this;
    }

    public final MIRQueryNode getQueryNode() {
        return this.hasQueryNode;
    }

    public final boolean removeQueryNode() {
        if (this.hasQueryNode != null) {
            this.hasQueryNode.hasQueryStatementNode = null;
            this.hasQueryNode = null;
            return true;
        }
        return false;
    }

    protected MIRObjectCollection<MIRExpressionNode> getReferencedExpressionNodeCollection() {
        this.referencedExpressionNodes = MIRObjectCollections.get(this.referencedExpressionNodes, MIRSdkCollection.Type.OBJECT);
        return this.referencedExpressionNodes;
    }

    public SortedSet<MIRExpressionNode> getReferencedExpressionNodes() {
        return MIRObjectCollections.sortedSet(this.referencedExpressionNodes);
    }

    public final void addReferencedExpressionNode(MIRExpressionNode mIRExpressionNode) {
        if (mIRExpressionNode == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("StatementNode", "ReferencedExpressionNode"));
        }
        if (mIRExpressionNode._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("StatementNode", "ReferencedExpressionNode"));
        }
        if (mIRExpressionNode.hasReferencedByStatementNode != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("ExpressionNode", "ReferencedByStatementNode"));
        }
        if (this.referencedExpressionNodes != null && this.referencedExpressionNodes.contains(mIRExpressionNode)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("StatementNode", "ReferencedExpressionNode"));
        }
        this.getReferencedExpressionNodeCollection().add(mIRExpressionNode);
        mIRExpressionNode.hasReferencedByStatementNode = this;
    }

    public final int getReferencedExpressionNodeCount() {
        if (this.referencedExpressionNodes != null) {
            return this.referencedExpressionNodes.size();
        }
        return 0;
    }

    public final boolean containsReferencedExpressionNode(MIRExpressionNode mIRExpressionNode) {
        if (mIRExpressionNode != null && this.referencedExpressionNodes != null) {
            return this.referencedExpressionNodes.contains(mIRExpressionNode);
        }
        return false;
    }

    public final MIRExpressionNode getReferencedExpressionNode(String string) {
        if (this.referencedExpressionNodes != null) {
            return this.referencedExpressionNodes.get(string);
        }
        return null;
    }

    public final Iterator<MIRExpressionNode> getReferencedExpressionNodeIterator() {
        if (this.referencedExpressionNodes != null) {
            return this.referencedExpressionNodes.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeReferencedExpressionNode(MIRExpressionNode mIRExpressionNode) {
        if (mIRExpressionNode != null && this.referencedExpressionNodes != null && this.referencedExpressionNodes.remove(mIRExpressionNode)) {
            mIRExpressionNode.hasReferencedByStatementNode = null;
            if (this.referencedExpressionNodes.isEmpty()) {
                this.referencedExpressionNodes = null;
            }
            return true;
        }
        return false;
    }

    public final void removeReferencedExpressionNodes() {
        if (this.referencedExpressionNodes != null) {
            for (MIRExpressionNode mIRExpressionNode : this.referencedExpressionNodes) {
                mIRExpressionNode.hasReferencedByStatementNode = null;
            }
            this.referencedExpressionNodes = null;
        }
    }

    public static MIRMetaClass staticGetMetaClass() {
        if (metaClass == null) {
            metaClass = new MIRMetaClass(MIRExpressionNode.staticGetMetaClass(), 134, "StatementNode", false);
            new MIRMetaAttribute(metaClass, 188, "StatementType", "java.lang.Integer", null, 0);
            new MIRMetaLink(metaClass, 324, "Expression", true, 2, 112, 286);
            new MIRMetaLink(metaClass, 323, "ExpressionNode", false, 3, 113, 297);
            new MIRMetaLink(metaClass, 1086, "QueryNode", true, 2, 339, 1085);
            new MIRMetaLink(metaClass, 353, "ReferencedExpressionNode", false, 0, 113, 354);
        }
        return metaClass;
    }

    @Override
    public MIRMetaClass getMetaClass() {
        return MIRStatementNode.staticGetMetaClass();
    }

    @Override
    protected void _rename(String string) {
        if (this.hasExpression != null) {
            this.hasExpression.statementNodes.rename(this, string);
        }
        super._rename(string);
    }
}

