/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk;

import MITI.messages.MIR.MIRSDK;
import MITI.sdk.MIRMetaClass;
import MITI.sdk.MIRMetaLink;
import MITI.sdk.MIRObject;
import MITI.sdk.MIRObjectCollections;
import MITI.sdk.MIRQuerySortItem;
import MITI.sdk.MIRQueryTable;
import MITI.sdk.collections.MIRObjectCollection;
import MITI.sdk.collections.MIRSdkCollection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;

public class MIRQuerySort
extends MIRObject {
    protected transient MIRObjectCollection<MIRQuerySortItem> querySortItems = null;
    protected transient MIRQueryTable hasQueryTable = null;
    private static MIRMetaClass metaClass = MIRQuerySort.staticGetMetaClass();

    public MIRQuerySort() {
    }

    public MIRQuerySort(MIRQuerySort mIRQuerySort) {
        this.setFrom(mIRQuerySort);
    }

    @Override
    public Object clone() {
        return new MIRQuerySort(this);
    }

    @Override
    public short getElementType() {
        return 341;
    }

    @Override
    public MIRObject getParent() {
        if (this.hasQueryTable != null) {
            return this.hasQueryTable;
        }
        return super.getParent();
    }

    @Override
    public int getParentCount() {
        return (this.hasQueryTable != null ? 1 : 0) + super.getParentCount();
    }

    protected MIRObjectCollection<MIRQuerySortItem> getQuerySortItemCollection() {
        this.querySortItems = MIRObjectCollections.get(this.querySortItems, MIRSdkCollection.Type.OBJECT);
        return this.querySortItems;
    }

    public SortedSet<MIRQuerySortItem> getQuerySortItems() {
        return MIRObjectCollections.sortedSet(this.querySortItems);
    }

    public final void addQuerySortItem(MIRQuerySortItem mIRQuerySortItem) {
        if (mIRQuerySortItem == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("QuerySort", "QuerySortItem"));
        }
        if (mIRQuerySortItem._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("QuerySort", "QuerySortItem"));
        }
        if (mIRQuerySortItem.hasQuerySort != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("QuerySortItem", "QuerySort"));
        }
        if (this.querySortItems != null && this.querySortItems.contains(mIRQuerySortItem)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("QuerySort", "QuerySortItem"));
        }
        this.getQuerySortItemCollection().add(mIRQuerySortItem);
        mIRQuerySortItem.hasQuerySort = this;
    }

    public final int getQuerySortItemCount() {
        if (this.querySortItems != null) {
            return this.querySortItems.size();
        }
        return 0;
    }

    public final boolean containsQuerySortItem(MIRQuerySortItem mIRQuerySortItem) {
        if (mIRQuerySortItem != null && this.querySortItems != null) {
            return this.querySortItems.contains(mIRQuerySortItem);
        }
        return false;
    }

    public final MIRQuerySortItem getQuerySortItem(String string) {
        if (this.querySortItems != null) {
            return this.querySortItems.get(string);
        }
        return null;
    }

    public final Iterator<MIRQuerySortItem> getQuerySortItemIterator() {
        if (this.querySortItems != null) {
            return this.querySortItems.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final List<MIRQuerySortItem> getQuerySortItemByPosition() {
        if (this.querySortItems != null) {
            ArrayList<MIRQuerySortItem> arrayList = new ArrayList<MIRQuerySortItem>();
            arrayList.addAll(this.querySortItems.values());
            MIRObjectCollections.sort(arrayList, MIRQuerySortItem.ByPosition);
            return arrayList;
        }
        return MIRObjectCollections.emptyList();
    }

    public final boolean removeQuerySortItem(MIRQuerySortItem mIRQuerySortItem) {
        if (mIRQuerySortItem != null && this.querySortItems != null && this.querySortItems.remove(mIRQuerySortItem)) {
            mIRQuerySortItem.hasQuerySort = null;
            if (this.querySortItems.isEmpty()) {
                this.querySortItems = null;
            }
            return true;
        }
        return false;
    }

    public final void removeQuerySortItems() {
        if (this.querySortItems != null) {
            for (MIRQuerySortItem mIRQuerySortItem : this.querySortItems) {
                mIRQuerySortItem.hasQuerySort = null;
            }
            this.querySortItems = null;
        }
    }

    public final void addQueryTable(MIRQueryTable mIRQueryTable) {
        if (mIRQueryTable == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("QuerySort", "QueryTable"));
        }
        if (mIRQueryTable._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("QuerySort", "QueryTable"));
        }
        if (this.hasQueryTable != null) {
            if (this.hasQueryTable._equals(mIRQueryTable)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("QuerySort", "QueryTable"));
            }
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("QuerySort", "QueryTable"));
        }
        if (mIRQueryTable.hasQuerySort != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("QueryTable", "QuerySort"));
        }
        this.hasQueryTable = mIRQueryTable;
        mIRQueryTable.hasQuerySort = this;
    }

    public final MIRQueryTable getQueryTable() {
        return this.hasQueryTable;
    }

    public final boolean removeQueryTable() {
        if (this.hasQueryTable != null) {
            this.hasQueryTable.hasQuerySort = null;
            this.hasQueryTable = null;
            return true;
        }
        return false;
    }

    public static MIRMetaClass staticGetMetaClass() {
        if (metaClass == null) {
            metaClass = new MIRMetaClass(MIRObject.staticGetMetaClass(), 341, "QuerySort", false);
            new MIRMetaLink(metaClass, 1094, "QuerySortItem", false, 3, 336, 1096);
            new MIRMetaLink(metaClass, 1095, "QueryTable", true, 2, 243, 1098);
        }
        return metaClass;
    }

    @Override
    public MIRMetaClass getMetaClass() {
        return MIRQuerySort.staticGetMetaClass();
    }
}

