/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk;

import MITI.messages.MIR.MIRSDK;
import MITI.sdk.MIRFolderContent;
import MITI.sdk.MIRMetaClass;
import MITI.sdk.MIRMetaLink;
import MITI.sdk.MIRObject;
import MITI.sdk.MIRObjectCollections;
import MITI.sdk.MIRRepository;
import MITI.sdk.MIRSecurityRole;
import MITI.sdk.collections.MIRObjectCollection;
import MITI.sdk.collections.MIRSdkCollection;
import java.util.Iterator;
import java.util.SortedSet;

public class MIRObjectRole
extends MIRSecurityRole {
    protected transient MIRObjectCollection<MIRFolderContent> folderContents = null;
    protected transient MIRRepository hasRepository = null;
    private static MIRMetaClass metaClass = MIRObjectRole.staticGetMetaClass();

    public MIRObjectRole() {
    }

    public MIRObjectRole(MIRObjectRole mIRObjectRole) {
        this.setFrom(mIRObjectRole);
    }

    @Override
    public Object clone() {
        return new MIRObjectRole(this);
    }

    @Override
    public short getElementType() {
        return 358;
    }

    @Override
    public MIRObject getParent() {
        if (this.hasRepository != null) {
            return this.hasRepository;
        }
        return super.getParent();
    }

    @Override
    public int getParentCount() {
        return (this.hasRepository != null ? 1 : 0) + super.getParentCount();
    }

    protected MIRObjectCollection<MIRFolderContent> getFolderContentCollection() {
        this.folderContents = MIRObjectCollections.get(this.folderContents, MIRSdkCollection.Type.OBJECT);
        return this.folderContents;
    }

    public SortedSet<MIRFolderContent> getFolderContents() {
        return MIRObjectCollections.sortedSet(this.folderContents);
    }

    public final void addFolderContent(MIRFolderContent mIRFolderContent) {
        if (mIRFolderContent == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("ObjectRole", "FolderContent"));
        }
        if (mIRFolderContent._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("ObjectRole", "FolderContent"));
        }
        if (this.folderContents != null && this.folderContents.contains(mIRFolderContent)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("ObjectRole", "FolderContent"));
        }
        this.getFolderContentCollection().add(mIRFolderContent);
        mIRFolderContent.getObjectRoleCollection().add(this);
    }

    public final int getFolderContentCount() {
        if (this.folderContents != null) {
            return this.folderContents.size();
        }
        return 0;
    }

    public final boolean containsFolderContent(MIRFolderContent mIRFolderContent) {
        if (mIRFolderContent != null && this.folderContents != null) {
            return this.folderContents.contains(mIRFolderContent);
        }
        return false;
    }

    public final MIRFolderContent getFolderContent(String string) {
        if (this.folderContents != null) {
            return this.folderContents.get(string);
        }
        return null;
    }

    public final Iterator<MIRFolderContent> getFolderContentIterator() {
        if (this.folderContents != null) {
            return this.folderContents.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeFolderContent(MIRFolderContent mIRFolderContent) {
        if (mIRFolderContent != null && this.folderContents != null && this.folderContents.remove(mIRFolderContent)) {
            mIRFolderContent.objectRoles.remove(this);
            if (mIRFolderContent.objectRoles.isEmpty()) {
                mIRFolderContent.objectRoles = null;
            }
            if (this.folderContents.isEmpty()) {
                this.folderContents = null;
            }
            return true;
        }
        return false;
    }

    public final void removeFolderContents() {
        if (this.folderContents != null) {
            for (MIRFolderContent mIRFolderContent : this.folderContents) {
                mIRFolderContent.objectRoles.remove(this);
                if (!mIRFolderContent.objectRoles.isEmpty()) continue;
                mIRFolderContent.objectRoles = null;
            }
            this.folderContents = null;
        }
    }

    public final void addRepository(MIRRepository mIRRepository) {
        if (mIRRepository == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("ObjectRole", "Repository"));
        }
        if (mIRRepository._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("ObjectRole", "Repository"));
        }
        if (this.hasRepository != null) {
            if (this.hasRepository._equals(mIRRepository)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("ObjectRole", "Repository"));
            }
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("ObjectRole", "Repository"));
        }
        this.hasRepository = mIRRepository;
        mIRRepository.getObjectRoleCollection().add(this);
    }

    public final MIRRepository getRepository() {
        return this.hasRepository;
    }

    public final boolean removeRepository() {
        if (this.hasRepository != null) {
            this.hasRepository.objectRoles.remove(this);
            if (this.hasRepository.objectRoles.isEmpty()) {
                this.hasRepository.objectRoles = null;
            }
            this.hasRepository = null;
            return true;
        }
        return false;
    }

    public static MIRMetaClass staticGetMetaClass() {
        if (metaClass == null) {
            metaClass = new MIRMetaClass(MIRSecurityRole.staticGetMetaClass(), 358, "ObjectRole", false);
            new MIRMetaLink(metaClass, 1136, "FolderContent", false, 1, 158, 1134);
            new MIRMetaLink(metaClass, 1137, "Repository", true, 2, 156, 1139);
        }
        return metaClass;
    }

    @Override
    public MIRMetaClass getMetaClass() {
        return MIRObjectRole.staticGetMetaClass();
    }

    @Override
    protected void _rename(String string) {
        if (this.folderContents != null) {
            for (MIRFolderContent mIRFolderContent : this.folderContents) {
                mIRFolderContent.objectRoles.rename(this, string);
            }
        }
        if (this.hasRepository != null) {
            this.hasRepository.objectRoles.rename(this, string);
        }
        super._rename(string);
    }
}

