/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk;

import MITI.messages.MIR.MIRSDK;
import MITI.sdk.MIRMetaClass;
import MITI.sdk.MIRMetaLink;
import MITI.sdk.MIRNamespaceElement;
import MITI.sdk.MIRObjectCollections;
import MITI.sdk.collections.MIRObjectCollection;
import MITI.sdk.collections.MIRSdkCollection;
import java.util.Iterator;
import java.util.SortedSet;

public abstract class MIRNamespace
extends MIRNamespaceElement {
    protected transient MIRObjectCollection<MIRNamespaceElement> namespaceElements = null;
    private static MIRMetaClass metaClass = MIRNamespace.staticGetMetaClass();

    @Override
    public short getElementType() {
        return 198;
    }

    protected MIRObjectCollection<MIRNamespaceElement> getNamespaceElementCollection() {
        this.namespaceElements = MIRObjectCollections.get(this.namespaceElements, MIRSdkCollection.Type.OPTIONAL_NAME);
        return this.namespaceElements;
    }

    public SortedSet<MIRNamespaceElement> getNamespaceElements() {
        return MIRObjectCollections.sortedSet(this.namespaceElements);
    }

    public final void addNamespaceElement(MIRNamespaceElement mIRNamespaceElement) {
        if (mIRNamespaceElement == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Namespace", "NamespaceElement"));
        }
        if (mIRNamespaceElement._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Namespace", "NamespaceElement"));
        }
        if (mIRNamespaceElement.hasNamespace != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("NamespaceElement", "Namespace"));
        }
        if (this.namespaceElements != null) {
            if (this.namespaceElements.contains(mIRNamespaceElement)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Namespace", "NamespaceElement"));
            }
            if (!this._allowName(this.namespaceElements, mIRNamespaceElement)) {
                throw new IllegalArgumentException(MIRSDK.NAME_COLLISION.getMessage("Namespace", this.getPath(), "NamespaceElement", "OptionalName", mIRNamespaceElement.getPath()));
            }
        }
        this.getNamespaceElementCollection().add(mIRNamespaceElement);
        mIRNamespaceElement.hasNamespace = this;
    }

    public final boolean addNamespaceElementUniqueName(MIRNamespaceElement mIRNamespaceElement) {
        return this.addNamespaceElementUniqueName(mIRNamespaceElement, '/');
    }

    public final boolean addNamespaceElementUniqueName(MIRNamespaceElement mIRNamespaceElement, char c) {
        if (mIRNamespaceElement == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Namespace", "NamespaceElement"));
        }
        if (mIRNamespaceElement._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Namespace", "NamespaceElement"));
        }
        if (mIRNamespaceElement.hasNamespace != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("NamespaceElement", "Namespace"));
        }
        this.getNamespaceElementCollection();
        boolean bl = false;
        if (this.namespaceElements != null) {
            if (this.namespaceElements.contains(mIRNamespaceElement)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Namespace", "NamespaceElement"));
            }
            if (!this._allowName(this.namespaceElements, mIRNamespaceElement)) {
                mIRNamespaceElement.hasNamespace = this;
                mIRNamespaceElement._rename(mIRNamespaceElement._setUniqueName(this.namespaceElements, c));
                bl = true;
            }
        }
        this.getNamespaceElementCollection().add(mIRNamespaceElement);
        mIRNamespaceElement.hasNamespace = this;
        return bl;
    }

    public final int getNamespaceElementCount() {
        if (this.namespaceElements != null) {
            return this.namespaceElements.size();
        }
        return 0;
    }

    public final boolean containsNamespaceElement(MIRNamespaceElement mIRNamespaceElement) {
        if (mIRNamespaceElement != null && this.namespaceElements != null) {
            return this.namespaceElements.contains(mIRNamespaceElement);
        }
        return false;
    }

    public final MIRNamespaceElement getNamespaceElement(String string) {
        if (this.namespaceElements != null) {
            return this.namespaceElements.get(string);
        }
        return null;
    }

    public final Iterator<MIRNamespaceElement> getNamespaceElementIterator() {
        if (this.namespaceElements != null) {
            return this.namespaceElements.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeNamespaceElement(MIRNamespaceElement mIRNamespaceElement) {
        if (mIRNamespaceElement != null && this.namespaceElements != null && this.namespaceElements.remove(mIRNamespaceElement)) {
            mIRNamespaceElement.hasNamespace = null;
            if (this.namespaceElements.isEmpty()) {
                this.namespaceElements = null;
            }
            return true;
        }
        return false;
    }

    public final void removeNamespaceElements() {
        if (this.namespaceElements != null) {
            for (MIRNamespaceElement mIRNamespaceElement : this.namespaceElements) {
                mIRNamespaceElement.hasNamespace = null;
            }
            this.namespaceElements = null;
        }
    }

    public static MIRMetaClass staticGetMetaClass() {
        if (metaClass == null) {
            metaClass = new MIRMetaClass(MIRNamespaceElement.staticGetMetaClass(), 198, "Namespace", true);
            new MIRMetaLink(metaClass, 595, "NamespaceElement", false, 3, 211, 596);
        }
        return metaClass;
    }

    @Override
    public MIRMetaClass getMetaClass() {
        return MIRNamespace.staticGetMetaClass();
    }
}

