/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk;

import MITI.messages.MIR.MIRSDK;
import MITI.sdk.MIRCategory;
import MITI.sdk.MIRConceptualDomain;
import MITI.sdk.MIRGlossaryModel;
import MITI.sdk.MIRMetaClass;
import MITI.sdk.MIRMetaLink;
import MITI.sdk.MIRNote;
import MITI.sdk.MIRObject;
import MITI.sdk.MIRObjectCollections;
import MITI.sdk.MIRTerm;
import MITI.sdk.MIRUser;
import MITI.sdk.collections.MIRObjectCollection;
import MITI.sdk.collections.MIRSdkCollection;
import java.util.Iterator;
import java.util.SortedSet;

public class MIRModelUser
extends MIRObject {
    protected transient MIRObjectCollection<MIRNote> createdNotes = null;
    protected transient MIRGlossaryModel hasGlossaryModel = null;
    protected transient MIRObjectCollection<MIRCategory> stewardOfCategories = null;
    protected transient MIRObjectCollection<MIRConceptualDomain> stewardOfConceptualDomains = null;
    protected transient MIRObjectCollection<MIRTerm> stewardOfTerms = null;
    protected transient MIRUser hasUser = null;
    private static MIRMetaClass metaClass = MIRModelUser.staticGetMetaClass();

    public MIRModelUser() {
    }

    public MIRModelUser(MIRModelUser mIRModelUser) {
        this.setFrom(mIRModelUser);
    }

    @Override
    public Object clone() {
        return new MIRModelUser(this);
    }

    @Override
    public short getElementType() {
        return 201;
    }

    @Override
    public MIRObject getParent() {
        if (this.hasGlossaryModel != null) {
            return this.hasGlossaryModel;
        }
        return super.getParent();
    }

    @Override
    public int getParentCount() {
        return (this.hasGlossaryModel != null ? 1 : 0) + super.getParentCount();
    }

    protected MIRObjectCollection<MIRNote> getCreatedNoteCollection() {
        this.createdNotes = MIRObjectCollections.get(this.createdNotes, MIRSdkCollection.Type.OBJECT);
        return this.createdNotes;
    }

    public SortedSet<MIRNote> getCreatedNotes() {
        return MIRObjectCollections.sortedSet(this.createdNotes);
    }

    public final void addCreatedNote(MIRNote mIRNote) {
        if (mIRNote == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("ModelUser", "CreatedNote"));
        }
        if (mIRNote._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("ModelUser", "CreatedNote"));
        }
        if (mIRNote.hasCreatedByModelUser != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("Note", "CreatedByModelUser"));
        }
        if (this.createdNotes != null && this.createdNotes.contains(mIRNote)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("ModelUser", "CreatedNote"));
        }
        this.getCreatedNoteCollection().add(mIRNote);
        mIRNote.hasCreatedByModelUser = this;
    }

    public final int getCreatedNoteCount() {
        if (this.createdNotes != null) {
            return this.createdNotes.size();
        }
        return 0;
    }

    public final boolean containsCreatedNote(MIRNote mIRNote) {
        if (mIRNote != null && this.createdNotes != null) {
            return this.createdNotes.contains(mIRNote);
        }
        return false;
    }

    public final MIRNote getCreatedNote(String string) {
        if (this.createdNotes != null) {
            return this.createdNotes.get(string);
        }
        return null;
    }

    public final Iterator<MIRNote> getCreatedNoteIterator() {
        if (this.createdNotes != null) {
            return this.createdNotes.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeCreatedNote(MIRNote mIRNote) {
        if (mIRNote != null && this.createdNotes != null && this.createdNotes.remove(mIRNote)) {
            mIRNote.hasCreatedByModelUser = null;
            if (this.createdNotes.isEmpty()) {
                this.createdNotes = null;
            }
            return true;
        }
        return false;
    }

    public final void removeCreatedNotes() {
        if (this.createdNotes != null) {
            for (MIRNote mIRNote : this.createdNotes) {
                mIRNote.hasCreatedByModelUser = null;
            }
            this.createdNotes = null;
        }
    }

    public final void addGlossaryModel(MIRGlossaryModel mIRGlossaryModel) {
        if (mIRGlossaryModel == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("ModelUser", "GlossaryModel"));
        }
        if (mIRGlossaryModel._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("ModelUser", "GlossaryModel"));
        }
        if (this.hasGlossaryModel != null) {
            if (this.hasGlossaryModel._equals(mIRGlossaryModel)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("ModelUser", "GlossaryModel"));
            }
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("ModelUser", "GlossaryModel"));
        }
        if (mIRGlossaryModel.modelUsers != null && !mIRGlossaryModel._allowName(mIRGlossaryModel.modelUsers, this)) {
            throw new IllegalArgumentException(MIRSDK.NAME_COLLISION.getMessage("GlossaryModel", mIRGlossaryModel.getPath(), "ModelUser", "Object", this.getName()));
        }
        this.hasGlossaryModel = mIRGlossaryModel;
        mIRGlossaryModel.getModelUserCollection().add(this);
    }

    public final MIRGlossaryModel getGlossaryModel() {
        return this.hasGlossaryModel;
    }

    public final boolean removeGlossaryModel() {
        if (this.hasGlossaryModel != null) {
            this.hasGlossaryModel.modelUsers.remove(this);
            if (this.hasGlossaryModel.modelUsers.isEmpty()) {
                this.hasGlossaryModel.modelUsers = null;
            }
            this.hasGlossaryModel = null;
            return true;
        }
        return false;
    }

    protected MIRObjectCollection<MIRCategory> getStewardOfCategoryCollection() {
        this.stewardOfCategories = MIRObjectCollections.get(this.stewardOfCategories, MIRSdkCollection.Type.OBJECT);
        return this.stewardOfCategories;
    }

    public SortedSet<MIRCategory> getStewardOfCategories() {
        return MIRObjectCollections.sortedSet(this.stewardOfCategories);
    }

    public final void addStewardOfCategory(MIRCategory mIRCategory) {
        if (mIRCategory == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("ModelUser", "StewardOfCategory"));
        }
        if (mIRCategory._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("ModelUser", "StewardOfCategory"));
        }
        if (mIRCategory.hasStewardModelUser != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("Category", "StewardModelUser"));
        }
        if (this.stewardOfCategories != null && this.stewardOfCategories.contains(mIRCategory)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("ModelUser", "StewardOfCategory"));
        }
        this.getStewardOfCategoryCollection().add(mIRCategory);
        mIRCategory.hasStewardModelUser = this;
    }

    public final int getStewardOfCategoryCount() {
        if (this.stewardOfCategories != null) {
            return this.stewardOfCategories.size();
        }
        return 0;
    }

    public final boolean containsStewardOfCategory(MIRCategory mIRCategory) {
        if (mIRCategory != null && this.stewardOfCategories != null) {
            return this.stewardOfCategories.contains(mIRCategory);
        }
        return false;
    }

    public final MIRCategory getStewardOfCategory(String string) {
        if (this.stewardOfCategories != null) {
            return this.stewardOfCategories.get(string);
        }
        return null;
    }

    public final Iterator<MIRCategory> getStewardOfCategoryIterator() {
        if (this.stewardOfCategories != null) {
            return this.stewardOfCategories.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeStewardOfCategory(MIRCategory mIRCategory) {
        if (mIRCategory != null && this.stewardOfCategories != null && this.stewardOfCategories.remove(mIRCategory)) {
            mIRCategory.hasStewardModelUser = null;
            if (this.stewardOfCategories.isEmpty()) {
                this.stewardOfCategories = null;
            }
            return true;
        }
        return false;
    }

    public final void removeStewardOfCategorys() {
        if (this.stewardOfCategories != null) {
            for (MIRCategory mIRCategory : this.stewardOfCategories) {
                mIRCategory.hasStewardModelUser = null;
            }
            this.stewardOfCategories = null;
        }
    }

    protected MIRObjectCollection<MIRConceptualDomain> getStewardOfConceptualDomainCollection() {
        this.stewardOfConceptualDomains = MIRObjectCollections.get(this.stewardOfConceptualDomains, MIRSdkCollection.Type.OBJECT);
        return this.stewardOfConceptualDomains;
    }

    public SortedSet<MIRConceptualDomain> getStewardOfConceptualDomains() {
        return MIRObjectCollections.sortedSet(this.stewardOfConceptualDomains);
    }

    public final void addStewardOfConceptualDomain(MIRConceptualDomain mIRConceptualDomain) {
        if (mIRConceptualDomain == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("ModelUser", "StewardOfConceptualDomain"));
        }
        if (mIRConceptualDomain._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("ModelUser", "StewardOfConceptualDomain"));
        }
        if (mIRConceptualDomain.hasStewardModelUser != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("ConceptualDomain", "StewardModelUser"));
        }
        if (this.stewardOfConceptualDomains != null && this.stewardOfConceptualDomains.contains(mIRConceptualDomain)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("ModelUser", "StewardOfConceptualDomain"));
        }
        this.getStewardOfConceptualDomainCollection().add(mIRConceptualDomain);
        mIRConceptualDomain.hasStewardModelUser = this;
    }

    public final int getStewardOfConceptualDomainCount() {
        if (this.stewardOfConceptualDomains != null) {
            return this.stewardOfConceptualDomains.size();
        }
        return 0;
    }

    public final boolean containsStewardOfConceptualDomain(MIRConceptualDomain mIRConceptualDomain) {
        if (mIRConceptualDomain != null && this.stewardOfConceptualDomains != null) {
            return this.stewardOfConceptualDomains.contains(mIRConceptualDomain);
        }
        return false;
    }

    public final MIRConceptualDomain getStewardOfConceptualDomain(String string) {
        if (this.stewardOfConceptualDomains != null) {
            return this.stewardOfConceptualDomains.get(string);
        }
        return null;
    }

    public final Iterator<MIRConceptualDomain> getStewardOfConceptualDomainIterator() {
        if (this.stewardOfConceptualDomains != null) {
            return this.stewardOfConceptualDomains.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeStewardOfConceptualDomain(MIRConceptualDomain mIRConceptualDomain) {
        if (mIRConceptualDomain != null && this.stewardOfConceptualDomains != null && this.stewardOfConceptualDomains.remove(mIRConceptualDomain)) {
            mIRConceptualDomain.hasStewardModelUser = null;
            if (this.stewardOfConceptualDomains.isEmpty()) {
                this.stewardOfConceptualDomains = null;
            }
            return true;
        }
        return false;
    }

    public final void removeStewardOfConceptualDomains() {
        if (this.stewardOfConceptualDomains != null) {
            for (MIRConceptualDomain mIRConceptualDomain : this.stewardOfConceptualDomains) {
                mIRConceptualDomain.hasStewardModelUser = null;
            }
            this.stewardOfConceptualDomains = null;
        }
    }

    protected MIRObjectCollection<MIRTerm> getStewardOfTermCollection() {
        this.stewardOfTerms = MIRObjectCollections.get(this.stewardOfTerms, MIRSdkCollection.Type.OBJECT);
        return this.stewardOfTerms;
    }

    public SortedSet<MIRTerm> getStewardOfTerms() {
        return MIRObjectCollections.sortedSet(this.stewardOfTerms);
    }

    public final void addStewardOfTerm(MIRTerm mIRTerm) {
        if (mIRTerm == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("ModelUser", "StewardOfTerm"));
        }
        if (mIRTerm._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("ModelUser", "StewardOfTerm"));
        }
        if (mIRTerm.hasStewardModelUser != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("Term", "StewardModelUser"));
        }
        if (this.stewardOfTerms != null && this.stewardOfTerms.contains(mIRTerm)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("ModelUser", "StewardOfTerm"));
        }
        this.getStewardOfTermCollection().add(mIRTerm);
        mIRTerm.hasStewardModelUser = this;
    }

    public final int getStewardOfTermCount() {
        if (this.stewardOfTerms != null) {
            return this.stewardOfTerms.size();
        }
        return 0;
    }

    public final boolean containsStewardOfTerm(MIRTerm mIRTerm) {
        if (mIRTerm != null && this.stewardOfTerms != null) {
            return this.stewardOfTerms.contains(mIRTerm);
        }
        return false;
    }

    public final MIRTerm getStewardOfTerm(String string) {
        if (this.stewardOfTerms != null) {
            return this.stewardOfTerms.get(string);
        }
        return null;
    }

    public final Iterator<MIRTerm> getStewardOfTermIterator() {
        if (this.stewardOfTerms != null) {
            return this.stewardOfTerms.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeStewardOfTerm(MIRTerm mIRTerm) {
        if (mIRTerm != null && this.stewardOfTerms != null && this.stewardOfTerms.remove(mIRTerm)) {
            mIRTerm.hasStewardModelUser = null;
            if (this.stewardOfTerms.isEmpty()) {
                this.stewardOfTerms = null;
            }
            return true;
        }
        return false;
    }

    public final void removeStewardOfTerms() {
        if (this.stewardOfTerms != null) {
            for (MIRTerm mIRTerm : this.stewardOfTerms) {
                mIRTerm.hasStewardModelUser = null;
            }
            this.stewardOfTerms = null;
        }
    }

    public final void addUser(MIRUser mIRUser) {
        if (mIRUser == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("ModelUser", "User"));
        }
        if (mIRUser._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("ModelUser", "User"));
        }
        if (this.hasUser != null) {
            if (this.hasUser._equals(mIRUser)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("ModelUser", "User"));
            }
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("ModelUser", "User"));
        }
        this.hasUser = mIRUser;
        mIRUser.getModelUserCollection().add(this);
    }

    public final MIRUser getUser() {
        return this.hasUser;
    }

    public final boolean removeUser() {
        if (this.hasUser != null) {
            this.hasUser.modelUsers.remove(this);
            if (this.hasUser.modelUsers.isEmpty()) {
                this.hasUser.modelUsers = null;
            }
            this.hasUser = null;
            return true;
        }
        return false;
    }

    public static MIRMetaClass staticGetMetaClass() {
        if (metaClass == null) {
            metaClass = new MIRMetaClass(MIRObject.staticGetMetaClass(), 201, "ModelUser", false);
            new MIRMetaLink(metaClass, 590, "CreatedNote", false, 0, 1, 589);
            new MIRMetaLink(metaClass, 582, "GlossaryModel", true, 2, 266, 581);
            new MIRMetaLink(metaClass, 584, "StewardOfCategory", false, 0, 195, 583);
            new MIRMetaLink(metaClass, 586, "StewardOfConceptualDomain", false, 0, 205, 585);
            new MIRMetaLink(metaClass, 588, "StewardOfTerm", false, 0, 203, 587);
            new MIRMetaLink(metaClass, 592, "User", true, 1, 176, 591);
        }
        return metaClass;
    }

    @Override
    public MIRMetaClass getMetaClass() {
        return MIRModelUser.staticGetMetaClass();
    }

    @Override
    protected boolean _isValidName() {
        if (this.hasGlossaryModel != null && !this.hasGlossaryModel._allowName(this.hasGlossaryModel.modelUsers, this)) {
            return false;
        }
        return super._isValidName();
    }

    @Override
    protected void _rename(String string) {
        if (this.hasGlossaryModel != null) {
            this.hasGlossaryModel.modelUsers.rename(this, string);
        }
        if (this.hasUser != null) {
            this.hasUser.modelUsers.rename(this, string);
        }
        super._rename(string);
    }
}

